/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.VersionNumber;
import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.ModelAwareGradleLintRule;
import com.netflix.nebula.lint.rule.dependency.DependencyService;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;

@Incubating
public class MinimumDependencyVersionRule
extends ModelAwareGradleLintRule {
    private String description;
    private Set alreadyAdded;
    private Set<Configuration> resolvableAndResolvedConfigurations;
    private /* synthetic */ List<GradleDependency> $minimumVersions;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public MinimumDependencyVersionRule() {
        MetaClass metaClass;
        Set set;
        String string;
        this.description = string = "pull up dependencies to a minimum version if necessary";
        this.alreadyAdded = set = (Set)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    protected void beforeApplyTo() {
        DependencyService dependencyService = DependencyService.forProject(this.getProject());
        Set<Configuration> set = dependencyService.resolvableAndResolvedConfigurations();
        this.resolvableAndResolvedConfigurations = set;
    }

    @Override
    public void visitGradleResolutionStrategyForce(MethodCallExpression call, String conf, Map<GradleDependency, Expression> forces) {
        Reference conf2 = new Reference((Object)conf);
        public final class _visitGradleResolutionStrategyForce_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference conf;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _visitGradleResolutionStrategyForce_closure1(Object _outerInstance, Object _thisObject, Reference conf) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.conf = reference = conf;
            }

            public Object doCall(Object dep, Object force) {
                ((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).fixDependencyDeclarationIfNecessary((ASTNode)ScriptBytecodeAdapter.castToType((Object)force, ASTNode.class), ShortTypeHandling.castToString((Object)this.conf.get()), (GradleDependency)ScriptBytecodeAdapter.castToType((Object)dep, GradleDependency.class));
                return null;
            }

            @Generated
            public Object call(Object dep, Object force) {
                return this.doCall(dep, force);
            }

            @Generated
            public String getConf() {
                return ShortTypeHandling.castToString((Object)this.conf.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _visitGradleResolutionStrategyForce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(forces, (Closure)new _visitGradleResolutionStrategyForce_closure1(this, this, conf2));
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.fixDependencyDeclarationIfNecessary((ASTNode)call.getArguments(), conf, dep);
    }

    private void fixDependencyDeclarationIfNecessary(ASTNode decl, String conf, GradleDependency dep) {
        Reference dep2 = new Reference((Object)dep);
        public final class _fixDependencyDeclarationIfNecessary_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dep;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _fixDependencyDeclarationIfNecessary_closure2(Object _outerInstance, Object _thisObject, Reference dep) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.dep = reference = dep;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)it).getGroup(), (Object)((GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.dep.get(), GradleDependency.class)).getGroup()) && ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)it).getName(), (Object)((GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.dep.get(), GradleDependency.class)).getName());
            }

            @Generated
            public GradleDependency getDep() {
                return (GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.dep.get(), GradleDependency.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                CallSite[] callSiteArray = _fixDependencyDeclarationIfNecessary_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixDependencyDeclarationIfNecessary_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_fixDependencyDeclarationIfNecessary_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fixDependencyDeclarationIfNecessary_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        GradleDependency minVersionConstraint = (GradleDependency)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find(this.getMinimumVersions(), (Closure)new _fixDependencyDeclarationIfNecessary_closure2(this, this, dep2)), GradleDependency.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)minVersionConstraint)) {
            return;
        }
        public final class _fixDependencyDeclarationIfNecessary_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _fixDependencyDeclarationIfNecessary_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return ((Configuration)it).getName();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                CallSite[] callSiteArray = _fixDependencyDeclarationIfNecessary_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixDependencyDeclarationIfNecessary_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_fixDependencyDeclarationIfNecessary_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fixDependencyDeclarationIfNecessary_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (!DefaultGroovyMethods.collect(this.resolvableAndResolvedConfigurations, (Closure)new _fixDependencyDeclarationIfNecessary_closure3(this, this)).contains(conf)) {
            return;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)((GradleDependency)dep2.get()).getVersion())) {
            return;
        }
        public final class _fixDependencyDeclarationIfNecessary_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dep;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _fixDependencyDeclarationIfNecessary_closure4(Object _outerInstance, Object _thisObject, Reference dep) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.dep = reference = dep;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((ResolvedArtifact)it).getModuleVersion().getId().getGroup(), (Object)((GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.dep.get(), GradleDependency.class)).getGroup()) && ScriptBytecodeAdapter.compareEqual((Object)((ResolvedArtifact)it).getModuleVersion().getId().getName(), (Object)((GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.dep.get(), GradleDependency.class)).getName());
            }

            @Generated
            public GradleDependency getDep() {
                return (GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.dep.get(), GradleDependency.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                CallSite[] callSiteArray = _fixDependencyDeclarationIfNecessary_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixDependencyDeclarationIfNecessary_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_fixDependencyDeclarationIfNecessary_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _fixDependencyDeclarationIfNecessary_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ResolvedArtifact resolved = (ResolvedArtifact)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)this.getProject().getConfigurations().getByName(conf).getResolvedConfiguration().getResolvedArtifacts(), (Closure)new _fixDependencyDeclarationIfNecessary_closure4(this, this, dep2)), ResolvedArtifact.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)resolved)) {
            return;
        }
        if (VersionNumber.parse(resolved.getModuleVersion().getId().getVersion()).compareTo(VersionNumber.parse(minVersionConstraint.getVersion())) < 0) {
            Set set;
            this.addBuildLintViolation(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{resolved.getModuleVersion().getId().getModule(), minVersionConstraint.getVersion()}, new String[]{"", " does not meet the minimum version of ", ""})), decl).documentationUri("https://github.com/nebula-plugins/gradle-lint-plugin/wiki/Minimum-Dependency-Version-Rule");
            this.alreadyAdded = set = DefaultGroovyMethods.plus((Set)this.alreadyAdded, (Object)minVersionConstraint);
        }
    }

    @Override
    public void visitDependencies(MethodCallExpression call) {
        this.bookmark("dependencies", (ASTNode)call);
    }

    @Override
    public void visitClassComplete(ClassNode node) {
        public final class _visitClassComplete_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _visitClassComplete_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<GradleDependency> doCall(Object conf) {
                Reference conf2 = new Reference(conf);
                if (((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).getResolvableAndResolvedConfigurations().contains(conf2.get())) {
                    public final class _closure9
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference conf;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure9(Object _outerInstance, Object _thisObject, Reference conf) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.conf = reference = conf;
                        }

                        public Set doCall(Object constraint) {
                            if (!((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).getAlreadyAdded().contains(constraint) && ((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).addFirstOrderIfNecessary((Configuration)ScriptBytecodeAdapter.castToType((Object)this.conf.get(), Configuration.class), (GradleDependency)ScriptBytecodeAdapter.castToType((Object)constraint, GradleDependency.class))) {
                                Set set = DefaultGroovyMethods.plus((Set)((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).getAlreadyAdded(), (Object)constraint);
                                ((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).setAlreadyAdded(set);
                                return set;
                            }
                            return (Set)ScriptBytecodeAdapter.castToType(null, Set.class);
                        }

                        @Generated
                        public Configuration getConf() {
                            return (Configuration)ScriptBytecodeAdapter.castToType((Object)this.conf.get(), Configuration.class);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure9.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    return DefaultGroovyMethods.each(((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).getMinimumVersions(), (Closure)new _closure9((Object)this, this.getThisObject(), conf2));
                }
                return (List)ScriptBytecodeAdapter.castToType(null, List.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _visitClassComplete_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each((Set)this.getProject().getConfigurations(), (Closure)new _visitClassComplete_closure5(this, this));
    }

    private boolean addFirstOrderIfNecessary(Configuration conf, GradleDependency constraint) {
        Reference constraint2 = new Reference((Object)constraint);
        if (!this.resolvableAndResolvedConfigurations.contains(conf)) {
            return false;
        }
        public final class _addFirstOrderIfNecessary_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference constraint;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addFirstOrderIfNecessary_closure6(Object _outerInstance, Object _thisObject, Reference constraint) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.constraint = reference = constraint;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.constraint.get(), GradleDependency.class)).getGroup(), (Object)((ModuleVersionIdentifier)it).getGroup()) && ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.constraint.get(), GradleDependency.class)).getName(), (Object)((ModuleVersionIdentifier)it).getName());
            }

            @Generated
            public GradleDependency getConstraint() {
                return (GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.constraint.get(), GradleDependency.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                CallSite[] callSiteArray = _addFirstOrderIfNecessary_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addFirstOrderIfNecessary_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_addFirstOrderIfNecessary_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addFirstOrderIfNecessary_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        ModuleVersionIdentifier resolved = (ModuleVersionIdentifier)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.find((Collection)((Collection)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getPropertySpreadSafe(MinimumDependencyVersionRule.class, (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(MinimumDependencyVersionRule.class, (Object)conf.getResolvedConfiguration().getResolvedArtifacts(), (String)"moduleVersion"), (String)"id"), Collection.class)), (Closure)new _addFirstOrderIfNecessary_closure6(this, this, constraint2)), ModuleVersionIdentifier.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)resolved)) {
            return false;
        }
        public final class _addFirstOrderIfNecessary_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference constraint;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _addFirstOrderIfNecessary_closure7(Object _outerInstance, Object _thisObject, Reference constraint) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.constraint = reference = constraint;
            }

            public Boolean doCall(Object it) {
                return ((MinimumDependencyVersionRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), MinimumDependencyVersionRule.class)).addFirstOrderIfNecessary((Configuration)ScriptBytecodeAdapter.castToType((Object)it, Configuration.class), (GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.constraint.get(), GradleDependency.class));
            }

            @Generated
            public GradleDependency getConstraint() {
                return (GradleDependency)ScriptBytecodeAdapter.castToType((Object)this.constraint.get(), GradleDependency.class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                CallSite[] callSiteArray = _addFirstOrderIfNecessary_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addFirstOrderIfNecessary_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_addFirstOrderIfNecessary_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _addFirstOrderIfNecessary_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (DefaultGroovyMethods.any((Iterable)conf.getExtendsFrom(), (Closure)new _addFirstOrderIfNecessary_closure7(this, this, constraint2))) {
            return true;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)((GradleDependency)constraint2.get())) && VersionNumber.parse(resolved.getVersion()).compareTo(VersionNumber.parse(((GradleDependency)constraint2.get()).getVersion())) < 0) {
            ASTNode dependenciesBlock = this.bookmark("dependencies");
            if (DefaultTypeTransformation.booleanUnbox((Object)dependenciesBlock)) {
                this.addBuildLintViolation(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((GradleDependency)constraint2.get()).getGroup(), ((GradleDependency)constraint2.get()).getName(), ((GradleDependency)constraint2.get()).getVersion()}, new String[]{"", ":", " is below the minimum version of ", ""}))).documentationUri("https://github.com/nebula-plugins/gradle-lint-plugin/wiki/Minimum-Dependency-Version-Rule");
            } else {
                this.addBuildLintViolation(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{((GradleDependency)constraint2.get()).getGroup(), ((GradleDependency)constraint2.get()).getName(), ((GradleDependency)constraint2.get()).getVersion()}, new String[]{"", ":", " is below the minimum version of ", ""}))).documentationUri("https://github.com/nebula-plugins/gradle-lint-plugin/wiki/Minimum-Dependency-Version-Rule");
            }
            return true;
        }
        return false;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MinimumDependencyVersionRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public List<GradleDependency> getMinimumVersions() {
        if (this.$minimumVersions != null) {
            return this.$minimumVersions;
        }
        public final class _getMinimumVersions_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _getMinimumVersions_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<GradleDependency> doCall(Object it) {
                if (((MinimumDependencyVersionRule)((ModelAwareGradleLintRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ModelAwareGradleLintRule.class))).getProject().hasProperty("gradleLint.minVersions")) {
                    Object object = ((MinimumDependencyVersionRule)((ModelAwareGradleLintRule)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ModelAwareGradleLintRule.class))).getProject().property("gradleLint.minVersions");
                    String string = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
                    Object[] objectArray = string != null ? string.split(",") : null;
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure10(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public GradleDependency doCall(Object it) {
                            return GradleDependency.fromConstant(it);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public GradleDependency doCall() {
                            CallSite[] callSiteArray = _closure10.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[]{};
                            return new CallSiteArray(_closure10.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure10.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    List list = objectArray != null ? DefaultGroovyMethods.collect((Object[])objectArray, (Closure)new _closure10((Object)this, this.getThisObject())) : null;
                    public final class _closure11
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure11(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Boolean doCall(Object it) {
                            return it != null;
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Boolean doCall() {
                            CallSite[] callSiteArray = _closure11.$getCallSiteArray();
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure11.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[]{};
                            return new CallSiteArray(_closure11.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure11.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    List list2 = list != null ? DefaultGroovyMethods.findAll((List)list, (Closure)new _closure11((Object)this, this.getThisObject())) : null;
                    return DefaultTypeTransformation.booleanUnbox(list2) ? list2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                }
                return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public List<GradleDependency> doCall() {
                CallSite[] callSiteArray = _getMinimumVersions_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMinimumVersions_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_getMinimumVersions_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _getMinimumVersions_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object object = new _getMinimumVersions_closure8(this, this).call();
        this.$minimumVersions = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        return (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
    }

    public static /* synthetic */ Set pfaccess$0(MinimumDependencyVersionRule $that) {
        return $that.alreadyAdded;
    }

    public static /* synthetic */ Set pfaccess$00(MinimumDependencyVersionRule $that, Set $value) {
        Set set;
        $that.alreadyAdded = set = $value;
        return set;
    }

    public static /* synthetic */ Set<Configuration> pfaccess$1(MinimumDependencyVersionRule $that) {
        return $that.resolvableAndResolvedConfigurations;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    @Generated
    public Set getAlreadyAdded() {
        return this.alreadyAdded;
    }

    @Generated
    public void setAlreadyAdded(Set set) {
        this.alreadyAdded = set;
    }

    @Generated
    public Set<Configuration> getResolvableAndResolvedConfigurations() {
        return this.resolvableAndResolvedConfigurations;
    }

    @Generated
    public void setResolvableAndResolvedConfigurations(Set<Configuration> set) {
        this.resolvableAndResolvedConfigurations = set;
    }
}

