/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IClasspathContainer;
import com.netflix.nebula.lint.jdt.core.IClasspathEntry;
import com.netflix.nebula.lint.jdt.internal.core.UserLibrary;
import com.netflix.nebula.lint.jdt.internal.core.UserLibraryManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class UserLibraryClasspathContainer
implements IClasspathContainer {
    private String name;

    public UserLibraryClasspathContainer(String libName) {
        this.name = libName;
    }

    private UserLibrary getUserLibrary() {
        return UserLibraryManager.getUserLibrary(this.name);
    }

    public IClasspathEntry[] getClasspathEntries() {
        UserLibrary library = this.getUserLibrary();
        if (library != null) {
            return library.getEntries();
        }
        return new IClasspathEntry[0];
    }

    public String getDescription() {
        return this.name;
    }

    public int getKind() {
        UserLibrary library = this.getUserLibrary();
        if (library != null && library.isSystemLibrary()) {
            return 2;
        }
        return 1;
    }

    public IPath getPath() {
        return new Path("com.netflix.nebula.lint.jdt.USER_LIBRARY").append(this.name);
    }
}

