/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.transport.PacketLineOut;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;

public class SideBandOutputStream
extends OutputStream {
    public static final int CH_DATA = 1;
    public static final int CH_PROGRESS = 2;
    public static final int CH_ERROR = 3;
    public static final int SMALL_BUF = 1000;
    public static final int MAX_BUF = 65520;
    static final int HDR_SIZE = 5;
    private final OutputStream out;
    private final byte[] buffer;
    private int cnt;

    public SideBandOutputStream(int chan, int sz, OutputStream os) {
        if (chan <= 0 || chan > 255) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().channelMustBeInRange1_255, chan));
        }
        if (sz <= 5) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().packetSizeMustBeAtLeast, sz, 5));
        }
        if (65520 < sz) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().packetSizeMustBeAtMost, sz, 65520));
        }
        this.out = os;
        this.buffer = new byte[sz];
        this.buffer[4] = (byte)chan;
        this.cnt = 5;
    }

    void flushBuffer() throws IOException {
        if (5 < this.cnt) {
            this.writeBuffer();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int capacity = this.buffer.length - this.cnt;
            if (this.cnt == 5 && capacity < len) {
                PacketLineOut.formatLength(this.buffer, this.buffer.length);
                this.out.write(this.buffer, 0, 5);
                this.out.write(b, off, capacity);
                off += capacity;
                len -= capacity;
                continue;
            }
            if (capacity == 0) {
                this.writeBuffer();
            }
            int n = Math.min(len, capacity);
            System.arraycopy(b, off, this.buffer, this.cnt, n);
            this.cnt += n;
            off += n;
            len -= n;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.cnt == this.buffer.length) {
            this.writeBuffer();
        }
        this.buffer[this.cnt++] = (byte)b;
    }

    private void writeBuffer() throws IOException {
        PacketLineOut.formatLength(this.buffer, this.cnt);
        this.out.write(this.buffer, 0, this.cnt);
        this.cnt = 5;
    }
}

