/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ArrayTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ClassScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Scope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class SingleTypeReference
extends TypeReference {
    public char[] token;

    public SingleTypeReference(char[] source, long pos) {
        this.token = source;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)(pos & 0xFFFFFFFFL);
    }

    public TypeReference copyDims(int dim) {
        return new ArrayTypeReference(this.token, dim, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.resolvedType = scope.getType(this.token);
        if (scope.kind == 3 && this.resolvedType.isValidBinding() && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this, null)) {
            return null;
        }
        return this.resolvedType;
    }

    public char[][] getTypeName() {
        return new char[][]{this.token};
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return output.append(this.token);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope scope, ReferenceBinding enclosingType) {
        ReferenceBinding memberType = scope.getMemberType(this.token, enclosingType);
        if (!memberType.isValidBinding()) {
            this.resolvedType = memberType;
            scope.problemReporter().invalidEnclosingType(this, memberType, enclosingType);
            return null;
        }
        if (this.isTypeUseDeprecated(memberType, scope)) {
            scope.problemReporter().deprecatedType(memberType, this);
        }
        this.resolvedType = scope.environment().convertToRawType(memberType);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

