/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.lib.CommitBuilder;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectInserter;
import com.netflix.nebula.lint.jgit.lib.PersonIdent;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.notes.Note;
import com.netflix.nebula.lint.jgit.notes.NoteMap;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;

public class AddNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String message;
    private String notesRef = "refs/notes/commits";

    protected AddNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Note note;
                RevWalk walk = new RevWalk(this.repo);
                try {
                    block17: {
                        ObjectInserter inserter = this.repo.newObjectInserter();
                        try {
                            Ref ref = this.repo.findRef(this.notesRef);
                            if (ref != null) {
                                notesCommit = walk.parseCommit(ref.getObjectId());
                                map = NoteMap.read(walk.getObjectReader(), notesCommit);
                            }
                            map.set(this.id, this.message, inserter);
                            AddNoteCommand.commitNoteMap(this.repo, this.notesRef, walk, map, notesCommit, inserter, "Notes added by 'git notes add'");
                            note = map.getNote(this.id);
                            return note;
                        }
                        finally {
                            if (inserter == null) break block17;
                            inserter.close();
                        }
                    }
                    if (walk != null) {
                        walk.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (walk == null) throw throwable;
                    walk.close();
                    throw throwable;
                }
                {
                    return note;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public AddNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public AddNoteCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    static void commitNoteMap(Repository r, String ref, RevWalk walk, NoteMap map, RevCommit notesCommit, ObjectInserter inserter, String msg) throws IOException {
        CommitBuilder builder = new CommitBuilder();
        builder.setTreeId(map.writeTree(inserter));
        builder.setAuthor(new PersonIdent(r));
        builder.setCommitter(builder.getAuthor());
        builder.setMessage(msg);
        if (notesCommit != null) {
            builder.setParentIds(notesCommit);
        }
        ObjectId commit = inserter.insert(builder);
        inserter.flush();
        RefUpdate refUpdate = r.updateRef(ref);
        if (notesCommit != null) {
            refUpdate.setExpectedOldObjectId(notesCommit);
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.setNewObjectId(commit);
        refUpdate.update(walk);
    }

    public AddNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

