/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.file;

import com.netflix.nebula.lint.jgit.util.FS;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class FileSnapshot {
    public static final FileSnapshot DIRTY = new FileSnapshot(-1L, -1L);
    public static final FileSnapshot MISSING_FILE = new FileSnapshot(0L, 0L){

        @Override
        public boolean isModified(File path) {
            return FS.DETECTED.exists(path);
        }
    };
    private final long lastModified;
    private volatile long lastRead;
    private boolean cannotBeRacilyClean;

    public static FileSnapshot save(File path) {
        long modified;
        long read = System.currentTimeMillis();
        try {
            modified = FS.DETECTED.lastModified(path);
        }
        catch (IOException e) {
            modified = path.lastModified();
        }
        return new FileSnapshot(read, modified);
    }

    public static FileSnapshot save(long modified) {
        long read = System.currentTimeMillis();
        return new FileSnapshot(read, modified);
    }

    private FileSnapshot(long read, long modified) {
        this.lastRead = read;
        this.lastModified = modified;
        this.cannotBeRacilyClean = this.notRacyClean(read);
    }

    public long lastModified() {
        return this.lastModified;
    }

    public boolean isModified(File path) {
        long currLastModified;
        try {
            currLastModified = FS.DETECTED.lastModified(path);
        }
        catch (IOException e) {
            currLastModified = path.lastModified();
        }
        return this.isModified(currLastModified);
    }

    public void setClean(FileSnapshot other) {
        long now = other.lastRead;
        if (this.notRacyClean(now)) {
            this.cannotBeRacilyClean = true;
        }
        this.lastRead = now;
    }

    public boolean equals(FileSnapshot other) {
        return this.lastModified == other.lastModified;
    }

    public boolean equals(Object other) {
        if (other instanceof FileSnapshot) {
            return this.equals((FileSnapshot)other);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lastModified;
    }

    public String toString() {
        if (this == DIRTY) {
            return "DIRTY";
        }
        if (this == MISSING_FILE) {
            return "MISSING_FILE";
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        return "FileSnapshot[modified: " + f.format(new Date(this.lastModified)) + ", read: " + f.format(new Date(this.lastRead)) + "]";
    }

    private boolean notRacyClean(long read) {
        return read - this.lastModified > 2500L;
    }

    private boolean isModified(long currLastModified) {
        if (this.lastModified != currLastModified) {
            return true;
        }
        if (this.cannotBeRacilyClean) {
            return false;
        }
        return !this.notRacyClean(this.lastRead);
    }

    /* synthetic */ FileSnapshot(long l, long l2, FileSnapshot fileSnapshot) {
        this(l, l2);
    }
}

