/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core.dom;

import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.dom.BindingResolver;
import com.netflix.nebula.lint.jdt.core.dom.DefaultValuePairBinding;
import com.netflix.nebula.lint.jdt.core.dom.IAnnotationBinding;
import com.netflix.nebula.lint.jdt.core.dom.IBinding;
import com.netflix.nebula.lint.jdt.core.dom.IMemberValuePairBinding;
import com.netflix.nebula.lint.jdt.core.dom.ITypeBinding;
import com.netflix.nebula.lint.jdt.core.dom.MemberValuePairBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ElementValuePair;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.util.HashtableOfObject;

class AnnotationBinding
implements IAnnotationBinding {
    static final AnnotationBinding[] NoAnnotations = new AnnotationBinding[0];
    private com.netflix.nebula.lint.jdt.internal.compiler.lookup.AnnotationBinding internalAnnotation;
    private BindingResolver bindingResolver;

    AnnotationBinding(com.netflix.nebula.lint.jdt.internal.compiler.lookup.AnnotationBinding annotation, BindingResolver resolver) {
        if (annotation == null) {
            throw new IllegalStateException();
        }
        this.internalAnnotation = annotation;
        this.bindingResolver = resolver;
    }

    public IAnnotationBinding[] getAnnotations() {
        return NoAnnotations;
    }

    public ITypeBinding getAnnotationType() {
        ITypeBinding binding = this.bindingResolver.getTypeBinding(this.internalAnnotation.getAnnotationType());
        if (binding == null || !binding.isAnnotation()) {
            return null;
        }
        return binding;
    }

    public IMemberValuePairBinding[] getDeclaredMemberValuePairs() {
        ElementValuePair[] internalPairs = this.internalAnnotation.getElementValuePairs();
        int length = internalPairs.length;
        IMemberValuePairBinding[] pairs = length == 0 ? MemberValuePairBinding.NoPair : new MemberValuePairBinding[length];
        int i = 0;
        while (i < length) {
            pairs[i] = this.bindingResolver.getMemberValuePairBinding(internalPairs[i]);
            ++i;
        }
        return pairs;
    }

    public IMemberValuePairBinding[] getAllMemberValuePairs() {
        int methodLength;
        IMemberValuePairBinding[] pairs = this.getDeclaredMemberValuePairs();
        ReferenceBinding typeBinding = this.internalAnnotation.getAnnotationType();
        if (typeBinding == null) {
            return pairs;
        }
        MethodBinding[] methods = typeBinding.availableMethods();
        int n = methodLength = methods == null ? 0 : methods.length;
        if (methodLength == 0) {
            return pairs;
        }
        int declaredLength = pairs.length;
        if (declaredLength == methodLength) {
            return pairs;
        }
        HashtableOfObject table = new HashtableOfObject(declaredLength);
        int i = 0;
        while (i < declaredLength) {
            table.put(((MemberValuePairBinding)pairs[i]).internalName(), pairs[i]);
            ++i;
        }
        IMemberValuePairBinding[] allPairs = new IMemberValuePairBinding[methodLength];
        int i2 = 0;
        while (i2 < methodLength) {
            Object pair = table.get(methods[i2].selector);
            allPairs[i2] = pair == null ? new DefaultValuePairBinding(methods[i2], this.bindingResolver) : (IMemberValuePairBinding)pair;
            ++i2;
        }
        return allPairs;
    }

    public IJavaElement getJavaElement() {
        ITypeBinding annotationType = this.getAnnotationType();
        if (annotationType == null) {
            return null;
        }
        return annotationType.getJavaElement();
    }

    public String getKey() {
        return null;
    }

    public int getKind() {
        return 5;
    }

    public int getModifiers() {
        return 0;
    }

    public String getName() {
        ITypeBinding annotationType = this.getAnnotationType();
        if (annotationType == null) {
            return new String(this.internalAnnotation.getAnnotationType().sourceName());
        }
        return annotationType.getName();
    }

    public boolean isDeprecated() {
        ReferenceBinding typeBinding = this.internalAnnotation.getAnnotationType();
        if (typeBinding == null) {
            return false;
        }
        return typeBinding.isDeprecated();
    }

    public boolean isEqualTo(IBinding binding) {
        IMemberValuePairBinding[] otherMemberValuePairs;
        if (this == binding) {
            return true;
        }
        if (binding.getKind() != 5) {
            return false;
        }
        IAnnotationBinding other = (IAnnotationBinding)binding;
        if (!this.getAnnotationType().isEqualTo(other.getAnnotationType())) {
            return false;
        }
        IMemberValuePairBinding[] memberValuePairs = this.getDeclaredMemberValuePairs();
        if (memberValuePairs.length != (otherMemberValuePairs = other.getDeclaredMemberValuePairs()).length) {
            return false;
        }
        int i = 0;
        int length = memberValuePairs.length;
        while (i < length) {
            if (!memberValuePairs[i].isEqualTo(otherMemberValuePairs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public String toString() {
        ITypeBinding type = this.getAnnotationType();
        StringBuffer buffer = new StringBuffer();
        buffer.append('@');
        if (type != null) {
            buffer.append(type.getName());
        }
        buffer.append('(');
        IMemberValuePairBinding[] pairs = this.getDeclaredMemberValuePairs();
        int i = 0;
        int len = pairs.length;
        while (i < len) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(pairs[i].toString());
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }
}

