/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.matching;

import com.netflix.nebula.lint.jdt.core.IPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.search.IJavaSearchScope;
import com.netflix.nebula.lint.jdt.core.search.SearchParticipant;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRuleSet;
import com.netflix.nebula.lint.jdt.internal.core.LocalVariable;
import com.netflix.nebula.lint.jdt.internal.core.index.Index;
import com.netflix.nebula.lint.jdt.internal.core.search.IndexQueryRequestor;
import com.netflix.nebula.lint.jdt.internal.core.search.JavaSearchScope;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.VariablePattern;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class LocalVariablePattern
extends VariablePattern {
    LocalVariable localVariable;

    public LocalVariablePattern(boolean findDeclarations, boolean readAccess, boolean writeAccess, LocalVariable localVariable, int matchRule) {
        super(512, findDeclarations, readAccess, writeAccess, localVariable.getElementName().toCharArray(), matchRule);
        this.localVariable = localVariable;
    }

    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) {
        JavaSearchScope javaSearchScope;
        AccessRuleSet access;
        String documentPath;
        String relativePath;
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.localVariable.getAncestor(3);
        if (root.isArchive()) {
            IType type = (IType)this.localVariable.getAncestor(7);
            relativePath = String.valueOf(type.getFullyQualifiedName('/').replace('.', '/')) + ".class";
            documentPath = root.getPath() + "|" + relativePath;
        } else {
            IPath path = this.localVariable.getPath();
            documentPath = path.toString();
            relativePath = Util.relativePath(path, 1);
        }
        if (scope instanceof JavaSearchScope ? (access = (javaSearchScope = (JavaSearchScope)scope).getAccessRuleSet(relativePath, index.containerPath)) != JavaSearchScope.NOT_ENCLOSED && !requestor.acceptIndexMatch(documentPath, this, participant, access) : scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, this, participant, null)) {
            throw new OperationCanceledException();
        }
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "LocalVarCombinedPattern: " : "LocalVarDeclarationPattern: ");
        } else {
            output.append("LocalVarReferencePattern: ");
        }
        output.append(this.localVariable.toStringWithAncestors());
        return super.print(output);
    }
}

