/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.eval;

import com.netflix.nebula.lint.jdt.internal.compiler.ClassFile;
import com.netflix.nebula.lint.jdt.internal.compiler.CompilationResult;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.problem.AbortType;
import com.netflix.nebula.lint.jdt.internal.eval.CodeSnippetClassFile;

public class CodeSnippetTypeDeclaration
extends TypeDeclaration {
    public CodeSnippetTypeDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void generateCode(ClassFile enclosingClassFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        this.bits |= 0x2000;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            CodeSnippetClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            int max;
            int i;
            CodeSnippetClassFile classFile = new CodeSnippetClassFile(this.binding, enclosingClassFile, false);
            classFile.addFieldInfos();
            if (this.binding.isMemberType()) {
                classFile.recordInnerClasses(this.binding);
            } else if (this.binding.isLocalType()) {
                enclosingClassFile.recordInnerClasses(this.binding);
                classFile.recordInnerClasses(this.binding);
            }
            if (this.memberTypes != null) {
                i = 0;
                max = this.memberTypes.length;
                while (i < max) {
                    TypeDeclaration memberType = this.memberTypes[i];
                    classFile.recordInnerClasses(memberType.binding);
                    memberType.generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.setForMethodInfos();
            if (this.methods != null) {
                i = 0;
                max = this.methods.length;
                while (i < max) {
                    this.methods[i].generateCode(this.scope, classFile);
                    ++i;
                }
            }
            classFile.addSpecialMethods();
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            classFile.addAttributes();
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile);
        }
        catch (AbortType abortType) {
            if (this.binding == null) {
                return;
            }
            CodeSnippetClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }
}

