/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.BufferChangedEvent;
import com.netflix.nebula.lint.jdt.core.CompletionRequestor;
import com.netflix.nebula.lint.jdt.core.IBuffer;
import com.netflix.nebula.lint.jdt.core.IBufferChangedListener;
import com.netflix.nebula.lint.jdt.core.IBufferFactory;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IOpenable;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.internal.codeassist.CompletionEngine;
import com.netflix.nebula.lint.jdt.internal.codeassist.SelectionEngine;
import com.netflix.nebula.lint.jdt.internal.compiler.env.ICompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.BufferManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.JavaModel;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelCache;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelStatus;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.NameLookup;
import com.netflix.nebula.lint.jdt.internal.core.NullBuffer;
import com.netflix.nebula.lint.jdt.internal.core.OpenableElementInfo;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.SearchableEnvironment;
import com.netflix.nebula.lint.jdt.internal.core.SelectionRequestor;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PerformanceStats;

public abstract class Openable
extends JavaElement
implements IOpenable,
IBufferChangedListener {
    protected Openable(JavaElement parent) {
        super(parent);
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().add(this);
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws JavaModelException;

    public boolean canBeRemovedFromCache() {
        try {
            return !this.hasUnsavedChanges();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        return !buffer.hasUnsavedChanges();
    }

    protected void closeBuffer() {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    protected void closing(Object info) {
        this.closeBuffer();
    }

    protected void codeComplete(ICompilationUnit cu, ICompilationUnit unitToSkip, int position, CompletionRequestor requestor, WorkingCopyOwner owner) throws JavaModelException {
        IBuffer buffer;
        PerformanceStats performanceStats;
        if (requestor == null) {
            throw new IllegalArgumentException("Completion requestor cannot be null");
        }
        PerformanceStats performanceStats2 = performanceStats = CompletionEngine.PERF ? PerformanceStats.getStats((String)"org.eclipse.jdt.core/perf/completion", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(cu.getFileName())) + " at " + position);
        }
        if ((buffer = this.getBuffer()) == null) {
            return;
        }
        if (position < -1 || position > buffer.getLength()) {
            throw new JavaModelException(new JavaModelStatus(980));
        }
        JavaProject project = (JavaProject)this.getJavaProject();
        SearchableEnvironment environment = project.newSearchableNameEnvironment(owner);
        environment.unitToSkip = unitToSkip;
        CompletionEngine engine = new CompletionEngine(environment, requestor, project.getOptions(true), project);
        engine.complete(cu, position, 0);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
    }

    protected IJavaElement[] codeSelect(ICompilationUnit cu, int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        PerformanceStats performanceStats;
        PerformanceStats performanceStats2 = performanceStats = SelectionEngine.PERF ? PerformanceStats.getStats((String)"org.eclipse.jdt.core/perf/selection", (Object)this) : null;
        if (performanceStats != null) {
            performanceStats.startRun(String.valueOf(new String(cu.getFileName())) + " at [" + offset + "," + length + "]");
        }
        JavaProject project = (JavaProject)this.getJavaProject();
        SearchableEnvironment environment = project.newSearchableNameEnvironment(owner);
        SelectionRequestor requestor = new SelectionRequestor(environment.nameLookup, this);
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return requestor.getElements();
        }
        int end = buffer.getLength();
        if (offset < 0 || length < 0 || offset + length > end) {
            throw new JavaModelException(new JavaModelStatus(980));
        }
        SelectionEngine engine = new SelectionEngine(environment, requestor, project.getOptions(true));
        engine.select(cu, offset, offset + length - 1);
        if (performanceStats != null) {
            performanceStats.endRun();
        }
        if (NameLookup.VERBOSE) {
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
            System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
        }
        return requestor.getElements();
    }

    protected Object createElementInfo() {
        return new OpenableElementInfo();
    }

    public boolean exists() {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        if (manager.getInfo(this) != null) {
            return true;
        }
        if (!this.parentExists()) {
            return false;
        }
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (!(root == null || root != this && root.isArchive())) {
            return this.resourceExists();
        }
        return super.exists();
    }

    public String findRecommendedLineSeparator() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        String source = buffer == null ? null : buffer.getContents();
        return Util.getLineSeparator(source, this.getJavaProject());
    }

    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor monitor) throws JavaModelException {
        if (JavaModelCache.VERBOSE) {
            String element;
            switch (this.getElementType()) {
                case 2: {
                    element = "project";
                    break;
                }
                case 3: {
                    element = "root";
                    break;
                }
                case 4: {
                    element = "package";
                    break;
                }
                case 6: {
                    element = "class file";
                    break;
                }
                case 5: {
                    element = "compilation unit";
                    break;
                }
                default: {
                    element = "element";
                }
            }
            System.out.println(Thread.currentThread() + " OPENING " + element + " " + this.toStringWithAncestors());
        }
        this.openParent(info, newElements, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        newElements.put(this, info);
        try {
            OpenableElementInfo openableElementInfo = (OpenableElementInfo)info;
            boolean isStructureKnown = this.buildStructure(openableElementInfo, monitor, newElements, this.getResource());
            openableElementInfo.setIsStructureKnown(isStructureKnown);
        }
        catch (JavaModelException e) {
            newElements.remove(this);
            throw e;
        }
        JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        if (JavaModelCache.VERBOSE) {
            System.out.println(JavaModelManager.getJavaModelManager().cacheToString("-> "));
        }
    }

    public IBuffer getBuffer() throws JavaModelException {
        if (this.hasBuffer()) {
            Object info = this.getElementInfo();
            IBuffer buffer = this.getBufferManager().getBuffer(this);
            if (buffer == null) {
                buffer = this.openBuffer(null, info);
            }
            if (buffer instanceof NullBuffer) {
                return null;
            }
            return buffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        return this.getUnderlyingResource();
    }

    public IOpenable getOpenable() {
        return this;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        IResource parentResource = this.parent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.getElementName());
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasUnsavedChanges() throws JavaModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer buf = this.getBuffer();
        if (buf != null && buf.hasUnsavedChanges()) {
            return true;
        }
        int elementType = this.getElementType();
        if (elementType == 4 || elementType == 3 || elementType == 2 || elementType == 1) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                IJavaElement owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (IJavaElement)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() {
        return true;
    }

    public boolean isOpen() {
        return JavaModelManager.getJavaModelManager().getInfo(this) != null;
    }

    protected boolean isSourceElement() {
        return false;
    }

    public boolean isStructureKnown() throws JavaModelException {
        return ((OpenableElementInfo)this.getElementInfo()).isStructureKnown();
    }

    public void makeConsistent(IProgressMonitor monitor) throws JavaModelException {
    }

    public void open(IProgressMonitor pm) throws JavaModelException {
        this.getElementInfo(pm);
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        return null;
    }

    protected void openParent(Object childInfo, HashMap newElements, IProgressMonitor pm) throws JavaModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    protected boolean parentExists() {
        IJavaElement parentElement = this.getParent();
        if (parentElement == null) {
            return true;
        }
        return parentElement.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return JavaModel.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    public void save(IProgressMonitor pm, boolean force) throws JavaModelException {
        if (this.isReadOnly()) {
            throw new JavaModelException(new JavaModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    public PackageFragmentRoot getPackageFragmentRoot() {
        return (PackageFragmentRoot)this.getAncestor(3);
    }
}

