/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.matching;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Annotation;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ConstructorDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.FieldDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Initializer;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocAllocationExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocArgumentExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocFieldReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocMessageSend;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocSingleNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.LocalDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MemberValuePair;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MessageSend;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MethodDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.NameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Reference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeParameter;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeReference;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ClassScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodScope;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Parser;
import com.netflix.nebula.lint.jdt.internal.compiler.problem.ProblemReporter;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.ImportMatchLocatorParser;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchLocator;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchingNodeSet;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.PatternLocator;

public class MatchLocatorParser
extends Parser {
    MatchingNodeSet nodeSet;
    PatternLocator patternLocator;
    private ASTVisitor localDeclarationVisitor;

    public static MatchLocatorParser createParser(ProblemReporter problemReporter, MatchLocator locator) {
        if ((locator.matchContainer & 1) != 0) {
            return new ImportMatchLocatorParser(problemReporter, locator);
        }
        return new MatchLocatorParser(problemReporter, locator);
    }

    protected MatchLocatorParser(ProblemReporter problemReporter, MatchLocator locator) {
        super(problemReporter, true);
        this.reportOnlyOneSyntaxError = true;
        this.patternLocator = locator.patternLocator;
        this.localDeclarationVisitor = (locator.matchContainer & 2) != 0 ? ((locator.matchContainer & 4) != 0 ? new ClassAndMethodDeclarationVisitor() : new ClassButNoMethodDeclarationVisitor()) : ((locator.matchContainer & 4) != 0 ? new MethodButNoClassDeclarationVisitor() : new NoClassNoMethodDeclarationVisitor());
    }

    public void checkComment() {
        super.checkComment();
        if (this.javadocParser.checkDocComment && this.javadoc != null) {
            Expression[] references;
            TypeReference[] thrownExceptions;
            JavadocSingleTypeReference[] paramTypeParameters;
            JavadocSingleNameReference[] paramReferences = this.javadoc.paramReferences;
            if (paramReferences != null) {
                int i = 0;
                int length = paramReferences.length;
                while (i < length) {
                    this.patternLocator.match(paramReferences[i], this.nodeSet);
                    ++i;
                }
            }
            if ((paramTypeParameters = this.javadoc.paramTypeParameters) != null) {
                int i = 0;
                int length = paramTypeParameters.length;
                while (i < length) {
                    this.patternLocator.match(paramTypeParameters[i], this.nodeSet);
                    ++i;
                }
            }
            if ((thrownExceptions = this.javadoc.exceptionReferences) != null) {
                int i = 0;
                int length = thrownExceptions.length;
                while (i < length) {
                    this.patternLocator.match(thrownExceptions[i], this.nodeSet);
                    ++i;
                }
            }
            if ((references = this.javadoc.seeReferences) != null) {
                int i = 0;
                int length = references.length;
                while (i < length) {
                    JavadocArgumentExpression argument;
                    int al;
                    Expression reference = references[i];
                    if (reference instanceof TypeReference) {
                        TypeReference typeRef = (TypeReference)reference;
                        this.patternLocator.match(typeRef, this.nodeSet);
                    } else if (reference instanceof JavadocFieldReference) {
                        JavadocFieldReference fieldRef = (JavadocFieldReference)reference;
                        this.patternLocator.match(fieldRef, this.nodeSet);
                        if (fieldRef.receiver instanceof TypeReference && !fieldRef.receiver.isThis()) {
                            TypeReference typeRef = (TypeReference)fieldRef.receiver;
                            this.patternLocator.match(typeRef, this.nodeSet);
                        }
                    } else if (reference instanceof JavadocMessageSend) {
                        JavadocMessageSend messageSend = (JavadocMessageSend)reference;
                        this.patternLocator.match(messageSend, this.nodeSet);
                        if (messageSend.receiver instanceof TypeReference && !messageSend.receiver.isThis()) {
                            TypeReference typeRef = (TypeReference)messageSend.receiver;
                            this.patternLocator.match(typeRef, this.nodeSet);
                        }
                        if (messageSend.arguments != null) {
                            int a = 0;
                            al = messageSend.arguments.length;
                            while (a < al) {
                                argument = (JavadocArgumentExpression)messageSend.arguments[a];
                                if (argument.argument != null && argument.argument.type != null) {
                                    this.patternLocator.match(argument.argument.type, this.nodeSet);
                                }
                                ++a;
                            }
                        }
                    } else if (reference instanceof JavadocAllocationExpression) {
                        JavadocAllocationExpression constructor = (JavadocAllocationExpression)reference;
                        this.patternLocator.match(constructor, this.nodeSet);
                        if (constructor.type != null && !constructor.type.isThis()) {
                            this.patternLocator.match(constructor.type, this.nodeSet);
                        }
                        if (constructor.arguments != null) {
                            int a = 0;
                            al = constructor.arguments.length;
                            while (a < al) {
                                this.patternLocator.match(constructor.arguments[a], this.nodeSet);
                                argument = (JavadocArgumentExpression)constructor.arguments[a];
                                if (argument.argument != null && argument.argument.type != null) {
                                    this.patternLocator.match(argument.argument.type, this.nodeSet);
                                }
                                ++a;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void classInstanceCreation(boolean alwaysQualified) {
        super.classInstanceCreation(alwaysQualified);
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeAssignment() {
        super.consumeAssignment();
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeClassInstanceCreationExpressionQualifiedWithTypeArguments() {
        super.consumeClassInstanceCreationExpressionWithTypeArguments();
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeClassInstanceCreationExpressionWithTypeArguments() {
        super.consumeClassInstanceCreationExpressionWithTypeArguments();
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeExplicitConstructorInvocation(int flag, int recFlag) {
        super.consumeExplicitConstructorInvocation(flag, recFlag);
        this.patternLocator.match(this.astStack[this.astPtr], this.nodeSet);
    }

    protected void consumeExplicitConstructorInvocationWithTypeArguments(int flag, int recFlag) {
        super.consumeExplicitConstructorInvocationWithTypeArguments(flag, recFlag);
        this.patternLocator.match(this.astStack[this.astPtr], this.nodeSet);
    }

    protected void consumeFieldAccess(boolean isSuperAccess) {
        super.consumeFieldAccess(isSuperAccess);
        this.patternLocator.match((Reference)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeFormalParameter(boolean isVarArgs) {
        super.consumeFormalParameter(isVarArgs);
        this.patternLocator.match((LocalDeclaration)this.astStack[this.astPtr], this.nodeSet);
    }

    protected void consumeLocalVariableDeclaration() {
        super.consumeLocalVariableDeclaration();
        this.patternLocator.match((LocalDeclaration)this.astStack[this.astPtr], this.nodeSet);
    }

    protected void consumeMarkerAnnotation() {
        super.consumeMarkerAnnotation();
        Annotation annotation = (Annotation)this.expressionStack[this.expressionPtr];
        this.patternLocator.match(annotation, this.nodeSet);
    }

    protected void consumeMemberValuePair() {
        super.consumeMemberValuePair();
        this.patternLocator.match((MemberValuePair)this.astStack[this.astPtr], this.nodeSet);
    }

    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        this.patternLocator.match((MessageSend)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeMethodInvocationNameWithTypeArguments() {
        super.consumeMethodInvocationNameWithTypeArguments();
        this.patternLocator.match((MessageSend)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeMethodInvocationPrimary() {
        super.consumeMethodInvocationPrimary();
        this.patternLocator.match((MessageSend)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeMethodInvocationPrimaryWithTypeArguments() {
        super.consumeMethodInvocationPrimaryWithTypeArguments();
        this.patternLocator.match((MessageSend)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeMethodInvocationSuper() {
        super.consumeMethodInvocationSuper();
        this.patternLocator.match((MessageSend)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeMethodInvocationSuperWithTypeArguments() {
        super.consumeMethodInvocationSuperWithTypeArguments();
        this.patternLocator.match((MessageSend)this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected void consumeNormalAnnotation() {
        super.consumeNormalAnnotation();
        Annotation annotation = (Annotation)this.expressionStack[this.expressionPtr];
        this.patternLocator.match(annotation, this.nodeSet);
    }

    protected void consumePrimaryNoNewArray() {
        --this.intPtr;
        --this.intPtr;
    }

    protected void consumePrimaryNoNewArrayWithName() {
        this.pushOnExpressionStack(this.getUnspecifiedReferenceOptimized());
        --this.intPtr;
        --this.intPtr;
    }

    protected void consumeSingleMemberAnnotation() {
        super.consumeSingleMemberAnnotation();
        Annotation annotation = (Annotation)this.expressionStack[this.expressionPtr];
        this.patternLocator.match(annotation, this.nodeSet);
    }

    protected void consumeTypeArgument() {
        super.consumeTypeArgument();
        this.patternLocator.match((TypeReference)this.genericsStack[this.genericsPtr], this.nodeSet);
    }

    protected void consumeTypeParameterHeader() {
        super.consumeTypeParameterHeader();
        this.patternLocator.match((TypeParameter)this.genericsStack[this.genericsPtr], this.nodeSet);
    }

    protected void consumeUnaryExpression(int op, boolean post) {
        super.consumeUnaryExpression(op, post);
        this.patternLocator.match(this.expressionStack[this.expressionPtr], this.nodeSet);
    }

    protected TypeReference copyDims(TypeReference typeRef, int dim) {
        TypeReference result = super.copyDims(typeRef, dim);
        if (this.nodeSet.removePossibleMatch(typeRef) != null) {
            this.nodeSet.addPossibleMatch(result);
        } else if (this.nodeSet.removeTrustedMatch(typeRef) != null) {
            this.nodeSet.addTrustedMatch((ASTNode)result, true);
        }
        return result;
    }

    protected TypeReference getTypeReference(int dim) {
        TypeReference typeRef = super.getTypeReference(dim);
        this.patternLocator.match(typeRef, this.nodeSet);
        return typeRef;
    }

    protected NameReference getUnspecifiedReference() {
        NameReference nameRef = super.getUnspecifiedReference();
        this.patternLocator.match(nameRef, this.nodeSet);
        return nameRef;
    }

    protected NameReference getUnspecifiedReferenceOptimized() {
        NameReference nameRef = super.getUnspecifiedReferenceOptimized();
        this.patternLocator.match(nameRef, this.nodeSet);
        return nameRef;
    }

    public void parseBodies(CompilationUnitDeclaration unit) {
        TypeDeclaration[] types = unit.types;
        if (types == null) {
            return;
        }
        int i = 0;
        while (i < types.length) {
            TypeDeclaration type = types[i];
            this.patternLocator.match(type, this.nodeSet);
            this.parseBodies(type, unit);
            ++i;
        }
    }

    protected void parseBodies(TypeDeclaration type, CompilationUnitDeclaration unit) {
        TypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                FieldDeclaration field = fields[i];
                if (field instanceof Initializer) {
                    this.parse((Initializer)field, type, unit);
                }
                field.traverse(this.localDeclarationVisitor, null);
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            while (i < methods.length) {
                AbstractMethodDeclaration method = methods[i];
                if (method.sourceStart >= type.bodyStart) {
                    if (method instanceof MethodDeclaration) {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)method;
                        this.parse(methodDeclaration, unit);
                        methodDeclaration.traverse(this.localDeclarationVisitor, (ClassScope)null);
                    } else if (method instanceof ConstructorDeclaration) {
                        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)method;
                        this.parse(constructorDeclaration, unit);
                        constructorDeclaration.traverse(this.localDeclarationVisitor, (ClassScope)null);
                    }
                } else if (method.isDefaultConstructor()) {
                    method.parseStatements(this, unit);
                }
                ++i;
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                TypeDeclaration memberType = memberTypes[i];
                this.parseBodies(memberType, unit);
                memberType.traverse(this.localDeclarationVisitor, (ClassScope)null);
                ++i;
            }
        }
    }

    public class ClassAndMethodDeclarationVisitor
    extends ClassButNoMethodDeclarationVisitor {
        public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
            MatchLocatorParser.this.patternLocator.match(localTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }
    }

    public class ClassButNoMethodDeclarationVisitor
    extends ASTVisitor {
        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            MatchLocatorParser.this.patternLocator.match(constructorDeclaration, MatchLocatorParser.this.nodeSet);
            return (constructorDeclaration.bits & 2) != 0;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            MatchLocatorParser.this.patternLocator.match(fieldDeclaration, MatchLocatorParser.this.nodeSet);
            return (fieldDeclaration.bits & 2) != 0;
        }

        public boolean visit(Initializer initializer, MethodScope scope) {
            MatchLocatorParser.this.patternLocator.match(initializer, MatchLocatorParser.this.nodeSet);
            return (initializer.bits & 2) != 0;
        }

        public boolean visit(TypeDeclaration memberTypeDeclaration, ClassScope scope) {
            MatchLocatorParser.this.patternLocator.match(memberTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            MatchLocatorParser.this.patternLocator.match(methodDeclaration, MatchLocatorParser.this.nodeSet);
            return (methodDeclaration.bits & 2) != 0;
        }

        public boolean visit(AnnotationMethodDeclaration methodDeclaration, ClassScope scope) {
            MatchLocatorParser.this.patternLocator.match(methodDeclaration, MatchLocatorParser.this.nodeSet);
            return false;
        }
    }

    public class MethodButNoClassDeclarationVisitor
    extends NoClassNoMethodDeclarationVisitor {
        public boolean visit(TypeDeclaration localTypeDeclaration, BlockScope scope) {
            MatchLocatorParser.this.patternLocator.match(localTypeDeclaration, MatchLocatorParser.this.nodeSet);
            return true;
        }
    }

    public class NoClassNoMethodDeclarationVisitor
    extends ASTVisitor {
        public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
            return (constructorDeclaration.bits & 2) != 0;
        }

        public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
            return (fieldDeclaration.bits & 2) != 0;
        }

        public boolean visit(Initializer initializer, MethodScope scope) {
            return (initializer.bits & 2) != 0;
        }

        public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
            return (methodDeclaration.bits & 2) != 0;
        }
    }
}

