/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.matching;

import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.search.SearchDocument;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.ClassFileReader;
import com.netflix.nebula.lint.jdt.internal.compiler.env.ICompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.BinaryType;
import com.netflix.nebula.lint.jdt.internal.core.ClassFile;
import com.netflix.nebula.lint.jdt.internal.core.CompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.Openable;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.SourceMapper;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchLocator;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchingNodeSet;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;

public class PossibleMatch
implements ICompilationUnit {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    public IResource resource;
    public Openable openable;
    public MatchingNodeSet nodeSet;
    public char[][] compoundName;
    CompilationUnitDeclaration parsedUnit;
    public SearchDocument document;
    private String sourceFileName;
    private char[] source;

    public PossibleMatch(MatchLocator locator, IResource resource, Openable openable, SearchDocument document, boolean mustResolve) {
        this.resource = resource;
        this.openable = openable;
        this.document = document;
        this.nodeSet = new MatchingNodeSet(mustResolve);
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            this.compoundName = CharOperation.splitOn('.', qualifiedName);
        }
    }

    public void cleanUp() {
        this.source = null;
        if (this.parsedUnit != null) {
            this.parsedUnit.cleanUp();
            this.parsedUnit = null;
        }
        this.nodeSet = null;
    }

    public boolean equals(Object obj) {
        if (this.compoundName == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof PossibleMatch)) {
            return false;
        }
        return CharOperation.equals(this.compoundName, ((PossibleMatch)obj).compoundName);
    }

    public char[] getContents() {
        if (this.source != null) {
            return this.source;
        }
        if (this.openable instanceof ClassFile) {
            String fileName = this.getSourceFileName();
            if (fileName == NO_SOURCE_FILE_NAME) {
                return CharOperation.NO_CHAR;
            }
            SourceMapper sourceMapper = this.openable.getSourceMapper();
            IType type = ((ClassFile)this.openable).getType();
            this.source = sourceMapper.findSource(type, fileName);
            return this.source;
        }
        this.source = this.document.getCharContents();
        return this.source;
    }

    public char[] getFileName() {
        return this.openable.getElementName().toCharArray();
    }

    public char[] getMainTypeName() {
        return this.compoundName[this.compoundName.length - 1];
    }

    public char[][] getPackageName() {
        int length = this.compoundName.length;
        if (length <= 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return CharOperation.subarray(this.compoundName, 0, length - 1);
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof CompilationUnit) {
            String fileName = this.openable.getElementName();
            char[] mainTypeName = Util.getNameWithoutJavaLikeExtension(fileName).toCharArray();
            CompilationUnit cu = (CompilationUnit)this.openable;
            return cu.getType(new String(mainTypeName)).getFullyQualifiedName().toCharArray();
        }
        if (this.openable instanceof ClassFile) {
            String fileName = this.getSourceFileName();
            if (fileName == NO_SOURCE_FILE_NAME) {
                return ((ClassFile)this.openable).getType().getFullyQualifiedName('.').toCharArray();
            }
            int index = Util.indexOfJavaLikeExtension(fileName);
            String simpleName = index == -1 ? fileName : fileName.substring(0, index);
            PackageFragment pkg = (PackageFragment)this.openable.getParent();
            return Util.concatWith(pkg.names, simpleName, '.').toCharArray();
        }
        return null;
    }

    private String getSourceFileName() {
        BinaryType type;
        ClassFileReader reader;
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        this.sourceFileName = NO_SOURCE_FILE_NAME;
        if (this.openable.getSourceMapper() != null && (reader = MatchLocator.classFileReader(type = (BinaryType)((ClassFile)this.openable).getType())) != null) {
            String fileName = type.sourceFileName(reader);
            this.sourceFileName = fileName == null ? NO_SOURCE_FILE_NAME : fileName;
        }
        return this.sourceFileName;
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int hashCode = 0;
        int i = 0;
        int length = this.compoundName.length;
        while (i < length) {
            hashCode += CharOperation.hashCode(this.compoundName[i]);
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        return this.openable == null ? "Fake PossibleMatch" : this.openable.toString();
    }
}

