/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.formatter;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.compiler.InvalidInputException;
import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Annotation;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Scanner;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.ScannerHelper;
import com.netflix.nebula.lint.jdt.internal.compiler.util.Util;
import com.netflix.nebula.lint.jdt.internal.core.util.CodeSnippetParsingUtil;
import com.netflix.nebula.lint.jdt.internal.core.util.RecordedParsingInformation;
import com.netflix.nebula.lint.jdt.internal.formatter.AbortFormatting;
import com.netflix.nebula.lint.jdt.internal.formatter.CodeFormatterVisitor;
import com.netflix.nebula.lint.jdt.internal.formatter.Location;
import com.netflix.nebula.lint.jdt.internal.formatter.OptimizedReplaceEdit;
import com.netflix.nebula.lint.jdt.internal.formatter.align.Alignment;
import com.netflix.nebula.lint.jdt.internal.formatter.align.AlignmentException;
import java.util.Arrays;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class Scribe {
    private static final int INITIAL_SIZE = 100;
    private boolean checkLineWrapping;
    public int column;
    private int[][] commentPositions;
    public Alignment currentAlignment;
    public int currentToken;
    private OptimizedReplaceEdit[] edits;
    public int editsIndex;
    public CodeFormatterVisitor formatter;
    public int indentationLevel;
    public int lastNumberOfNewLines;
    public int line;
    private int[] lineEnds;
    private String lineSeparator;
    public Alignment memberAlignment;
    public boolean needSpace = false;
    public int nlsTagCounter;
    public int pageWidth;
    public boolean pendingSpace = false;
    public Scanner scanner;
    public int scannerEndPosition;
    public int tabLength;
    public int indentationSize;
    private int textRegionEnd;
    private int textRegionStart;
    public int tabChar;
    public int numberOfIndentations;
    private boolean useTabsOnlyForLeadingIndents;
    private final boolean indentEmptyLines;
    private final boolean formatJavadocComment;
    private final boolean formatBlockComment;

    Scribe(CodeFormatterVisitor formatter, long sourceLevel, int offset, int length, CodeSnippetParsingUtil codeSnippetParsingUtil) {
        RecordedParsingInformation information;
        this.scanner = new Scanner(true, true, false, sourceLevel, null, null, true);
        this.formatter = formatter;
        this.pageWidth = formatter.preferences.page_width;
        this.tabLength = formatter.preferences.tab_size;
        this.indentationLevel = 0;
        this.numberOfIndentations = 0;
        this.useTabsOnlyForLeadingIndents = formatter.preferences.use_tabs_only_for_leading_indentations;
        this.indentEmptyLines = formatter.preferences.indent_empty_lines;
        this.tabChar = formatter.preferences.tab_char;
        this.indentationSize = this.tabChar == 4 ? formatter.preferences.indentation_size : this.tabLength;
        this.lineSeparator = formatter.preferences.line_separator;
        this.indentationLevel = formatter.preferences.initial_indentation_level * this.indentationSize;
        this.textRegionStart = offset;
        this.textRegionEnd = offset + length - 1;
        if (codeSnippetParsingUtil != null && (information = codeSnippetParsingUtil.recordedParsingInformation) != null) {
            this.lineEnds = information.lineEnds;
            this.commentPositions = information.commentPositions;
        }
        this.formatBlockComment = formatter.preferences.comment_format_block_comment;
        this.formatJavadocComment = formatter.preferences.comment_format_javadoc_comment;
        this.reset();
    }

    private final void addDeleteEdit(int start, int end) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, Util.EMPTY_STRING);
    }

    public final void addInsertEdit(int insertPosition, String insertedString) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(insertPosition, 0, insertedString);
    }

    private final void addOptimizedReplaceEdit(int offset, int length, String replacement) {
        if (this.editsIndex > 0) {
            OptimizedReplaceEdit previous = this.edits[this.editsIndex - 1];
            int previousOffset = previous.offset;
            int previousLength = previous.length;
            int endOffsetOfPreviousEdit = previousOffset + previousLength;
            int replacementLength = replacement.length();
            String previousReplacement = previous.replacement;
            int previousReplacementLength = previousReplacement.length();
            if (previousOffset == offset && previousLength == length && (replacementLength == 0 || previousReplacementLength == 0)) {
                if (this.currentAlignment != null) {
                    Location location = this.currentAlignment.location;
                    if (location.editsIndex == this.editsIndex) {
                        --location.editsIndex;
                        location.textEdit = previous;
                    }
                }
                --this.editsIndex;
                return;
            }
            if (endOffsetOfPreviousEdit == offset) {
                if (length != 0) {
                    if (replacementLength != 0) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, String.valueOf(previousReplacement) + replacement);
                    } else if (previousLength + length == previousReplacementLength) {
                        boolean canBeRemoved = true;
                        int i = previousOffset;
                        while (i < previousOffset + previousReplacementLength) {
                            if (this.scanner.source[i] != previousReplacement.charAt(i - previousOffset)) {
                                this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousReplacementLength, previousReplacement);
                                canBeRemoved = false;
                                break;
                            }
                            ++i;
                        }
                        if (canBeRemoved) {
                            if (this.currentAlignment != null) {
                                Location location = this.currentAlignment.location;
                                if (location.editsIndex == this.editsIndex) {
                                    --location.editsIndex;
                                    location.textEdit = previous;
                                }
                            }
                            --this.editsIndex;
                        }
                    } else {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength + length, previousReplacement);
                    }
                } else if (replacementLength != 0) {
                    this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(previousOffset, previousLength, String.valueOf(previousReplacement) + replacement);
                }
            } else if (offset + length == previousOffset && previousLength + length == replacementLength + previousReplacementLength) {
                boolean canBeRemoved = true;
                String totalReplacement = String.valueOf(replacement) + previousReplacement;
                int i = 0;
                while (i < previousLength + length) {
                    if (this.scanner.source[i + offset] != totalReplacement.charAt(i)) {
                        this.edits[this.editsIndex - 1] = new OptimizedReplaceEdit(offset, previousLength + length, totalReplacement);
                        canBeRemoved = false;
                        break;
                    }
                    ++i;
                }
                if (canBeRemoved) {
                    if (this.currentAlignment != null) {
                        Location location = this.currentAlignment.location;
                        if (location.editsIndex == this.editsIndex) {
                            --location.editsIndex;
                            location.textEdit = previous;
                        }
                    }
                    --this.editsIndex;
                }
            } else {
                this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
            }
        } else {
            this.edits[this.editsIndex++] = new OptimizedReplaceEdit(offset, length, replacement);
        }
    }

    public final void addReplaceEdit(int start, int end, String replacement) {
        if (this.edits.length == this.editsIndex) {
            this.resize();
        }
        this.addOptimizedReplaceEdit(start, end - start + 1, replacement);
    }

    public void alignFragment(Alignment alignment, int fragmentIndex) {
        alignment.fragmentIndex = fragmentIndex;
        alignment.checkColumn();
        alignment.performFragmentEffect();
    }

    public void checkNLSTag(int sourceStart) {
        if (this.hasNLSTag(sourceStart)) {
            ++this.nlsTagCounter;
        }
    }

    public void consumeNextToken() {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart) {
        return this.createAlignment(name, mode, 2, count, sourceRestart);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart) {
        return this.createAlignment(name, mode, tieBreakRule, count, sourceRestart, this.formatter.preferences.continuation_indentation, false);
    }

    public Alignment createAlignment(String name, int mode, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        return this.createAlignment(name, mode, 2, count, sourceRestart, continuationIndent, adjust);
    }

    public Alignment createAlignment(String name, int mode, int tieBreakRule, int count, int sourceRestart, int continuationIndent, boolean adjust) {
        Alignment alignment = new Alignment(name, mode, tieBreakRule, this, count, sourceRestart, continuationIndent);
        if (adjust && this.memberAlignment != null) {
            Alignment current = this.memberAlignment;
            while (current.enclosing != null) {
                current = current.enclosing;
            }
            if ((current.mode & 0x100) != 0) {
                int indentSize = this.indentationSize;
                switch (current.chunkKind) {
                    case 2: 
                    case 3: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                        alignment.update();
                        break;
                    }
                    case 1: {
                        alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                        alignment.update();
                    }
                }
            } else {
                block4 : switch (current.mode & 0x70) {
                    case 16: 
                    case 32: 
                    case 48: 
                    case 64: 
                    case 80: {
                        int indentSize = this.indentationSize;
                        switch (current.chunkKind) {
                            case 2: 
                            case 3: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? this.indentationLevel + indentSize : this.indentationLevel + continuationIndent * indentSize;
                                alignment.update();
                                break block4;
                            }
                            case 1: {
                                alignment.breakIndentationLevel = (mode & 4) != 0 ? current.originalIndentationLevel + indentSize : current.originalIndentationLevel + continuationIndent * indentSize;
                                alignment.update();
                            }
                        }
                    }
                }
            }
        }
        return alignment;
    }

    public Alignment createMemberAlignment(String name, int mode, int count, int sourceRestart) {
        Alignment mAlignment = this.createAlignment(name, mode, 2, count, sourceRestart);
        mAlignment.breakIndentationLevel = this.indentationLevel;
        return mAlignment;
    }

    public void enterAlignment(Alignment alignment) {
        alignment.enclosing = this.currentAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.currentAlignment = alignment;
    }

    public void enterMemberAlignment(Alignment alignment) {
        alignment.enclosing = this.memberAlignment;
        alignment.location.lastLocalDeclarationSourceStart = this.formatter.lastLocalDeclarationSourceStart;
        this.memberAlignment = alignment;
    }

    public void exitAlignment(Alignment alignment, boolean discardAlignment) {
        Alignment current = this.currentAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = alignment.location.outputIndentationLevel;
        this.numberOfIndentations = alignment.location.numberOfIndentations;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        if (discardAlignment) {
            this.currentAlignment = alignment.enclosing;
        }
    }

    public void exitMemberAlignment(Alignment alignment) {
        Alignment current = this.memberAlignment;
        while (current != null) {
            if (current == alignment) break;
            current = current.enclosing;
        }
        if (current == null) {
            throw new AbortFormatting("could not find matching alignment: " + alignment);
        }
        this.indentationLevel = current.location.outputIndentationLevel;
        this.numberOfIndentations = current.location.numberOfIndentations;
        this.formatter.lastLocalDeclarationSourceStart = alignment.location.lastLocalDeclarationSourceStart;
        this.memberAlignment = current.enclosing;
    }

    public Alignment getAlignment(String name) {
        if (this.currentAlignment != null) {
            return this.currentAlignment.getAlignment(name);
        }
        return null;
    }

    public int getColumnIndentationLevel() {
        return this.column - 1;
    }

    public final int getCommentIndex(int position) {
        if (this.commentPositions == null) {
            return -1;
        }
        int length = this.commentPositions.length;
        if (length == 0) {
            return -1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = g + (d - g) / 2;
            int bound = this.commentPositions[m][1];
            if (bound < 0) {
                bound = -bound;
            }
            if (bound < position) {
                g = m + 1;
                continue;
            }
            if (bound > position) {
                d = m - 1;
                continue;
            }
            return m;
        }
        return -(g + 1);
    }

    private int getCurrentCommentOffset(int start) {
        int linePtr = -Arrays.binarySearch(this.lineEnds, start);
        int offset = 0;
        int beginningOfLine = this.getLineEnd(linePtr - 1);
        if (beginningOfLine == -1) {
            beginningOfLine = 0;
        }
        int currentStartPosition = start;
        char[] source = this.scanner.source;
        while (beginningOfLine > currentStartPosition) {
            if (linePtr > 0) {
                beginningOfLine = this.getLineEnd(--linePtr);
                continue;
            }
            beginningOfLine = 0;
            break;
        }
        int i = currentStartPosition - 1;
        while (i >= beginningOfLine) {
            char currentCharacter = source[i];
            switch (currentCharacter) {
                case '\t': {
                    offset += this.tabLength;
                    break;
                }
                case ' ': {
                    ++offset;
                    break;
                }
                case '\n': 
                case '\r': {
                    break;
                }
                default: {
                    return offset;
                }
            }
            --i;
        }
        return offset;
    }

    public String getEmptyLines(int linesNumber) {
        if (this.nlsTagCounter > 0) {
            return Util.EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.lastNumberOfNewLines == 0) {
            ++linesNumber;
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else if (this.lastNumberOfNewLines == 1) {
            int i = 0;
            while (i < linesNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += linesNumber;
            this.line += linesNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        } else {
            if (this.lastNumberOfNewLines - 1 >= linesNumber) {
                return Util.EMPTY_STRING;
            }
            int realNewLineNumber = linesNumber - this.lastNumberOfNewLines + 1;
            int i = 0;
            while (i < realNewLineNumber) {
                if (this.indentEmptyLines) {
                    this.printIndentationIfNecessary(buffer);
                }
                buffer.append(this.lineSeparator);
                ++i;
            }
            this.lastNumberOfNewLines += realNewLineNumber;
            this.line += realNewLineNumber;
            this.column = 1;
            this.needSpace = false;
            this.pendingSpace = false;
        }
        return String.valueOf(buffer);
    }

    public OptimizedReplaceEdit getLastEdit() {
        if (this.editsIndex > 0) {
            return this.edits[this.editsIndex - 1];
        }
        return null;
    }

    public final int getLineEnd(int lineNumber) {
        if (this.lineEnds == null) {
            return -1;
        }
        if (lineNumber >= this.lineEnds.length + 1) {
            return this.scannerEndPosition;
        }
        if (lineNumber <= 0) {
            return -1;
        }
        return this.lineEnds[lineNumber - 1];
    }

    Alignment getMemberAlignment() {
        return this.memberAlignment;
    }

    public String getNewLine() {
        if (this.nlsTagCounter > 0) {
            return Util.EMPTY_STRING;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return Util.EMPTY_STRING;
        }
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
        return this.lineSeparator;
    }

    public int getNextIndentationLevel(int someColumn) {
        int indent = someColumn - 1;
        if (indent == 0) {
            return this.indentationLevel;
        }
        if (this.tabChar == 1) {
            if (this.useTabsOnlyForLeadingIndents) {
                return indent;
            }
            int rem = indent % this.indentationSize;
            int addition = rem == 0 ? 0 : this.indentationSize - rem;
            return indent + addition;
        }
        return indent;
    }

    private String getPreserveEmptyLines(int count) {
        if (count > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                return this.getEmptyLines(linesToPreserve);
            }
            return this.getNewLine();
        }
        return Util.EMPTY_STRING;
    }

    public TextEdit getRootEdit() {
        MultiTextEdit edit = null;
        int length = this.textRegionEnd - this.textRegionStart + 1;
        edit = this.textRegionStart <= 0 ? (length <= 0 ? new MultiTextEdit(0, 0) : new MultiTextEdit(0, this.textRegionEnd + 1)) : new MultiTextEdit(this.textRegionStart, this.textRegionEnd - this.textRegionStart + 1);
        int i = 0;
        int max = this.editsIndex;
        while (i < max) {
            OptimizedReplaceEdit currentEdit = this.edits[i];
            if (this.isValidEdit(currentEdit)) {
                edit.addChild((TextEdit)new ReplaceEdit(currentEdit.offset, currentEdit.length, currentEdit.replacement));
            }
            ++i;
        }
        this.edits = null;
        return edit;
    }

    public void handleLineTooLong() {
        int relativeDepth = 0;
        int outerMostDepth = -1;
        Alignment targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.tieBreakRule == 1 && targetAlignment.couldBreak()) {
                outerMostDepth = relativeDepth;
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
        if (outerMostDepth >= 0) {
            throw new AlignmentException(1, outerMostDepth);
        }
        relativeDepth = 0;
        targetAlignment = this.currentAlignment;
        while (targetAlignment != null) {
            if (targetAlignment.couldBreak()) {
                throw new AlignmentException(1, relativeDepth);
            }
            targetAlignment = targetAlignment.enclosing;
            ++relativeDepth;
        }
    }

    private boolean hasNLSTag(int sourceStart) {
        if (this.lineEnds == null) {
            return false;
        }
        int index = Arrays.binarySearch(this.lineEnds, sourceStart);
        int currentLineEnd = this.getLineEnd(-index);
        if (currentLineEnd != -1) {
            int lineIndexForComment;
            int start;
            int commentIndex = this.getCommentIndex(currentLineEnd);
            if (commentIndex < 0) {
                commentIndex = -commentIndex - 2;
            }
            if (commentIndex >= 0 && commentIndex < this.commentPositions.length && (start = this.commentPositions[commentIndex][0]) < 0 && (lineIndexForComment = Arrays.binarySearch(this.lineEnds, start = -start)) == index) {
                return CharOperation.indexOf(Scanner.TAG_PREFIX, this.scanner.source, true, start, currentLineEnd) != -1;
            }
        }
        return false;
    }

    public void indent() {
        this.indentationLevel += this.indentationSize;
        ++this.numberOfIndentations;
    }

    public void initializeScanner(char[] compilationUnitSource) {
        this.scanner.setSource(compilationUnitSource);
        this.scannerEndPosition = compilationUnitSource.length;
        this.scanner.resetTo(0, this.scannerEndPosition - 1);
        this.edits = new OptimizedReplaceEdit[100];
    }

    private boolean isOnFirstColumn(int start) {
        if (this.lineEnds == null) {
            return start == 0;
        }
        int index = Arrays.binarySearch(this.lineEnds, start);
        int previousLineEnd = this.getLineEnd(-index - 1);
        return previousLineEnd != -1 && previousLineEnd == start - 1;
    }

    private boolean isValidEdit(OptimizedReplaceEdit edit) {
        int editLength = edit.length;
        int editReplacementLength = edit.replacement.length();
        int editOffset = edit.offset;
        if (editLength != 0) {
            if (this.textRegionStart <= editOffset && editOffset + editLength - 1 <= this.textRegionEnd) {
                if (editReplacementLength != 0 && editLength == editReplacementLength) {
                    int i = editOffset;
                    int max = editOffset + editLength;
                    while (i < max) {
                        if (this.scanner.source[i] != edit.replacement.charAt(i - editOffset)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                return true;
            }
            if (editOffset + editLength == this.textRegionStart) {
                int i = editOffset;
                int max = editOffset + editLength;
                while (i < max) {
                    int replacementStringIndex = i - editOffset;
                    if (replacementStringIndex >= editReplacementLength || this.scanner.source[i] != edit.replacement.charAt(replacementStringIndex)) break;
                    ++i;
                }
                if (i - editOffset != editReplacementLength && i != editOffset + editLength - 1) {
                    edit.offset = this.textRegionStart;
                    edit.length = 0;
                    edit.replacement = edit.replacement.substring(i - editOffset);
                    return true;
                }
            }
        } else {
            if (this.textRegionStart <= editOffset && editOffset <= this.textRegionEnd) {
                return true;
            }
            if (editOffset == this.scannerEndPosition && editOffset == this.textRegionEnd + 1) {
                return true;
            }
        }
        return false;
    }

    private void preserveEmptyLines(int count, int insertPosition) {
        if (count > 0) {
            if (this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                int linesToPreserve = Math.min(count, this.formatter.preferences.number_of_empty_lines_to_preserve);
                this.printEmptyLines(linesToPreserve, insertPosition);
            } else {
                this.printNewLine(insertPosition);
            }
        }
    }

    private void print(char[] s, boolean considerSpaceIfAny) {
        if (this.checkLineWrapping && s.length + this.column > this.pageWidth) {
            this.handleLineTooLong();
        }
        this.lastNumberOfNewLines = 0;
        if (this.indentationLevel != 0) {
            this.printIndentationIfNecessary();
        }
        if (considerSpaceIfAny) {
            this.space();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), " ");
        }
        this.pendingSpace = false;
        this.needSpace = false;
        this.column += s.length;
        this.needSpace = true;
    }

    private void printBlockComment(char[] s, boolean isJavadoc) {
        int currentCharacter;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        int currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1;
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        boolean isNewLine = false;
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        int previousStart = currentTokenStartPosition;
        boolean onFirstColumn = this.isOnFirstColumn(start);
        boolean indentComment = false;
        if (!(this.indentationLevel == 0 || !isJavadoc && this.formatter.preferences.never_indent_block_comments_on_first_column && onFirstColumn)) {
            indentComment = true;
            this.printIndentationIfNecessary();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(currentTokenStartPosition, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int currentCommentOffset = onFirstColumn ? 0 : this.getCurrentCommentOffset(start);
        boolean formatComment = isJavadoc && this.formatJavadocComment || !isJavadoc && this.formatBlockComment;
        while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.currentPosition;
            switch (currentCharacter) {
                case 13: {
                    start = previousStart;
                    isNewLine = true;
                    if (!this.scanner.getNextChar('\n')) break;
                    currentCharacter = 10;
                    nextCharacterStart = this.scanner.currentPosition;
                    break;
                }
                case 10: {
                    start = previousStart;
                    isNewLine = true;
                    nextCharacterStart = this.scanner.currentPosition;
                    break;
                }
                default: {
                    if (isNewLine) {
                        int previousStartPosition;
                        this.column = 1;
                        ++this.line;
                        isNewLine = false;
                        StringBuffer buffer = new StringBuffer();
                        if (onFirstColumn) {
                            buffer.append(this.lineSeparator);
                            if (indentComment) {
                                this.printIndentationIfNecessary(buffer);
                            }
                            if (formatComment) {
                                if (ScannerHelper.isWhitespace((char)currentCharacter)) {
                                    previousStartPosition = this.scanner.currentPosition;
                                    while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && ScannerHelper.isWhitespace((char)currentCharacter)) {
                                        previousStart = nextCharacterStart;
                                        previousStartPosition = this.scanner.currentPosition;
                                        currentCharacter = this.scanner.getNextChar();
                                        nextCharacterStart = this.scanner.currentPosition;
                                    }
                                    if (currentCharacter == 13 || currentCharacter == 10) {
                                        nextCharacterStart = previousStartPosition;
                                    }
                                }
                                if (currentCharacter != 13 && currentCharacter != 10) {
                                    buffer.append(' ');
                                }
                            }
                        } else {
                            if (ScannerHelper.isWhitespace((char)currentCharacter)) {
                                previousStartPosition = this.scanner.currentPosition;
                                int count = 0;
                                while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && ScannerHelper.isWhitespace((char)currentCharacter)) {
                                    if (count >= currentCommentOffset) break;
                                    previousStart = nextCharacterStart;
                                    previousStartPosition = this.scanner.currentPosition;
                                    switch (currentCharacter) {
                                        case 9: {
                                            count += this.tabLength;
                                            break;
                                        }
                                        default: {
                                            ++count;
                                        }
                                    }
                                    currentCharacter = this.scanner.getNextChar();
                                    nextCharacterStart = this.scanner.currentPosition;
                                }
                                if (currentCharacter == 13 || currentCharacter == 10) {
                                    nextCharacterStart = previousStartPosition;
                                }
                            }
                            buffer.append(this.lineSeparator);
                            if (indentComment) {
                                this.printIndentationIfNecessary(buffer);
                            }
                            if (formatComment) {
                                int previousStartTemp = previousStart;
                                int nextCharacterStartTemp = nextCharacterStart;
                                while (currentCharacter != -1 && currentCharacter != 13 && currentCharacter != 10 && ScannerHelper.isWhitespace((char)currentCharacter)) {
                                    previousStart = nextCharacterStart;
                                    currentCharacter = this.scanner.getNextChar();
                                    nextCharacterStart = this.scanner.currentPosition;
                                }
                                if (currentCharacter == 42) {
                                    buffer.append(' ');
                                } else {
                                    previousStart = previousStartTemp;
                                    nextCharacterStart = nextCharacterStartTemp;
                                }
                                this.scanner.currentPosition = nextCharacterStart;
                            }
                        }
                        this.addReplaceEdit(start, previousStart - 1, String.valueOf(buffer));
                        break;
                    }
                    this.column += nextCharacterStart - previousStart;
                }
            }
            previousStart = nextCharacterStart;
            this.scanner.currentPosition = nextCharacterStart;
        }
        this.lastNumberOfNewLines = 0;
        this.needSpace = false;
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
        if (isJavadoc) {
            this.printNewLine();
        }
    }

    public void printEndOfCompilationUnit() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasLineComment = false;
            boolean hasWhitespace = false;
            int count = 0;
            block14: while (true) {
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 1000: {
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        count = 0;
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count == 0) {
                            hasWhitespace = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasComment) {
                            if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasLineComment) {
                            this.preserveEmptyLines(count, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        continue block14;
                    }
                    case 1001: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printLineComment(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        count = 0;
                        continue block14;
                    }
                    case 1002: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        continue block14;
                    }
                    case 1003: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        continue block14;
                    }
                    case 27: {
                        char[] currentTokenSource = this.scanner.getRawTokenSource();
                        this.print(currentTokenSource, this.formatter.preferences.insert_space_before_semicolon);
                        continue block14;
                    }
                    case 68: {
                        if (count >= 1 || this.formatter.preferences.insert_new_line_at_end_of_file_if_missing) {
                            this.printNewLine(this.scannerEndPosition);
                        }
                        return;
                    }
                }
                break;
            }
            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
            return;
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printComment() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasLineComment = false;
            boolean hasWhitespace = false;
            int count = 0;
            while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 1000: {
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        count = 0;
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count == 0) {
                            hasWhitespace = true;
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasComment) {
                            if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            } else {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            }
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (hasLineComment) {
                            this.preserveEmptyLines(count, this.scanner.getCurrentTokenStartPosition());
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        } else if (count != 0 && this.formatter.preferences.number_of_empty_lines_to_preserve != 0) {
                            this.addReplaceEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition(), this.getPreserveEmptyLines(count - 1));
                        } else {
                            this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printLineComment(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        count = 0;
                        break;
                    }
                    case 1002: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        break;
                    }
                    case 1003: {
                        if (count >= 1) {
                            if (count > 1) {
                                this.preserveEmptyLines(count - 1, this.scanner.getCurrentTokenStartPosition());
                            } else if (count == 1) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                        } else if (hasWhitespace) {
                            this.space();
                        }
                        hasWhitespace = false;
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = false;
                        hasComment = true;
                        count = 0;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printLineComment(char[] s) {
        int currentCharacter;
        int currentTokenEndPosition;
        int currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
        if (CharOperation.indexOf(Scanner.TAG_PREFIX, this.scanner.source, true, currentTokenStartPosition, currentTokenEndPosition = this.scanner.getCurrentTokenEndPosition() + 1) != -1) {
            this.nlsTagCounter = 0;
        }
        this.scanner.resetTo(currentTokenStartPosition, currentTokenEndPosition - 1);
        int start = currentTokenStartPosition;
        int nextCharacterStart = currentTokenStartPosition;
        if (!(this.indentationLevel == 0 || this.formatter.preferences.never_indent_line_comments_on_first_column && this.isOnFirstColumn(start))) {
            this.printIndentationIfNecessary();
        }
        if (this.pendingSpace) {
            this.addInsertEdit(currentTokenStartPosition, " ");
        }
        this.needSpace = false;
        this.pendingSpace = false;
        int previousStart = currentTokenStartPosition;
        block4: while (nextCharacterStart <= currentTokenEndPosition && (currentCharacter = this.scanner.getNextChar()) != -1) {
            nextCharacterStart = this.scanner.currentPosition;
            switch (currentCharacter) {
                case 13: {
                    start = previousStart;
                    break block4;
                }
                case 10: {
                    start = previousStart;
                    break block4;
                }
                default: {
                    previousStart = nextCharacterStart;
                }
            }
        }
        if (start != currentTokenStartPosition) {
            this.addReplaceEdit(start, currentTokenEndPosition - 1, this.lineSeparator);
            ++this.line;
            this.column = 1;
            this.lastNumberOfNewLines = 1;
        }
        this.needSpace = false;
        this.pendingSpace = false;
        if (this.currentAlignment != null) {
            if (this.memberAlignment != null) {
                if (this.currentAlignment.location.inputOffset > this.memberAlignment.location.inputOffset) {
                    if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                        this.currentAlignment.performFragmentEffect();
                    }
                } else {
                    this.indentationLevel = Math.max(this.indentationLevel, this.memberAlignment.breakIndentationLevel);
                }
            } else if (this.currentAlignment.couldBreak() && this.currentAlignment.wasSplit) {
                this.currentAlignment.performFragmentEffect();
            }
        }
        this.scanner.resetTo(currentTokenEndPosition, this.scannerEndPosition - 1);
    }

    public void printEmptyLines(int linesNumber) {
        this.printEmptyLines(linesNumber, this.scanner.getCurrentTokenEndPosition() + 1);
    }

    private void printEmptyLines(int linesNumber, int insertPosition) {
        String buffer = this.getEmptyLines(linesNumber);
        if (Util.EMPTY_STRING == buffer) {
            return;
        }
        this.addInsertEdit(insertPosition, buffer);
    }

    void printIndentationIfNecessary() {
        StringBuffer buffer = new StringBuffer();
        this.printIndentationIfNecessary(buffer);
        if (buffer.length() > 0) {
            this.addInsertEdit(this.scanner.getCurrentTokenStartPosition(), buffer.toString());
            this.pendingSpace = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printIndentationIfNecessary(StringBuffer buffer) {
        switch (this.tabChar) {
            case 1: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = 0;
                if (!useTabsForLeadingIndents) ** GOTO lbl27
                while (this.column <= this.indentationLevel) {
                    if (indentationsAsTab < numberOfLeadingIndents) {
                        buffer.append('\t');
                        ++indentationsAsTab;
                        complement = this.tabLength - (this.column - 1) % this.tabLength;
                        this.column += complement;
                        this.needSpace = false;
                        continue;
                    }
                    buffer.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    buffer.append('\t');
                    complement = this.tabLength - (this.column - 1) % this.tabLength;
                    this.column += complement;
                    this.needSpace = false;
lbl27:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
lbl28:
                // 1 sources

                break;
            }
            case 2: {
                while (this.column <= this.indentationLevel) {
                    buffer.append(' ');
                    ++this.column;
                    this.needSpace = false;
                }
                break;
            }
            case 4: {
                useTabsForLeadingIndents = this.useTabsOnlyForLeadingIndents;
                numberOfLeadingIndents = this.numberOfIndentations;
                indentationsAsTab = false;
                if (!useTabsForLeadingIndents) ** GOTO lbl94
                columnForLeadingIndents = numberOfLeadingIndents * this.indentationSize;
                while (this.column <= this.indentationLevel) {
                    if (this.column <= columnForLeadingIndents) {
                        if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                            buffer.append('\t');
                            this.column += this.tabLength;
                        } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                            i = 0;
                            max = this.indentationSize;
                            while (i < max) {
                                buffer.append(' ');
                                ++this.column;
                                ++i;
                            }
                        } else {
                            buffer.append(' ');
                            ++this.column;
                        }
                    } else {
                        i = this.column;
                        max = this.indentationLevel;
                        while (i <= max) {
                            buffer.append(' ');
                            ++this.column;
                            ++i;
                        }
                    }
                    this.needSpace = false;
                }
                break;
lbl-1000:
                // 1 sources

                {
                    if (this.column - 1 + this.tabLength <= this.indentationLevel) {
                        buffer.append('\t');
                        this.column += this.tabLength;
                    } else if (this.column - 1 + this.indentationSize <= this.indentationLevel) {
                        i = 0;
                        max = this.indentationSize;
                        while (i < max) {
                            buffer.append(' ');
                            ++this.column;
                            ++i;
                        }
                    } else {
                        buffer.append(' ');
                        ++this.column;
                    }
                    this.needSpace = false;
lbl94:
                    // 2 sources

                    ** while (this.column <= this.indentationLevel)
                }
            }
        }
lbl95:
        // 6 sources

    }

    public void printModifiers(Annotation[] annotations, ASTVisitor visitor) {
        try {
            int annotationsLength = annotations != null ? annotations.length : 0;
            int annotationsIndex = 0;
            boolean isFirstModifier = true;
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasComment = false;
            boolean hasModifiers = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: {
                        hasModifiers = true;
                        this.print(this.scanner.getRawTokenSource(), !isFirstModifier);
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 53: {
                        hasModifiers = true;
                        if (!isFirstModifier) {
                            this.space();
                        }
                        this.scanner.resetTo(this.scanner.getCurrentTokenStartPosition(), this.scannerEndPosition - 1);
                        if (annotationsIndex < annotationsLength) {
                            annotations[annotationsIndex++].traverse(visitor, (BlockScope)null);
                            if (this.formatter.preferences.insert_new_line_after_annotation) {
                                this.printNewLine();
                            }
                        } else {
                            return;
                        }
                        isFirstModifier = false;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1002: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), true);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    case 1001: {
                        this.printLineComment(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (count >= 1 && hasComment) {
                            this.printNewLine();
                        }
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = false;
                        break;
                    }
                    default: {
                        if (hasModifiers) {
                            this.space();
                        }
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNewLine() {
        if (this.nlsTagCounter > 0) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(this.scanner.getCurrentTokenEndPosition() + 1, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
    }

    public void printNewLine(int insertPosition) {
        if (this.nlsTagCounter > 0) {
            return;
        }
        if (this.lastNumberOfNewLines >= 1) {
            this.column = 1;
            return;
        }
        this.addInsertEdit(insertPosition, this.lineSeparator);
        ++this.line;
        this.lastNumberOfNewLines = 1;
        this.column = 1;
        this.needSpace = false;
        this.pendingSpace = false;
    }

    public void printNextToken(int expectedTokenType) {
        this.printNextToken(expectedTokenType, false);
    }

    public void printNextToken(int expectedTokenType, boolean considerSpaceIfAny) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (expectedTokenType != this.currentToken) {
                throw new AbortFormatting("unexpected token type, expecting:" + expectedTokenType + ", actual:" + this.currentToken);
            }
            this.print(currentTokenSource, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printNextToken(int[] expectedTokenTypes) {
        this.printNextToken(expectedTokenTypes, false);
    }

    public void printNextToken(int[] expectedTokenTypes, boolean considerSpaceIfAny) {
        this.printComment();
        try {
            this.currentToken = this.scanner.getNextToken();
            char[] currentTokenSource = this.scanner.getRawTokenSource();
            if (Arrays.binarySearch(expectedTokenTypes, this.currentToken) < 0) {
                StringBuffer expectations = new StringBuffer(5);
                int i = 0;
                while (i < expectedTokenTypes.length) {
                    if (i > 0) {
                        expectations.append(',');
                    }
                    expectations.append(expectedTokenTypes[i]);
                    ++i;
                }
                throw new AbortFormatting("unexpected token type, expecting:[" + expectations.toString() + "], actual:" + this.currentToken);
            }
            this.print(currentTokenSource, considerSpaceIfAny);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printArrayQualifiedReference(int numberOfTokens, int sourceEnd) {
        int currentTokenStartPosition = this.scanner.currentPosition;
        int numberOfIdentifiers = 0;
        try {
            block10: do {
                this.printComment();
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 68: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1002: 
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        this.printLineComment(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 26: {
                        this.print(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        if (++numberOfIdentifiers != numberOfTokens) continue block10;
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                    case 3: {
                        this.print(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            } while (this.scanner.currentPosition <= sourceEnd);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printQualifiedReference(int sourceEnd) {
        int currentTokenStartPosition = this.scanner.currentPosition;
        try {
            do {
                this.printComment();
                this.currentToken = this.scanner.getNextToken();
                switch (this.currentToken) {
                    case 68: {
                        return;
                    }
                    case 1000: {
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1002: 
                    case 1003: {
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 1001: {
                        this.printLineComment(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    case 3: 
                    case 26: {
                        this.print(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            } while (this.scanner.currentPosition <= sourceEnd);
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    private void printRule(StringBuffer stringBuffer) {
        int i = 0;
        while (i < this.pageWidth) {
            if (i % this.tabLength == 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
            }
            ++i;
        }
        stringBuffer.append(this.lineSeparator);
        i = 0;
        while (i < this.pageWidth / this.tabLength) {
            stringBuffer.append(i);
            stringBuffer.append('\t');
            ++i;
        }
    }

    public void printTrailingComment(int numberOfNewLinesToInsert) {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasWhitespaces = false;
            boolean hasLineComment = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 1000: {
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (hasLineComment) {
                            if (count >= 1) {
                                currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(numberOfNewLinesToInsert, currentTokenStartPosition);
                                this.addDeleteEdit(currentTokenStartPosition, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        if (count > 1) {
                            this.printEmptyLines(numberOfNewLinesToInsert, this.scanner.getCurrentTokenStartPosition());
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        hasWhitespaces = true;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    case 1001: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printLineComment(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        break;
                    }
                    case 1002: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    public void printTrailingComment() {
        try {
            int currentTokenStartPosition = this.scanner.currentPosition;
            boolean hasWhitespaces = false;
            boolean hasComment = false;
            boolean hasLineComment = false;
            while ((this.currentToken = this.scanner.getNextToken()) != 68) {
                switch (this.currentToken) {
                    case 1000: {
                        int count = 0;
                        char[] whiteSpaces = this.scanner.getCurrentTokenSource();
                        int i = 0;
                        int max = whiteSpaces.length;
                        while (i < max) {
                            switch (whiteSpaces[i]) {
                                case '\r': {
                                    if (i + 1 < max && whiteSpaces[i + 1] == '\n') {
                                        ++i;
                                    }
                                    ++count;
                                    break;
                                }
                                case '\n': {
                                    ++count;
                                }
                            }
                            ++i;
                        }
                        if (hasLineComment) {
                            if (count >= 1) {
                                currentTokenStartPosition = this.scanner.getCurrentTokenStartPosition();
                                this.preserveEmptyLines(count, currentTokenStartPosition);
                                this.addDeleteEdit(currentTokenStartPosition, this.scanner.getCurrentTokenEndPosition());
                                this.scanner.resetTo(this.scanner.currentPosition, this.scannerEndPosition - 1);
                                return;
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        if (count >= 1) {
                            if (hasComment) {
                                this.printNewLine(this.scanner.getCurrentTokenStartPosition());
                            }
                            this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                            return;
                        }
                        hasWhitespaces = true;
                        currentTokenStartPosition = this.scanner.currentPosition;
                        this.addDeleteEdit(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
                        break;
                    }
                    case 1001: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printLineComment(this.scanner.getRawTokenSource());
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasLineComment = true;
                        break;
                    }
                    case 1002: {
                        if (hasWhitespaces) {
                            this.space();
                        }
                        this.printBlockComment(this.scanner.getRawTokenSource(), false);
                        currentTokenStartPosition = this.scanner.currentPosition;
                        hasComment = true;
                        break;
                    }
                    default: {
                        this.scanner.resetTo(currentTokenStartPosition, this.scannerEndPosition - 1);
                        return;
                    }
                }
            }
        }
        catch (InvalidInputException e) {
            throw new AbortFormatting(e);
        }
    }

    void redoAlignment(AlignmentException e) {
        if (e.relativeDepth > 0) {
            --e.relativeDepth;
            this.currentAlignment = this.currentAlignment.enclosing;
            throw e;
        }
        this.resetAt(this.currentAlignment.location);
        this.scanner.resetTo(this.currentAlignment.location.inputOffset, this.scanner.eofPosition);
        this.currentAlignment.chunkKind = 0;
    }

    void redoMemberAlignment(AlignmentException e) {
        this.resetAt(this.memberAlignment.location);
        this.scanner.resetTo(this.memberAlignment.location.inputOffset, this.scanner.eofPosition);
        this.memberAlignment.chunkKind = 0;
    }

    public void reset() {
        this.checkLineWrapping = true;
        this.line = 0;
        this.column = 1;
        this.editsIndex = 0;
        this.nlsTagCounter = 0;
    }

    private void resetAt(Location location) {
        this.line = location.outputLine;
        this.column = location.outputColumn;
        this.indentationLevel = location.outputIndentationLevel;
        this.numberOfIndentations = location.numberOfIndentations;
        this.lastNumberOfNewLines = location.lastNumberOfNewLines;
        this.needSpace = location.needSpace;
        this.pendingSpace = location.pendingSpace;
        this.editsIndex = location.editsIndex;
        this.nlsTagCounter = location.nlsTagCounter;
        if (this.editsIndex > 0) {
            this.edits[this.editsIndex - 1] = location.textEdit;
        }
        this.formatter.lastLocalDeclarationSourceStart = location.lastLocalDeclarationSourceStart;
    }

    private void resize() {
        this.edits = new OptimizedReplaceEdit[this.editsIndex * 2];
        System.arraycopy(this.edits, 0, this.edits, 0, this.editsIndex);
    }

    public void space() {
        if (!this.needSpace) {
            return;
        }
        this.lastNumberOfNewLines = 0;
        this.pendingSpace = true;
        ++this.column;
        this.needSpace = false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(page width = " + this.pageWidth + ") - (tabChar = ");
        switch (this.tabChar) {
            case 1: {
                stringBuffer.append("TAB");
                break;
            }
            case 2: {
                stringBuffer.append("SPACE");
                break;
            }
            default: {
                stringBuffer.append("MIXED");
            }
        }
        stringBuffer.append(") - (tabSize = " + this.tabLength + ")").append(this.lineSeparator).append("(line = " + this.line + ") - (column = " + this.column + ") - (identationLevel = " + this.indentationLevel + ")").append(this.lineSeparator).append("(needSpace = " + this.needSpace + ") - (lastNumberOfNewLines = " + this.lastNumberOfNewLines + ") - (checkLineWrapping = " + this.checkLineWrapping + ")").append(this.lineSeparator).append("==================================================================================").append(this.lineSeparator);
        this.printRule(stringBuffer);
        return stringBuffer.toString();
    }

    public void unIndent() {
        this.indentationLevel -= this.indentationSize;
        --this.numberOfIndentations;
    }
}

