/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.ModelAwareGradleLintRule;
import com.netflix.nebula.lint.rule.dependency.DependencyHelper;
import com.netflix.nebula.lint.rule.dependency.ModuleDescriptor;
import com.netflix.nebula.lint.rule.dependency.provider.MavenBomRecommendationProvider;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class RecommendedVersionsRule
extends ModelAwareGradleLintRule {
    private static final String GRADLE_VERSION_WITH_EXPERIMENTAL_FEATURES = "4.5";
    private static final String GRADLE_VERSION_WITH_OPT_IN_FEATURES = "4.6";
    private static final String GRADLE_VERSION_WITH_DEFAULT_FEATURES = "5.0";
    private static final String GRADLE_PROPERTIES = "gradle.properties";
    private static final String GRADLE_SETTINGS = "settings.gradle";
    private String description;
    private Map<String, Map<ModuleDescriptor, MethodCallExpression>> dependenciesPerConf;
    private MavenBomRecommendationProvider recommendationProvider;
    private Boolean recommenderIsEnabled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public RecommendedVersionsRule() {
        MetaClass metaClass;
        String string;
        this.description = string = "Remove versions from dependencies that are recommended";
        CallSite callSite = IndyInterface.bootstrap("invoke", "withDefault", 0, ScriptBytecodeAdapter.createMap((Object[])new Object[0]), new _closure1(this, this));
        this.dependenciesPerConf = IndyInterface.bootstrap("cast", "()", 0, callSite);
        Object var3_3 = null;
        this.recommenderIsEnabled = IndyInterface.bootstrap("cast", "()", 0, var3_3);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        IndyInterface.bootstrap("invoke", "handleDependencyVisit", 2, this, call, conf, dep);
    }

    @Override
    public void visitSubprojectGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        IndyInterface.bootstrap("invoke", "handleDependencyVisit", 2, this, call, conf, dep);
    }

    @Override
    public void visitAllprojectsGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        IndyInterface.bootstrap("invoke", "handleDependencyVisit", 2, this, call, conf, dep);
    }

    private void handleDependencyVisit(MethodCallExpression call, String conf, GradleDependency dep) {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.recommenderIsEnabled, null)) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "recommenderIsEnabled", 2, this);
            this.recommenderIsEnabled = IndyInterface.bootstrap("cast", "()", 0, callSite);
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "ignored", 12, this)) == false && DefaultTypeTransformation.booleanUnbox((Object)this.recommenderIsEnabled)) {
            CallSite desc = IndyInterface.bootstrap("invoke", "fromGradleDependency", 0, ModuleDescriptor.class, dep);
            IndyInterface.bootstrap("invoke", "put", 0, IndyInterface.bootstrap("invoke", "get", 0, this.dependenciesPerConf, conf), desc, call);
        }
    }

    @Override
    public void visitClassComplete(ClassNode node) {
        if (IndyInterface.bootstrap("cast", "()", 0, this.recommenderIsEnabled) == false) {
            return;
        }
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, MavenBomRecommendationProvider.class, IndyInterface.bootstrap("getProperty", "project", 12, this));
        this.recommendationProvider = IndyInterface.bootstrap("cast", "()", 0, callSite);
        public final class _visitClassComplete_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _visitClassComplete_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object conf, Object allDependencies) {
                public final class _closure4
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure4(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object desc, Object call) {
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "version", 0, desc))) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "recommendationIsAvailable", 2, this, desc)) != false) {
                            CallSite violation = IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, "using a recommended dependency with a declared version, the version should be removed", call);
                            return IndyInterface.bootstrap("invoke", "removeVersion", 0, DependencyHelper.class, violation, call, IndyInterface.bootstrap("init", "<init>", 0, GradleDependency.class, IndyInterface.bootstrap("getProperty", "group", 0, desc), IndyInterface.bootstrap("getProperty", "name", 0, desc), IndyInterface.bootstrap("getProperty", "version", 0, desc)));
                        }
                        return null;
                    }

                    @Generated
                    public Object call(Object desc, Object call) {
                        return IndyInterface.bootstrap("invoke", "doCall", 2, this, desc, call);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, allDependencies, new _closure4((Object)this, this.getThisObject()));
            }

            @Generated
            public Object call(Object conf, Object allDependencies) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, conf, allDependencies);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _visitClassComplete_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, this.dependenciesPerConf, new _visitClassComplete_closure2(this, this));
    }

    private boolean recommendationIsAvailable(ModuleDescriptor desc) {
        return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "getVersion", 0, this.recommendationProvider, IndyInterface.bootstrap("getProperty", "group", 4, desc), IndyInterface.bootstrap("getProperty", "name", 4, desc)), null);
    }

    private boolean recommenderIsEnabled() {
        CallSite gradleVersion = IndyInterface.bootstrap("getProperty", "gradleVersion", 0, IndyInterface.bootstrap("getProperty", "gradle", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)));
        if (ScriptBytecodeAdapter.compareLessThan((Object)gradleVersion, (Object)GRADLE_VERSION_WITH_EXPERIMENTAL_FEATURES)) {
            return false;
        }
        CallSite rootProjectDir = IndyInterface.bootstrap("getProperty", "rootDir", 0, IndyInterface.bootstrap("getProperty", "project", 12, this));
        if (ScriptBytecodeAdapter.compareLessThan((Object)gradleVersion, (Object)GRADLE_VERSION_WITH_OPT_IN_FEATURES)) {
            CallSite gradlePropertiesFiles = IndyInterface.bootstrap("invoke", "findAllInPath", 2, this, GRADLE_PROPERTIES);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, gradlePropertiesFiles)) != false) {
                return false;
            }
            Reference advancedPomPropertySet = new Reference((Object)false);
            Boolean cfr_ignored_0 = (Boolean)advancedPomPropertySet.get();
            public final class _recommenderIsEnabled_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference advancedPomPropertySet;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _recommenderIsEnabled_closure3(Object _outerInstance, Object _thisObject, Reference advancedPomPropertySet) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.advancedPomPropertySet = reference = advancedPomPropertySet;
                }

                public Object doCall(Object it) {
                    Reference props = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, Properties.class));
                    public final class _closure5
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference props;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure5(Object _outerInstance, Object _thisObject, Reference props) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.props = reference = props;
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("invoke", "load", 0, this.props.get(), it);
                        }

                        @Generated
                        public Object getProps() {
                            return this.props.get();
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure5.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    IndyInterface.bootstrap("invoke", "withInputStream", 0, IndyInterface.bootstrap("init", "<init>", 0, File.class, IndyInterface.bootstrap("invoke", "toString", 0, it)), new _closure5((Object)this, this.getThisObject(), props));
                    if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getProperty", 0, props.get(), "org.gradle.advancedpomsupport"), (Object)"true")) {
                        boolean bl = true;
                        this.advancedPomPropertySet.set((Object)bl);
                        return bl;
                    }
                    return null;
                }

                @Generated
                public Boolean getAdvancedPomPropertySet() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.advancedPomPropertySet.get());
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _recommenderIsEnabled_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, gradlePropertiesFiles, new _recommenderIsEnabled_closure3(this, this, advancedPomPropertySet));
            Boolean experimentalFeaturesEnabled = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "get", 1, IndyInterface.bootstrap("invoke", "getProperties", 1, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "properties", 0, IndyInterface.bootstrap("getProperty", "gradle", 0, IndyInterface.bootstrap("getProperty", "project", 12, this))), "experimentalFeatures")), "enabled"), (Object)true);
            return DefaultTypeTransformation.booleanUnbox((Object)((Boolean)advancedPomPropertySet.get())) && DefaultTypeTransformation.booleanUnbox((Object)experimentalFeaturesEnabled);
        }
        if (ScriptBytecodeAdapter.compareLessThan((Object)gradleVersion, (Object)GRADLE_VERSION_WITH_DEFAULT_FEATURES)) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "listFiles", 0, rootProjectDir)), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "toString", 0, rootProjectDir), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), GRADLE_SETTINGS))) == false) {
                return false;
            }
            CallSite settingsFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, rootProjectDir, GRADLE_SETTINGS);
            CallSite advancedPomFeatureEnabled = IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "text", 0, settingsFile), "enableFeaturePreview('IMPROVED_POM_SUPPORT')");
        }
        return true;
    }

    public List<File> findAllInPath(String fileName) {
        CallSite foundFiles = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
        CallSite curr = IndyInterface.bootstrap("getProperty", "projectDir", 0, IndyInterface.bootstrap("getProperty", "project", 12, this));
        while (ScriptBytecodeAdapter.compareNotEqual((Object)curr, (Object)IndyInterface.bootstrap("getProperty", "rootDir", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)))) {
            CallSite fileInCurrentProjectDir = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "toString", 0, curr), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), fileName);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "listFiles", 0, curr)), fileInCurrentProjectDir)) != false) {
                IndyInterface.bootstrap("invoke", "add", 0, foundFiles, fileInCurrentProjectDir);
            }
            IndyInterface.bootstrap("getProperty", "parentFile", 0, curr);
        }
        CallSite fileInParentDir = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "rootDir", 0, IndyInterface.bootstrap("getProperty", "project", 12, this))), IndyInterface.bootstrap("getProperty", "separator", 0, File.class)), fileName);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("invoke", "listFiles", 0, IndyInterface.bootstrap("getProperty", "rootDir", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)))), fileInParentDir)) != false) {
            IndyInterface.bootstrap("invoke", "add", 0, foundFiles, fileInParentDir);
        }
        return IndyInterface.bootstrap("cast", "()", 0, foundFiles);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RecommendedVersionsRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    @Generated
    public Map<String, Map<ModuleDescriptor, MethodCallExpression>> getDependenciesPerConf() {
        return this.dependenciesPerConf;
    }

    @Generated
    public void setDependenciesPerConf(Map<String, Map<ModuleDescriptor, MethodCallExpression>> map) {
        this.dependenciesPerConf = map;
    }

    @Generated
    public MavenBomRecommendationProvider getRecommendationProvider() {
        return this.recommendationProvider;
    }

    @Generated
    public void setRecommendationProvider(MavenBomRecommendationProvider mavenBomRecommendationProvider) {
        this.recommendationProvider = mavenBomRecommendationProvider;
    }

    public /* synthetic */ void super$2$visitClassComplete(ClassNode classNode) {
        super.visitClassComplete(classNode);
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$visitGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitSubprojectGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitSubprojectGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitAllprojectsGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitAllprojectsGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

