/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.dependency.DependencyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "getProject", "()Lorg/gradle/api/Project;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "violationsForModules", "", "", "moduleIds", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "conf", "Lorg/gradle/api/artifacts/Configuration;", "ignoredDependencies", "", "violationsForModule", "mvid", "Companion", "gradle-lint-plugin"})
@SourceDebugExtension(value={"SMAP\nDuplicateDependencyService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateDependencyService.kt\ncom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n1374#2:75\n1460#2,5:76\n1869#2,2:84\n1761#2,3:93\n1869#2,2:101\n536#3:81\n521#3,2:82\n523#3,4:86\n536#3:90\n521#3,2:91\n523#3,4:96\n216#4:100\n217#4:103\n216#4,2:104\n*S KotlinDebug\n*F\n+ 1 DuplicateDependencyService.kt\ncom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService\n*L\n21#1:75\n21#1:76,5\n33#1:84,2\n44#1:93,3\n51#1:101,2\n31#1:81\n31#1:82,2\n31#1:86,4\n40#1:90\n40#1:91,2\n40#1:96,4\n50#1:100\n50#1:103\n63#1:104,2\n*E\n"})
public final class DuplicateDependencyService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Set<String> BLACKLISTED_CLASSES;

    public DuplicateDependencyService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Logger logger = LoggerFactory.getLogger(DuplicateDependencyService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> violationsForModules(@NotNull List<? extends ModuleVersionIdentifier> moduleIds, @NotNull Configuration conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(moduleIds, (String)"moduleIds");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter(ignoredDependencies, (String)"ignoredDependencies");
        Iterable $this$flatMap$iv = moduleIds;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModuleVersionIdentifier it = (ModuleVersionIdentifier)element$iv$iv;
            boolean bl = false;
            String string = conf.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Iterable list$iv$iv = this.violationsForModule(it, string, ignoredDependencies);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> violationsForModule(@NotNull ModuleVersionIdentifier mvid, @NotNull String conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        Intrinsics.checkNotNullParameter((Object)mvid, (String)"mvid");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter(ignoredDependencies, (String)"ignoredDependencies");
        dependencyService = DependencyService.forProject(this.project);
        if (ignoredDependencies.contains(mvid)) {
            return CollectionsKt.emptyList();
        }
        v0 = dependencyService.jarContents(mvid.getModule());
        if (v0 == null || (v0 = v0.getClasses()) == null) {
            return CollectionsKt.emptyList();
        }
        dependencyClasses = v0;
        v1 = dependencyService.artifactsByClass(conf);
        Intrinsics.checkNotNullExpressionValue(v1, (String)"artifactsByClass(...)");
        var7_6 = v1;
        $i$f$filter = false;
        var9_9 = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var12_15 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var12_15.hasNext()) {
            it = element$iv$iv = var12_15.next();
            $i$a$-filter-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$1 = false;
            allowable = false;
            allowable = true;
            $this$forEach$iv = DuplicateDependencyService.BLACKLISTED_CLASSES;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                bc = (String)element$iv;
                $i$a$-forEach-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$1$1 = false;
                v2 = it.getKey();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"<get-key>(...)");
                if (!StringsKt.contains$default((CharSequence)((CharSequence)v2), (CharSequence)bc, (boolean)false, (int)2, null)) continue;
                allowable = false;
            }
            if (!allowable) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$filterTo = false;
        var12_15 = $this$filterTo$iv$iv.entrySet().iterator();
        while (var12_15.hasNext()) {
            block16: {
                it = element$iv$iv = var12_15.next();
                $i$a$-filter-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$2 = false;
                artifacts = (Collection)it.getValue();
                if (!dependencyClasses.contains(it.getKey())) ** GOTO lbl-1000
                Intrinsics.checkNotNull((Object)artifacts);
                $this$any$iv = artifacts;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v3 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (ResolvedArtifact)element$iv;
                        $i$a$-any-DuplicateDependencyService$violationsForModule$dupeDependencyClasses$2$1 = false;
                        if (!(ignoredDependencies.contains(it.getModuleVersion().getId()) == false && Intrinsics.areEqual((Object)it.getModuleVersion().getId().getModule(), (Object)mvid.getModule()) == false)) continue;
                        v3 = true;
                        break block16;
                    }
                    v3 = false;
                }
            }
            if (v3) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            if (!v4) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        dupeDependencyClasses = destination$iv$iv;
        dupeClassesByDependency = new TreeMap<ModuleVersionIdentifier, Set>(DependencyService.DEPENDENCY_COMPARATOR);
        $this$forEach$iv = dupeDependencyClasses;
        $i$f$forEach = false;
        for (Map.Entry element$iv : $this$forEach$iv.entrySet()) {
            var12_15 = element$iv;
            $i$a$-forEach-DuplicateDependencyService$violationsForModule$1 = false;
            className = (String)var12_15.getKey();
            resolvedArtifacts = (Collection)var12_15.getValue();
            Intrinsics.checkNotNull((Object)resolvedArtifacts);
            $this$forEach$iv = resolvedArtifacts;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                artifact = (ResolvedArtifact)element$iv;
                $i$a$-forEach-DuplicateDependencyService$violationsForModule$1$1 = false;
                Intrinsics.checkNotNullExpressionValue((Object)artifact.getModuleVersion().getId(), (String)"getId(...)");
                if (!dupeClassesByDependency.containsKey(moduleId)) {
                    dupeClassesByDependency.put(moduleId, new LinkedHashSet<E>());
                }
                v5 = dupeClassesByDependency.get(artifact.getModuleVersion().getId());
                Intrinsics.checkNotNull(v5);
                v6 = (Set)v5;
                Intrinsics.checkNotNull((Object)className);
                v6.add(className);
            }
        }
        violations = new ArrayList<E>();
        v7 = this.project.getConfigurations().getByName(conf);
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getByName(...)");
        configuration = v7;
        if (!dupeClassesByDependency.isEmpty()) {
            v8 = dupeClassesByDependency.keySet();
            Intrinsics.checkNotNullExpressionValue(v8, (String)"<get-keys>(...)");
            if (Intrinsics.areEqual((Object)mvid, (Object)CollectionsKt.first((Iterable)v8))) {
                $this$forEach$iv = dupeClassesByDependency;
                $i$f$forEach = false;
                var12_15 = $this$forEach$iv.entrySet().iterator();
                while (var12_15.hasNext()) {
                    var14_19 = element$iv = var12_15.next();
                    $i$a$-forEach-DuplicateDependencyService$violationsForModule$2 = false;
                    resolvedMvid = (ModuleVersionIdentifier)var14_19.getKey();
                    classes = (Set)var14_19.getValue();
                    if (Intrinsics.areEqual((Object)mvid, (Object)resolvedMvid)) continue;
                    message = mvid + " in " + configuration + " has " + classes.size() + " classes duplicated by " + resolvedMvid;
                    this.logger.info(message + ". Duplicate classes: " + classes);
                    violations.add(message + " (use --info for detailed class list)");
                }
            }
        }
        return violations;
    }

    static {
        Object[] objectArray = new String[]{"package-info", "module-info"};
        BLACKLISTED_CLASSES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService$Companion;", "", "<init>", "()V", "BLACKLISTED_CLASSES", "", "", "getBLACKLISTED_CLASSES", "()Ljava/util/Set;", "gradle-lint-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getBLACKLISTED_CLASSES() {
            return BLACKLISTED_CLASSES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

