/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IClasspathEntry;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IJavaModelStatus;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.internal.core.ChangeClasspathOperation;
import com.netflix.nebula.lint.jdt.internal.core.ClasspathEntry;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelStatus;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import org.eclipse.core.runtime.IPath;

public class SetClasspathOperation
extends ChangeClasspathOperation {
    IClasspathEntry[] newRawClasspath;
    IPath newOutputLocation;
    JavaProject project;

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] newRawClasspath, IPath newOutputLocation, boolean canChangeResource) {
        super(new IJavaElement[]{project}, canChangeResource);
        this.project = project;
        this.newRawClasspath = newRawClasspath;
        this.newOutputLocation = newOutputLocation;
    }

    protected void executeOperation() throws JavaModelException {
        this.checkCanceled();
        try {
            this.project.getPerProjectInfo().setClasspath(this.newRawClasspath, this.newOutputLocation, JavaModelStatus.VERIFIED_OK, null, null, null, null);
            this.classpathChanged(this.project);
            if (this.canChangeResources && this.project.saveClasspath(this.newRawClasspath, this.newOutputLocation)) {
                SetClasspathOperation.setAttribute("hasModifiedResource", "true");
            }
        }
        finally {
            this.done();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetClasspathOperation\n");
        buffer.append(" - classpath : ");
        buffer.append("{");
        int i = 0;
        while (i < this.newRawClasspath.length) {
            if (i > 0) {
                buffer.append(",");
            }
            IClasspathEntry element = this.newRawClasspath[i];
            buffer.append(" ").append(element.toString());
            ++i;
        }
        buffer.append("\n - output location : ");
        buffer.append(this.newOutputLocation.toString());
        return buffer.toString();
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        return ClasspathEntry.validateClasspath(this.project, this.newRawClasspath, this.newOutputLocation);
    }
}

