/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.indexing;

import com.netflix.nebula.lint.jdt.core.JavaCore;
import com.netflix.nebula.lint.jdt.core.search.SearchDocument;
import com.netflix.nebula.lint.jdt.internal.compiler.SourceElementParser;
import com.netflix.nebula.lint.jdt.internal.compiler.util.SuffixConstants;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.jdom.CompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.AbstractIndexer;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.SourceIndexerRequestor;
import com.netflix.nebula.lint.jdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;

public class SourceIndexer
extends AbstractIndexer
implements SuffixConstants {
    public SourceIndexer(SearchDocument document) {
        super(document);
    }

    public void indexDocument() {
        block7: {
            SourceIndexerRequestor requestor = new SourceIndexerRequestor(this);
            String documentPath = this.document.getPath();
            SourceElementParser parser = this.document.parser;
            if (parser == null) {
                Path path = new Path(documentPath);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
                parser = JavaModelManager.getJavaModelManager().indexManager.getSourceElementParser(JavaCore.create(project), requestor);
            } else {
                parser.requestor = requestor;
            }
            char[] source = null;
            char[] name = null;
            try {
                source = this.document.getCharContents();
                name = documentPath.toCharArray();
            }
            catch (Exception exception) {}
            if (source == null || name == null) {
                return;
            }
            CompilationUnit compilationUnit = new CompilationUnit(source, name);
            try {
                parser.parseCompilationUnit(compilationUnit, true);
            }
            catch (Exception e) {
                if (!JobManager.VERBOSE) break block7;
                e.printStackTrace();
            }
        }
    }
}

