/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.annotations.Nullable;
import com.netflix.nebula.lint.jgit.api.FetchCommand;
import com.netflix.nebula.lint.jgit.api.Git;
import com.netflix.nebula.lint.jgit.api.InitCommand;
import com.netflix.nebula.lint.jgit.api.SubmoduleInitCommand;
import com.netflix.nebula.lint.jgit.api.SubmoduleUpdateCommand;
import com.netflix.nebula.lint.jgit.api.TransportCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.InvalidRemoteException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.TransportException;
import com.netflix.nebula.lint.jgit.dircache.DirCache;
import com.netflix.nebula.lint.jgit.dircache.DirCacheCheckout;
import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.BranchConfig;
import com.netflix.nebula.lint.jgit.lib.NullProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.submodule.SubmoduleWalk;
import com.netflix.nebula.lint.jgit.transport.FetchResult;
import com.netflix.nebula.lint.jgit.transport.RefSpec;
import com.netflix.nebula.lint.jgit.transport.RemoteConfig;
import com.netflix.nebula.lint.jgit.transport.TagOpt;
import com.netflix.nebula.lint.jgit.transport.URIish;
import com.netflix.nebula.lint.jgit.util.FS;
import com.netflix.nebula.lint.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CloneCommand
extends TransportCommand<CloneCommand, Git> {
    private String uri;
    private File directory;
    private File gitDir;
    private boolean bare;
    private FS fs;
    private String remote = "origin";
    private String branch = "HEAD";
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean cloneAllBranches;
    private boolean cloneSubmodules;
    private boolean noCheckout;
    private Collection<String> branchesToClone;
    private Callback callback;
    private boolean directoryExistsInitially;
    private boolean gitDirExistsInitially;

    public CloneCommand() {
        super(null);
    }

    @Nullable
    File getDirectory() {
        return this.directory;
    }

    @Override
    public Git call() throws GitAPIException, InvalidRemoteException, TransportException {
        URIish u = null;
        try {
            u = new URIish(this.uri);
            this.verifyDirectories(u);
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidURL, this.uri));
        }
        Repository repository = this.init();
        FetchResult fetchResult = null;
        Thread cleanupHook = new Thread(() -> this.cleanup());
        Runtime.getRuntime().addShutdownHook(cleanupHook);
        try {
            try {
                fetchResult = this.fetch(repository, u);
            }
            catch (IOException ioe) {
                if (repository != null) {
                    repository.close();
                }
                this.cleanup();
                throw new JGitInternalException(ioe.getMessage(), ioe);
            }
            catch (URISyntaxException e) {
                if (repository != null) {
                    repository.close();
                }
                this.cleanup();
                throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote));
            }
            catch (GitAPIException | RuntimeException e) {
                if (repository != null) {
                    repository.close();
                }
                this.cleanup();
                throw e;
            }
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(cleanupHook);
        }
        if (!this.noCheckout) {
            try {
                this.checkout(repository, fetchResult);
            }
            catch (IOException ioe) {
                repository.close();
                throw new JGitInternalException(ioe.getMessage(), ioe);
            }
            catch (GitAPIException | RuntimeException e) {
                repository.close();
                throw e;
            }
        }
        return new Git(repository, true);
    }

    private static boolean isNonEmptyDirectory(File dir) {
        if (dir != null && dir.exists()) {
            File[] files = dir.listFiles();
            return files != null && files.length != 0;
        }
        return false;
    }

    void verifyDirectories(URIish u) {
        if (this.directory == null && this.gitDir == null) {
            this.directory = new File(String.valueOf(u.getHumanishName()) + (this.bare ? ".git" : ""));
        }
        this.directoryExistsInitially = this.directory != null && this.directory.exists();
        this.gitDirExistsInitially = this.gitDir != null && this.gitDir.exists();
        CloneCommand.validateDirs(this.directory, this.gitDir, this.bare);
        if (CloneCommand.isNonEmptyDirectory(this.directory)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.directory.getName()));
        }
        if (CloneCommand.isNonEmptyDirectory(this.gitDir)) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().cloneNonEmptyDirectory, this.gitDir.getName()));
        }
    }

    private Repository init() throws GitAPIException {
        InitCommand command = Git.init();
        command.setBare(this.bare);
        if (this.fs != null) {
            command.setFs(this.fs);
        }
        if (this.directory != null) {
            command.setDirectory(this.directory);
        }
        if (this.gitDir != null) {
            command.setGitDir(this.gitDir);
        }
        return command.call().getRepository();
    }

    private FetchResult fetch(Repository clonedRepo, URIish u) throws URISyntaxException, TransportException, IOException, GitAPIException {
        RemoteConfig config = new RemoteConfig(clonedRepo.getConfig(), this.remote);
        config.addURI(u);
        String dst = String.valueOf(this.bare ? "refs/heads/" : "refs/remotes/" + config.getName() + "/") + "*";
        RefSpec refSpec = new RefSpec();
        refSpec = refSpec.setForceUpdate(true);
        refSpec = refSpec.setSourceDestination("refs/heads/*", dst);
        config.addFetchRefSpec(refSpec);
        config.update(clonedRepo.getConfig());
        clonedRepo.getConfig().save();
        FetchCommand command = new FetchCommand(clonedRepo);
        command.setRemote(this.remote);
        command.setProgressMonitor(this.monitor);
        command.setTagOpt(TagOpt.FETCH_TAGS);
        this.configure(command);
        List<RefSpec> specs = this.calculateRefSpecs(dst);
        command.setRefSpecs(specs);
        return command.call();
    }

    private List<RefSpec> calculateRefSpecs(String dst) {
        RefSpec wcrs = new RefSpec();
        wcrs = wcrs.setForceUpdate(true);
        wcrs = wcrs.setSourceDestination("refs/heads/*", dst);
        ArrayList<RefSpec> specs = new ArrayList<RefSpec>();
        if (this.cloneAllBranches) {
            specs.add(wcrs);
        } else if (this.branchesToClone != null && this.branchesToClone.size() > 0) {
            for (String selectedRef : this.branchesToClone) {
                if (!wcrs.matchSource(selectedRef)) continue;
                specs.add(wcrs.expandFromSource(selectedRef));
            }
        }
        return specs;
    }

    private void checkout(Repository clonedRepo, FetchResult result) throws MissingObjectException, IncorrectObjectTypeException, IOException, GitAPIException {
        Ref foundBranch;
        Ref head = null;
        if (this.branch.equals("HEAD") && (foundBranch = this.findBranchToCheckout(result)) != null) {
            head = foundBranch;
        }
        if (head == null) {
            head = result.getAdvertisedRef(this.branch);
            if (head == null) {
                head = result.getAdvertisedRef("refs/heads/" + this.branch);
            }
            if (head == null) {
                head = result.getAdvertisedRef("refs/tags/" + this.branch);
            }
        }
        if (head == null || head.getObjectId() == null) {
            return;
        }
        if (head.getName().startsWith("refs/heads/")) {
            RefUpdate newHead = clonedRepo.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            this.addMergeConfig(clonedRepo, head);
        }
        RevCommit commit = this.parseCommit(clonedRepo, head);
        boolean detached = !head.getName().startsWith("refs/heads/");
        RefUpdate u = clonedRepo.updateRef("HEAD", detached);
        u.setNewObjectId(commit.getId());
        u.forceUpdate();
        if (!this.bare) {
            DirCache dc = clonedRepo.lockDirCache();
            DirCacheCheckout co = new DirCacheCheckout(clonedRepo, dc, commit.getTree());
            co.setProgressMonitor(this.monitor);
            co.checkout();
            if (this.cloneSubmodules) {
                this.cloneSubmodules(clonedRepo);
            }
        }
    }

    private void cloneSubmodules(Repository clonedRepo) throws IOException, GitAPIException {
        SubmoduleInitCommand init = new SubmoduleInitCommand(clonedRepo);
        Object submodules = init.call();
        if (submodules.isEmpty()) {
            return;
        }
        if (this.callback != null) {
            this.callback.initializedSubmodules((Collection<String>)submodules);
        }
        SubmoduleUpdateCommand update = new SubmoduleUpdateCommand(clonedRepo);
        this.configure(update);
        update.setProgressMonitor(this.monitor);
        update.setCallback(this.callback);
        if (!update.call().isEmpty()) {
            SubmoduleWalk walk = SubmoduleWalk.forIndex(clonedRepo);
            while (walk.next()) {
                Throwable throwable = null;
                Object var7_8 = null;
                try (Repository subRepo = walk.getRepository();){
                    if (subRepo == null) continue;
                    this.cloneSubmodules(subRepo);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    private Ref findBranchToCheckout(FetchResult result) {
        ObjectId objectId;
        ObjectId headId;
        Ref idHEAD = result.getAdvertisedRef("HEAD");
        ObjectId objectId2 = headId = idHEAD != null ? idHEAD.getObjectId() : null;
        if (headId == null) {
            return null;
        }
        Ref master = result.getAdvertisedRef("refs/heads/master");
        ObjectId objectId3 = objectId = master != null ? master.getObjectId() : null;
        if (headId.equals(objectId)) {
            return master;
        }
        Ref foundBranch = null;
        for (Ref r : result.getAdvertisedRefs()) {
            String n = r.getName();
            if (!n.startsWith("refs/heads/") || !headId.equals(r.getObjectId())) continue;
            foundBranch = r;
            break;
        }
        return foundBranch;
    }

    private void addMergeConfig(Repository clonedRepo, Ref head) throws IOException {
        String branchName = Repository.shortenRefName(head.getName());
        clonedRepo.getConfig().setString("branch", branchName, "remote", this.remote);
        clonedRepo.getConfig().setString("branch", branchName, "merge", head.getName());
        String autosetupRebase = clonedRepo.getConfig().getString("branch", null, "autosetuprebase");
        if ("always".equals(autosetupRebase) || "remote".equals(autosetupRebase)) {
            clonedRepo.getConfig().setEnum("branch", branchName, "rebase", BranchConfig.BranchRebaseMode.REBASE);
        }
        clonedRepo.getConfig().save();
    }

    private RevCommit parseCommit(Repository clonedRepo, Ref ref) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit commit;
        Throwable throwable = null;
        Object var5_5 = null;
        try (RevWalk rw = new RevWalk(clonedRepo);){
            commit = rw.parseCommit(ref.getObjectId());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return commit;
    }

    public CloneCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public CloneCommand setDirectory(File directory) {
        CloneCommand.validateDirs(directory, this.gitDir, this.bare);
        this.directory = directory;
        return this;
    }

    public CloneCommand setGitDir(File gitDir) {
        CloneCommand.validateDirs(this.directory, gitDir, this.bare);
        this.gitDir = gitDir;
        return this;
    }

    public CloneCommand setBare(boolean bare) throws IllegalStateException {
        CloneCommand.validateDirs(this.directory, this.gitDir, bare);
        this.bare = bare;
        return this;
    }

    public CloneCommand setFs(FS fs) {
        this.fs = fs;
        return this;
    }

    public CloneCommand setRemote(String remote) {
        if (remote == null) {
            remote = "origin";
        }
        this.remote = remote;
        return this;
    }

    public CloneCommand setBranch(String branch) {
        if (branch == null) {
            branch = "HEAD";
        }
        this.branch = branch;
        return this;
    }

    public CloneCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public CloneCommand setCloneAllBranches(boolean cloneAllBranches) {
        this.cloneAllBranches = cloneAllBranches;
        return this;
    }

    public CloneCommand setCloneSubmodules(boolean cloneSubmodules) {
        this.cloneSubmodules = cloneSubmodules;
        return this;
    }

    public CloneCommand setBranchesToClone(Collection<String> branchesToClone) {
        this.branchesToClone = branchesToClone;
        return this;
    }

    public CloneCommand setNoCheckout(boolean noCheckout) {
        this.noCheckout = noCheckout;
        return this;
    }

    public CloneCommand setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    private static void validateDirs(File directory, File gitDir, boolean bare) throws IllegalStateException {
        if (directory != null) {
            if (directory.exists() && !directory.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedDirIsNoDirectory, directory));
            }
            if (gitDir != null && gitDir.exists() && !gitDir.isDirectory()) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedGitDirIsNoDirectory, gitDir));
            }
            if (bare) {
                if (gitDir != null && !gitDir.equals(directory)) {
                    throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedBareRepoDifferentDirs, gitDir, directory));
                }
            } else if (gitDir != null && gitDir.equals(directory)) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().initFailedNonBareRepoSameDirs, gitDir, directory));
            }
        }
    }

    private void cleanup() {
        try {
            if (this.directory != null) {
                if (!this.directoryExistsInitially) {
                    FileUtils.delete(this.directory, 13);
                } else {
                    this.deleteChildren(this.directory);
                }
            }
            if (this.gitDir != null) {
                if (!this.gitDirExistsInitially) {
                    FileUtils.delete(this.gitDir, 13);
                } else {
                    this.deleteChildren(this.directory);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void deleteChildren(File file) throws IOException {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            FileUtils.delete(child, 13);
            ++n2;
        }
    }

    public static interface Callback {
        public void initializedSubmodules(Collection<String> var1);

        public void cloningSubmodule(String var1);

        public void checkingOut(AnyObjectId var1, String var2);
    }
}

