/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.errors.TransportException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.transport.BasePackPushConnection;
import com.netflix.nebula.lint.jgit.transport.PackTransport;
import com.netflix.nebula.lint.jgit.transport.ReceivePack;
import com.netflix.nebula.lint.jgit.transport.resolver.ReceivePackFactory;
import com.netflix.nebula.lint.jgit.transport.resolver.ServiceNotAuthorizedException;
import com.netflix.nebula.lint.jgit.transport.resolver.ServiceNotEnabledException;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

class InternalPushConnection<C>
extends BasePackPushConnection {
    private Thread worker;

    public InternalPushConnection(PackTransport transport, final ReceivePackFactory<C> receivePackFactory, final C req, final Repository remote) throws TransportException {
        super(transport);
        PipedOutputStream out_w;
        PipedInputStream out_r;
        PipedOutputStream in_w;
        PipedInputStream in_r;
        try {
            in_r = new PipedInputStream();
            in_w = new PipedOutputStream(in_r);
            out_r = new PipedInputStream();
            out_w = new PipedOutputStream(out_r);
        }
        catch (IOException err) {
            remote.close();
            throw new TransportException(this.uri, JGitText.get().cannotConnectPipes, err);
        }
        this.worker = new Thread("JGit-Receive-Pack"){

            @Override
            public void run() {
                try {
                    try {
                        ReceivePack rp = receivePackFactory.create(req, remote);
                        rp.receive(out_r, in_w, System.err);
                    }
                    catch (ServiceNotEnabledException serviceNotEnabledException) {
                        try {
                            out_r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        remote.close();
                    }
                    catch (ServiceNotAuthorizedException serviceNotAuthorizedException) {
                        try {
                            out_r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        remote.close();
                    }
                    catch (IOException iOException) {
                        try {
                            out_r.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException iOException3) {
                            // empty catch block
                        }
                        remote.close();
                    }
                    catch (RuntimeException runtimeException) {
                        try {
                            out_r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            in_w.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        remote.close();
                    }
                }
                finally {
                    try {
                        out_r.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        in_w.close();
                    }
                    catch (IOException iOException) {}
                    remote.close();
                }
            }
        };
        this.worker.start();
        this.init(in_r, out_w);
        this.readAdvertisedRefs();
    }

    @Override
    public void close() {
        super.close();
        if (this.worker != null) {
            try {
                try {
                    this.worker.join();
                }
                catch (InterruptedException interruptedException) {
                    this.worker = null;
                }
            }
            finally {
                this.worker = null;
            }
        }
    }
}

