/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.VersionNumber;
import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.ModelAwareGradleLintRule;
import com.netflix.nebula.lint.rule.dependency.DependencyService;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;

@Incubating
public class MinimumDependencyVersionRule
extends ModelAwareGradleLintRule {
    private String description;
    private Set alreadyAdded;
    private Set<Configuration> resolvableAndResolvedConfigurations;
    private /* synthetic */ List<GradleDependency> $minimumVersions;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public MinimumDependencyVersionRule() {
        MetaClass metaClass;
        Set set;
        String string;
        this.description = string = "pull up dependencies to a minimum version if necessary";
        this.alreadyAdded = set = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    protected void beforeApplyTo() {
        DependencyService dependencyService = DependencyService.forProject(this.getProject());
        Set<Configuration> set = dependencyService.resolvableAndResolvedConfigurations();
        this.resolvableAndResolvedConfigurations = set;
    }

    @Override
    public void visitGradleResolutionStrategyForce(MethodCallExpression call, String conf, Map<GradleDependency, Expression> forces) {
        Reference conf2 = new Reference((Object)conf);
        public final class _visitGradleResolutionStrategyForce_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference conf;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _visitGradleResolutionStrategyForce_closure1(Object _outerInstance, Object _thisObject, Reference conf) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.conf = reference = conf;
            }

            public Object doCall(Object dep, Object force) {
                ((MinimumDependencyVersionRule)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).fixDependencyDeclarationIfNecessary((ASTNode)IndyInterface.bootstrap("cast", "()", 0, force), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.conf.get())), (GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, dep)));
                return null;
            }

            @Generated
            public Object call(Object dep, Object force) {
                return this.doCall(dep, force);
            }

            @Generated
            public String getConf() {
                return IndyInterface.bootstrap("cast", "()", 0, this.conf.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _visitGradleResolutionStrategyForce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DefaultGroovyMethods.each(forces, (Closure)new _visitGradleResolutionStrategyForce_closure1(this, this, conf2));
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.fixDependencyDeclarationIfNecessary((ASTNode)call.getArguments(), conf, dep);
    }

    private void fixDependencyDeclarationIfNecessary(ASTNode decl, String conf, GradleDependency dep) {
        Reference dep2 = new Reference((Object)dep);
        public final class _fixDependencyDeclarationIfNecessary_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dep;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fixDependencyDeclarationIfNecessary_closure2(Object _outerInstance, Object _thisObject, Reference dep) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.dep = reference = dep;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)it).getGroup(), (Object)((GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, this.dep.get()))).getGroup()) && ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)it).getName(), (Object)((GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, this.dep.get()))).getName());
            }

            @Generated
            public GradleDependency getDep() {
                return IndyInterface.bootstrap("cast", "()", 0, this.dep.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixDependencyDeclarationIfNecessary_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite minVersionConstraint = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.find(this.getMinimumVersions(), (Closure)new _fixDependencyDeclarationIfNecessary_closure2(this, this, dep2)));
        CallSite callSite = minVersionConstraint;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) {
            return;
        }
        public final class _fixDependencyDeclarationIfNecessary_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fixDependencyDeclarationIfNecessary_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public String doCall(Object it) {
                return ((Configuration)it).getName();
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public String doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixDependencyDeclarationIfNecessary_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        if (!DefaultGroovyMethods.collect(this.resolvableAndResolvedConfigurations, (Closure)new _fixDependencyDeclarationIfNecessary_closure3(this, this)).contains(conf)) {
            return;
        }
        String string = ((GradleDependency)dep2.get()).getVersion();
        if ((string == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, string)) == false) {
            return;
        }
        public final class _fixDependencyDeclarationIfNecessary_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dep;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _fixDependencyDeclarationIfNecessary_closure4(Object _outerInstance, Object _thisObject, Reference dep) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.dep = reference = dep;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((ResolvedArtifact)it).getModuleVersion().getId().getGroup(), (Object)((GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, this.dep.get()))).getGroup()) && ScriptBytecodeAdapter.compareEqual((Object)((ResolvedArtifact)it).getModuleVersion().getId().getName(), (Object)((GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, this.dep.get()))).getName());
            }

            @Generated
            public GradleDependency getDep() {
                return IndyInterface.bootstrap("cast", "()", 0, this.dep.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _fixDependencyDeclarationIfNecessary_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite resolved = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.find((Collection)this.getProject().getConfigurations().getByName(conf).getResolvedConfiguration().getResolvedArtifacts(), (Closure)new _fixDependencyDeclarationIfNecessary_closure4(this, this, dep2)));
        CallSite callSite2 = resolved;
        if ((callSite2 == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite2)) == false) {
            return;
        }
        if (VersionNumber.parse(resolved.getModuleVersion().getId().getVersion()).compareTo(VersionNumber.parse(((GradleDependency)((Object)minVersionConstraint)).getVersion())) < 0) {
            Set set;
            this.addBuildLintViolation((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{resolved.getModuleVersion().getId().getModule(), ((GradleDependency)((Object)minVersionConstraint)).getVersion()}, new String[]{"", " does not meet the minimum version of ", ""}))), decl).documentationUri("https://github.com/nebula-plugins/gradle-lint-plugin/wiki/Minimum-Dependency-Version-Rule");
            this.alreadyAdded = set = DefaultGroovyMethods.plus((Set)this.alreadyAdded, (Object)minVersionConstraint);
        }
    }

    @Override
    public void visitDependencies(MethodCallExpression call) {
        this.bookmark("dependencies", (ASTNode)call);
    }

    @Override
    public void visitClassComplete(ClassNode node) {
        public final class _visitClassComplete_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _visitClassComplete_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<GradleDependency> doCall(Object conf) {
                Reference conf2 = new Reference(conf);
                if (((MinimumDependencyVersionRule)this.getThisObject()).getResolvableAndResolvedConfigurations().contains(conf2.get())) {
                    public final class _closure9
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference conf;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure9(Object _outerInstance, Object _thisObject, Reference conf) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.conf = reference = conf;
                        }

                        public Set doCall(Object constraint) {
                            if (!((MinimumDependencyVersionRule)this.getThisObject()).getAlreadyAdded().contains(constraint) && ((MinimumDependencyVersionRule)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).addFirstOrderIfNecessary((Configuration)IndyInterface.bootstrap("cast", "()", 0, this.conf.get()), (GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, constraint)))) {
                                Set set = DefaultGroovyMethods.plus((Set)((MinimumDependencyVersionRule)this.getThisObject()).getAlreadyAdded(), (Object)constraint);
                                ((MinimumDependencyVersionRule)this.getThisObject()).setAlreadyAdded(set);
                                return set;
                            }
                            return null;
                        }

                        @Generated
                        public Configuration getConf() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.conf.get());
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure9.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return DefaultGroovyMethods.each(((MinimumDependencyVersionRule)this.getThisObject()).getMinimumVersions(), (Closure)new _closure9((Object)this, this.getThisObject(), conf2));
                }
                return null;
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _visitClassComplete_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        DefaultGroovyMethods.each((Set)this.getProject().getConfigurations(), (Closure)new _visitClassComplete_closure5(this, this));
    }

    private boolean addFirstOrderIfNecessary(Configuration conf, GradleDependency constraint) {
        Reference constraint2 = new Reference((Object)constraint);
        if (!this.resolvableAndResolvedConfigurations.contains(conf)) {
            return false;
        }
        public final class _addFirstOrderIfNecessary_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference constraint;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addFirstOrderIfNecessary_closure6(Object _outerInstance, Object _thisObject, Reference constraint) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.constraint = reference = constraint;
            }

            public Boolean doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, this.constraint.get()))).getGroup(), (Object)((ModuleVersionIdentifier)it).getGroup()) && ScriptBytecodeAdapter.compareEqual((Object)((GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, this.constraint.get()))).getName(), (Object)((ModuleVersionIdentifier)it).getName());
            }

            @Generated
            public GradleDependency getConstraint() {
                return IndyInterface.bootstrap("cast", "()", 0, this.constraint.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addFirstOrderIfNecessary_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite resolved = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.find((Collection)((Object)IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(MinimumDependencyVersionRule.class, (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(MinimumDependencyVersionRule.class, (Object)conf.getResolvedConfiguration().getResolvedArtifacts(), (String)"moduleVersion"), (String)"id"))), (Closure)new _addFirstOrderIfNecessary_closure6(this, this, constraint2)));
        CallSite callSite = resolved;
        if ((callSite == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, callSite)) == false) {
            return false;
        }
        public final class _addFirstOrderIfNecessary_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference constraint;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _addFirstOrderIfNecessary_closure7(Object _outerInstance, Object _thisObject, Reference constraint) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.constraint = reference = constraint;
            }

            public Boolean doCall(Object it) {
                return ((MinimumDependencyVersionRule)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).addFirstOrderIfNecessary((Configuration)IndyInterface.bootstrap("cast", "()", 0, it), (GradleDependency)((Object)IndyInterface.bootstrap("cast", "()", 0, this.constraint.get())));
            }

            @Generated
            public GradleDependency getConstraint() {
                return IndyInterface.bootstrap("cast", "()", 0, this.constraint.get());
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Boolean doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _addFirstOrderIfNecessary_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        if (DefaultGroovyMethods.any((Iterable)conf.getExtendsFrom(), (Closure)new _addFirstOrderIfNecessary_closure7(this, this, constraint2))) {
            return true;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)((GradleDependency)constraint2.get())) && VersionNumber.parse(resolved.getVersion()).compareTo(VersionNumber.parse(((GradleDependency)constraint2.get()).getVersion())) < 0) {
            ASTNode dependenciesBlock = this.bookmark("dependencies");
            ASTNode aSTNode = dependenciesBlock;
            if ((aSTNode == null ? (Object)false : IndyInterface.bootstrap("cast", "()", 0, aSTNode)) != false) {
                this.addBuildLintViolation((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((GradleDependency)constraint2.get()).getGroup(), ((GradleDependency)constraint2.get()).getName(), ((GradleDependency)constraint2.get()).getVersion()}, new String[]{"", ":", " is below the minimum version of ", ""})))).documentationUri("https://github.com/nebula-plugins/gradle-lint-plugin/wiki/Minimum-Dependency-Version-Rule");
            } else {
                this.addBuildLintViolation((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{((GradleDependency)constraint2.get()).getGroup(), ((GradleDependency)constraint2.get()).getName(), ((GradleDependency)constraint2.get()).getVersion()}, new String[]{"", ":", " is below the minimum version of ", ""})))).documentationUri("https://github.com/nebula-plugins/gradle-lint-plugin/wiki/Minimum-Dependency-Version-Rule");
            }
            return true;
        }
        return false;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MinimumDependencyVersionRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    public List<GradleDependency> getMinimumVersions() {
        if (this.$minimumVersions != null) {
            return this.$minimumVersions;
        }
        public final class _getMinimumVersions_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getMinimumVersions_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public List<GradleDependency> doCall(Object it) {
                if (((MinimumDependencyVersionRule)this.getThisObject()).getProject().hasProperty("gradleLint.minVersions")) {
                    Object object = ((MinimumDependencyVersionRule)this.getThisObject()).getProject().property("gradleLint.minVersions");
                    String string = object != null ? DefaultGroovyMethods.toString((Object)object) : null;
                    Object[] objectArray = string != null ? string.split(",") : null;
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure10(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public GradleDependency doCall(Object it) {
                            return GradleDependency.fromConstant(it);
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public GradleDependency doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    List list = objectArray != null ? DefaultGroovyMethods.collect((Object[])objectArray, (Closure)new _closure10((Object)this, this.getThisObject())) : null;
                    public final class _closure11
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure11(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Boolean doCall(Object it) {
                            return it != null;
                        }

                        @Generated
                        public Object call(Object args) {
                            return this.doCall(args);
                        }

                        @Generated
                        public Object call() {
                            return this.doCall(null);
                        }

                        @Generated
                        public Boolean doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure11.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    List list2 = list != null ? DefaultGroovyMethods.findAll((List)list, (Closure)new _closure11((Object)this, this.getThisObject())) : null;
                    return IndyInterface.bootstrap("cast", "()", 0, list2) != false ? list2 : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
                }
                return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public List<GradleDependency> doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getMinimumVersions_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        Object object = new _getMinimumVersions_closure8(this, this).call();
        this.$minimumVersions = IndyInterface.bootstrap("cast", "()", 0, object);
        return IndyInterface.bootstrap("cast", "()", 0, object);
    }

    public static /* synthetic */ Set pfaccess$0(MinimumDependencyVersionRule $that) {
        return $that.alreadyAdded;
    }

    public static /* synthetic */ Set pfaccess$00(MinimumDependencyVersionRule $that, Set $value) {
        Set set;
        $that.alreadyAdded = set = $value;
        return set;
    }

    public static /* synthetic */ Set<Configuration> pfaccess$1(MinimumDependencyVersionRule $that) {
        return $that.resolvableAndResolvedConfigurations;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    @Generated
    public Set getAlreadyAdded() {
        return this.alreadyAdded;
    }

    @Generated
    public void setAlreadyAdded(Set set) {
        this.alreadyAdded = set;
    }

    @Generated
    public Set<Configuration> getResolvableAndResolvedConfigurations() {
        return this.resolvableAndResolvedConfigurations;
    }

    @Generated
    public void setResolvableAndResolvedConfigurations(Set<Configuration> set) {
        this.resolvableAndResolvedConfigurations = set;
    }
}

