/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.SourceSetUtils;
import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.ModelAwareGradleLintRule;
import com.netflix.nebula.lint.rule.dependency.DependencyService;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.tasks.SourceSet;

public class UnusedDependencyRule
extends ModelAwareGradleLintRule {
    private String description;
    private static final List<String> shouldBeRuntime;
    private Map<ModuleIdentifier, MethodCallExpression> runtimeDependencyDefinitions;
    private Set<ModuleIdentifier> compileOnlyDependencies;
    private DependencyService dependencyService;
    private Collection<UnusedDependencyDeclaration> unusedDependencies;
    private Map<String, Collection<ModuleIdentifier>> declaredDependenciesByConf;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public UnusedDependencyRule() {
        MetaClass metaClass;
        Set set;
        Map map;
        String string;
        this.description = string = "remove unused dependencies, relocate dependencies to the correct configuration, and ensure that directly used transitives are declared as first order dependencies";
        this.runtimeDependencyDefinitions = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.compileOnlyDependencies = set = (Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class));
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class);
        this.unusedDependencies = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, HashMap.class);
        this.declaredDependenciesByConf = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    protected void beforeApplyTo() {
        CallSite callSite = IndyInterface.bootstrap("invoke", "forProject", 0, DependencyService.class, IndyInterface.bootstrap("getProperty", "project", 12, this));
        this.dependencyService = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String declaredConf, GradleDependency dep) {
        CallSite conf = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("invoke", "findAndReplaceNonResolvableConfiguration", 0, this.dependencyService, IndyInterface.bootstrap("invoke", "getByName", 0, IndyInterface.bootstrap("getProperty", "configurations", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)), declaredConf))));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasSourceSets", 0, SourceSetUtils.class, IndyInterface.bootstrap("getProperty", "project", 12, this))) != false) {
            Reference mid = new Reference((Object)IndyInterface.bootstrap("invoke", "toModule", 0, dep));
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, this.declaredDependenciesByConf, declaredConf)) == false) {
                IndyInterface.bootstrap("invoke", "put", 0, this.declaredDependenciesByConf, declaredConf, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class));
            }
            IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("invoke", "get", 0, this.declaredDependenciesByConf, declaredConf), mid.get());
            if (ScriptBytecodeAdapter.compareEqual((Object)declaredConf, (Object)"compileOnly")) {
                IndyInterface.bootstrap("invoke", "add", 0, this.compileOnlyDependencies, mid.get());
            }
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isRuntime", 0, this.dependencyService, conf)) == false && (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isResolvable", 0, this.dependencyService, conf)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "hasResolvableParentConfiguration", 0, this.dependencyService, conf)))) {
                CallSite jarContents = IndyInterface.bootstrap("invoke", "jarContents", 0, this.dependencyService, mid.get());
                if (IndyInterface.bootstrap("cast", "()", 0, jarContents) == false) {
                    return;
                }
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "isWebjar", 0, jarContents)) != false) {
                    IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, "webjars should be in the runtimeOnly configuration", call);
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "nothingButMetaInf", 0, jarContents)) != false) {
                    IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, "this dependency should be removed since its artifact is empty", call);
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, IndyInterface.bootstrap("getProperty", "classes", 0, jarContents))) != false) {
                    IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, "this dependency should be moved to the runtimeOnly configuration since it has no classes", call);
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, shouldBeRuntime, IndyInterface.bootstrap("getProperty", "name", 4, dep))) != false) {
                    IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, "this dependency should be moved to the runtimeOnly configuration", call);
                } else if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "unusedDependencies", 0, this.dependencyService, conf, declaredConf), mid.get())) != false) {
                    public final class _visitGradleDependency_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference mid;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _visitGradleDependency_closure1(Object _outerInstance, Object _thisObject, Reference mid) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            this.mid = reference = mid;
                        }

                        public Object doCall(Object parent) {
                            return IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "usedDependencies", 0, IndyInterface.bootstrap("getProperty", "dependencyService", 8, this), IndyInterface.bootstrap("getProperty", "name", 0, parent)), this.mid.get());
                        }

                        @Generated
                        public Object getMid() {
                            return this.mid.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _visitGradleDependency_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite requiringSourceSet = IndyInterface.bootstrap("invoke", "find", 0, IndyInterface.bootstrap("invoke", "parentSourceSetConfigurations", 0, this.dependencyService, conf), new _visitGradleDependency_closure1(this, this, mid));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "isServiceProvider", 0, jarContents)) != false) {
                        IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, "this dependency is a service provider unused at compileClasspath time and can be moved to the runtimeOnly configuration", call);
                    }
                    public final class _visitGradleDependency_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _visitGradleDependency_closure2(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return IndyInterface.bootstrap("getProperty", "module", 0, it);
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _visitGradleDependency_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)requiringSourceSet) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("invoke", "collect", 0, IndyInterface.bootstrap("invoke", "firstLevelDependenciesInConf", 0, this.dependencyService, requiringSourceSet, conf), new _visitGradleDependency_closure2(this, this)), mid.get())) == false && ScriptBytecodeAdapter.compareNotEqual((Object)conf, (Object)"compileOnly")) {
                        IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, requiringSourceSet)}, new String[]{"this dependency should be moved to configuration ", ""}), call);
                    } else {
                        IndyInterface.bootstrap("invoke", "add", 0, this.unusedDependencies, IndyInterface.bootstrap("init", "<init>", 0, UnusedDependencyDeclaration.class, this, conf, mid.get(), dep, "this dependency is unused and can be removed", call));
                    }
                }
            } else if (ScriptBytecodeAdapter.compareNotEqual((Object)conf, (Object)"compileOnly")) {
                MethodCallExpression methodCallExpression = call;
                IndyInterface.bootstrap("invoke", "putAt", 0, this.runtimeDependencyDefinitions, mid.get(), methodCallExpression);
            }
        }
    }

    @Override
    public void visitDependencies(MethodCallExpression call) {
        IndyInterface.bootstrap("invoke", "bookmark", 2, this, "dependencies", call);
    }

    @Override
    public void visitClassComplete(ClassNode node) {
        Reference insertedDependencies = new Reference((Object)((Set)((Object)IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[0]), Set.class))));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasSourceSets", 0, SourceSetUtils.class, IndyInterface.bootstrap("getProperty", "project", 12, this))) != false) {
            CallSite sortedSourceSets = IndyInterface.bootstrap("invoke", "sort", 0, IndyInterface.bootstrap("invoke", "getSourceSets", 0, SourceSetUtils.class, IndyInterface.bootstrap("getProperty", "project", 12, this)), false, IndyInterface.bootstrap("invoke", "sourceSetComparator", 0, this.dependencyService));
            public final class _visitClassComplete_closure3
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference insertedDependencies;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _visitClassComplete_closure3(Object _outerInstance, Object _thisObject, Reference insertedDependencies) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.insertedDependencies = reference = insertedDependencies;
                }

                public Object doCall(Object sourceSet) {
                    Reference confName = new Reference((Object)IndyInterface.bootstrap("getProperty", "compileClasspathConfigurationName", 0, sourceSet));
                    public final class _closure10
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference confName;
                        private /* synthetic */ Reference insertedDependencies;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure10(Object _outerInstance, Object _thisObject, Reference confName, Reference insertedDependencies) {
                            super(_outerInstance, _thisObject);
                            Reference reference;
                            Reference reference2;
                            this.confName = reference2 = confName;
                            this.insertedDependencies = reference = insertedDependencies;
                        }

                        public Object doCall(Object undeclared) {
                            CallSite runtimeDeclaration = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "runtimeDependencyDefinitions", 8, this), IndyInterface.bootstrap("getProperty", "module", 0, undeclared));
                            if (IndyInterface.bootstrap("cast", "()", 0, runtimeDeclaration) != false) {
                                return IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "declarationConfigurationName", 2, this, this.confName.get())}, new String[]{"this dependency should be moved to configuration ", ""}), runtimeDeclaration);
                            }
                            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("getProperty", "compileOnlyDependencies", 8, this), IndyInterface.bootstrap("getProperty", "module", 0, undeclared))) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.insertedDependencies.get()), undeclared)) != false) {
                                return IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, new GStringImpl(new Object[]{undeclared}, new String[]{"one or more classes in ", " are required by your code directly"}));
                            }
                            return null;
                        }

                        @Generated
                        public Object getConfName() {
                            return this.confName.get();
                        }

                        @Generated
                        public Set getInsertedDependencies() {
                            return IndyInterface.bootstrap("cast", "()", 0, this.insertedDependencies.get());
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure10.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    return IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "undeclaredDependencies", 0, IndyInterface.bootstrap("getProperty", "dependencyService", 8, this), confName.get()), new _closure10((Object)this, this.getThisObject(), confName, this.insertedDependencies));
                }

                @Generated
                public Set getInsertedDependencies() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.insertedDependencies.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _visitClassComplete_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, sortedSourceSets, new _visitClassComplete_closure3(this, this, insertedDependencies));
            IndyInterface.bootstrap("invoke", "handleDependenciesUsedInOtherConfigurations", 2, this, sortedSourceSets);
        }
    }

    private void handleDependenciesUsedInOtherConfigurations(List<SourceSet> sortedSourceSets) {
        CallSite usedElsewhere = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies", 2, this, sortedSourceSets));
        CallSite filteredUsedElsewhere = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "removeDuplicatedChildrenConfigurations", 2, this, usedElsewhere));
        public final class _handleDependenciesUsedInOtherConfigurations_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handleDependenciesUsedInOtherConfigurations_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object declaration) {
                CallSite dependencyDeclarationConfName = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "declarationConfigurationName", 2, this, IndyInterface.bootstrap("getProperty", "confNameRequiringDep", 0, declaration)));
                boolean dependencyAlreadyListed = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 1, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "declaredDependenciesByConf", 8, this), dependencyDeclarationConfName), IndyInterface.bootstrap("getProperty", "moduleIdentifier", 0, declaration)));
                if (dependencyAlreadyListed) {
                    return IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, new GStringImpl(new Object[]{dependencyDeclarationConfName, IndyInterface.bootstrap("getProperty", "configurationName", 0, declaration)}, new String[]{"this dependency should is already added to the needed configuration ", " and can be removed from ", ""}), IndyInterface.bootstrap("getProperty", "call", 0, declaration)), IndyInterface.bootstrap("getProperty", "call", 0, declaration));
                }
                CallSite versionAddition = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("getProperty", "version", 0, IndyInterface.bootstrap("getProperty", "gradleDependency", 0, declaration)), null) ? new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "version", 0, IndyInterface.bootstrap("getProperty", "gradleDependency", 0, declaration))}, new String[]{":", ""}) : "");
                return IndyInterface.bootstrap("invoke", "replaceWith", 0, IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, new GStringImpl(new Object[]{dependencyDeclarationConfName}, new String[]{"this dependency should be moved to configuration ", ""}), IndyInterface.bootstrap("getProperty", "call", 0, declaration)), IndyInterface.bootstrap("getProperty", "call", 0, declaration), new GStringImpl(new Object[]{dependencyDeclarationConfName, IndyInterface.bootstrap("getProperty", "moduleIdentifier", 0, declaration), versionAddition}, new String[]{"", " '", "", "'"}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handleDependenciesUsedInOtherConfigurations_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, filteredUsedElsewhere, new _handleDependenciesUsedInOtherConfigurations_closure4(this, this));
    }

    private ArrayList<UsedElsewhereDependencyDeclaration> collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies(List<SourceSet> sortedSourceSets) {
        Reference usedElsewhere = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class)));
        Reference falseAlarmUnusedDependencies = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ArrayList.class)));
        public final class _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure5(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "compileClasspathConfigurationName", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference usedElsewhere;
            private /* synthetic */ Reference falseAlarmUnusedDependencies;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure6(Object _outerInstance, Object _thisObject, Reference usedElsewhere, Reference falseAlarmUnusedDependencies) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.usedElsewhere = reference2 = usedElsewhere;
                this.falseAlarmUnusedDependencies = reference = falseAlarmUnusedDependencies;
            }

            public Object doCall(Object confName) {
                Reference confName2 = new Reference(confName);
                CallSite requiredDependencies = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findRequiredDependencies", 0, IndyInterface.bootstrap("getProperty", "dependencyService", 8, this), confName2.get()));
                public final class _closure11
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference usedElsewhere;
                    private /* synthetic */ Reference confName;
                    private /* synthetic */ Reference falseAlarmUnusedDependencies;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure11(Object _outerInstance, Object _thisObject, Reference usedElsewhere, Reference confName, Reference falseAlarmUnusedDependencies) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        Reference reference3;
                        this.usedElsewhere = reference3 = usedElsewhere;
                        this.confName = reference2 = confName;
                        this.falseAlarmUnusedDependencies = reference = falseAlarmUnusedDependencies;
                    }

                    public Object doCall(Object required) {
                        Reference required2 = new Reference(required);
                        public final class _closure12
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference required;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure12(Object _outerInstance, Object _thisObject, Reference required) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.required = reference = required;
                            }

                            public Object doCall(Object unused) {
                                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "moduleIdentifier", 0, unused), (Object)IndyInterface.bootstrap("getProperty", "module", 0, this.required.get()));
                            }

                            @Generated
                            public Object getRequired() {
                                return this.required.get();
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure12.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        Reference falseAlarmDepsForConf = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("getProperty", "unusedDependencies", 8, this), new _closure12((Object)this, this.getThisObject(), required2))));
                        public final class _closure13
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference usedElsewhere;
                            private /* synthetic */ Reference confName;
                            private /* synthetic */ Reference falseAlarmUnusedDependencies;
                            private /* synthetic */ Reference falseAlarmDepsForConf;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure13(Object _outerInstance, Object _thisObject, Reference usedElsewhere, Reference confName, Reference falseAlarmUnusedDependencies, Reference falseAlarmDepsForConf) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                Reference reference2;
                                Reference reference3;
                                Reference reference4;
                                this.usedElsewhere = reference4 = usedElsewhere;
                                this.confName = reference3 = confName;
                                this.falseAlarmUnusedDependencies = reference2 = falseAlarmUnusedDependencies;
                                this.falseAlarmDepsForConf = reference = falseAlarmDepsForConf;
                            }

                            public Object doCall(Object it) {
                                IndyInterface.bootstrap("invoke", "add", 0, IndyInterface.bootstrap("cast", "()", 0, this.usedElsewhere.get()), IndyInterface.bootstrap("init", "<init>", 0, UsedElsewhereDependencyDeclaration.class, this.getThisObject(), IndyInterface.bootstrap("getProperty", "configurationName", 0, it), IndyInterface.bootstrap("getProperty", "moduleIdentifier", 0, it), IndyInterface.bootstrap("getProperty", "gradleDependency", 0, it), IndyInterface.bootstrap("getProperty", "message", 0, it), IndyInterface.bootstrap("getProperty", "call", 0, it), this.confName.get()));
                                return IndyInterface.bootstrap("invoke", "addAll", 0, IndyInterface.bootstrap("cast", "()", 0, this.falseAlarmUnusedDependencies.get()), IndyInterface.bootstrap("cast", "()", 0, this.falseAlarmDepsForConf.get()));
                            }

                            @Generated
                            public Collection getUsedElsewhere() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.usedElsewhere.get());
                            }

                            @Generated
                            public Object getConfName() {
                                return this.confName.get();
                            }

                            @Generated
                            public Collection getFalseAlarmUnusedDependencies() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.falseAlarmUnusedDependencies.get());
                            }

                            @Generated
                            public Collection getFalseAlarmDepsForConf() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.falseAlarmDepsForConf.get());
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure13.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        return IndyInterface.bootstrap("invoke", "each", 0, (Collection)falseAlarmDepsForConf.get(), new _closure13((Object)this, this.getThisObject(), this.usedElsewhere, this.confName, this.falseAlarmUnusedDependencies, falseAlarmDepsForConf));
                    }

                    @Generated
                    public Collection getUsedElsewhere() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.usedElsewhere.get());
                    }

                    @Generated
                    public Object getConfName() {
                        return this.confName.get();
                    }

                    @Generated
                    public Collection getFalseAlarmUnusedDependencies() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.falseAlarmUnusedDependencies.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure11.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, requiredDependencies, new _closure11((Object)this, this.getThisObject(), this.usedElsewhere, confName2, this.falseAlarmUnusedDependencies));
            }

            @Generated
            public Collection getUsedElsewhere() {
                return IndyInterface.bootstrap("cast", "()", 0, this.usedElsewhere.get());
            }

            @Generated
            public Collection getFalseAlarmUnusedDependencies() {
                return IndyInterface.bootstrap("cast", "()", 0, this.falseAlarmUnusedDependencies.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "collect", 0, sortedSourceSets, new _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure5(this, this)), new _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure6(this, this, usedElsewhere, falseAlarmUnusedDependencies));
        public final class _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure7(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object declaration) {
                return IndyInterface.bootstrap("invoke", "delete", 0, IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, IndyInterface.bootstrap("getProperty", "message", 0, declaration), IndyInterface.bootstrap("getProperty", "call", 0, declaration)), IndyInterface.bootstrap("getProperty", "call", 0, declaration));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "minus", 0, this.unusedDependencies, (Collection)falseAlarmUnusedDependencies.get()), new _collectUsedElsewhereDependenciesAndAddViolationsToTrueUnusedDependencies_closure7(this, this));
        return IndyInterface.bootstrap("cast", "()", 0, (Collection)usedElsewhere.get());
    }

    private ArrayList<UsedElsewhereDependencyDeclaration> removeDuplicatedChildrenConfigurations(ArrayList<UsedElsewhereDependencyDeclaration> usedElsewhere) {
        Reference usedElsewhere2 = new Reference(usedElsewhere);
        public final class _removeDuplicatedChildrenConfigurations_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeDuplicatedChildrenConfigurations_closure8(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "moduleIdentifier", 0, it);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeDuplicatedChildrenConfigurations_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        public final class _removeDuplicatedChildrenConfigurations_closure9
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference usedElsewhere;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeDuplicatedChildrenConfigurations_closure9(Object _outerInstance, Object _thisObject, Reference usedElsewhere) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.usedElsewhere = reference = usedElsewhere;
            }

            public Object doCall(Object declarationByDep) {
                CallSite declarations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getValue", 0, declarationByDep));
                public final class _closure14
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure14(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return IndyInterface.bootstrap("getProperty", "confNameRequiringDep", 0, it);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure14.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Reference confsRequiringDep = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, declarations, new _closure14((Object)this, this.getThisObject()))));
                public final class _closure15
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference confsRequiringDep;
                    private /* synthetic */ Reference usedElsewhere;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure15(Object _outerInstance, Object _thisObject, Reference confsRequiringDep, Reference usedElsewhere) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.confsRequiringDep = reference2 = confsRequiringDep;
                        this.usedElsewhere = reference = usedElsewhere;
                    }

                    public Object doCall(Object declaration) {
                        CallSite conf = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getByName", 0, IndyInterface.bootstrap("getProperty", "configurations", 0, IndyInterface.bootstrap("getProperty", "project", 8, this)), IndyInterface.bootstrap("getProperty", "confNameRequiringDep", 0, declaration)));
                        public final class _closure16
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference confsRequiringDep;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure16(Object _outerInstance, Object _thisObject, Reference confsRequiringDep) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.confsRequiringDep = reference = confsRequiringDep;
                            }

                            public Object doCall(Object parentConfigName) {
                                return IndyInterface.bootstrap("invoke", "contains", 0, IndyInterface.bootstrap("cast", "()", 0, this.confsRequiringDep.get()), parentConfigName);
                            }

                            @Generated
                            public Collection getConfsRequiringDep() {
                                return IndyInterface.bootstrap("cast", "()", 0, this.confsRequiringDep.get());
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure16.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "any", 0, IndyInterface.bootstrap("getProperty", "name", 0, IndyInterface.bootstrap("getProperty", "extendsFrom", 0, conf)), new _closure16((Object)this, this.getThisObject(), this.confsRequiringDep))) != false) {
                            return IndyInterface.bootstrap("invoke", "remove", 0, IndyInterface.bootstrap("cast", "()", 0, this.usedElsewhere.get()), declaration);
                        }
                        return null;
                    }

                    @Generated
                    public Collection getConfsRequiringDep() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.confsRequiringDep.get());
                    }

                    @Generated
                    public ArrayList getUsedElsewhere() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.usedElsewhere.get());
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure15.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                return IndyInterface.bootstrap("invoke", "each", 0, declarations, new _closure15((Object)this, this.getThisObject(), confsRequiringDep, this.usedElsewhere));
            }

            @Generated
            public ArrayList getUsedElsewhere() {
                return IndyInterface.bootstrap("cast", "()", 0, this.usedElsewhere.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeDuplicatedChildrenConfigurations_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "groupBy", 0, (ArrayList)usedElsewhere2.get(), new _removeDuplicatedChildrenConfigurations_closure8(this, this)), new _removeDuplicatedChildrenConfigurations_closure9(this, this, usedElsewhere2));
        return (ArrayList)usedElsewhere2.get();
    }

    private static String declarationConfigurationName(String configName) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "replace", 0, IndyInterface.bootstrap("invoke", "replace", 0, configName, "compileClasspath", "implementation"), "CompileClasspath", "Implementation"));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UnusedDependencyRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        if (!(args instanceof Object[])) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(UnusedDependencyRule.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{args});
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(UnusedDependencyRule.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
        }
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(UnusedDependencyRule.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, UnusedDependencyRule.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(UnusedDependencyRule.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    static {
        List list;
        shouldBeRuntime = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"xerces", "xercesImpl", "xml-apis"});
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    @Generated
    public static List<String> getShouldBeRuntime() {
        return shouldBeRuntime;
    }

    @Generated
    public Map<ModuleIdentifier, MethodCallExpression> getRuntimeDependencyDefinitions() {
        return this.runtimeDependencyDefinitions;
    }

    @Generated
    public void setRuntimeDependencyDefinitions(Map<ModuleIdentifier, MethodCallExpression> map) {
        this.runtimeDependencyDefinitions = map;
    }

    @Generated
    public Set<ModuleIdentifier> getCompileOnlyDependencies() {
        return this.compileOnlyDependencies;
    }

    @Generated
    public void setCompileOnlyDependencies(Set<ModuleIdentifier> set) {
        this.compileOnlyDependencies = set;
    }

    @Generated
    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    @Generated
    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    @Generated
    public Collection<UnusedDependencyDeclaration> getUnusedDependencies() {
        return this.unusedDependencies;
    }

    @Generated
    public void setUnusedDependencies(Collection<UnusedDependencyDeclaration> collection) {
        this.unusedDependencies = collection;
    }

    @Generated
    public Map<String, Collection<ModuleIdentifier>> getDeclaredDependenciesByConf() {
        return this.declaredDependenciesByConf;
    }

    @Generated
    public void setDeclaredDependenciesByConf(Map<String, Collection<ModuleIdentifier>> map) {
        this.declaredDependenciesByConf = map;
    }

    public /* synthetic */ void super$2$visitClassComplete(ClassNode classNode) {
        super.visitClassComplete(classNode);
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$visitGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitDependencies(MethodCallExpression methodCallExpression) {
        super.visitDependencies(methodCallExpression);
    }

    public /* synthetic */ void super$3$beforeApplyTo() {
        super.beforeApplyTo();
    }

    public class UnusedDependencyDeclaration
    implements GroovyObject {
        private String configurationName;
        private ModuleIdentifier moduleIdentifier;
        private String message;
        private GradleDependency gradleDependency;
        private MethodCallExpression call;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        final /* synthetic */ UnusedDependencyRule this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public UnusedDependencyDeclaration(UnusedDependencyRule $p$, String configurationName, ModuleIdentifier moduleIdentifier, GradleDependency gradleDependency, String message, MethodCallExpression call) {
            MethodCallExpression methodCallExpression;
            String string;
            GradleDependency gradleDependency2;
            ModuleIdentifier moduleIdentifier2;
            String string2;
            MetaClass metaClass;
            UnusedDependencyRule unusedDependencyRule;
            this.this$0 = unusedDependencyRule = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.configurationName = string2 = configurationName;
            this.moduleIdentifier = moduleIdentifier2 = moduleIdentifier;
            this.gradleDependency = gradleDependency2 = gradleDependency;
            this.message = string = message;
            this.call = methodCallExpression = call;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != UnusedDependencyDeclaration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            try {
                return this.this$0.this$dist$invoke$4(name, args);
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(UnusedDependencyDeclaration.class, UnusedDependencyRule.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(UnusedDependencyDeclaration.class, UnusedDependencyRule.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(UnusedDependencyDeclaration.class, UnusedDependencyRule.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), UnusedDependencyDeclaration.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                this.this$0.this$dist$set$4(name, value);
                return;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, UnusedDependencyRule.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), UnusedDependencyDeclaration.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public /* synthetic */ Object propertyMissing(String name) {
            try {
                return this.this$0.this$dist$get$4(name);
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(UnusedDependencyDeclaration.class, UnusedDependencyRule.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), UnusedDependencyDeclaration.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        @Internal
        @Transient
        public MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        public String getConfigurationName() {
            return this.configurationName;
        }

        @Generated
        public void setConfigurationName(String string) {
            this.configurationName = string;
        }

        @Generated
        public ModuleIdentifier getModuleIdentifier() {
            return this.moduleIdentifier;
        }

        @Generated
        public void setModuleIdentifier(ModuleIdentifier moduleIdentifier) {
            this.moduleIdentifier = moduleIdentifier;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setMessage(String string) {
            this.message = string;
        }

        @Generated
        public GradleDependency getGradleDependency() {
            return this.gradleDependency;
        }

        @Generated
        public void setGradleDependency(GradleDependency gradleDependency) {
            this.gradleDependency = gradleDependency;
        }

        @Generated
        public MethodCallExpression getCall() {
            return this.call;
        }

        @Generated
        public void setCall(MethodCallExpression methodCallExpression) {
            this.call = methodCallExpression;
        }
    }

    public class UsedElsewhereDependencyDeclaration
    extends UnusedDependencyDeclaration {
        private String confNameRequiringDep;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        final /* synthetic */ UnusedDependencyRule this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public UsedElsewhereDependencyDeclaration(UnusedDependencyRule $p$, String originalConfName, ModuleIdentifier moduleIdentifier, GradleDependency gradleDependency, String message, MethodCallExpression call, String confNameRequiringDep) {
            String string;
            MetaClass metaClass;
            UnusedDependencyRule unusedDependencyRule;
            this.this$0 = unusedDependencyRule = $p$;
            super($p$, originalConfName, moduleIdentifier, gradleDependency, message, call);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.confNameRequiringDep = string = confNameRequiringDep;
        }

        @Override
        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != UsedElsewhereDependencyDeclaration.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Override
        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }

        @Override
        public /* synthetic */ Object methodMissing(String name, Object args) {
            try {
                return this.this$0.this$dist$invoke$4(name, args);
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "arguments", 0, notFound)));
            }
        }

        /*
         * Unable to fully structure code
         */
        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            if (!(args instanceof Object[] == false)) ** GOTO lbl8
            var2_2 = ScriptBytecodeAdapter.invokeMethodN(UsedElsewhereDependencyDeclaration.class, UnusedDependencyRule.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{args});
            return var2_2;
lbl8:
            // 1 sources

            if (!ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "length", 0, IndyInterface.bootstrap("cast", "()", 0, args)), (Object)1)) ** GOTO lbl14
            var3_3 = ScriptBytecodeAdapter.invokeMethodN(UsedElsewhereDependencyDeclaration.class, UnusedDependencyRule.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])new Object[]{IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("cast", "()", 0, args), false)});
            return var3_3;
lbl14:
            // 1 sources

            var4_4 = ScriptBytecodeAdapter.invokeMethodN(UsedElsewhereDependencyDeclaration.class, UnusedDependencyRule.class, (String)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            try {
                return var4_4;
            }
            catch (MissingMethodException notFound) {
                throw (Throwable)IndyInterface.bootstrap("init", "<init>", 0, MissingMethodException.class, IndyInterface.bootstrap("getProperty", "method", 0, notFound), UsedElsewhereDependencyDeclaration.class, IndyInterface.bootstrap("getProperty", "arguments", 0, notFound));
            }
        }

        @Override
        public /* synthetic */ void propertyMissing(String name, Object value) {
            try {
                this.this$0.this$dist$set$4(name, value);
                return;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object value) {
            try {
                Object object = value;
                ScriptBytecodeAdapter.setProperty((Object)object, null, UnusedDependencyRule.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), UsedElsewhereDependencyDeclaration.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Override
        public /* synthetic */ Object propertyMissing(String name) {
            try {
                return this.this$0.this$dist$get$4(name);
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), IndyInterface.bootstrap("invoke", "getClass", 2, this), IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            Object object = ScriptBytecodeAdapter.getProperty(UsedElsewhereDependencyDeclaration.class, UnusedDependencyRule.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
            try {
                return object;
            }
            catch (MissingPropertyException notFound) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, MissingPropertyException.class, IndyInterface.bootstrap("getProperty", "property", 0, notFound), UsedElsewhereDependencyDeclaration.class, IndyInterface.bootstrap("getProperty", "cause", 0, notFound)));
            }
        }

        @Generated
        public String getConfNameRequiringDep() {
            return this.confNameRequiringDep;
        }

        @Generated
        public void setConfNameRequiringDep(String string) {
            this.confNameRequiringDep = string;
        }

        public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
            return super.$getStaticMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup super$2$$getLookup() {
            return super.$getLookup();
        }

        public /* synthetic */ Object super$2$methodMissing(String string, Object object) {
            return super.methodMissing(string, object);
        }

        public /* synthetic */ void super$2$propertyMissing(String string, Object object) {
            super.propertyMissing(string, object);
        }

        public /* synthetic */ Object super$2$propertyMissing(String string) {
            return super.propertyMissing(string);
        }
    }
}

