/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.AddCommand;
import com.netflix.nebula.lint.jgit.api.CloneCommand;
import com.netflix.nebula.lint.jgit.api.Git;
import com.netflix.nebula.lint.jgit.api.TransportCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.NoFilepatternException;
import com.netflix.nebula.lint.jgit.errors.ConfigInvalidException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.lib.StoredConfig;
import com.netflix.nebula.lint.jgit.storage.file.FileBasedConfig;
import com.netflix.nebula.lint.jgit.submodule.SubmoduleWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilter;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class SubmoduleAddCommand
extends TransportCommand<SubmoduleAddCommand, Repository> {
    private String path;
    private String uri;
    private ProgressMonitor monitor;

    public SubmoduleAddCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleAddCommand setPath(String path) {
        this.path = path;
        return this;
    }

    public SubmoduleAddCommand setURI(String uri) {
        this.uri = uri;
        return this;
    }

    public SubmoduleAddCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    protected boolean submoduleExists() throws IOException {
        PathFilter filter = PathFilter.create(this.path);
        return SubmoduleWalk.forIndex(this.repo).setFilter(filter).next();
    }

    @Override
    public Repository call() throws GitAPIException {
        String resolvedUri;
        this.checkCallable();
        if (this.path == null || this.path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
        }
        if (this.uri == null || this.uri.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().uriNotConfigured);
        }
        try {
            if (this.submoduleExists()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().submoduleExists, this.path));
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        try {
            resolvedUri = SubmoduleWalk.getSubmoduleRemoteUrl(this.repo, this.uri);
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        File moduleDirectory = SubmoduleWalk.getSubmoduleDirectory(this.repo, this.path);
        CloneCommand clone = Git.cloneRepository();
        this.configure(clone);
        clone.setDirectory(moduleDirectory);
        clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), this.path));
        clone.setURI(resolvedUri);
        if (this.monitor != null) {
            clone.setProgressMonitor(this.monitor);
        }
        Repository subRepo = clone.call().getRepository();
        StoredConfig config = this.repo.getConfig();
        config.setString("submodule", this.path, "url", resolvedUri);
        try {
            config.save();
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        FileBasedConfig modulesConfig = new FileBasedConfig(new File(this.repo.getWorkTree(), ".gitmodules"), this.repo.getFS());
        try {
            modulesConfig.load();
            modulesConfig.setString("submodule", this.path, "path", this.path);
            modulesConfig.setString("submodule", this.path, "url", this.uri);
            modulesConfig.save();
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        AddCommand add = new AddCommand(this.repo);
        add.addFilepattern(".gitmodules");
        add.addFilepattern(this.path);
        try {
            add.call();
        }
        catch (NoFilepatternException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return subRepo;
    }
}

