/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.gitrepo;

import com.netflix.nebula.lint.jgit.lib.Repository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RepoProject
implements Comparable<RepoProject> {
    private final String name;
    private final String path;
    private final String revision;
    private final String remote;
    private final Set<String> groups;
    private final List<CopyFile> copyfiles;
    private String recommendShallow;
    private String url;
    private String defaultRevision;

    public RepoProject(String name, String path, String revision, String remote, Set<String> groups, String recommendShallow) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.path = path != null ? path : name;
        this.revision = revision;
        this.remote = remote;
        this.groups = groups;
        this.recommendShallow = recommendShallow;
        this.copyfiles = new ArrayList<CopyFile>();
    }

    public RepoProject(String name, String path, String revision, String remote, String groups) {
        this(name, path, revision, remote, new HashSet<String>(), null);
        if (groups != null && groups.length() > 0) {
            this.setGroups(groups);
        }
    }

    public RepoProject setUrl(String url) {
        this.url = url;
        return this;
    }

    public RepoProject setGroups(String groups) {
        this.groups.clear();
        this.groups.addAll(Arrays.asList(groups.split(",")));
        return this;
    }

    public RepoProject setDefaultRevision(String defaultRevision) {
        this.defaultRevision = defaultRevision;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision == null ? this.defaultRevision : this.revision;
    }

    public List<CopyFile> getCopyFiles() {
        return Collections.unmodifiableList(this.copyfiles);
    }

    public String getUrl() {
        return this.url;
    }

    public String getRemote() {
        return this.remote;
    }

    public boolean inGroup(String group) {
        return this.groups.contains(group);
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getRecommendShallow() {
        return this.recommendShallow;
    }

    public void setRecommendShallow(String recommendShallow) {
        this.recommendShallow = recommendShallow;
    }

    public void addCopyFile(CopyFile copyfile) {
        this.copyfiles.add(copyfile);
    }

    public void addCopyFiles(Collection<CopyFile> copyFiles) {
        this.copyfiles.addAll(copyFiles);
    }

    public void clearCopyFiles() {
        this.copyfiles.clear();
    }

    private String getPathWithSlash() {
        if (this.path.endsWith("/")) {
            return this.path;
        }
        return this.path + "/";
    }

    public boolean isAncestorOf(RepoProject that) {
        return this.isAncestorOf(that.getPathWithSlash());
    }

    public boolean isAncestorOf(String thatPath) {
        return thatPath.startsWith(this.getPathWithSlash());
    }

    public boolean equals(Object o) {
        if (o instanceof RepoProject) {
            RepoProject that = (RepoProject)o;
            return this.getPathWithSlash().equals(that.getPathWithSlash());
        }
        return false;
    }

    public int hashCode() {
        return this.getPathWithSlash().hashCode();
    }

    @Override
    public int compareTo(RepoProject that) {
        return this.getPathWithSlash().compareTo(that.getPathWithSlash());
    }

    public static class CopyFile {
        final Repository repo;
        final String path;
        final String src;
        final String dest;

        public CopyFile(Repository repo, String path, String src, String dest) {
            this.repo = repo;
            this.path = path;
            this.src = src;
            this.dest = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copy() throws IOException {
            File srcFile = new File(this.repo.getWorkTree(), this.path + "/" + this.src);
            File destFile = new File(this.repo.getWorkTree(), this.dest);
            try (FileInputStream input = new FileInputStream(srcFile);
                 FileOutputStream output = new FileOutputStream(destFile);){
                FileChannel channel = input.getChannel();
                output.getChannel().transferFrom(channel, 0L, channel.size());
            }
        }
    }
}

