/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.lib;

import com.netflix.nebula.lint.jgit.lib.Config;
import com.netflix.nebula.lint.jgit.transport.RefSpec;
import com.netflix.nebula.lint.jgit.transport.RemoteConfig;
import java.net.URISyntaxException;

public class BranchConfig {
    public static final String LOCAL_REPOSITORY = ".";
    private final Config config;
    private final String branchName;

    public BranchConfig(Config config, String branchName) {
        this.config = config;
        this.branchName = branchName;
    }

    public String getTrackingBranch() {
        String remote = this.getRemoteOrDefault();
        String mergeRef = this.getMerge();
        if (remote == null || mergeRef == null) {
            return null;
        }
        if (this.isRemoteLocal()) {
            return mergeRef;
        }
        return this.findRemoteTrackingBranch(remote, mergeRef);
    }

    public String getRemoteTrackingBranch() {
        String remote = this.getRemoteOrDefault();
        String mergeRef = this.getMerge();
        if (remote == null || mergeRef == null) {
            return null;
        }
        return this.findRemoteTrackingBranch(remote, mergeRef);
    }

    public boolean isRemoteLocal() {
        return LOCAL_REPOSITORY.equals(this.getRemote());
    }

    public String getRemote() {
        return this.config.getString("branch", this.branchName, "remote");
    }

    public String getMerge() {
        return this.config.getString("branch", this.branchName, "merge");
    }

    public boolean isRebase() {
        return this.config.getBoolean("branch", this.branchName, "rebase", false);
    }

    private String findRemoteTrackingBranch(String remote, String mergeRef) {
        RemoteConfig remoteConfig;
        try {
            remoteConfig = new RemoteConfig(this.config, remote);
        }
        catch (URISyntaxException e) {
            return null;
        }
        for (RefSpec refSpec : remoteConfig.getFetchRefSpecs()) {
            if (!refSpec.matchSource(mergeRef)) continue;
            RefSpec expanded = refSpec.expandFromSource(mergeRef);
            return expanded.getDestination();
        }
        return null;
    }

    private String getRemoteOrDefault() {
        String remote = this.getRemote();
        if (remote == null) {
            return "origin";
        }
        return remote;
    }
}

