/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefComparator;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.transport.PacketLineOut;
import com.netflix.nebula.lint.jgit.util.RefMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class RefAdvertiser {
    private final StringBuilder tmpLine = new StringBuilder(100);
    private final char[] tmpId = new char[40];
    private final Set<String> capablities = new LinkedHashSet<String>();
    private final Set<ObjectId> sent = new HashSet<ObjectId>();
    private Repository repository;
    private boolean derefTags;
    private boolean first = true;

    public void init(Repository src) {
        this.repository = src;
    }

    public void setDerefTags(boolean deref) {
        this.derefTags = deref;
    }

    public void advertiseCapability(String name) {
        this.capablities.add(name);
    }

    public void advertiseCapability(String name, String value) {
        if (value != null) {
            this.capablities.add(name + '=' + value);
        }
    }

    public void addSymref(String from, String to) {
        this.advertiseCapability("symref", from + ':' + to);
    }

    public Set<ObjectId> send(Map<String, Ref> refs) throws IOException {
        for (Ref ref : this.getSortedRefs(refs)) {
            if (ref.getObjectId() == null) continue;
            this.advertiseAny(ref.getObjectId(), ref.getName());
            if (!this.derefTags) continue;
            if (!ref.isPeeled()) {
                if (this.repository == null) continue;
                ref = this.repository.peel(ref);
            }
            if (ref.getPeeledObjectId() == null) continue;
            this.advertiseAny(ref.getPeeledObjectId(), ref.getName() + "^{}");
        }
        return this.sent;
    }

    private Iterable<Ref> getSortedRefs(Map<String, Ref> all) {
        if (all instanceof RefMap || all instanceof SortedMap && ((SortedMap)all).comparator() == null) {
            return all.values();
        }
        return RefComparator.sort(all.values());
    }

    public void advertiseHave(AnyObjectId id) throws IOException {
        this.advertiseAnyOnce(id, ".have");
    }

    public boolean isEmpty() {
        return this.first;
    }

    private void advertiseAnyOnce(AnyObjectId obj, String refName) throws IOException {
        if (!this.sent.contains(obj)) {
            this.advertiseAny(obj, refName);
        }
    }

    private void advertiseAny(AnyObjectId obj, String refName) throws IOException {
        this.sent.add(obj.toObjectId());
        this.advertiseId(obj, refName);
    }

    public void advertiseId(AnyObjectId id, String refName) throws IOException {
        this.tmpLine.setLength(0);
        id.copyTo(this.tmpId, this.tmpLine);
        this.tmpLine.append(' ');
        this.tmpLine.append(refName);
        if (this.first) {
            this.first = false;
            if (!this.capablities.isEmpty()) {
                this.tmpLine.append('\u0000');
                for (String capName : this.capablities) {
                    this.tmpLine.append(' ');
                    this.tmpLine.append(capName);
                }
                this.tmpLine.append(' ');
            }
        }
        this.tmpLine.append('\n');
        this.writeOne(this.tmpLine);
    }

    protected abstract void writeOne(CharSequence var1) throws IOException;

    protected abstract void end() throws IOException;

    public static class PacketLineOutRefAdvertiser
    extends RefAdvertiser {
        private final PacketLineOut pckOut;

        public PacketLineOutRefAdvertiser(PacketLineOut out) {
            this.pckOut = out;
        }

        @Override
        protected void writeOne(CharSequence line) throws IOException {
            this.pckOut.writeString(line.toString());
        }

        @Override
        protected void end() throws IOException {
            this.pckOut.end();
        }
    }
}

