/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.GradleLintRule;
import com.netflix.nebula.lint.rule.GradleModelAware;
import com.netflix.nebula.lint.rule.dependency.DependencyService;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.plugins.JavaPluginConvention;

public class UnusedDependencyRule
extends GradleLintRule
implements GradleModelAware {
    private String description;
    private static final List<String> shouldBeRuntime;
    private Map<ModuleVersionIdentifier, MethodCallExpression> runtimeDependencyDefinitions;
    private DependencyService dependencyService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public UnusedDependencyRule() {
        MetaClass metaClass;
        Map map;
        String string;
        CallSite[] callSiteArray = UnusedDependencyRule.$getCallSiteArray();
        this.description = string = "remove unused dependencies, relocate dependencies to the correct configuration, and ensure that directly used transitives are declared as first order dependencies";
        this.runtimeDependencyDefinitions = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    protected void beforeApplyTo() {
        CallSite[] callSiteArray = UnusedDependencyRule.$getCallSiteArray();
        Object object = callSiteArray[0].call(DependencyService.class, callSiteArray[1].callGroovyObjectGetProperty((Object)this));
        this.dependencyService = (DependencyService)ScriptBytecodeAdapter.castToType((Object)object, DependencyService.class);
    }

    private static String replaceDependencyWith(MethodCallExpression call, String conf, ModuleVersionIdentifier dep) {
        CallSite[] callSiteArray = UnusedDependencyRule.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{conf, dep}, new String[]{"", " '", "'"}));
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        CallSite[] callSiteArray = UnusedDependencyRule.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[2].call((Object)this.dependencyService, (Object)conf))) {
            return;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].call(callSiteArray[4].callGetProperty(callSiteArray[5].callGroovyObjectGetProperty((Object)this)), JavaPluginConvention.class))) {
            Reference mvid = new Reference(callSiteArray[6].call((Object)dep));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call((Object)this.dependencyService, (Object)conf))) {
                Object jarContents = callSiteArray[8].call((Object)this.dependencyService, mvid.get());
                if (!DefaultTypeTransformation.booleanUnbox((Object)jarContents)) {
                    return;
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callGetProperty(jarContents))) {
                    callSiteArray[10].call(callSiteArray[11].callCurrent((GroovyObject)this, (Object)"webjars should be in the runtime configuration", (Object)call), (Object)call, callSiteArray[12].callStatic(UnusedDependencyRule.class, (Object)call, (Object)"runtime", mvid.get()));
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callGetProperty(jarContents))) {
                    callSiteArray[14].call(callSiteArray[15].callCurrent((GroovyObject)this, (Object)"this dependency should be removed since its artifact is empty", (Object)call), (Object)call);
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call(callSiteArray[17].callGetProperty(jarContents)))) {
                    callSiteArray[18].call(callSiteArray[19].callCurrent((GroovyObject)this, (Object)"this dependency should be moved to the runtime configuration since it has no classes", (Object)call), (Object)call, callSiteArray[20].callStatic(UnusedDependencyRule.class, (Object)call, (Object)"runtime", mvid.get()));
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[21].call(shouldBeRuntime, callSiteArray[22].callGroovyObjectGetProperty((Object)dep)))) {
                    callSiteArray[23].call(callSiteArray[24].callCurrent((GroovyObject)this, (Object)"this dependency should be moved to the runtime configuration", (Object)call), (Object)call, callSiteArray[25].callStatic(UnusedDependencyRule.class, (Object)call, (Object)"runtime", mvid.get()));
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call(callSiteArray[27].call((Object)this.dependencyService, (Object)conf), callSiteArray[28].callGetProperty(mvid.get())))) {
                    class _visitGradleDependency_closure1
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference mvid;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _visitGradleDependency_closure1(Object _outerInstance, Object _thisObject, Reference mvid) {
                            Reference reference;
                            CallSite[] callSiteArray = _visitGradleDependency_closure1.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.mvid = reference = mvid;
                        }

                        public Object doCall(Object parent) {
                            CallSite[] callSiteArray = _visitGradleDependency_closure1.$getCallSiteArray();
                            return callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), callSiteArray[3].callGetProperty(parent)), callSiteArray[4].callGetProperty(this.mvid.get()));
                        }

                        public Object getMvid() {
                            CallSite[] callSiteArray = _visitGradleDependency_closure1.$getCallSiteArray();
                            return this.mvid.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _visitGradleDependency_closure1.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "contains";
                            stringArray[1] = "usedDependencies";
                            stringArray[2] = "dependencyService";
                            stringArray[3] = "name";
                            stringArray[4] = "module";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[5];
                            _visitGradleDependency_closure1.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_visitGradleDependency_closure1.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _visitGradleDependency_closure1.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    Object requiringSourceSet = callSiteArray[29].call(callSiteArray[30].call((Object)this.dependencyService, (Object)conf), (Object)new _visitGradleDependency_closure1(this, this, mvid));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[31].callGetProperty(jarContents))) {
                        callSiteArray[32].call(callSiteArray[33].callCurrent((GroovyObject)this, (Object)"this dependency is a service provider unused at compile time and can be moved to the runtime configuration", (Object)call), (Object)call, callSiteArray[34].callStatic(UnusedDependencyRule.class, (Object)call, (Object)"runtime", mvid.get()));
                    }
                    if (DefaultTypeTransformation.booleanUnbox((Object)requiringSourceSet) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[35].call(callSiteArray[36].call((Object)this.dependencyService, requiringSourceSet), mvid.get()))) {
                        callSiteArray[37].call(callSiteArray[38].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{callSiteArray[39].callGetProperty(requiringSourceSet)}, new String[]{"this dependency should be moved to configuration ", ""}), (Object)call), (Object)call, callSiteArray[40].callStatic(UnusedDependencyRule.class, (Object)call, callSiteArray[41].callGetProperty(requiringSourceSet), mvid.get()));
                    } else {
                        callSiteArray[42].call(callSiteArray[43].callCurrent((GroovyObject)this, (Object)"this dependency is unused and can be removed", (Object)call), (Object)call);
                    }
                }
            } else {
                MethodCallExpression methodCallExpression = call;
                callSiteArray[44].call(this.runtimeDependencyDefinitions, mvid.get(), (Object)methodCallExpression);
            }
        }
    }

    @Override
    public void visitDependencies(MethodCallExpression call) {
        CallSite[] callSiteArray = UnusedDependencyRule.$getCallSiteArray();
        callSiteArray[45].callCurrent((GroovyObject)this, (Object)"dependencies", (Object)call);
    }

    @Override
    protected void visitClassComplete(ClassNode node) {
        CallSite[] callSiteArray = UnusedDependencyRule.$getCallSiteArray();
        Reference dependenciesBlock = new Reference(callSiteArray[46].callCurrent((GroovyObject)this, (Object)"dependencies"));
        Object convention = callSiteArray[47].call(callSiteArray[48].callGetProperty(callSiteArray[49].callGroovyObjectGetProperty((Object)this)), JavaPluginConvention.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)convention)) {
            class _visitClassComplete_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference dependenciesBlock;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _visitClassComplete_closure2(Object _outerInstance, Object _thisObject, Reference dependenciesBlock) {
                    Reference reference;
                    CallSite[] callSiteArray = _visitClassComplete_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.dependenciesBlock = reference = dependenciesBlock;
                }

                public Object doCall(Object sourceSet) {
                    CallSite[] callSiteArray = _visitClassComplete_closure2.$getCallSiteArray();
                    Reference conf = new Reference(callSiteArray[0].callGetProperty(sourceSet));
                    class _closure3
                    extends Closure
                    implements GeneratedClosure {
                        private /* synthetic */ Reference conf;
                        private /* synthetic */ Reference dependenciesBlock;
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;
                        private static /* synthetic */ SoftReference $callSiteArray;

                        public _closure3(Object _outerInstance, Object _thisObject, Reference conf, Reference dependenciesBlock) {
                            Reference reference;
                            Reference reference2;
                            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                            super(_outerInstance, _thisObject);
                            this.conf = reference2 = conf;
                            this.dependenciesBlock = reference = dependenciesBlock;
                        }

                        public Object doCall(Object dep) {
                            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                            Object runtimeDeclaration = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), dep);
                            if (DefaultTypeTransformation.booleanUnbox((Object)runtimeDeclaration)) {
                                return callSiteArray[2].call(callSiteArray[3].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{this.conf.get()}, new String[]{"this dependency should be moved to configuration ", ""}), runtimeDeclaration), runtimeDeclaration, callSiteArray[4].callCurrent((GroovyObject)this, runtimeDeclaration, this.conf.get(), dep));
                            }
                            return callSiteArray[5].call(callSiteArray[6].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{dep}, new String[]{"one or more classes in ", " are required by your code directly"})), this.dependenciesBlock.get(), (Object)new GStringImpl(new Object[]{this.conf.get(), dep}, new String[]{"", " '", "'"}));
                        }

                        public Object getConf() {
                            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                            return this.conf.get();
                        }

                        public Object getDependenciesBlock() {
                            CallSite[] callSiteArray = _closure3.$getCallSiteArray();
                            return this.dependenciesBlock.get();
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                            stringArray[0] = "getAt";
                            stringArray[1] = "runtimeDependencyDefinitions";
                            stringArray[2] = "replaceWith";
                            stringArray[3] = "addBuildLintViolation";
                            stringArray[4] = "replaceDependencyWith";
                            stringArray[5] = "insertIntoClosure";
                            stringArray[6] = "addBuildLintViolation";
                        }

                        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                            String[] stringArray = new String[7];
                            _closure3.$createCallSiteArray_1(stringArray);
                            return new CallSiteArray(_closure3.class, stringArray);
                        }

                        private static /* synthetic */ CallSite[] $getCallSiteArray() {
                            CallSiteArray callSiteArray;
                            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                callSiteArray = _closure3.$createCallSiteArray();
                                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                            }
                            return callSiteArray.array;
                        }
                    }
                    return callSiteArray[1].call(callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty((Object)this), conf.get()), (Object)new _closure3((Object)this, this.getThisObject(), conf, this.dependenciesBlock));
                }

                public Object getDependenciesBlock() {
                    CallSite[] callSiteArray = _visitClassComplete_closure2.$getCallSiteArray();
                    return this.dependenciesBlock.get();
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _visitClassComplete_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "compileConfigurationName";
                    stringArray[1] = "each";
                    stringArray[2] = "undeclaredDependencies";
                    stringArray[3] = "dependencyService";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[4];
                    _visitClassComplete_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_visitClassComplete_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _visitClassComplete_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[50].call(callSiteArray[51].callGetProperty(convention), (Object)new _visitClassComplete_closure2(this, this, dependenciesBlock));
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != UnusedDependencyRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        List list;
        shouldBeRuntime = list = ScriptBytecodeAdapter.createList((Object[])new Object[]{"xerces", "xercesImpl", "xml-apis"});
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public static final List<String> getShouldBeRuntime() {
        return shouldBeRuntime;
    }

    public Map<ModuleVersionIdentifier, MethodCallExpression> getRuntimeDependencyDefinitions() {
        return this.runtimeDependencyDefinitions;
    }

    public void setRuntimeDependencyDefinitions(Map<ModuleVersionIdentifier, MethodCallExpression> map) {
        this.runtimeDependencyDefinitions = map;
    }

    public DependencyService getDependencyService() {
        return this.dependencyService;
    }

    public void setDependencyService(DependencyService dependencyService) {
        this.dependencyService = dependencyService;
    }

    public /* synthetic */ void super$5$visitGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$4$visitClassComplete(ClassNode classNode) {
        super.visitClassComplete(classNode);
    }

    public /* synthetic */ void super$5$visitDependencies(MethodCallExpression methodCallExpression) {
        super.visitDependencies(methodCallExpression);
    }

    public /* synthetic */ void super$5$beforeApplyTo() {
        super.beforeApplyTo();
    }

    public /* synthetic */ MetaClass super$5$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "forProject";
        stringArray[1] = "project";
        stringArray[2] = "isResolved";
        stringArray[3] = "findPlugin";
        stringArray[4] = "convention";
        stringArray[5] = "project";
        stringArray[6] = "toModuleVersion";
        stringArray[7] = "isRuntime";
        stringArray[8] = "jarContents";
        stringArray[9] = "isWebjar";
        stringArray[10] = "replaceWith";
        stringArray[11] = "addBuildLintViolation";
        stringArray[12] = "replaceDependencyWith";
        stringArray[13] = "nothingButMetaInf";
        stringArray[14] = "delete";
        stringArray[15] = "addBuildLintViolation";
        stringArray[16] = "isEmpty";
        stringArray[17] = "classes";
        stringArray[18] = "replaceWith";
        stringArray[19] = "addBuildLintViolation";
        stringArray[20] = "replaceDependencyWith";
        stringArray[21] = "contains";
        stringArray[22] = "name";
        stringArray[23] = "replaceWith";
        stringArray[24] = "addBuildLintViolation";
        stringArray[25] = "replaceDependencyWith";
        stringArray[26] = "contains";
        stringArray[27] = "unusedDependencies";
        stringArray[28] = "module";
        stringArray[29] = "find";
        stringArray[30] = "parentSourceSetConfigurations";
        stringArray[31] = "isServiceProvider";
        stringArray[32] = "replaceWith";
        stringArray[33] = "addBuildLintViolation";
        stringArray[34] = "replaceDependencyWith";
        stringArray[35] = "contains";
        stringArray[36] = "firstLevelDependenciesInConf";
        stringArray[37] = "replaceWith";
        stringArray[38] = "addBuildLintViolation";
        stringArray[39] = "name";
        stringArray[40] = "replaceDependencyWith";
        stringArray[41] = "name";
        stringArray[42] = "delete";
        stringArray[43] = "addBuildLintViolation";
        stringArray[44] = "putAt";
        stringArray[45] = "bookmark";
        stringArray[46] = "bookmark";
        stringArray[47] = "findPlugin";
        stringArray[48] = "convention";
        stringArray[49] = "project";
        stringArray[50] = "each";
        stringArray[51] = "sourceSets";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[52];
        UnusedDependencyRule.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(UnusedDependencyRule.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = UnusedDependencyRule.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

