/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsObjDatabase;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsOutputStream;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackDescription;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsReaderOptions;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsRefDatabase;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsRepository;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsRepositoryBuilder;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsRepositoryDescription;
import com.netflix.nebula.lint.jgit.internal.storage.dfs.ReadableChannel;
import com.netflix.nebula.lint.jgit.internal.storage.pack.PackExt;
import com.netflix.nebula.lint.jgit.lib.BatchRefUpdate;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectIdRef;
import com.netflix.nebula.lint.jgit.lib.ProgressMonitor;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefDatabase;
import com.netflix.nebula.lint.jgit.revwalk.RevObject;
import com.netflix.nebula.lint.jgit.revwalk.RevTag;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.transport.ReceiveCommand;
import com.netflix.nebula.lint.jgit.util.RefList;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class InMemoryRepository
extends DfsRepository {
    static final AtomicInteger packId = new AtomicInteger();
    private final DfsObjDatabase objdb = new MemObjDatabase(this);
    private final RefDatabase refdb = new MemRefDatabase();
    private boolean performsAtomicTransactions = true;

    public InMemoryRepository(DfsRepositoryDescription repoDesc) {
        this((Builder)new Builder().setRepositoryDescription(repoDesc));
    }

    InMemoryRepository(Builder builder) {
        super(builder);
    }

    @Override
    public DfsObjDatabase getObjectDatabase() {
        return this.objdb;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refdb;
    }

    public void setPerformsAtomicTransactions(boolean atomic) {
        this.performsAtomicTransactions = atomic;
    }

    public static class Builder
    extends DfsRepositoryBuilder<Builder, InMemoryRepository> {
        @Override
        public InMemoryRepository build() throws IOException {
            return new InMemoryRepository(this);
        }
    }

    private static class ByteArrayReadableChannel
    implements ReadableChannel {
        private final byte[] data;
        private int position;
        private boolean open = true;

        ByteArrayReadableChannel(byte[] buf) {
            this.data = buf;
        }

        @Override
        public int read(ByteBuffer dst) {
            int n = Math.min(dst.remaining(), this.data.length - this.position);
            if (n == 0) {
                return -1;
            }
            dst.put(this.data, this.position, n);
            this.position += n;
            return n;
        }

        @Override
        public void close() {
            this.open = false;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public long position() {
            return this.position;
        }

        @Override
        public void position(long newPosition) {
            this.position = (int)newPosition;
        }

        @Override
        public long size() {
            return this.data.length;
        }

        @Override
        public int blockSize() {
            return 0;
        }

        @Override
        public void setReadAheadBytes(int b) {
        }
    }

    private class MemObjDatabase
    extends DfsObjDatabase {
        private List<DfsPackDescription> packs;

        MemObjDatabase(DfsRepository repo) {
            super(repo, new DfsReaderOptions());
            this.packs = new ArrayList<DfsPackDescription>();
        }

        @Override
        protected synchronized List<DfsPackDescription> listPacks() {
            return this.packs;
        }

        @Override
        protected DfsPackDescription newPack(DfsObjDatabase.PackSource source) {
            int id = packId.incrementAndGet();
            MemPack desc = new MemPack("pack-" + id + "-" + source.name(), this.getRepository().getDescription());
            return desc.setPackSource(source);
        }

        @Override
        protected synchronized void commitPackImpl(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replace) {
            ArrayList<DfsPackDescription> n = new ArrayList<DfsPackDescription>(desc.size() + this.packs.size());
            n.addAll(desc);
            n.addAll(this.packs);
            if (replace != null) {
                n.removeAll(replace);
            }
            this.packs = n;
        }

        @Override
        protected void rollbackPack(Collection<DfsPackDescription> desc) {
        }

        @Override
        protected ReadableChannel openFile(DfsPackDescription desc, PackExt ext) throws FileNotFoundException, IOException {
            MemPack memPack = (MemPack)desc;
            byte[] file = memPack.fileMap.get(ext);
            if (file == null) {
                throw new FileNotFoundException(desc.getFileName(ext));
            }
            return new ByteArrayReadableChannel(file);
        }

        @Override
        protected DfsOutputStream writeFile(DfsPackDescription desc, final PackExt ext) throws IOException {
            final MemPack memPack = (MemPack)desc;
            return new Out(){

                @Override
                public void flush() {
                    memPack.fileMap.put(ext, this.getData());
                }
            };
        }
    }

    private static class MemPack
    extends DfsPackDescription {
        final Map<PackExt, byte[]> fileMap = new HashMap<PackExt, byte[]>();

        MemPack(String name, DfsRepositoryDescription repoDesc) {
            super(repoDesc, name);
        }
    }

    protected class MemRefDatabase
    extends DfsRefDatabase {
        private final ConcurrentMap<String, Ref> refs;
        private final ReadWriteLock lock;

        protected MemRefDatabase() {
            super(InMemoryRepository.this);
            this.refs = new ConcurrentHashMap<String, Ref>();
            this.lock = new ReentrantReadWriteLock(true);
        }

        @Override
        public boolean performsAtomicTransactions() {
            return InMemoryRepository.this.performsAtomicTransactions;
        }

        @Override
        public BatchRefUpdate newBatchUpdate() {
            return new BatchRefUpdate(this){

                @Override
                public void execute(RevWalk walk, ProgressMonitor monitor) throws IOException {
                    if (MemRefDatabase.this.performsAtomicTransactions() && this.isAtomic()) {
                        try {
                            MemRefDatabase.this.lock.writeLock().lock();
                            MemRefDatabase.this.batch(this.getCommands());
                        }
                        finally {
                            MemRefDatabase.this.lock.writeLock().unlock();
                        }
                    } else {
                        super.execute(walk, monitor);
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected DfsRefDatabase.RefCache scanAllRefs() throws IOException {
            RefList.Builder<Ref> ids = new RefList.Builder<Ref>();
            RefList.Builder<Ref> sym = new RefList.Builder<Ref>();
            try {
                this.lock.readLock().lock();
                for (Ref ref : this.refs.values()) {
                    if (ref.isSymbolic()) {
                        sym.add(ref);
                    }
                    ids.add(ref);
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            ids.sort();
            sym.sort();
            InMemoryRepository.this.objdb.getCurrentPackList().markDirty();
            return new DfsRefDatabase.RefCache(ids.toRefList(), sym.toRefList());
        }

        private void batch(List<ReceiveCommand> cmds) {
            HashMap<RevObject, ObjectId> peeled = new HashMap<RevObject, ObjectId>();
            try (RevWalk rw = new RevWalk(this.getRepository());){
                for (ReceiveCommand c : cmds) {
                    if (c.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                        ReceiveCommand.abort(cmds);
                        return;
                    }
                    if (ObjectId.zeroId().equals(c.getNewId())) continue;
                    try {
                        RevObject o = rw.parseAny(c.getNewId());
                        if (!(o instanceof RevTag)) continue;
                        peeled.put(o, rw.peel(o).copy());
                    }
                    catch (IOException e) {
                        c.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
                        ReceiveCommand.abort(cmds);
                        if (rw != null) {
                            if (var4_4 != null) {
                                try {
                                    rw.close();
                                }
                                catch (Throwable throwable) {
                                    var4_4.addSuppressed(throwable);
                                }
                            } else {
                                rw.close();
                            }
                        }
                        return;
                    }
                }
            }
            for (ReceiveCommand c : cmds) {
                Ref r = (Ref)this.refs.get(c.getRefName());
                if (r == null) {
                    if (c.getType() == ReceiveCommand.Type.CREATE) continue;
                    c.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                    ReceiveCommand.abort(cmds);
                    return;
                }
                ObjectId objectId = r.getObjectId();
                if (!r.isSymbolic() && objectId != null && objectId.equals(c.getOldId())) continue;
                c.setResult(ReceiveCommand.Result.LOCK_FAILURE);
                ReceiveCommand.abort(cmds);
                return;
            }
            for (ReceiveCommand c : cmds) {
                if (c.getType() == ReceiveCommand.Type.DELETE) {
                    this.refs.remove(c.getRefName());
                    c.setResult(ReceiveCommand.Result.OK);
                    continue;
                }
                ObjectId p = (ObjectId)peeled.get(c.getNewId());
                ObjectIdRef r = p != null ? new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, c.getRefName(), c.getNewId(), p) : new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, c.getRefName(), c.getNewId());
                this.refs.put(r.getName(), r);
                c.setResult(ReceiveCommand.Result.OK);
            }
            this.clearCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean compareAndPut(Ref oldRef, Ref newRef) throws IOException {
            try {
                this.lock.writeLock().lock();
                ObjectId id = newRef.getObjectId();
                if (id != null) {
                    try (RevWalk rw = new RevWalk(this.getRepository());){
                        rw.parseAny(id);
                    }
                }
                String name = newRef.getName();
                if (oldRef == null) {
                    boolean bl = this.refs.putIfAbsent(name, newRef) == null;
                    return bl;
                }
                Ref cur = (Ref)this.refs.get(name);
                if (cur != null && this.eq(cur, oldRef)) {
                    boolean bl = this.refs.replace(name, cur, newRef);
                    return bl;
                }
                if (oldRef.getStorage() == Ref.Storage.NEW) {
                    boolean bl = this.refs.putIfAbsent(name, newRef) == null;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean compareAndRemove(Ref oldRef) throws IOException {
            try {
                this.lock.writeLock().lock();
                String name = oldRef.getName();
                Ref cur = (Ref)this.refs.get(name);
                if (cur != null && this.eq(cur, oldRef)) {
                    boolean bl = this.refs.remove(name, cur);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        private boolean eq(Ref a, Ref b) {
            if (!Objects.equals(a.getName(), b.getName())) {
                return false;
            }
            if (a.isSymbolic() != b.isSymbolic()) {
                return false;
            }
            if (a.isSymbolic()) {
                return Objects.equals(a.getTarget().getName(), b.getTarget().getName());
            }
            return Objects.equals(a.getObjectId(), b.getObjectId());
        }
    }

    private static abstract class Out
    extends DfsOutputStream {
        private final ByteArrayOutputStream dst = new ByteArrayOutputStream();
        private byte[] data;

        private Out() {
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            this.data = null;
            this.dst.write(buf, off, len);
        }

        @Override
        public int read(long position, ByteBuffer buf) {
            byte[] d = this.getData();
            int n = Math.min(buf.remaining(), d.length - (int)position);
            if (n == 0) {
                return -1;
            }
            buf.put(d, (int)position, n);
            return n;
        }

        byte[] getData() {
            if (this.data == null) {
                this.data = this.dst.toByteArray();
            }
            return this.data;
        }

        @Override
        public abstract void flush();

        @Override
        public void close() {
            this.flush();
        }
    }
}

