/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.ClasspathContainerInitializer;
import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.IClasspathContainer;
import com.netflix.nebula.lint.jdt.core.IClasspathEntry;
import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IJavaProject;
import com.netflix.nebula.lint.jdt.core.IPackageFragment;
import com.netflix.nebula.lint.jdt.core.IPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.core.IParent;
import com.netflix.nebula.lint.jdt.core.IProblemRequestor;
import com.netflix.nebula.lint.jdt.core.JavaConventions;
import com.netflix.nebula.lint.jdt.core.JavaCore;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.compiler.IProblem;
import com.netflix.nebula.lint.jdt.internal.codeassist.CompletionEngine;
import com.netflix.nebula.lint.jdt.internal.codeassist.SelectionEngine;
import com.netflix.nebula.lint.jdt.internal.compiler.Compiler;
import com.netflix.nebula.lint.jdt.internal.compiler.util.Util;
import com.netflix.nebula.lint.jdt.internal.compiler.util.WeakHashSet;
import com.netflix.nebula.lint.jdt.internal.compiler.util.WeakHashSetOfCharArray;
import com.netflix.nebula.lint.jdt.internal.core.BufferManager;
import com.netflix.nebula.lint.jdt.internal.core.ClasspathEntry;
import com.netflix.nebula.lint.jdt.internal.core.CompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.DefaultWorkingCopyOwner;
import com.netflix.nebula.lint.jdt.internal.core.DeltaProcessingState;
import com.netflix.nebula.lint.jdt.internal.core.DeltaProcessor;
import com.netflix.nebula.lint.jdt.internal.core.JarPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.JavaElementDeltaBuilder;
import com.netflix.nebula.lint.jdt.internal.core.JavaElementInfo;
import com.netflix.nebula.lint.jdt.internal.core.JavaModel;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelCache;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelOperation;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.NameLookup;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.ReconcileWorkingCopyOperation;
import com.netflix.nebula.lint.jdt.internal.core.SetClasspathOperation;
import com.netflix.nebula.lint.jdt.internal.core.SourceMapper;
import com.netflix.nebula.lint.jdt.internal.core.builder.JavaBuilder;
import com.netflix.nebula.lint.jdt.internal.core.builder.State;
import com.netflix.nebula.lint.jdt.internal.core.hierarchy.TypeHierarchy;
import com.netflix.nebula.lint.jdt.internal.core.search.AbstractSearchScope;
import com.netflix.nebula.lint.jdt.internal.core.search.BasicSearchEngine;
import com.netflix.nebula.lint.jdt.internal.core.search.JavaWorkspaceScope;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IndexManager;
import com.netflix.nebula.lint.jdt.internal.core.search.processing.JobManager;
import com.netflix.nebula.lint.jdt.internal.core.util.Messages;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class JavaModelManager
implements ISaveParticipant {
    final JavaModel javaModel = new JavaModel();
    public HashMap variables = new HashMap(5);
    public HashMap previousSessionVariables = new HashMap(5);
    private ThreadLocal variableInitializationInProgress = new ThreadLocal();
    public HashMap containers = new HashMap(5);
    public HashMap previousSessionContainers = new HashMap(5);
    private ThreadLocal containerInitializationInProgress = new ThreadLocal();
    public boolean batchContainerInitializations = false;
    public HashMap containerInitializersCache = new HashMap(5);
    private ThreadLocal classpathsBeingResolved = new ThreadLocal();
    public JavaWorkspaceScope workspaceScope;
    private WeakHashSet stringSymbols = new WeakHashSet(5);
    private WeakHashSetOfCharArray charArraySymbols = new WeakHashSetOfCharArray(5);
    public static final String CP_VARIABLE_PREFERENCES_PREFIX = "com.netflix.nebula.lint.jdt.core.classpathVariable.";
    public static final String CP_CONTAINER_PREFERENCES_PREFIX = "com.netflix.nebula.lint.jdt.core.classpathContainer.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    private static final int VARIABLES_AND_CONTAINERS_FILE_VERSION = 1;
    public static final String CPVARIABLE_INITIALIZER_EXTPOINT_ID = "classpathVariableInitializer";
    public static final String CPCONTAINER_INITIALIZER_EXTPOINT_ID = "classpathContainerInitializer";
    public static final String FORMATTER_EXTPOINT_ID = "codeFormatter";
    public static final String JAVA_SOURCE_CONTENT_TYPE = "com.netflix.nebula.lint.jdt.core.javaSource";
    public static final IPath VARIABLE_INITIALIZATION_IN_PROGRESS = new Path("Variable Initialization In Progress");
    public static final IClasspathContainer CONTAINER_INITIALIZATION_IN_PROGRESS = new IClasspathContainer(){

        public IClasspathEntry[] getClasspathEntries() {
            return null;
        }

        public String getDescription() {
            return "Container Initialization In Progress";
        }

        public int getKind() {
            return 0;
        }

        public IPath getPath() {
            return null;
        }

        public String toString() {
            return this.getDescription();
        }
    };
    private static final String BUFFER_MANAGER_DEBUG = "org.eclipse.jdt.core/debug/buffermanager";
    private static final String INDEX_MANAGER_DEBUG = "org.eclipse.jdt.core/debug/indexmanager";
    private static final String COMPILER_DEBUG = "org.eclipse.jdt.core/debug/compiler";
    private static final String JAVAMODEL_DEBUG = "org.eclipse.jdt.core/debug/javamodel";
    private static final String CP_RESOLVE_DEBUG = "org.eclipse.jdt.core/debug/cpresolution";
    private static final String ZIP_ACCESS_DEBUG = "org.eclipse.jdt.core/debug/zipaccess";
    private static final String DELTA_DEBUG = "org.eclipse.jdt.core/debug/javadelta";
    private static final String DELTA_DEBUG_VERBOSE = "org.eclipse.jdt.core/debug/javadelta/verbose";
    private static final String HIERARCHY_DEBUG = "org.eclipse.jdt.core/debug/hierarchy";
    private static final String POST_ACTION_DEBUG = "org.eclipse.jdt.core/debug/postaction";
    private static final String BUILDER_DEBUG = "org.eclipse.jdt.core/debug/builder";
    private static final String COMPLETION_DEBUG = "org.eclipse.jdt.core/debug/completion";
    private static final String RESOLUTION_DEBUG = "org.eclipse.jdt.core/debug/resolution";
    private static final String SELECTION_DEBUG = "org.eclipse.jdt.core/debug/selection";
    private static final String SEARCH_DEBUG = "org.eclipse.jdt.core/debug/search";
    private static final String SOURCE_MAPPER_DEBUG_VERBOSE = "org.eclipse.jdt.core/debug/sourcemapper";
    public static final String COMPLETION_PERF = "org.eclipse.jdt.core/perf/completion";
    public static final String SELECTION_PERF = "org.eclipse.jdt.core/perf/selection";
    public static final String DELTA_LISTENER_PERF = "org.eclipse.jdt.core/perf/javadeltalistener";
    public static final String VARIABLE_INITIALIZER_PERF = "org.eclipse.jdt.core/perf/variableinitializer";
    public static final String CONTAINER_INITIALIZER_PERF = "org.eclipse.jdt.core/perf/containerinitializer";
    public static final String RECONCILE_PERF = "org.eclipse.jdt.core/perf/reconcile";
    public static boolean PERF_VARIABLE_INITIALIZER = false;
    public static boolean PERF_CONTAINER_INITIALIZER = false;
    public static final ICompilationUnit[] NO_WORKING_COPY = new ICompilationUnit[0];
    HashSet optionNames = new HashSet(20);
    Hashtable optionsCache;
    public final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    private static JavaModelManager MANAGER = new JavaModelManager();
    public JavaModelCache cache = new JavaModelCache();
    private ThreadLocal temporaryCache = new ThreadLocal();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    public IndexManager indexManager = new IndexManager();
    protected Map perProjectInfos = new HashMap(5);
    protected Map perWorkingCopyInfos = new HashMap(5);
    protected WeakHashMap searchScopes = new WeakHashMap();
    public static boolean VERBOSE = false;
    public static boolean CP_RESOLVE_VERBOSE = false;
    public static boolean ZIP_ACCESS_VERBOSE = false;
    private ThreadLocal zipFiles = new ThreadLocal();

    public static boolean conflictsWithOutputLocation(IPath folderPath, JavaProject project) {
        try {
            IPath outputLocation = project.getOutputLocation();
            if (outputLocation == null) {
                return true;
            }
            if (outputLocation.isPrefixOf(folderPath)) {
                IClasspathEntry[] classpath = project.getResolvedClasspath(true, false, false);
                boolean isOutputUsed = false;
                int i = 0;
                int length = classpath.length;
                while (i < length) {
                    IClasspathEntry entry = classpath[i];
                    if (entry.getEntryKind() == 3) {
                        if (entry.getPath().equals((Object)outputLocation)) {
                            return false;
                        }
                        if (entry.getOutputLocation() == null) {
                            isOutputUsed = true;
                        }
                    }
                    ++i;
                }
                return isOutputUsed;
            }
            return false;
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    public synchronized IClasspathContainer containerGet(IJavaProject project, IPath containerPath) {
        HashSet projectInitializations = this.containerInitializationInProgress(project);
        if (projectInitializations.contains(containerPath)) {
            return CONTAINER_INITIALIZATION_IN_PROGRESS;
        }
        Map projectContainers = (Map)this.containers.get(project);
        if (projectContainers == null) {
            return null;
        }
        IClasspathContainer container = (IClasspathContainer)projectContainers.get(containerPath);
        return container;
    }

    private synchronized Map containerClone(IJavaProject project) {
        Map originalProjectContainers = (Map)this.containers.get(project);
        if (originalProjectContainers == null) {
            return null;
        }
        HashMap projectContainers = new HashMap(originalProjectContainers.size());
        projectContainers.putAll(originalProjectContainers);
        return projectContainers;
    }

    private HashSet containerInitializationInProgress(IJavaProject project) {
        HashSet projectInitializations;
        HashMap initializations = (HashMap)this.containerInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashMap();
            this.containerInitializationInProgress.set(initializations);
        }
        if ((projectInitializations = (HashSet)initializations.get(project)) == null) {
            projectInitializations = new HashSet();
            initializations.put(project, projectInitializations);
        }
        return projectInitializations;
    }

    public synchronized void containerPut(IJavaProject project, IPath containerPath, IClasspathContainer container) {
        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
            HashSet projectInitializations = this.containerInitializationInProgress(project);
            projectInitializations.add(containerPath);
            return;
        }
        this.containerRemoveInitializationInProgress(project, containerPath);
        HashMap<IPath, IClasspathContainer> projectContainers = (HashMap<IPath, IClasspathContainer>)this.containers.get(project);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IClasspathContainer>(1);
            this.containers.put(project, projectContainers);
        }
        if (container == null) {
            projectContainers.remove(containerPath);
        } else {
            projectContainers.put(containerPath, container);
        }
        Map previousContainers = (Map)this.previousSessionContainers.get(project);
        if (previousContainers != null) {
            previousContainers.remove(containerPath);
        }
    }

    public boolean containerPutIfInitializingWithSameEntries(IPath containerPath, IJavaProject[] projects, IClasspathContainer[] respectiveContainers) {
        int projectLength = projects.length;
        if (projectLength != 1) {
            return false;
        }
        final IClasspathContainer container = respectiveContainers[0];
        if (container == null) {
            return false;
        }
        IJavaProject project = projects[0];
        if (!this.containerInitializationInProgress(project).contains(containerPath)) {
            return false;
        }
        IClasspathContainer previousSessionContainer = this.getPreviousSessionContainer(containerPath, project);
        final IClasspathEntry[] newEntries = container.getClasspathEntries();
        if (previousSessionContainer == null) {
            if (newEntries.length == 0) {
                this.containerPut(project, containerPath, container);
                return true;
            }
            return false;
        }
        final IClasspathEntry[] oldEntries = previousSessionContainer.getClasspathEntries();
        if (oldEntries.length != newEntries.length) {
            return false;
        }
        int i = 0;
        int length = newEntries.length;
        while (i < length) {
            if (!newEntries[i].equals(oldEntries[i])) {
                if (CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPContainer SET  - missbehaving container\n\tcontainer path: " + containerPath + '\n' + "\tprojects: {" + com.netflix.nebula.lint.jdt.internal.compiler.util.Util.toString(projects, new Util.Displayable(){

                        public String displayString(Object o) {
                            return ((IJavaProject)o).getElementName();
                        }
                    }) + "}\n\tvalues on previous session: {\n" + com.netflix.nebula.lint.jdt.internal.compiler.util.Util.toString(respectiveContainers, new Util.Displayable(){

                        public String displayString(Object o) {
                            StringBuffer buffer = new StringBuffer("\t\t");
                            if (o == null) {
                                buffer.append("<null>");
                                return buffer.toString();
                            }
                            buffer.append(container.getDescription());
                            buffer.append(" {\n");
                            int j = 0;
                            while (j < oldEntries.length) {
                                buffer.append(" \t\t\t");
                                buffer.append(oldEntries[j]);
                                buffer.append('\n');
                                ++j;
                            }
                            buffer.append(" \t\t}");
                            return buffer.toString();
                        }
                    }) + "}\n\tnew values: {\n" + com.netflix.nebula.lint.jdt.internal.compiler.util.Util.toString(respectiveContainers, new Util.Displayable(){

                        public String displayString(Object o) {
                            StringBuffer buffer = new StringBuffer("\t\t");
                            if (o == null) {
                                buffer.append("<null>");
                                return buffer.toString();
                            }
                            buffer.append(container.getDescription());
                            buffer.append(" {\n");
                            int j = 0;
                            while (j < newEntries.length) {
                                buffer.append(" \t\t\t");
                                buffer.append(newEntries[j]);
                                buffer.append('\n');
                                ++j;
                            }
                            buffer.append(" \t\t}");
                            return buffer.toString();
                        }
                    }) + "\n\t}");
                }
                return false;
            }
            ++i;
        }
        this.containerPut(project, containerPath, container);
        return true;
    }

    private void containerRemoveInitializationInProgress(IJavaProject project, IPath containerPath) {
        HashSet projectInitializations = this.containerInitializationInProgress(project);
        projectInitializations.remove(containerPath);
        if (projectInitializations.size() == 0) {
            Map initializations = (Map)this.containerInitializationInProgress.get();
            initializations.remove(project);
        }
    }

    private synchronized void containersReset(String[] containerIDs) {
        int i = 0;
        while (i < containerIDs.length) {
            String containerID = containerIDs[i];
            Iterator projectIterator = this.containers.keySet().iterator();
            while (projectIterator.hasNext()) {
                IJavaProject project = (IJavaProject)projectIterator.next();
                Map projectContainers = (Map)this.containers.get(project);
                if (projectContainers == null) continue;
                Iterator containerIterator = projectContainers.keySet().iterator();
                while (containerIterator.hasNext()) {
                    IPath containerPath = (IPath)containerIterator.next();
                    if (!containerPath.segment(0).equals(containerID)) continue;
                    projectContainers.put(containerPath, null);
                }
            }
            ++i;
        }
    }

    public static IJavaElement create(IResource resource, IJavaProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return JavaCore.create((IProject)resource);
            }
            case 1: {
                return JavaModelManager.create((IFile)resource, project);
            }
            case 2: {
                return JavaModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return JavaCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IJavaElement create(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if (file.getFileExtension() != null) {
            String name = file.getName();
            if (Util.isJavaLikeFileName(name)) {
                return JavaModelManager.createCompilationUnitFrom(file, project);
            }
            if (com.netflix.nebula.lint.jdt.internal.compiler.util.Util.isClassFileName(name)) {
                return JavaModelManager.createClassFileFrom(file, project);
            }
            if (com.netflix.nebula.lint.jdt.internal.compiler.util.Util.isArchiveFileName(name)) {
                return JavaModelManager.createJarPackageFragmentRootFrom(file, project);
            }
        }
        return null;
    }

    public static IJavaElement create(IFolder folder, IJavaProject project) {
        IJavaElement element;
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(folder.getProject());
            element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
            if (element == null) {
                IJavaProject[] projects;
                try {
                    projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
                int i = 0;
                int length = projects.length;
                while (i < length) {
                    project = projects[i];
                    element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
                    if (element == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
        }
        if (JavaModelManager.conflictsWithOutputLocation(folder.getFullPath(), (JavaProject)project) || folder.getName().indexOf(46) >= 0 && !(element instanceof IPackageFragmentRoot)) {
            return null;
        }
        return element;
    }

    public static IClassFile createClassFileFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)file, project)) == null) {
            PackageFragmentRoot root = (PackageFragmentRoot)project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment(CharOperation.NO_STRINGS);
        }
        return pkg.getClassFile(file.getName());
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)file, project)) == null) {
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment("");
            if (VERBOSE) {
                System.out.println("WARNING : creating unit element outside classpath (" + Thread.currentThread() + "): " + file.getFullPath());
            }
        }
        return pkg.getCompilationUnit(file.getName());
    }

    public static IPackageFragmentRoot createJarPackageFragmentRootFrom(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        IPath resourcePath = file.getFullPath();
        try {
            IClasspathEntry[] entries = ((JavaProject)project).getResolvedClasspath(true, false, false);
            int i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                IPath rootPath = entry.getPath();
                if (rootPath.equals((Object)resourcePath)) {
                    return project.getPackageFragmentRoot((IResource)file);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IJavaElement determineIfOnClasspath(IResource resource, IJavaProject project) {
        IPath resourcePath = resource.getFullPath();
        try {
            IClasspathEntry[] entries = Util.isJavaLikeFileName(resourcePath.lastSegment()) ? project.getRawClasspath() : ((JavaProject)project).getResolvedClasspath(true, false, false);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 2) {
                    IPath rootPath = entry.getPath();
                    if (rootPath.equals((Object)resourcePath)) {
                        return project.getPackageFragmentRoot(resource);
                    }
                    if (rootPath.isPrefixOf(resourcePath) && !Util.isExcluded(resource, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars())) {
                        String[] pkgName;
                        PackageFragmentRoot root = (PackageFragmentRoot)((JavaProject)project).getFolderPackageFragmentRoot(rootPath);
                        if (root == null) {
                            return null;
                        }
                        IPath pkgPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
                        if (resource.getType() == 1) {
                            pkgPath = pkgPath.removeLastSegments(1);
                        }
                        if ((pkgName = pkgPath.segments()).length != 0 && JavaConventions.validatePackageName(Util.packageName(pkgPath)).getSeverity() == 4) {
                            return null;
                        }
                        return root.getPackageFragment(pkgName);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    private JavaModelManager() {
    }

    private void addDeprecatedOptions(Hashtable options) {
        options.put("com.netflix.nebula.lint.jdt.core.compiler.problem.invalidImport", "error");
        options.put("com.netflix.nebula.lint.jdt.core.compiler.problem.unreachableCode", "error");
    }

    public void cacheZipFiles() {
        if (this.zipFiles.get() != null) {
            return;
        }
        this.zipFiles.set(new HashMap());
    }

    public void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        if (this.zipFiles.get() != null) {
            return;
        }
        try {
            if (ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelManager.closeZipFile(ZipFile)] Closing ZipFile on " + zipFile.getName());
            }
            zipFile.close();
        }
        catch (IOException iOException) {}
    }

    public void configurePluginDebugOptions() {
        if (JavaCore.getPlugin().isDebugging()) {
            String option = Platform.getDebugOption((String)BUFFER_MANAGER_DEBUG);
            if (option != null) {
                BufferManager.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)BUILDER_DEBUG)) != null) {
                JavaBuilder.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)COMPILER_DEBUG)) != null) {
                Compiler.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)COMPLETION_DEBUG)) != null) {
                CompletionEngine.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)CP_RESOLVE_DEBUG)) != null) {
                CP_RESOLVE_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG)) != null) {
                DeltaProcessor.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG_VERBOSE)) != null) {
                DeltaProcessor.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)HIERARCHY_DEBUG)) != null) {
                TypeHierarchy.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)INDEX_MANAGER_DEBUG)) != null) {
                JobManager.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)JAVAMODEL_DEBUG)) != null) {
                VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)POST_ACTION_DEBUG)) != null) {
                JavaModelOperation.POST_ACTION_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)RESOLUTION_DEBUG)) != null) {
                NameLookup.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SEARCH_DEBUG)) != null) {
                BasicSearchEngine.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SELECTION_DEBUG)) != null) {
                SelectionEngine.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)ZIP_ACCESS_DEBUG)) != null) {
                ZIP_ACCESS_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)SOURCE_MAPPER_DEBUG_VERBOSE)) != null) {
                SourceMapper.VERBOSE = option.equalsIgnoreCase("true");
            }
        }
        if (PerformanceStats.ENABLED) {
            CompletionEngine.PERF = PerformanceStats.isEnabled((String)COMPLETION_PERF);
            SelectionEngine.PERF = PerformanceStats.isEnabled((String)SELECTION_PERF);
            DeltaProcessor.PERF = PerformanceStats.isEnabled((String)DELTA_LISTENER_PERF);
            PERF_VARIABLE_INITIALIZER = PerformanceStats.isEnabled((String)VARIABLE_INITIALIZER_PERF);
            PERF_CONTAINER_INITIALIZER = PerformanceStats.isEnabled((String)CONTAINER_INITIALIZER_PERF);
            ReconcileWorkingCopyOperation.PERF = PerformanceStats.isEnabled((String)RECONCILE_PERF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discardPerWorkingCopyInfo(CompilationUnit workingCopy) throws JavaModelException {
        JavaElementDeltaBuilder deltaBuilder = null;
        if (workingCopy.isPrimary()) {
            deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
        }
        PerWorkingCopyInfo info = null;
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            Map workingCopyToInfos;
            WorkingCopyOwner owner;
            block12: {
                block11: {
                    owner = workingCopy.owner;
                    workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
                    if (workingCopyToInfos != null) break block11;
                    return -1;
                }
                info = (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
                if (info != null) break block12;
                return -1;
            }
            if (--info.useCount == 0) {
                workingCopyToInfos.remove(workingCopy);
                if (workingCopyToInfos.isEmpty()) {
                    this.perWorkingCopyInfos.remove(owner);
                }
            }
        }
        if (info.useCount == 0) {
            this.removeInfoAndChildren(workingCopy);
            workingCopy.closeBuffer();
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null && deltaBuilder.delta.getAffectedChildren().length > 0) {
                    this.getDeltaProcessor().registerJavaModelDelta(deltaBuilder.delta);
                }
            }
        }
        return info.useCount;
    }

    public void doneSaving(ISaveContext context) {
    }

    public void flushZipFiles() {
        Thread currentThread = Thread.currentThread();
        HashMap map = (HashMap)this.zipFiles.get();
        if (map == null) {
            return;
        }
        this.zipFiles.set(null);
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            try {
                ZipFile zipFile = (ZipFile)iterator.next();
                if (ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + currentThread + ") [JavaModelManager.flushZipFiles()] Closing ZipFile on " + zipFile.getName());
                }
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IClasspathContainer getClasspathContainer(IPath containerPath, IJavaProject project) throws JavaModelException {
        IClasspathContainer container = this.containerGet(project, containerPath);
        if (container == null) {
            if (this.batchContainerInitializations) {
                this.batchContainerInitializations = false;
                return this.initializeAllContainers(project, containerPath);
            }
            return this.initializeContainer(project, containerPath);
        }
        return container;
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public IndexManager getIndexManager() {
        return this.indexManager;
    }

    public synchronized Object getInfo(IJavaElement element) {
        Object result;
        HashMap tempCache = (HashMap)this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.getInfo(element);
    }

    public IEclipsePreferences getInstancePreferences() {
        return this.preferencesLookup[0];
    }

    public Hashtable getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>(10);
        IEclipsePreferences defaultPreferences = this.getDefaultPreferences();
        Iterator iterator = this.optionNames.iterator();
        while (iterator.hasNext()) {
            String propertyName = (String)iterator.next();
            String value = defaultPreferences.get(propertyName, null);
            if (value == null) continue;
            defaultOptions.put(propertyName, value);
        }
        defaultOptions.put("com.netflix.nebula.lint.jdt.core.encoding", JavaCore.getEncoding());
        this.addDeprecatedOptions(defaultOptions);
        return defaultOptions;
    }

    public IEclipsePreferences getDefaultPreferences() {
        return this.preferencesLookup[1];
    }

    public final JavaModel getJavaModel() {
        return this.javaModel;
    }

    public static final JavaModelManager getJavaModelManager() {
        return MANAGER;
    }

    public Object getLastBuiltState(IProject project, IProgressMonitor monitor) {
        if (!JavaProject.hasJavaNature(project)) {
            if (JavaBuilder.DEBUG) {
                System.out.println(project + " is not a Java project");
            }
            return null;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        if (!info.triedRead) {
            info.triedRead = true;
            try {
                if (monitor != null) {
                    monitor.subTask(Messages.bind(Messages.build_readStateProgress, project.getName()));
                }
                info.savedState = this.readState(project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return info.savedState;
    }

    public String getOption(String optionName) {
        if ("com.netflix.nebula.lint.jdt.core.encoding".equals(optionName)) {
            return JavaCore.getEncoding();
        }
        if (this.isDeprecatedOption(optionName)) {
            return "error";
        }
        String propertyName = optionName;
        if (this.optionNames.contains(propertyName)) {
            IPreferencesService service = Platform.getPreferencesService();
            String value = service.get(optionName, null, (Preferences[])this.preferencesLookup);
            return value == null ? null : value.trim();
        }
        return null;
    }

    public Hashtable getOptions() {
        if (this.optionsCache != null) {
            return new Hashtable(this.optionsCache);
        }
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        IPreferencesService service = Platform.getPreferencesService();
        Iterator iterator = this.optionNames.iterator();
        while (iterator.hasNext()) {
            String propertyName = (String)iterator.next();
            String propertyValue = service.get(propertyName, null, (Preferences[])this.preferencesLookup);
            if (propertyValue == null) continue;
            options.put(propertyName, propertyValue);
        }
        options.put("com.netflix.nebula.lint.jdt.core.encoding", JavaCore.getEncoding());
        this.addDeprecatedOptions(options);
        this.optionsCache = new Hashtable(options);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfos.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws JavaModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!JavaProject.hasJavaNature(project)) {
                throw ((JavaProject)JavaCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerWorkingCopyInfo getPerWorkingCopyInfo(CompilationUnit workingCopy, boolean create, boolean recordUsage, IProblemRequestor problemRequestor) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo info;
            WorkingCopyOwner owner = workingCopy.owner;
            HashMap<CompilationUnit, PerWorkingCopyInfo> workingCopyToInfos = (HashMap<CompilationUnit, PerWorkingCopyInfo>)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null && create) {
                workingCopyToInfos = new HashMap<CompilationUnit, PerWorkingCopyInfo>();
                this.perWorkingCopyInfos.put(owner, workingCopyToInfos);
            }
            PerWorkingCopyInfo perWorkingCopyInfo = info = workingCopyToInfos == null ? null : (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
            if (info == null && create) {
                info = new PerWorkingCopyInfo(workingCopy, problemRequestor);
                workingCopyToInfos.put(workingCopy, info);
            }
            if (info != null && recordUsage) {
                ++info.useCount;
            }
            return info;
        }
    }

    public IClasspathContainer getPreviousSessionContainer(IPath containerPath, IJavaProject project) {
        IClasspathContainer previousContainer;
        Map previousContainerValues = (Map)this.previousSessionContainers.get(project);
        if (previousContainerValues != null && (previousContainer = (IClasspathContainer)previousContainerValues.get(containerPath)) != null) {
            if (CP_RESOLVE_VERBOSE) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("CPContainer INIT - reentering access to project container during its initialization, will see previous value\n");
                buffer.append("\tproject: " + project.getElementName() + '\n');
                buffer.append("\tcontainer path: " + containerPath + '\n');
                buffer.append("\tprevious value: ");
                buffer.append(previousContainer.getDescription());
                buffer.append(" {\n");
                IClasspathEntry[] entries = previousContainer.getClasspathEntries();
                if (entries != null) {
                    int j = 0;
                    while (j < entries.length) {
                        buffer.append(" \t\t");
                        buffer.append(entries[j]);
                        buffer.append('\n');
                        ++j;
                    }
                }
                buffer.append(" \t}");
                Util.verbose(buffer.toString());
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            return previousContainer;
        }
        return null;
    }

    public IPath getPreviousSessionVariable(String variableName) {
        IPath previousPath = (IPath)this.previousSessionVariables.get(variableName);
        if (previousPath != null) {
            if (CP_RESOLVE_VERBOSE) {
                Util.verbose("CPVariable INIT - reentering access to variable during its initialization, will see previous value\n\tvariable: " + variableName + '\n' + "\tprevious value: " + previousPath);
                new Exception("<Fake exception>").printStackTrace(System.out);
            }
            return previousPath;
        }
        return null;
    }

    public HashMap getTemporaryCache() {
        HashMap result = (HashMap)this.temporaryCache.get();
        if (result == null) {
            result = new HashMap();
            this.temporaryCache.set(result);
        }
        return result;
    }

    private File getVariableAndContainersFile() {
        return JavaCore.getPlugin().getStateLocation().append("variablesAndContainers.dat").toFile();
    }

    public static String[] getRegisteredVariableNames() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> variableList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("com.netflix.nebula.lint.jdt.core", CPVARIABLE_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String varAttribute = configElements[j].getAttribute("variable");
                    if (varAttribute != null) {
                        variableList.add(varAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] variableNames = new String[variableList.size()];
        variableList.toArray(variableNames);
        return variableNames;
    }

    public static String[] getRegisteredContainerIDs() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("com.netflix.nebula.lint.jdt.core", CPCONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String idAttribute = configElements[j].getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++j;
                }
                ++i;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("com.netflix.nebula.lint.jdt.core");
        return workingLocation.append("state.dat").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompilationUnit[] getWorkingCopies(WorkingCopyOwner owner, boolean addPrimary) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            ICompilationUnit[] primaryWCs = addPrimary && owner != DefaultWorkingCopyOwner.PRIMARY ? this.getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false) : null;
            Map workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null) {
                return primaryWCs;
            }
            int primaryLength = primaryWCs == null ? 0 : primaryWCs.length;
            int size = workingCopyToInfos.size();
            ICompilationUnit[] result = new ICompilationUnit[primaryLength + size];
            int index = 0;
            if (primaryWCs != null) {
                int i = 0;
                while (i < primaryLength) {
                    ICompilationUnit primaryWorkingCopy = primaryWCs[i];
                    CompilationUnit workingCopy = new CompilationUnit((PackageFragment)primaryWorkingCopy.getParent(), primaryWorkingCopy.getElementName(), owner);
                    if (!workingCopyToInfos.containsKey(workingCopy)) {
                        result[index++] = primaryWorkingCopy;
                    }
                    ++i;
                }
                if (index != primaryLength) {
                    ICompilationUnit[] iCompilationUnitArray = result;
                    result = new ICompilationUnit[index + size];
                    System.arraycopy(iCompilationUnitArray, 0, result, 0, index);
                }
            }
            Iterator iterator = workingCopyToInfos.values().iterator();
            while (iterator.hasNext()) {
                result[index++] = ((PerWorkingCopyInfo)iterator.next()).getWorkingCopy();
            }
            return result;
        }
    }

    public JavaWorkspaceScope getWorkspaceScope() {
        if (this.workspaceScope == null) {
            this.workspaceScope = new JavaWorkspaceScope();
        }
        return this.workspaceScope;
    }

    public ZipFile getZipFile(IPath path) throws CoreException {
        ZipFile zipFile;
        HashMap map = (HashMap)this.zipFiles.get();
        if (map != null && (zipFile = (ZipFile)map.get(path)) != null) {
            return zipFile;
        }
        String fileSystemPath = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource file = root.findMember(path);
        if (file != null) {
            IPath location;
            if (file.getType() != 1 || (location = file.getLocation()) == null) {
                throw new CoreException((IStatus)new Status(4, "com.netflix.nebula.lint.jdt.core", -1, Messages.bind(Messages.file_notFound, path.toString()), null));
            }
            fileSystemPath = location.toOSString();
        } else {
            fileSystemPath = path.toOSString();
        }
        try {
            if (ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + Thread.currentThread() + ") [JavaModelManager.getZipFile(IPath)] Creating ZipFile on " + fileSystemPath);
            }
            zipFile = new ZipFile(fileSystemPath);
            if (map != null) {
                map.put(path, zipFile);
            }
            return zipFile;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.netflix.nebula.lint.jdt.core", -1, Messages.status_IOException, (Throwable)e));
        }
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    /*
     * Exception decompiling
     */
    private IClasspathContainer initializeAllContainers(IJavaProject javaProjectToInit, IPath containerToInit) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 434->437)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IClasspathContainer initializeContainer(IJavaProject project, IPath containerPath) throws JavaModelException {
        boolean ok;
        PerformanceStats stats;
        ClasspathContainerInitializer initializer;
        IClasspathContainer container;
        block25: {
            IClasspathContainer iClasspathContainer;
            block23: {
                block24: {
                    container = null;
                    initializer = JavaCore.getClasspathContainerInitializer(containerPath.segment(0));
                    if (initializer == null) {
                        if (!CP_RESOLVE_VERBOSE) return container;
                        Util.verbose("CPContainer INIT - no initializer found\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath);
                        return container;
                    }
                    if (CP_RESOLVE_VERBOSE) {
                        Util.verbose("CPContainer INIT - triggering initialization\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer + '\n' + "\tinvocation stack trace:");
                        new Exception("<Fake exception>").printStackTrace(System.out);
                    }
                    stats = null;
                    if (PERF_CONTAINER_INITIALIZER) {
                        stats = PerformanceStats.getStats((String)CONTAINER_INITIALIZER_PERF, (Object)this);
                        stats.startRun(containerPath + " of " + project.getPath());
                    }
                    this.containerPut(project, containerPath, CONTAINER_INITIALIZATION_IN_PROGRESS);
                    ok = false;
                    try {
                        try {
                            initializer.initialize(containerPath, project);
                            container = this.containerGet(project, containerPath);
                            if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
                                iClasspathContainer = null;
                                Object var10_8 = null;
                                if (!PERF_CONTAINER_INITIALIZER) break block23;
                                break block24;
                            }
                            ok = true;
                            break block25;
                        }
                        catch (CoreException e) {
                            if (!(e instanceof JavaModelException)) throw new JavaModelException(e);
                            throw (JavaModelException)e;
                        }
                        catch (RuntimeException e) {
                            if (!CP_RESOLVE_VERBOSE) throw e;
                            e.printStackTrace();
                            throw e;
                        }
                        catch (Error e) {
                            if (!CP_RESOLVE_VERBOSE) throw e;
                            e.printStackTrace();
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_9 = null;
                        if (PERF_CONTAINER_INITIALIZER) {
                            stats.endRun();
                        }
                        if (ok) throw throwable;
                        this.containerRemoveInitializationInProgress(project, containerPath);
                        if (!CP_RESOLVE_VERBOSE) throw throwable;
                        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
                            Util.verbose("CPContainer INIT - FAILED (initializer did not initialize container)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
                            throw throwable;
                        }
                        Util.verbose("CPContainer INIT - FAILED (see exception above)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
                        throw throwable;
                    }
                }
                stats.endRun();
            }
            if (ok) return iClasspathContainer;
            this.containerRemoveInitializationInProgress(project, containerPath);
            if (!CP_RESOLVE_VERBOSE) return iClasspathContainer;
            if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
                Util.verbose("CPContainer INIT - FAILED (initializer did not initialize container)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
                return iClasspathContainer;
            }
            Util.verbose("CPContainer INIT - FAILED (see exception above)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
            return iClasspathContainer;
        }
        Object var10_10 = null;
        if (PERF_CONTAINER_INITIALIZER) {
            stats.endRun();
        }
        if (!ok) {
            this.containerRemoveInitializationInProgress(project, containerPath);
            if (CP_RESOLVE_VERBOSE) {
                if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
                    Util.verbose("CPContainer INIT - FAILED (initializer did not initialize container)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
                } else {
                    Util.verbose("CPContainer INIT - FAILED (see exception above)\n\tproject: " + project.getElementName() + '\n' + "\tcontainer path: " + containerPath + '\n' + "\tinitializer: " + initializer);
                }
            }
        }
        if (!CP_RESOLVE_VERBOSE) return container;
        StringBuffer buffer = new StringBuffer();
        buffer.append("CPContainer INIT - after resolution\n");
        buffer.append("\tproject: " + project.getElementName() + '\n');
        buffer.append("\tcontainer path: " + containerPath + '\n');
        if (container != null) {
            buffer.append("\tcontainer: " + container.getDescription() + " {\n");
            IClasspathEntry[] entries = container.getClasspathEntries();
            if (entries != null) {
                int i = 0;
                while (i < entries.length) {
                    buffer.append("\t\t" + entries[i] + '\n');
                    ++i;
                }
            }
            buffer.append("\t}");
        } else {
            buffer.append("\tcontainer: {unbound}");
        }
        Util.verbose(buffer.toString());
        return container;
    }

    public void initializePreferences() {
        this.preferencesLookup[0] = new InstanceScope().getNode("com.netflix.nebula.lint.jdt.core");
        this.preferencesLookup[1] = new DefaultScope().getNode("com.netflix.nebula.lint.jdt.core");
        Object listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == JavaModelManager.this.preferencesLookup[0]) {
                    JavaModelManager.this.preferencesLookup[0] = new InstanceScope().getNode("com.netflix.nebula.lint.jdt.core");
                    JavaModelManager.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener(listener);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
        listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == JavaModelManager.this.preferencesLookup[1]) {
                    JavaModelManager.this.preferencesLookup[1] = new DefaultScope().getNode("com.netflix.nebula.lint.jdt.core");
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener(listener);
    }

    public synchronized char[] intern(char[] array) {
        return this.charArraySymbols.add(array);
    }

    public synchronized String intern(String s) {
        return (String)this.stringSymbols.add(new String(s));
    }

    private HashSet getClasspathBeingResolved() {
        HashSet result = (HashSet)this.classpathsBeingResolved.get();
        if (result == null) {
            result = new HashSet();
            this.classpathsBeingResolved.set(result);
        }
        return result;
    }

    public boolean isClasspathBeingResolved(IJavaProject project) {
        return this.getClasspathBeingResolved().contains(project);
    }

    private boolean isDeprecatedOption(String optionName) {
        return "com.netflix.nebula.lint.jdt.core.compiler.problem.invalidImport".equals(optionName) || "com.netflix.nebula.lint.jdt.core.compiler.problem.unreachableCode".equals(optionName);
    }

    public void setClasspathBeingResolved(IJavaProject project, boolean classpathIsResolved) {
        if (classpathIsResolved) {
            this.getClasspathBeingResolved().add(project);
        } else {
            this.getClasspathBeingResolved().remove(project);
        }
    }

    /*
     * Exception decompiling
     */
    public void loadVariablesAndContainers() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 105->108)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected synchronized Object peekAtInfo(IJavaElement element) {
        Object result;
        HashMap tempCache = (HashMap)this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.peekAtInfo(element);
    }

    public void prepareToSave(ISaveContext context) {
    }

    protected synchronized void putInfos(IJavaElement openedElement, Map newElements) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof JavaElementInfo) {
            IJavaElement[] children = ((JavaElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                JavaElement child = (JavaElement)children[i];
                try {
                    child.close();
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
        }
        Iterator it = newElements.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            IJavaElement element = (IJavaElement)entry.getKey();
            if (!(element instanceof JarPackageFragmentRoot)) continue;
            Object info = entry.getValue();
            it.remove();
            this.cache.putInfo(element, info);
        }
        Iterator iterator = newElements.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement element = (IJavaElement)iterator.next();
            Object info = newElements.get(element);
            this.cache.putInfo(element, info);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object readState(IProject project) throws CoreException {
        File file = this.getSerializationFile(project);
        if (file != null && file.exists()) {
            try {
                DataInputStream in;
                block12: {
                    State state;
                    block11: {
                        in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                        try {
                            String pluginID = in.readUTF();
                            if (!pluginID.equals("com.netflix.nebula.lint.jdt.core")) {
                                throw new IOException(Messages.build_wrongFileFormat);
                            }
                            String kind = in.readUTF();
                            if (!kind.equals("STATE")) {
                                throw new IOException(Messages.build_wrongFileFormat);
                            }
                            if (in.readBoolean()) {
                                state = JavaBuilder.readState(project, in);
                                Object var8_8 = null;
                                break block11;
                            }
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Saved state thinks last build failed for " + project.getName());
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            in.close();
                            throw throwable;
                        }
                    }
                    in.close();
                    return state;
                }
                Object var8_10 = null;
                in.close();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CoreException((IStatus)new Status(4, "com.netflix.nebula.lint.jdt.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
            }
        }
        if (!JavaBuilder.DEBUG) return null;
        if (file == null) {
            System.out.println("Project does not exist: " + project);
            return null;
        }
        System.out.println("Build state file " + file.getPath() + " does not exist");
        return null;
    }

    public static void recreatePersistedContainer(String propertyName, String containerString, boolean addToContainerValues) {
        int containerPrefixLength = CP_CONTAINER_PREFERENCES_PREFIX.length();
        int index = propertyName.indexOf(124, containerPrefixLength);
        if (containerString != null) {
            containerString = containerString.trim();
        }
        if (index > 0) {
            String projectName = propertyName.substring(containerPrefixLength, index).trim();
            IJavaProject project = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
            Path containerPath = new Path(propertyName.substring(index + 1).trim());
            JavaModelManager.recreatePersistedContainer(project, (IPath)containerPath, containerString, addToContainerValues);
        }
    }

    private static void recreatePersistedContainer(final IJavaProject project, final IPath containerPath, String containerString, boolean addToContainerValues) {
        if (!project.getProject().isAccessible()) {
            return;
        }
        if (containerString == null) {
            JavaModelManager.getJavaModelManager().containerPut(project, containerPath, null);
        } else {
            final IClasspathEntry[] containerEntries = ((JavaProject)project).decodeClasspath(containerString, false, false);
            if (containerEntries != null && containerEntries != JavaProject.INVALID_CLASSPATH) {
                HashMap<IPath, 7> projectContainers;
                IClasspathContainer container = new IClasspathContainer(){

                    public IClasspathEntry[] getClasspathEntries() {
                        return containerEntries;
                    }

                    public String getDescription() {
                        return "Persisted container [" + containerPath + " for project [" + project.getElementName() + "]";
                    }

                    public int getKind() {
                        return 0;
                    }

                    public IPath getPath() {
                        return containerPath;
                    }

                    public String toString() {
                        return this.getDescription();
                    }
                };
                if (addToContainerValues) {
                    JavaModelManager.getJavaModelManager().containerPut(project, containerPath, container);
                }
                if ((projectContainers = (HashMap<IPath, 7>)JavaModelManager.getJavaModelManager().previousSessionContainers.get(project)) == null) {
                    projectContainers = new HashMap<IPath, 7>(1);
                    JavaModelManager.getJavaModelManager().previousSessionContainers.put(project, projectContainers);
                }
                projectContainers.put(containerPath, container);
            }
        }
    }

    public void rememberScope(AbstractSearchScope scope) {
        this.searchScopes.put(scope, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object removeInfoAndChildren(JavaElement element) throws JavaModelException {
        Object info = this.cache.peekAtInfo(element);
        if (info == null) {
            return null;
        }
        boolean wasVerbose = false;
        try {
            if (VERBOSE) {
                String elementType;
                switch (element.getElementType()) {
                    case 2: {
                        elementType = "project";
                        break;
                    }
                    case 3: {
                        elementType = "root";
                        break;
                    }
                    case 4: {
                        elementType = "package";
                        break;
                    }
                    case 6: {
                        elementType = "class file";
                        break;
                    }
                    case 5: {
                        elementType = "compilation unit";
                        break;
                    }
                    default: {
                        elementType = "element";
                    }
                }
                System.out.println(Thread.currentThread() + " CLOSING " + elementType + " " + element.toStringWithAncestors());
                wasVerbose = true;
                VERBOSE = false;
            }
            element.closing(info);
            if (element instanceof IParent && info instanceof JavaElementInfo) {
                IJavaElement[] children = ((JavaElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    JavaElement child = (JavaElement)children[i];
                    child.close();
                    ++i;
                }
            }
            this.cache.removeInfo(element);
            if (wasVerbose) {
                System.out.println(this.cache.toStringFillingRation("-> "));
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            VERBOSE = wasVerbose;
            throw throwable;
        }
        {
            Object var9_10 = null;
            VERBOSE = wasVerbose;
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(JavaProject javaProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info != null) {
                this.perProjectInfos.remove(project);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectOptions(JavaProject javaProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info != null) {
                info.options = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectPreferences(JavaProject javaProject) {
        Map map = this.perProjectInfos;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfos.get(project);
            if (info != null) {
                info.preferences = null;
            }
        }
    }

    public static final void doNotUse() {
        MANAGER = new JavaModelManager();
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public void rollback(ISaveContext context) {
    }

    private void saveState(PerProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            this.saveBuiltState(info);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveBuiltState(PerProjectInfo info) throws CoreException {
        File file;
        if (JavaBuilder.DEBUG) {
            System.out.println(Messages.bind(Messages.build_saveStateProgress, info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF("com.netflix.nebula.lint.jdt.core");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    JavaBuilder.writeState(info.savedState, out);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                out.close();
                throw throwable;
            }
            {
                Object var7_9 = null;
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
                throw new CoreException((IStatus)new Status(4, "com.netflix.nebula.lint.jdt.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "com.netflix.nebula.lint.jdt.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
                throw new CoreException((IStatus)new Status(4, "com.netflix.nebula.lint.jdt.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "com.netflix.nebula.lint.jdt.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
        }
        if (!JavaBuilder.DEBUG) return;
        t = System.currentTimeMillis() - t;
        System.out.println(Messages.bind(Messages.build_saveStateComplete, String.valueOf(t)));
    }

    /*
     * Exception decompiling
     */
    private void saveVariablesAndContainers() throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 506->510)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saving(ISaveContext context) throws CoreException {
        IProject savedProject;
        this.saveVariablesAndContainers();
        if (context.getKind() == 1) {
            context.needDelta();
            IndexManager manager = this.indexManager;
            if (manager != null && this.workspaceScope != null) {
                manager.cleanUpIndexes();
            }
        }
        if ((savedProject = context.getProject()) != null) {
            if (!JavaProject.hasJavaNature(savedProject)) {
                return;
            }
            PerProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            info.rememberExternalLibTimestamps();
            return;
        }
        ArrayList<IStatus> vStats = null;
        ArrayList values = null;
        Map map = this.perProjectInfos;
        synchronized (map) {
            values = new ArrayList(this.perProjectInfos.values());
        }
        if (values != null) {
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                try {
                    PerProjectInfo info = (PerProjectInfo)iterator.next();
                    this.saveState(info, context);
                    info.rememberExternalLibTimestamps();
                }
                catch (CoreException e) {
                    if (vStats == null) {
                        vStats = new ArrayList<IStatus>();
                    }
                    vStats.add(e.getStatus());
                }
            }
        }
        if (vStats != null) {
            IStatus[] stats = new IStatus[vStats.size()];
            vStats.toArray(stats);
            throw new CoreException((IStatus)new MultiStatus("com.netflix.nebula.lint.jdt.core", 4, stats, Messages.build_cannotSaveStates, null));
        }
        this.deltaState.saveExternalLibTimeStamps();
    }

    protected void setBuildOrder(String[] javaBuildOrder) throws JavaModelException {
        String[] newOrder;
        if (!"compute".equals(JavaCore.getOption("com.netflix.nebula.lint.jdt.core.computeJavaBuildOrder"))) {
            return;
        }
        if (javaBuildOrder == null || javaBuildOrder.length <= 1) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        String[] wksBuildOrder = description.getBuildOrder();
        if (wksBuildOrder == null) {
            newOrder = javaBuildOrder;
        } else {
            int javaCount = javaBuildOrder.length;
            HashMap<String, String> newSet = new HashMap<String, String>(javaCount);
            int i = 0;
            while (i < javaCount) {
                newSet.put(javaBuildOrder[i], javaBuildOrder[i]);
                ++i;
            }
            int removed = 0;
            int oldCount = wksBuildOrder.length;
            int i2 = 0;
            while (i2 < oldCount) {
                if (newSet.containsKey(wksBuildOrder[i2])) {
                    wksBuildOrder[i2] = null;
                    ++removed;
                }
                ++i2;
            }
            newOrder = new String[oldCount - removed + javaCount];
            System.arraycopy(javaBuildOrder, 0, newOrder, 0, javaCount);
            int index = javaCount;
            int i3 = 0;
            while (i3 < oldCount) {
                if (wksBuildOrder[i3] != null) {
                    newOrder[index++] = wksBuildOrder[i3];
                }
                ++i3;
            }
        }
        description.setBuildOrder(newOrder);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (JavaProject.hasJavaNature(project)) {
            PerProjectInfo info = this.getPerProjectInfo(project, true);
            info.triedRead = true;
            info.savedState = state;
        }
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    public void setOptions(Hashtable newOptions) {
        try {
            IEclipsePreferences defaultPreferences = this.getDefaultPreferences();
            IEclipsePreferences instancePreferences = this.getInstancePreferences();
            if (newOptions == null) {
                instancePreferences.clear();
            } else {
                Enumeration keys = newOptions.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!this.optionNames.contains(key) || key.equals("com.netflix.nebula.lint.jdt.core.encoding")) continue;
                    String value = (String)newOptions.get(key);
                    String defaultValue = defaultPreferences.get(key, null);
                    if (defaultValue != null && defaultValue.equals(value)) {
                        instancePreferences.remove(key);
                        continue;
                    }
                    instancePreferences.put(key, value);
                }
            }
            instancePreferences.flush();
            this.optionsCache = newOptions == null ? null : new Hashtable(newOptions);
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public void startup() throws CoreException {
        try {
            this.configurePluginDebugOptions();
            JavaCore.getPlugin().getStateLocation();
            this.initializePreferences();
            Preferences.IPropertyChangeListener propertyListener = new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    JavaModelManager.this.optionsCache = null;
                }
            };
            JavaCore.getPlugin().getPluginPreferences().addPropertyChangeListener(propertyListener);
            this.loadVariablesAndContainers();
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this.deltaState, 31);
            this.startIndexing();
            Job processSavedState = new Job(Messages.savedState_jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(this, workspace){
                            final /* synthetic */ 9 this$1;
                            private final /* synthetic */ IWorkspace val$workspace;
                            {
                                this.this$1 = var1_1;
                                this.val$workspace = iWorkspace;
                            }

                            public void run(IProgressMonitor progress) throws CoreException {
                                ISavedState savedState = this.val$workspace.addSaveParticipant((Plugin)JavaCore.getJavaCore(), (ISaveParticipant)9.access$0(this.this$1));
                                if (savedState != null) {
                                    9.access$0(this.this$1).deltaState.getDeltaProcessor().overridenEventType = 1;
                                    savedState.processResourceChangeEvents((IResourceChangeListener)9.access$0(this.this$1).deltaState);
                                }
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }

                static /* synthetic */ JavaModelManager access$0(9 var0) {
                    return var0.JavaModelManager.this;
                }
            };
            processSavedState.setSystem(true);
            processSavedState.setPriority(20);
            processSavedState.schedule();
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
    }

    private void startIndexing() {
        this.getIndexManager().reset();
    }

    public void shutdown() {
        JavaCore javaCore = JavaCore.getJavaCore();
        javaCore.savePluginPreferences();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.deltaState);
        workspace.removeSaveParticipant((Plugin)javaCore);
        if (this.indexManager != null) {
            this.indexManager.shutdown();
        }
        try {
            Platform.getJobManager().join((Object)"com.netflix.nebula.lint.jdt.core", null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public synchronized IPath variableGet(String variableName) {
        HashSet initializations = this.variableInitializationInProgress();
        if (initializations.contains(variableName)) {
            return VARIABLE_INITIALIZATION_IN_PROGRESS;
        }
        return (IPath)this.variables.get(variableName);
    }

    public void updateVariableValues(String[] variableNames, IPath[] variablePaths, IProgressMonitor monitor) throws JavaModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (CP_RESOLVE_VERBOSE) {
            Util.verbose("CPVariable SET  - setting variables\n\tvariables: " + com.netflix.nebula.lint.jdt.internal.compiler.util.Util.toString(variableNames) + '\n' + "\tvalues: " + com.netflix.nebula.lint.jdt.internal.compiler.util.Util.toString(variablePaths));
        }
        if (this.variablePutIfInitializingWithSameValue(variableNames, variablePaths)) {
            return;
        }
        int varLength = variableNames.length;
        final HashMap<JavaProject, IClasspathEntry[]> affectedProjectClasspaths = new HashMap<JavaProject, IClasspathEntry[]>(5);
        JavaModel model = this.getJavaModel();
        int discardCount = 0;
        int i = 0;
        while (i < varLength) {
            String variableName = variableNames[i];
            IPath oldPath = this.variableGet(variableName);
            if (oldPath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
                oldPath = null;
            }
            if (oldPath != null && oldPath.equals((Object)variablePaths[i])) {
                variableNames[i] = null;
                ++discardCount;
            }
            ++i;
        }
        if (discardCount > 0) {
            if (discardCount == varLength) {
                return;
            }
            int changedLength = varLength - discardCount;
            String[] changedVariableNames = new String[changedLength];
            IPath[] changedVariablePaths = new IPath[changedLength];
            int i2 = 0;
            int index = 0;
            while (i2 < varLength) {
                if (variableNames[i2] != null) {
                    changedVariableNames[index] = variableNames[i2];
                    changedVariablePaths[index] = variablePaths[i2];
                    ++index;
                }
                ++i2;
            }
            variableNames = changedVariableNames;
            variablePaths = changedVariablePaths;
            varLength = changedLength;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (model != null) {
            IJavaProject[] projects = model.getJavaProjects();
            int i3 = 0;
            int projectLength = projects.length;
            while (i3 < projectLength) {
                JavaProject project = (JavaProject)projects[i3];
                IClasspathEntry[] classpath = project.getRawClasspath();
                int j = 0;
                int cpLength = classpath.length;
                block5: while (j < cpLength) {
                    IClasspathEntry entry = classpath[j];
                    int k = 0;
                    while (k < varLength) {
                        String variableName = variableNames[k];
                        if (entry.getEntryKind() == 4) {
                            IPath sourceRootPath;
                            if (variableName.equals(entry.getPath().segment(0))) {
                                affectedProjectClasspaths.put(project, project.getResolvedClasspath(true, false, false));
                                break block5;
                            }
                            IPath sourcePath = entry.getSourceAttachmentPath();
                            if (sourcePath != null && variableName.equals(sourcePath.segment(0)) || (sourceRootPath = entry.getSourceAttachmentRootPath()) != null && variableName.equals(sourceRootPath.segment(0))) {
                                affectedProjectClasspaths.put(project, project.getResolvedClasspath(true, false, false));
                                break block5;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        i = 0;
        while (i < varLength) {
            this.variablePut(variableNames[i], variablePaths[i]);
            ++i;
        }
        Object[] dbgVariableNames = variableNames;
        if (!affectedProjectClasspaths.isEmpty()) {
            try {
                boolean canChangeResources = !ResourcesPlugin.getWorkspace().isTreeLocked();
                JavaCore.run(new IWorkspaceRunnable((String[])dbgVariableNames, canChangeResources){
                    private final /* synthetic */ String[] val$dbgVariableNames;
                    private final /* synthetic */ boolean val$canChangeResources;
                    {
                        this.val$dbgVariableNames = stringArray;
                        this.val$canChangeResources = bl;
                    }

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        Iterator projectsToUpdate = affectedProjectClasspaths.keySet().iterator();
                        while (projectsToUpdate.hasNext()) {
                            if (progressMonitor != null && progressMonitor.isCanceled()) {
                                return;
                            }
                            JavaProject affectedProject = (JavaProject)projectsToUpdate.next();
                            if (CP_RESOLVE_VERBOSE) {
                                Util.verbose("CPVariable SET  - updating affected project due to setting variables\n\tproject: " + affectedProject.getElementName() + '\n' + "\tvariables: " + com.netflix.nebula.lint.jdt.internal.compiler.util.Util.toString(this.val$dbgVariableNames));
                            }
                            affectedProject.setRawClasspath(affectedProject.getRawClasspath(), SetClasspathOperation.DO_NOT_SET_OUTPUT, null, this.val$canChangeResources, (IClasspathEntry[])affectedProjectClasspaths.get(affectedProject), false, false);
                        }
                    }
                }, null, monitor);
            }
            catch (CoreException e) {
                if (CP_RESOLVE_VERBOSE) {
                    Util.verbose("CPVariable SET  - FAILED DUE TO EXCEPTION\n\tvariables: " + com.netflix.nebula.lint.jdt.internal.compiler.util.Util.toString(dbgVariableNames), System.err);
                    e.printStackTrace();
                }
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
    }

    private HashSet variableInitializationInProgress() {
        HashSet initializations = (HashSet)this.variableInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashSet();
            this.variableInitializationInProgress.set(initializations);
        }
        return initializations;
    }

    public synchronized String[] variableNames() {
        int length = this.variables.size();
        String[] result = new String[length];
        Iterator vars = this.variables.keySet().iterator();
        int index = 0;
        while (vars.hasNext()) {
            result[index++] = (String)vars.next();
        }
        return result;
    }

    public synchronized void variablePut(String variableName, IPath variablePath) {
        HashSet initializations = this.variableInitializationInProgress();
        if (variablePath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
            initializations.add(variableName);
            return;
        }
        initializations.remove(variableName);
        if (variablePath == null) {
            this.variables.remove(variableName);
        } else {
            this.variables.put(variableName, variablePath);
        }
        this.previousSessionVariables.remove(variableName);
        String variableKey = CP_VARIABLE_PREFERENCES_PREFIX + variableName;
        if (variablePath == null) {
            this.getInstancePreferences().remove(variableKey);
        } else {
            this.getInstancePreferences().put(variableKey, variablePath.toString());
        }
        try {
            this.getInstancePreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public boolean variablePutIfInitializingWithSameValue(String[] variableNames, IPath[] variablePaths) {
        if (variableNames.length != 1) {
            return false;
        }
        String variableName = variableNames[0];
        IPath oldPath = this.getPreviousSessionVariable(variableName);
        if (oldPath == null) {
            return false;
        }
        IPath newPath = variablePaths[0];
        if (!oldPath.equals((Object)newPath)) {
            return false;
        }
        this.variablePut(variableName, newPath);
        return true;
    }

    public static class PerProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public IClasspathEntry[] rawClasspath;
        public IClasspathEntry[] resolvedClasspath;
        public Map resolvedPathToRawEntries;
        public IPath outputLocation;
        public IEclipsePreferences preferences;
        public Hashtable options;

        public PerProjectInfo(IProject project) {
            this.project = project;
        }

        public void rememberExternalLibTimestamps() {
            IClasspathEntry[] classpath = this.resolvedClasspath;
            if (classpath == null) {
                return;
            }
            IWorkspaceRoot wRoot = ResourcesPlugin.getWorkspace().getRoot();
            Hashtable externalTimeStamps = JavaModelManager.getJavaModelManager().deltaState.getExternalLibTimeStamps();
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                Object target;
                IPath path;
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 1 && externalTimeStamps.get(path = entry.getPath()) == null && (target = JavaModel.getTarget((IContainer)wRoot, path, true)) instanceof File) {
                    long timestamp = DeltaProcessor.getTimeStamp((File)target);
                    externalTimeStamps.put(path, new Long(timestamp));
                }
                ++i;
            }
        }

        public synchronized void updateClasspathInformation(IClasspathEntry[] newRawClasspath) {
            this.rawClasspath = newRawClasspath;
            this.resolvedClasspath = null;
            this.resolvedPathToRawEntries = null;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(this.project.getFullPath());
            buffer.append("\nRaw classpath:\n");
            if (this.rawClasspath == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = this.rawClasspath.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(this.rawClasspath[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Resolved classpath:\n");
            IClasspathEntry[] resolvedCP = this.resolvedClasspath;
            if (resolvedCP == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = resolvedCP.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(resolvedCP[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Output location:\n  ");
            if (this.outputLocation == null) {
                buffer.append("<null>");
            } else {
                buffer.append(this.outputLocation);
            }
            return buffer.toString();
        }
    }

    public static class PerWorkingCopyInfo
    implements IProblemRequestor {
        int useCount = 0;
        IProblemRequestor problemRequestor;
        ICompilationUnit workingCopy;

        public PerWorkingCopyInfo(ICompilationUnit workingCopy, IProblemRequestor problemRequestor) {
            this.workingCopy = workingCopy;
            this.problemRequestor = problemRequestor;
        }

        public void acceptProblem(IProblem problem) {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.acceptProblem(problem);
        }

        public void beginReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.beginReporting();
        }

        public void endReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.endReporting();
        }

        public ICompilationUnit getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isActive() {
            return this.problemRequestor != null && this.problemRequestor.isActive();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(((JavaElement)((Object)this.workingCopy)).toStringWithAncestors());
            buffer.append("\nUse count = ");
            buffer.append(this.useCount);
            buffer.append("\nProblem requestor:\n  ");
            buffer.append(this.problemRequestor);
            return buffer.toString();
        }
    }

    public static class EclipsePreferencesListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String propertyName = event.getKey();
            if (propertyName.startsWith(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX)) {
                String varName = propertyName.substring(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX.length());
                String newValue = (String)event.getNewValue();
                if (newValue != null && !(newValue = newValue.trim()).equals(JavaModelManager.CP_ENTRY_IGNORE)) {
                    JavaModelManager.getJavaModelManager().variables.put(varName, new Path(newValue));
                } else {
                    JavaModelManager.getJavaModelManager().variables.remove(varName);
                }
            }
            if (propertyName.startsWith(JavaModelManager.CP_CONTAINER_PREFERENCES_PREFIX)) {
                JavaModelManager.recreatePersistedContainer(propertyName, (String)event.getNewValue(), false);
            }
        }
    }
}

