/*
 * Copyright 2015-2016 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.nebula.lint.plugin

import org.gradle.api.GradleException

/**
 * Thrown when a rule is found to be invalid when it is loaded.
 */
class InvalidRuleException extends GradleException {

    InvalidRuleException(String message) {
        super(message)
    }

    InvalidRuleException(String message, Throwable cause) {
        super(message, cause)
    }
}
