/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ListTagCommand
extends GitCommand<List<Ref>> {
    protected ListTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Ref> tags = new ArrayList<Ref>();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Map<String, Ref> refList = this.repo.getRefDatabase().getRefs("refs/tags/");
            for (Ref ref : refList.values()) {
                tags.add(ref);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        Collections.sort(tags, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.setCallable(false);
        return tags;
    }
}

