/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk;

import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.revwalk.BlockRevQueue;
import com.netflix.nebula.lint.jgit.revwalk.DepthWalk;
import com.netflix.nebula.lint.jgit.revwalk.FIFORevQueue;
import com.netflix.nebula.lint.jgit.revwalk.Generator;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevFlag;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;

class DepthGenerator
extends Generator {
    private final FIFORevQueue pending = new FIFORevQueue();
    private final int depth;
    private final RevWalk walk;
    private final RevFlag UNSHALLOW;
    private final RevFlag REINTERESTING;

    DepthGenerator(DepthWalk w, Generator s) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit c;
        this.walk = (RevWalk)((Object)w);
        this.depth = w.getDepth();
        this.UNSHALLOW = w.getUnshallowFlag();
        this.REINTERESTING = w.getReinterestingFlag();
        s.shareFreeList(this.pending);
        while ((c = s.next()) != null) {
            if (((DepthWalk.Commit)c).getDepth() != 0) continue;
            this.pending.add(c);
        }
    }

    @Override
    int outputType() {
        return this.pending.outputType() | 0x10;
    }

    @Override
    void shareFreeList(BlockRevQueue q) {
        this.pending.shareFreeList(q);
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        DepthWalk.Commit c;
        boolean produce;
        do {
            if ((c = (DepthWalk.Commit)this.pending.next()) == null) {
                return null;
            }
            if ((c.flags & 1) == 0) {
                c.parseHeaders(this.walk);
            }
            int newDepth = c.depth + 1;
            for (RevCommit p : c.parents) {
                DepthWalk.Commit dp = (DepthWalk.Commit)p;
                if (dp.depth == -1) {
                    dp.depth = newDepth;
                    if (newDepth <= this.depth) {
                        this.pending.add(p);
                    }
                }
                if (!c.has(this.UNSHALLOW) && !c.has(this.REINTERESTING)) continue;
                p.add(this.REINTERESTING);
                p.flags &= 0xFFFFFFFB;
            }
            boolean bl = produce = c.depth <= this.depth;
            if ((c.flags & 4) == 0 || c.has(this.UNSHALLOW)) continue;
            produce = false;
        } while (!produce);
        return c;
    }
}

