/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.util.io;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import java.text.MessageFormat;

public final class InterruptTimer {
    private final AlarmState state = new AlarmState();
    private final AlarmThread thread;
    final AutoKiller autoKiller = new AutoKiller(this.state);

    public InterruptTimer() {
        this("JGit-InterruptTimer");
    }

    public InterruptTimer(String threadName) {
        this.thread = new AlarmThread(threadName, this.state);
        this.thread.start();
    }

    public void begin(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, timeout));
        }
        Thread.interrupted();
        this.state.begin(timeout);
    }

    public void end() {
        this.state.end();
    }

    public void terminate() {
        this.state.terminate();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static final class AlarmState
    implements Runnable {
        private Thread callingThread = Thread.currentThread();
        private long deadline;
        private boolean terminated;

        AlarmState() {
        }

        @Override
        public synchronized void run() {
            while (!this.terminated && this.callingThread.isAlive()) {
                try {
                    if (0L < this.deadline) {
                        long delay = this.deadline - AlarmState.now();
                        if (delay <= 0L) {
                            this.deadline = 0L;
                            this.callingThread.interrupt();
                            continue;
                        }
                        this.wait(delay);
                        continue;
                    }
                    this.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void begin(int timeout) {
            if (this.terminated) {
                throw new IllegalStateException(JGitText.get().timerAlreadyTerminated);
            }
            this.callingThread = Thread.currentThread();
            this.deadline = AlarmState.now() + (long)timeout;
            this.notifyAll();
        }

        synchronized void end() {
            if (0L == this.deadline) {
                Thread.interrupted();
            } else {
                this.deadline = 0L;
            }
            this.notifyAll();
        }

        synchronized void terminate() {
            if (!this.terminated) {
                this.deadline = 0L;
                this.terminated = true;
                this.notifyAll();
            }
        }

        private static long now() {
            return System.currentTimeMillis();
        }
    }

    static final class AlarmThread
    extends Thread {
        AlarmThread(String name, AlarmState q) {
            super(q);
            this.setName(name);
            this.setDaemon(true);
        }
    }

    private static final class AutoKiller {
        private final AlarmState state;

        AutoKiller(AlarmState s) {
            this.state = s;
        }

        protected void finalize() throws Throwable {
            this.state.terminate();
        }
    }
}

