/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core.dom;

import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IPackageFragment;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.dom.IBinding;
import com.netflix.nebula.lint.jdt.core.dom.IPackageBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.env.INameEnvironment;
import com.netflix.nebula.lint.jdt.internal.core.NameLookup;
import com.netflix.nebula.lint.jdt.internal.core.SearchableEnvironment;

class PackageBinding
implements IPackageBinding {
    private static final String[] NO_NAME_COMPONENTS = new String[0];
    private static final String UNNAMED = "";
    private static final char PACKAGE_NAME_SEPARATOR = '.';
    private com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding binding;
    private String name;
    private String[] components;

    PackageBinding(com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding binding) {
        this.binding = binding;
    }

    public String getName() {
        if (this.name == null) {
            this.computeNameAndComponents();
        }
        return this.name;
    }

    public boolean isUnnamed() {
        return this.getName().equals(UNNAMED);
    }

    public String[] getNameComponents() {
        if (this.components == null) {
            this.computeNameAndComponents();
        }
        return this.components;
    }

    public int getKind() {
        return 1;
    }

    public int getModifiers() {
        return -1;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public IJavaElement getJavaElement() {
        INameEnvironment nameEnvironment = this.binding.environment.nameEnvironment;
        if (!(nameEnvironment instanceof SearchableEnvironment)) {
            return null;
        }
        NameLookup nameLookup = ((SearchableEnvironment)nameEnvironment).nameLookup;
        if (nameLookup == null) {
            return null;
        }
        IPackageFragment[] pkgs = nameLookup.findPackageFragments(this.getName(), false);
        if (pkgs == null) {
            return null;
        }
        return pkgs[0];
    }

    public String getKey() {
        return new String(this.binding.computeUniqueKey());
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PackageBinding)) {
            return false;
        }
        com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding packageBinding2 = ((PackageBinding)other).binding;
        return CharOperation.equals(this.binding.compoundName, packageBinding2.compoundName);
    }

    private void computeNameAndComponents() {
        char[][] compoundName = this.binding.compoundName;
        if (compoundName == CharOperation.NO_CHAR_CHAR || compoundName == null) {
            this.name = UNNAMED;
            this.components = NO_NAME_COMPONENTS;
        } else {
            int length = compoundName.length;
            this.components = new String[length];
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < length - 1) {
                this.components[i] = new String(compoundName[i]);
                buffer.append(compoundName[i]).append('.');
                ++i;
            }
            this.components[length - 1] = new String(compoundName[length - 1]);
            buffer.append(compoundName[length - 1]);
            this.name = buffer.toString();
        }
    }

    public String toString() {
        return this.binding.toString();
    }
}

