/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IJavaElementDelta;
import com.netflix.nebula.lint.jdt.core.IJavaProject;
import com.netflix.nebula.lint.jdt.core.IPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.internal.core.CompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.JavaElementInfo;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.Openable;
import java.util.HashSet;
import java.util.Iterator;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void elementAdded(Openable element) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            this.addToParentInfo(element);
            this.projectsToUpdate.add(element);
        } else {
            this.addToParentInfo(element);
            ModelUpdater.close(element);
        }
        switch (elementType) {
            case 3: {
                this.projectsToUpdate.add(element.getJavaProject());
                break;
            }
            case 4: {
                JavaProject project = (JavaProject)element.getJavaProject();
                project.resetCaches();
            }
        }
    }

    protected void elementChanged(Openable element) {
        ModelUpdater.close(element);
    }

    protected void elementRemoved(Openable element) {
        if (element.isOpen()) {
            ModelUpdater.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: {
                JavaModelManager.getJavaModelManager().getIndexManager().reset();
                break;
            }
            case 2: {
                JavaModelManager.getJavaModelManager().removePerProjectInfo((JavaProject)element);
                break;
            }
            case 3: {
                this.projectsToUpdate.add(element.getJavaProject());
                break;
            }
            case 4: {
                JavaProject project = (JavaProject)element.getJavaProject();
                project.resetCaches();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processJavaDelta(IJavaElementDelta delta) {
        try {
            this.traverseDelta(delta, null, null);
            Iterator iterator = this.projectsToUpdate.iterator();
            while (iterator.hasNext()) {
                JavaProject project = (JavaProject)iterator.next();
                project.updatePackageFragmentRoots();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.projectsToUpdate = new HashSet();
            throw throwable;
        }
        {
            Object var5_6 = null;
            this.projectsToUpdate = new HashSet();
            return;
        }
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected void traverseDelta(IJavaElementDelta delta, IPackageFragmentRoot root, IJavaProject project) {
        boolean processChildren = true;
        Openable element = (Openable)delta.getElement();
        switch (element.getElementType()) {
            case 2: {
                project = (IJavaProject)((Object)element);
                break;
            }
            case 3: {
                root = (IPackageFragmentRoot)((Object)element);
                break;
            }
            case 5: {
                CompilationUnit cu = (CompilationUnit)element;
                if (cu.isWorkingCopy() && !cu.isPrimary()) {
                    return;
                }
            }
            case 6: {
                processChildren = false;
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.elementAdded(element);
                break;
            }
            case 2: {
                this.elementRemoved(element);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 1) == 0) break;
                this.elementChanged(element);
            }
        }
        if (processChildren) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IJavaElementDelta childDelta = children[i];
                this.traverseDelta(childDelta, root, project);
                ++i;
            }
        }
    }
}

