/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.indexing;

import com.netflix.nebula.lint.jdt.core.IClasspathEntry;
import com.netflix.nebula.lint.jdt.core.JavaCore;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.search.IJavaSearchScope;
import com.netflix.nebula.lint.jdt.core.search.SearchDocument;
import com.netflix.nebula.lint.jdt.core.search.SearchEngine;
import com.netflix.nebula.lint.jdt.core.search.SearchParticipant;
import com.netflix.nebula.lint.jdt.internal.compiler.util.SimpleLookupTable;
import com.netflix.nebula.lint.jdt.internal.compiler.util.Util;
import com.netflix.nebula.lint.jdt.internal.core.JavaModel;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.index.Index;
import com.netflix.nebula.lint.jdt.internal.core.search.BasicSearchEngine;
import com.netflix.nebula.lint.jdt.internal.core.search.PatternSearchJob;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.AddFolderToIndex;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.AddJarFileToIndex;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IIndexConstants;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IndexAllProject;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IndexBinaryFolder;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.IndexRequest;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.ReadWriteMonitor;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.RemoveFolderFromIndex;
import com.netflix.nebula.lint.jdt.internal.core.search.indexing.RemoveFromIndex;
import com.netflix.nebula.lint.jdt.internal.core.search.processing.IJob;
import com.netflix.nebula.lint.jdt.internal.core.search.processing.JobManager;
import com.netflix.nebula.lint.jdt.internal.core.util.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private Map indexes = new HashMap(5);
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath javaPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getJavaPluginWorkingLocation().append("savedIndexNames.txt").toOSString());
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);

    public synchronized void aboutToUpdateIndex(IPath containerPath, Integer newIndexState) {
        Integer currentIndexState;
        String indexLocation = this.computeIndexLocation(containerPath);
        Object state = this.getIndexStates().get(indexLocation);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexLocation, newIndexState);
        } else if (compare < 0 && this.indexes.get(indexLocation) == null) {
            this.rebuildIndex(indexLocation, containerPath);
        }
    }

    public void addBinary(IFile resource, IPath containerPath) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        String indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void addSource(IFile resource, IPath containerPath) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        String indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void cleanUpIndexes() {
        File[] indexesFiles;
        File indexesDirectory;
        SimpleLookupTable knownPaths = new SimpleLookupTable();
        IJavaSearchScope scope = BasicSearchEngine.createWorkspaceScope();
        PatternSearchJob job = new PatternSearchJob(null, SearchEngine.getDefaultSearchParticipant(), scope, null);
        Index[] selectedIndexes = job.getIndexes(null);
        int j = 0;
        int max = selectedIndexes.length;
        while (j < max) {
            String path = selectedIndexes[j].getIndexFile().getAbsolutePath();
            knownPaths.put(path, path);
            ++j;
        }
        if (this.indexStates != null) {
            Object[] keys = this.indexStates.keyTable;
            int i = 0;
            int l = keys.length;
            while (i < l) {
                String key = (String)keys[i];
                if (key != null && !knownPaths.containsKey(key)) {
                    this.updateIndexState(key, null);
                }
                ++i;
            }
        }
        if ((indexesDirectory = new File(this.getJavaPluginWorkingLocation().toOSString())).isDirectory() && (indexesFiles = indexesDirectory.listFiles()) != null) {
            int i = 0;
            int indexesFilesLength = indexesFiles.length;
            while (i < indexesFilesLength) {
                String fileName = indexesFiles[i].getAbsolutePath();
                if (!knownPaths.containsKey(fileName) && fileName.toLowerCase().endsWith(".index")) {
                    if (VERBOSE) {
                        com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("Deleting index file " + indexesFiles[i]);
                    }
                    indexesFiles[i].delete();
                }
                ++i;
            }
        }
    }

    public String computeIndexLocation(IPath containerPath) {
        String indexLocation = (String)this.indexLocations.get(containerPath);
        if (indexLocation == null) {
            String pathString = containerPath.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".index";
            if (VERBOSE) {
                com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> index name for " + pathString + " is " + fileName);
            }
            indexLocation = this.getJavaPluginWorkingLocation().append(fileName).toOSString();
            this.indexLocations.put(containerPath, indexLocation);
        }
        return indexLocation;
    }

    public void ensureIndexExists(String indexLocation, IPath containerPath) {
        SimpleLookupTable states = this.getIndexStates();
        Object state = states.get(indexLocation);
        if (state == null) {
            this.updateIndexState(indexLocation, REBUILDING_STATE);
            this.getIndex(containerPath, indexLocation, true, true);
        }
    }

    public synchronized Index getIndex(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        String indexLocation = this.computeIndexLocation(containerPath);
        return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
    }

    public synchronized Index getIndex(IPath containerPath, String indexLocation, boolean reuseExistingFile, boolean createIfMissing) {
        Index index = (Index)this.indexes.get(indexLocation);
        if (index == null) {
            String containerPathString;
            Integer currentIndexState;
            Object state = this.getIndexStates().get(indexLocation);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState == UNKNOWN_STATE) {
                this.rebuildIndex(indexLocation, containerPath);
                return null;
            }
            String string = containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
            if (reuseExistingFile) {
                File indexFile = new File(indexLocation);
                if (indexFile.exists()) {
                    try {
                        index = new Index(indexLocation, containerPathString, true);
                        this.indexes.put(indexLocation, index);
                        return index;
                    }
                    catch (IOException iOException) {
                        if (currentIndexState != REBUILDING_STATE) {
                            if (VERBOSE) {
                                com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> cannot reuse existing index: " + indexLocation + " path: " + containerPathString);
                            }
                            this.rebuildIndex(indexLocation, containerPath);
                            return null;
                        }
                        index = null;
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexLocation, containerPath);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    if (VERBOSE) {
                        com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> create empty index: " + indexLocation + " path: " + containerPathString);
                    }
                    index = new Index(indexLocation, containerPathString, false);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> unable to create empty index: " + indexLocation + " path: " + containerPathString);
                    }
                    return null;
                }
            }
        }
        return index;
    }

    public synchronized Index getIndex(String indexLocation) {
        return (Index)this.indexes.get(indexLocation);
    }

    public synchronized Index getIndexForUpdate(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        String indexLocation = this.computeIndexLocation(containerPath);
        if (this.getIndexStates().get(indexLocation) == REBUILDING_STATE) {
            return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
        }
        return null;
    }

    private SimpleLookupTable getIndexStates() {
        block6: {
            File indexesDirectory;
            block7: {
                char[][] names;
                if (this.indexStates != null) {
                    return this.indexStates;
                }
                this.indexStates = new SimpleLookupTable();
                char[] savedIndexNames = this.readIndexState();
                if (savedIndexNames.length <= 0 || (names = CharOperation.splitOn('\n', savedIndexNames)).length <= 0) break block6;
                indexesDirectory = new File(this.getJavaPluginWorkingLocation().toOSString());
                char[] dirName = indexesDirectory.getAbsolutePath().toCharArray();
                int delimiterPos = dirName.length;
                if (!CharOperation.match(names[0], 0, delimiterPos, dirName, 0, delimiterPos, true)) break block7;
                int i = 0;
                int l = names.length;
                while (i < l) {
                    char[] name = names[i];
                    if (name.length > 0) {
                        this.indexStates.put(new String(name), SAVED_STATE);
                    }
                    ++i;
                }
                break block6;
            }
            this.savedIndexNamesFile.delete();
            File[] files = indexesDirectory.listFiles();
            if (files == null) break block6;
            int i = 0;
            int l = files.length;
            while (i < l) {
                String fileName = files[i].getAbsolutePath();
                if (fileName.toLowerCase().endsWith(".index")) {
                    if (VERBOSE) {
                        com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("Deleting index file " + files[i]);
                    }
                    files[i].delete();
                }
                ++i;
            }
        }
        return this.indexStates;
    }

    private IPath getJavaPluginWorkingLocation() {
        IPath stateLocation;
        if (this.javaPluginLocation != null) {
            return this.javaPluginLocation;
        }
        this.javaPluginLocation = stateLocation = JavaCore.getPlugin().getStateLocation();
        return this.javaPluginLocation;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void indexDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, Index index, IPath indexLocation) {
        try {
            searchDocument.index = index;
            searchParticipant.indexDocument(searchDocument, indexLocation);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            searchDocument.index = null;
            throw throwable;
        }
        {
            Object var6_7 = null;
            searchDocument.index = null;
            return;
        }
    }

    public void indexAll(IProject project) {
        if (JavaCore.getPlugin() == null) {
            return;
        }
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject javaProject = (JavaProject)model.getJavaProject((IResource)project);
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true, false, false);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 1) {
                    this.indexLibrary(entry.getPath(), project);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        IndexAllProject request = new IndexAllProject(project, this);
        if (!this.isJobWaiting(request)) {
            this.request(request);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void indexLibrary(IPath path, IProject requestingProject) {
        void var4_8;
        if (JavaCore.getPlugin() == null) {
            return;
        }
        Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), path, true);
        Object var4_4 = null;
        if (target instanceof IFile) {
            AddJarFileToIndex addJarFileToIndex = new AddJarFileToIndex((IFile)target, this);
        } else if (target instanceof File) {
            if (!((File)target).isFile()) return;
            AddJarFileToIndex addJarFileToIndex = new AddJarFileToIndex(path, this);
        } else {
            if (!(target instanceof IContainer)) return;
            IndexBinaryFolder indexBinaryFolder = new IndexBinaryFolder((IContainer)target, this);
        }
        if (this.isJobWaiting((IJob)var4_8)) return;
        this.request((IJob)var4_8);
    }

    public void indexSourceFolder(JavaProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new AddFolderToIndex(sourceFolder, project, inclusionPatterns, exclusionPatterns, this));
    }

    public void jobWasCancelled(IPath containerPath) {
        String indexLocation = this.computeIndexLocation(containerPath);
        Object o = this.indexes.get(indexLocation);
        if (o instanceof Index) {
            ((Index)o).monitor = null;
            this.indexes.remove(indexLocation);
        }
        this.updateIndexState(indexLocation, UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long idlingTime) {
        if (idlingTime > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public String processName() {
        return Messages.process_name;
    }

    private void rebuildIndex(String indexLocation, IPath containerPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        Object target = JavaModel.getTarget((IContainer)workspace.getRoot(), containerPath, true);
        if (target == null) {
            return;
        }
        if (VERBOSE) {
            com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> request to rebuild index: " + indexLocation + " path: " + containerPath.toOSString());
        }
        this.updateIndexState(indexLocation, REBUILDING_STATE);
        IndexRequest request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            if (JavaProject.hasJavaNature(p)) {
                request = new IndexAllProject(p, this);
            }
        } else if (target instanceof IFolder) {
            request = new IndexBinaryFolder((IContainer)((IFolder)target), this);
        } else if (target instanceof IFile) {
            request = new AddJarFileToIndex((IFile)target, this);
        } else if (target instanceof File) {
            request = new AddJarFileToIndex(containerPath, this);
        }
        if (request != null) {
            this.request(request);
        }
    }

    public synchronized Index recreateIndex(IPath containerPath) {
        String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
        try {
            ReadWriteMonitor monitor;
            String indexLocation = this.computeIndexLocation(containerPath);
            Index index = (Index)this.indexes.get(indexLocation);
            ReadWriteMonitor readWriteMonitor = monitor = index == null ? null : index.monitor;
            if (VERBOSE) {
                com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> recreating index: " + indexLocation + " for path: " + containerPathString);
            }
            index = new Index(indexLocation, containerPathString, false);
            this.indexes.put(indexLocation, index);
            index.monitor = monitor;
            return index;
        }
        catch (IOException e) {
            if (VERBOSE) {
                com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> failed to recreate index for path: " + containerPathString);
                e.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String containerRelativePath, IPath indexedContainer) {
        this.request(new RemoveFromIndex(containerRelativePath, indexedContainer, this));
    }

    public synchronized void removeIndex(IPath containerPath) {
        Object o;
        String indexLocation;
        File indexFile;
        if (VERBOSE) {
            com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("removing index " + containerPath);
        }
        if ((indexFile = new File(indexLocation = this.computeIndexLocation(containerPath))).exists()) {
            indexFile.delete();
        }
        if ((o = this.indexes.get(indexLocation)) instanceof Index) {
            ((Index)o).monitor = null;
        }
        this.indexes.remove(indexLocation);
        this.updateIndexState(indexLocation, null);
    }

    public synchronized void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        Object[] containerPaths = this.indexLocations.keyTable;
        int i = 0;
        int length = containerPaths.length;
        while (i < length) {
            IPath containerPath = (IPath)containerPaths[i];
            if (containerPath != null && path.isPrefixOf(containerPath)) {
                if (toRemove == null) {
                    toRemove = new ArrayList<IPath>();
                }
                toRemove.add(containerPath);
            }
            ++i;
        }
        if (toRemove != null) {
            i = 0;
            length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeSourceFolderFromIndex(JavaProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new RemoveFolderFromIndex(sourceFolder, inclusionPatterns, exclusionPatterns, project, this));
    }

    public synchronized void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new HashMap(5);
            this.indexStates = null;
        }
        this.indexLocations = new SimpleLookupTable();
        this.javaPluginLocation = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndex(Index index) throws IOException {
        Object containerPath;
        if (index.hasChanged()) {
            if (VERBOSE) {
                com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> saving index " + index.getIndexFile());
            }
            index.save();
        }
        String indexLocation = index.getIndexFile().getPath();
        if (this.jobEnd > this.jobStart && (containerPath = this.indexLocations.keyForValue(indexLocation)) != null) {
            IndexManager indexManager = this;
            synchronized (indexManager) {
                int i = this.jobEnd;
                while (i > this.jobStart) {
                    IJob job = this.awaitingJobs[i];
                    if (job instanceof IndexRequest && ((IndexRequest)job).containerPath.equals(containerPath)) {
                        return;
                    }
                    --i;
                }
            }
        }
        this.updateIndexState(indexLocation, SAVED_STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        ArrayList toSave = new ArrayList();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Iterator iter = this.indexes.values().iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof Index)) continue;
                toSave.add(o);
            }
        }
        boolean allSaved = true;
        int i = 0;
        int length = toSave.size();
        while (i < length) {
            Index index = (Index)toSave.get(i);
            ReadWriteMonitor monitor = index.monitor;
            if (monitor != null) {
                Object var11_12;
                try {
                    monitor.enterRead();
                    if (index.hasChanged()) {
                        if (monitor.exitReadEnterWrite()) {
                            Object var9_11;
                            try {
                                try {
                                    this.saveIndex(index);
                                }
                                catch (IOException e) {
                                    if (VERBOSE) {
                                        com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> got the following exception while saving:", System.err);
                                        e.printStackTrace();
                                    }
                                    allSaved = false;
                                }
                                var9_11 = null;
                                monitor.exitWriteEnterRead();
                            }
                            catch (Throwable throwable) {
                                var9_11 = null;
                                monitor.exitWriteEnterRead();
                                throw throwable;
                            }
                        } else {
                            allSaved = false;
                        }
                    }
                    var11_12 = null;
                    monitor.exitRead();
                }
                catch (Throwable throwable) {
                    var11_12 = null;
                    monitor.exitRead();
                    throw throwable;
                }
            }
            ++i;
        }
        this.needToSave = !allSaved;
    }

    public void scheduleDocumentIndexing(final SearchDocument searchDocument, IPath container, final String indexLocation, final SearchParticipant searchParticipant) {
        this.request(new IndexRequest(container, this){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean execute(IProgressMonitor progressMonitor) {
                if (this.isCancelled) return true;
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                Index index = IndexManager.this.getIndex(this.containerPath, indexLocation, true, true);
                if (index == null) {
                    return true;
                }
                ReadWriteMonitor monitor = index.monitor;
                if (monitor == null) {
                    return true;
                }
                try {
                    monitor.enterWrite();
                    IndexManager.this.indexDocument(searchDocument, searchParticipant, index, (IPath)new Path(indexLocation));
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    monitor.exitWrite();
                    throw throwable;
                }
                {
                    Object var5_6 = null;
                    monitor.exitWrite();
                    return true;
                }
            }

            public String toString() {
                return "indexing " + searchDocument.getPath();
            }
        });
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        Iterator iter = this.indexes.values().iterator();
        while (iter.hasNext()) {
            buffer.append(++count).append(" - ").append(iter.next().toString()).append('\n');
        }
        return buffer.toString();
    }

    private char[] readIndexState() {
        try {
            return Util.getFileCharContent(this.savedIndexNamesFile, null);
        }
        catch (IOException iOException) {
            if (VERBOSE) {
                com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("Failed to read saved index file names");
            }
            return new char[0];
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void updateIndexState(String indexLocation, Integer indexState) {
        block22: {
            this.getIndexStates();
            if (indexState != null) {
                if (indexState.equals(this.indexStates.get(indexLocation))) {
                    return;
                }
                this.indexStates.put(indexLocation, indexState);
            } else {
                if (!this.indexStates.containsKey(indexLocation)) {
                    return;
                }
                this.indexStates.removeKey(indexLocation);
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(this.savedIndexNamesFile));
                    Object[] keys = this.indexStates.keyTable;
                    Object[] states = this.indexStates.valueTable;
                    int i = 0;
                    int l = states.length;
                    while (i < l) {
                        if (states[i] == SAVED_STATE) {
                            writer.write((String)keys[i]);
                            writer.write(10);
                        }
                        ++i;
                    }
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("Failed to write saved index file names", System.err);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (writer == null) throw throwable;
                try {
                    writer.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var9_10 = null;
                if (writer == null) break block22;
            }
            try {}
            catch (IOException iOException) {}
            writer.close();
        }
        if (!VERBOSE) return;
        String state = "?";
        if (indexState == SAVED_STATE) {
            state = "SAVED";
        } else if (indexState == UPDATING_STATE) {
            state = "UPDATING";
        } else if (indexState == UNKNOWN_STATE) {
            state = "UNKNOWN";
        } else if (indexState == REBUILDING_STATE) {
            state = "REBUILDING";
        }
        com.netflix.nebula.lint.jdt.internal.core.util.Util.verbose("-> index state updated to: " + state + " for: " + indexLocation);
    }
}

