/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search.matching;

import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.LocalDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.NameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.QualifiedNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.SingleNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Binding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.LocalVariableBinding;
import com.netflix.nebula.lint.jdt.internal.core.LocalVariable;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.LocalVariablePattern;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchLocator;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.MatchingNodeSet;
import com.netflix.nebula.lint.jdt.internal.core.search.matching.VariableLocator;
import org.eclipse.core.runtime.CoreException;

public class LocalVariableLocator
extends VariableLocator {
    public LocalVariableLocator(LocalVariablePattern pattern) {
        super(pattern);
    }

    public int match(LocalDeclaration node, MatchingNodeSet nodeSet) {
        int referencesLevel = 0;
        if (this.pattern.findReferences && this.pattern.writeAccess && !this.pattern.readAccess && node.initialization != null && this.matchesName(this.pattern.name, node.name)) {
            referencesLevel = this.pattern.mustResolve ? 2 : 3;
        }
        int declarationsLevel = 0;
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, node.name) && node.declarationSourceStart == this.getLocalVariable().declarationSourceStart) {
            declarationsLevel = this.pattern.mustResolve ? 2 : 3;
        }
        return nodeSet.addMatch(node, referencesLevel >= declarationsLevel ? referencesLevel : declarationsLevel);
    }

    private LocalVariable getLocalVariable() {
        return ((LocalVariablePattern)this.pattern).localVariable;
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        int offset = -1;
        int length = -1;
        if (reference instanceof SingleNameReference) {
            offset = reference.sourceStart;
            length = reference.sourceEnd - offset + 1;
        } else if (reference instanceof QualifiedNameReference) {
            QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
            long sourcePosition = qNameRef.sourcePositions[0];
            offset = (int)(sourcePosition >>> 32);
            length = (int)sourcePosition - offset + 1;
        } else if (reference instanceof LocalDeclaration) {
            LocalVariable localVariable = this.getLocalVariable();
            offset = localVariable.nameStart;
            length = localVariable.nameEnd - offset + 1;
            element = localVariable;
        }
        if (offset >= 0) {
            this.match = locator.newLocalVariableReferenceMatch(element, accuracy, offset, length, reference);
            locator.report(this.match);
        }
    }

    protected int matchContainer() {
        return 4;
    }

    protected int matchLocalVariable(LocalVariableBinding variable, boolean matchName) {
        if (variable == null) {
            return 1;
        }
        if (matchName && !this.matchesName(this.pattern.name, variable.readableName())) {
            return 0;
        }
        return variable.declaration.declarationSourceStart == this.getLocalVariable().declarationSourceStart ? 3 : 0;
    }

    protected int referenceType() {
        return 14;
    }

    public int resolveLevel(ASTNode possiblelMatchingNode) {
        if (this.pattern.findReferences && possiblelMatchingNode instanceof NameReference) {
            return this.resolveLevel((NameReference)possiblelMatchingNode);
        }
        if (possiblelMatchingNode instanceof LocalDeclaration) {
            return this.matchLocalVariable(((LocalDeclaration)possiblelMatchingNode).binding, true);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof LocalVariableBinding)) {
            return 0;
        }
        return this.matchLocalVariable((LocalVariableBinding)binding, true);
    }

    protected int resolveLevel(NameReference nameRef) {
        return this.resolveLevel(nameRef.binding);
    }
}

