/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.CheckoutResult;
import com.netflix.nebula.lint.jgit.api.CreateBranchCommand;
import com.netflix.nebula.lint.jgit.api.Git;
import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.CheckoutConflictException;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.InvalidRefNameException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.RefAlreadyExistsException;
import com.netflix.nebula.lint.jgit.api.errors.RefNotFoundException;
import com.netflix.nebula.lint.jgit.dircache.DirCache;
import com.netflix.nebula.lint.jgit.dircache.DirCacheCheckout;
import com.netflix.nebula.lint.jgit.dircache.DirCacheEditor;
import com.netflix.nebula.lint.jgit.dircache.DirCacheEntry;
import com.netflix.nebula.lint.jgit.dircache.DirCacheIterator;
import com.netflix.nebula.lint.jgit.errors.AmbiguousObjectException;
import com.netflix.nebula.lint.jgit.errors.UnmergedPathException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.CoreConfig;
import com.netflix.nebula.lint.jgit.lib.FileMode;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectReader;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevTree;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.treewalk.TreeWalk;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public class CheckoutCommand
extends GitCommand<Ref> {
    private String name;
    private boolean force = false;
    private boolean createBranch = false;
    private boolean orphan = false;
    private CreateBranchCommand.SetupUpstreamMode upstreamMode;
    private String startPoint = null;
    private RevCommit startCommit;
    private Stage checkoutStage = null;
    private CheckoutResult status;
    private List<String> paths = new LinkedList<String>();
    private boolean checkoutAllPaths;

    protected CheckoutCommand(Repository repo) {
        super(repo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref call() throws GitAPIException, RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException {
        this.checkCallable();
        try {
            RefUpdate.Result updateResult;
            DirCacheCheckout dco;
            ObjectId branch;
            Ref headRef;
            this.processOptions();
            if (this.checkoutAllPaths || !this.paths.isEmpty()) {
                this.checkoutPaths();
                this.status = new CheckoutResult(CheckoutResult.Status.OK, this.paths);
                this.setCallable(false);
                Ref ref = null;
                return ref;
            }
            if (this.createBranch) {
                try (Git git = new Git(this.repo);){
                    CreateBranchCommand command = git.branchCreate();
                    command.setName(this.name);
                    if (this.startCommit != null) {
                        command.setStartPoint(this.startCommit);
                    } else {
                        command.setStartPoint(this.startPoint);
                    }
                    if (this.upstreamMode != null) {
                        command.setUpstreamMode(this.upstreamMode);
                    }
                    command.call();
                }
            }
            if ((headRef = this.repo.exactRef("HEAD")) == null) {
                throw new UnsupportedOperationException(JGitText.get().cannotCheckoutFromUnbornBranch);
            }
            String shortHeadRef = this.getShortBranchName(headRef);
            String refLogMessage = "checkout: moving from " + shortHeadRef;
            if (this.orphan) {
                if (this.startPoint == null && this.startCommit == null) {
                    RefUpdate.Result r = this.repo.updateRef("HEAD").link(this.getBranchName());
                    if (!EnumSet.of(RefUpdate.Result.NEW, RefUpdate.Result.FORCED).contains((Object)r)) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, r.name()));
                    }
                    this.status = CheckoutResult.NOT_TRIED_RESULT;
                    Ref ref = this.repo.exactRef("HEAD");
                    return ref;
                }
                branch = this.getStartPointObjectId();
            } else {
                branch = this.repo.resolve(this.name);
                if (branch == null) {
                    throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.name));
                }
            }
            RevCommit headCommit = null;
            RevCommit newCommit = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                ObjectId headId = headRef.getObjectId();
                headCommit = headId == null ? null : revWalk.parseCommit(headId);
                newCommit = revWalk.parseCommit(branch);
            }
            RevTree headTree = headCommit == null ? null : headCommit.getTree();
            DirCache dc = this.repo.lockDirCache();
            try {
                dco = new DirCacheCheckout(this.repo, headTree, dc, newCommit.getTree());
                dco.setFailOnConflict(true);
                try {
                    dco.checkout();
                }
                catch (com.netflix.nebula.lint.jgit.errors.CheckoutConflictException e) {
                    this.status = new CheckoutResult(CheckoutResult.Status.CONFLICTS, dco.getConflicts());
                    throw new CheckoutConflictException(dco.getConflicts(), e);
                }
            }
            finally {
                dc.unlock();
            }
            Ref ref = this.repo.findRef(this.name);
            if (ref != null && !ref.getName().startsWith("refs/heads/")) {
                ref = null;
            }
            String toName = Repository.shortenRefName(this.name);
            RefUpdate refUpdate = this.repo.updateRef("HEAD", ref == null);
            refUpdate.setForceUpdate(this.force);
            refUpdate.setRefLogMessage(refLogMessage + " to " + toName, false);
            if (ref != null) {
                updateResult = refUpdate.link(ref.getName());
            } else if (this.orphan) {
                updateResult = refUpdate.link(this.getBranchName());
                ref = this.repo.exactRef("HEAD");
            } else {
                refUpdate.setNewObjectId(newCommit);
                updateResult = refUpdate.forceUpdate();
            }
            this.setCallable(false);
            boolean ok = false;
            switch (updateResult) {
                case NEW: {
                    ok = true;
                    break;
                }
                case NO_CHANGE: 
                case FAST_FORWARD: 
                case FORCED: {
                    ok = true;
                    break;
                }
            }
            if (!ok) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutUnexpectedResult, updateResult.name()));
            }
            this.status = !dco.getToBeDeleted().isEmpty() ? new CheckoutResult(CheckoutResult.Status.NONDELETED, dco.getToBeDeleted()) : new CheckoutResult(new ArrayList<String>(dco.getUpdated().keySet()), dco.getRemoved());
            Ref ref2 = ref;
            return ref2;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
        finally {
            if (this.status == null) {
                this.status = CheckoutResult.ERROR_RESULT;
            }
        }
    }

    private String getShortBranchName(Ref headRef) {
        if (headRef.isSymbolic()) {
            return Repository.shortenRefName(headRef.getTarget().getName());
        }
        ObjectId id = headRef.getObjectId();
        if (id == null) {
            throw new NullPointerException();
        }
        return id.getName();
    }

    public CheckoutCommand addPath(String path) {
        this.checkCallable();
        this.paths.add(path);
        return this;
    }

    public CheckoutCommand setAllPaths(boolean all) {
        this.checkoutAllPaths = all;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckoutCommand checkoutPaths() throws IOException, RefNotFoundException {
        DirCache dc = this.repo.lockDirCache();
        try (RevWalk revWalk = new RevWalk(this.repo);
             TreeWalk treeWalk = new TreeWalk(this.repo, revWalk.getObjectReader());){
            treeWalk.setRecursive(true);
            if (!this.checkoutAllPaths) {
                treeWalk.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            if (this.isCheckoutIndex()) {
                this.checkoutPathsFromIndex(treeWalk, dc);
            } else {
                RevCommit commit = revWalk.parseCommit(this.getStartPointObjectId());
                this.checkoutPathsFromCommit(treeWalk, dc, commit);
            }
        }
        finally {
            dc.unlock();
        }
        return this;
    }

    private void checkoutPathsFromIndex(TreeWalk treeWalk, DirCache dc) throws IOException {
        DirCacheIterator dci = new DirCacheIterator(dc);
        treeWalk.addTree(dci);
        String previousPath = null;
        final ObjectReader r = treeWalk.getObjectReader();
        DirCacheEditor editor = dc.editor();
        while (treeWalk.next()) {
            String path = treeWalk.getPathString();
            if (path.equals(previousPath)) continue;
            final CoreConfig.EolStreamType eolStreamType = treeWalk.getEolStreamType();
            final String filterCommand = treeWalk.getFilterCommand("smudge");
            editor.add(new DirCacheEditor.PathEdit(path){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void apply(DirCacheEntry ent) {
                    int stage = ent.getStage();
                    if (stage <= 0) {
                        CheckoutCommand.this.checkoutPath(ent, r, new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand));
                        return;
                    }
                    if (CheckoutCommand.this.checkoutStage != null) {
                        if (stage != CheckoutCommand.this.checkoutStage.number) return;
                        CheckoutCommand.this.checkoutPath(ent, r, new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand));
                        return;
                    }
                    UnmergedPathException e = new UnmergedPathException(ent);
                    throw new JGitInternalException(e.getMessage(), e);
                }
            });
            previousPath = path;
        }
        editor.commit();
    }

    private void checkoutPathsFromCommit(TreeWalk treeWalk, DirCache dc, RevCommit commit) throws IOException {
        treeWalk.addTree(commit.getTree());
        final ObjectReader r = treeWalk.getObjectReader();
        DirCacheEditor editor = dc.editor();
        while (treeWalk.next()) {
            final ObjectId blobId = treeWalk.getObjectId(0);
            final FileMode mode = treeWalk.getFileMode(0);
            final CoreConfig.EolStreamType eolStreamType = treeWalk.getEolStreamType();
            final String filterCommand = treeWalk.getFilterCommand("smudge");
            editor.add(new DirCacheEditor.PathEdit(treeWalk.getPathString()){

                @Override
                public void apply(DirCacheEntry ent) {
                    ent.setObjectId(blobId);
                    ent.setFileMode(mode);
                    CheckoutCommand.this.checkoutPath(ent, r, new DirCacheCheckout.CheckoutMetadata(eolStreamType, filterCommand));
                }
            });
        }
        editor.commit();
    }

    private void checkoutPath(DirCacheEntry entry, ObjectReader reader, DirCacheCheckout.CheckoutMetadata checkoutMetadata) {
        try {
            DirCacheCheckout.checkoutEntry(this.repo, entry, reader, true, checkoutMetadata);
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().checkoutConflictWithFile, entry.getPathString()), e);
        }
    }

    private boolean isCheckoutIndex() {
        return this.startCommit == null && this.startPoint == null;
    }

    private ObjectId getStartPointObjectId() throws AmbiguousObjectException, RefNotFoundException, IOException {
        if (this.startCommit != null) {
            return this.startCommit.getId();
        }
        String startPointOrHead = this.startPoint != null ? this.startPoint : "HEAD";
        ObjectId result = this.repo.resolve(startPointOrHead);
        if (result == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, startPointOrHead));
        }
        return result;
    }

    private void processOptions() throws InvalidRefNameException, RefAlreadyExistsException, IOException {
        Ref refToCheck;
        if ((!this.checkoutAllPaths && this.paths.isEmpty() || this.orphan) && (this.name == null || !Repository.isValidRefName("refs/heads/" + this.name))) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (this.orphan && (refToCheck = this.repo.exactRef(this.getBranchName())) != null) {
            throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists, this.name));
        }
    }

    private String getBranchName() {
        if (this.name.startsWith("refs/")) {
            return this.name;
        }
        return "refs/heads/" + this.name;
    }

    public CheckoutCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public CheckoutCommand setCreateBranch(boolean createBranch) {
        this.checkCallable();
        this.createBranch = createBranch;
        return this;
    }

    public CheckoutCommand setOrphan(boolean orphan) {
        this.checkCallable();
        this.orphan = orphan;
        return this;
    }

    public CheckoutCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }

    public CheckoutCommand setStartPoint(String startPoint) {
        this.checkCallable();
        this.startPoint = startPoint;
        this.startCommit = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setStartPoint(RevCommit startCommit) {
        this.checkCallable();
        this.startCommit = startCommit;
        this.startPoint = null;
        this.checkOptions();
        return this;
    }

    public CheckoutCommand setUpstreamMode(CreateBranchCommand.SetupUpstreamMode mode) {
        this.checkCallable();
        this.upstreamMode = mode;
        return this;
    }

    public CheckoutCommand setStage(Stage stage) {
        this.checkCallable();
        this.checkoutStage = stage;
        this.checkOptions();
        return this;
    }

    public CheckoutResult getResult() {
        if (this.status == null) {
            return CheckoutResult.NOT_TRIED_RESULT;
        }
        return this.status;
    }

    private void checkOptions() {
        if (this.checkoutStage != null && !this.isCheckoutIndex()) {
            throw new IllegalStateException(JGitText.get().cannotCheckoutOursSwitchBranch);
        }
    }

    public static enum Stage {
        BASE(1),
        OURS(2),
        THEIRS(3);

        private final int number;

        private Stage(int number) {
            this.number = number;
        }
    }
}

