/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.notes.Note;
import com.netflix.nebula.lint.jgit.notes.NoteMap;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListNotesCommand
extends GitCommand<List<Note>> {
    private String notesRef = "refs/notes/commits";

    protected ListNotesCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Note> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Note> notes = new ArrayList<Note>();
        NoteMap map = NoteMap.newEmptyMap();
        try (RevWalk walk = new RevWalk(this.repo);){
            Ref ref = this.repo.findRef(this.notesRef);
            if (ref != null) {
                RevCommit notesCommit = walk.parseCommit(ref.getObjectId());
                map = NoteMap.read(walk.getObjectReader(), notesCommit);
            }
            Iterator<Note> i = map.iterator();
            while (i.hasNext()) {
                notes.add(i.next());
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        return notes;
    }

    public ListNotesCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

