/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.internal.storage.file.BasePackBitmapIndex;
import com.netflix.nebula.lint.jgit.internal.storage.file.BitmapIndexImpl;
import com.netflix.nebula.lint.jgit.internal.storage.pack.ObjectToPack;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.BitmapIndex;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectIdOwnerMap;
import com.netflix.nebula.lint.jgit.util.BlockList;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PackBitmapIndexBuilder
extends BasePackBitmapIndex {
    private static final int MAX_XOR_OFFSET_SEARCH = 10;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final BlockList<PositionEntry> byOffset;
    final BlockList<BasePackBitmapIndex.StoredBitmap> byAddOrder = new BlockList();
    final ObjectIdOwnerMap<PositionEntry> positionEntries = new ObjectIdOwnerMap();

    public PackBitmapIndexBuilder(List<ObjectToPack> objects) {
        super(new ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap>());
        this.byOffset = new BlockList(objects.size());
        PackBitmapIndexBuilder.sortByOffsetAndIndex(this.byOffset, this.positionEntries, objects);
        int sizeInWords = Math.max(4, this.byOffset.size() / 64 / 3);
        this.commits = new EWAHCompressedBitmap(sizeInWords);
        this.trees = new EWAHCompressedBitmap(sizeInWords);
        this.blobs = new EWAHCompressedBitmap(sizeInWords);
        this.tags = new EWAHCompressedBitmap(sizeInWords);
        block6: for (int i = 0; i < objects.size(); ++i) {
            int type = objects.get(i).getType();
            switch (type) {
                case 1: {
                    this.commits.set(i);
                    continue block6;
                }
                case 2: {
                    this.trees.set(i);
                    continue block6;
                }
                case 3: {
                    this.blobs.set(i);
                    continue block6;
                }
                case 4: {
                    this.tags.set(i);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, String.valueOf(type)));
                }
            }
        }
        this.commits.trim();
        this.trees.trim();
        this.blobs.trim();
        this.tags.trim();
    }

    private static void sortByOffsetAndIndex(BlockList<PositionEntry> byOffset, ObjectIdOwnerMap<PositionEntry> positionEntries, List<ObjectToPack> entries) {
        int i;
        for (i = 0; i < entries.size(); ++i) {
            positionEntries.add(new PositionEntry(entries.get(i), i));
        }
        Collections.sort(entries, new Comparator<ObjectToPack>(){

            @Override
            public int compare(ObjectToPack a, ObjectToPack b) {
                return Long.signum(a.getOffset() - b.getOffset());
            }
        });
        i = 0;
        while (i < entries.size()) {
            PositionEntry e = positionEntries.get(entries.get(i));
            e.offsetPosition = i++;
            byOffset.add(e);
        }
    }

    public ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> getObjectSet() {
        ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> r = new ObjectIdOwnerMap<ObjectIdOwnerMap.Entry>();
        for (PositionEntry e : this.byOffset) {
            r.add(new ObjectIdOwnerMap.Entry(e){});
        }
        return r;
    }

    public void addBitmap(AnyObjectId objectId, BitmapIndex.Bitmap bitmap, int flags) {
        if (bitmap instanceof BitmapIndex.BitmapBuilder) {
            bitmap = ((BitmapIndex.BitmapBuilder)bitmap).build();
        }
        if (!(bitmap instanceof BitmapIndexImpl.CompressedBitmap)) {
            throw new IllegalArgumentException(bitmap.getClass().toString());
        }
        EWAHCompressedBitmap compressed = ((BitmapIndexImpl.CompressedBitmap)bitmap).getEwahCompressedBitmap();
        this.addBitmap(objectId, compressed, flags);
    }

    public void addBitmap(AnyObjectId objectId, EWAHCompressedBitmap bitmap, int flags) {
        bitmap.trim();
        BasePackBitmapIndex.StoredBitmap result = new BasePackBitmapIndex.StoredBitmap(objectId, bitmap, null, flags);
        this.getBitmaps().add(result);
        this.byAddOrder.add(result);
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type) {
        switch (type) {
            case 3: {
                return this.getBlobs().and(bitmap);
            }
            case 2: {
                return this.getTrees().and(bitmap);
            }
            case 1: {
                return this.getCommits().and(bitmap);
            }
            case 4: {
                return this.getTags().and(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        PositionEntry entry = this.positionEntries.get(objectId);
        if (entry == null) {
            return -1;
        }
        return entry.offsetPosition;
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        ObjectId objectId = this.byOffset.get(position);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    public EWAHCompressedBitmap getCommits() {
        return this.commits;
    }

    public EWAHCompressedBitmap getTrees() {
        return this.trees;
    }

    public EWAHCompressedBitmap getBlobs() {
        return this.blobs;
    }

    public EWAHCompressedBitmap getTags() {
        return this.tags;
    }

    public int getOptions() {
        return 1;
    }

    @Override
    public int getBitmapCount() {
        return this.getBitmaps().size();
    }

    public void clearBitmaps() {
        this.byAddOrder.clear();
        this.getBitmaps().clear();
    }

    @Override
    public int getObjectCount() {
        return this.byOffset.size();
    }

    public Iterable<StoredEntry> getCompressedBitmaps() {
        return new Iterable<StoredEntry>(){

            @Override
            public Iterator<StoredEntry> iterator() {
                return new Iterator<StoredEntry>(){
                    private int index;
                    {
                        this.index = PackBitmapIndexBuilder.this.byAddOrder.size() - 1;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index >= 0;
                    }

                    @Override
                    public StoredEntry next() {
                        int curr;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        BasePackBitmapIndex.StoredBitmap item = PackBitmapIndexBuilder.this.byAddOrder.get(this.index);
                        int bestXorOffset = 0;
                        EWAHCompressedBitmap bestBitmap = item.getBitmap();
                        for (int i = 1; i <= 10 && (curr = i + this.index) < PackBitmapIndexBuilder.this.byAddOrder.size(); ++i) {
                            BasePackBitmapIndex.StoredBitmap other = PackBitmapIndexBuilder.this.byAddOrder.get(curr);
                            EWAHCompressedBitmap bitmap = other.getBitmap().xor(item.getBitmap());
                            if (bitmap.sizeInBytes() >= bestBitmap.sizeInBytes()) continue;
                            bestBitmap = bitmap;
                            bestXorOffset = i;
                        }
                        --this.index;
                        PositionEntry entry = PackBitmapIndexBuilder.this.positionEntries.get(item);
                        if (entry == null) {
                            throw new IllegalStateException();
                        }
                        return new StoredEntry(entry.namePosition, bestBitmap, bestXorOffset, item.getFlags());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static final class PositionEntry
    extends ObjectIdOwnerMap.Entry {
        final int namePosition;
        int offsetPosition;

        PositionEntry(AnyObjectId objectId, int namePosition) {
            super(objectId);
            this.namePosition = namePosition;
        }
    }

    public static final class StoredEntry {
        private final long objectId;
        private final EWAHCompressedBitmap bitmap;
        private final int xorOffset;
        private final int flags;

        StoredEntry(long objectId, EWAHCompressedBitmap bitmap, int xorOffset, int flags) {
            this.objectId = objectId;
            this.bitmap = bitmap;
            this.xorOffset = xorOffset;
            this.flags = flags;
        }

        public EWAHCompressedBitmap getBitmap() {
            return this.bitmap;
        }

        public int getXorOffset() {
            return this.xorOffset;
        }

        public int getFlags() {
            return this.flags;
        }

        public long getObjectId() {
            return this.objectId;
        }
    }
}

