/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.lint.rule.dependency.DependencyService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012J0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u00152\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/netflix/nebula/lint/rule/dependency/DuplicateDependencyService;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "getProject", "()Lorg/gradle/api/Project;", "violationsForModule", "", "", "mvid", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "conf", "ignoredDependencies", "", "violationsForModules", "moduleIds", "Lorg/gradle/api/artifacts/Configuration;", "gradle-lint-plugin_main"})
public final class DuplicateDependencyService {
    @NotNull
    private final Logger logger;
    @NotNull
    private final Project project;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> violationsForModules(@NotNull List<? extends ModuleVersionIdentifier> moduleIds, @NotNull Configuration conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(moduleIds, (String)"moduleIds");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        Intrinsics.checkParameterIsNotNull(ignoredDependencies, (String)"ignoredDependencies");
        Iterable iterable = $receiver$iv = (Iterable)moduleIds;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ModuleVersionIdentifier it = (ModuleVersionIdentifier)element$iv$iv;
            String string = conf.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"conf.name");
            Iterable list$iv$iv = this.violationsForModule(it, string, ignoredDependencies);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<String> violationsForModule(@NotNull ModuleVersionIdentifier mvid, @NotNull String conf, @NotNull Set<? extends ModuleVersionIdentifier> ignoredDependencies) {
        Intrinsics.checkParameterIsNotNull((Object)mvid, (String)"mvid");
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        Intrinsics.checkParameterIsNotNull(ignoredDependencies, (String)"ignoredDependencies");
        dependencyService = DependencyService.forProject(this.project);
        if (ignoredDependencies.contains(mvid)) {
            return CollectionsKt.emptyList();
        }
        v0 = dependencyService.jarContents(mvid.getModule());
        if (v0 == null || (v0 = v0.getClasses()) == null) {
            return CollectionsKt.emptyList();
        }
        dependencyClasses = v0;
        var6_6 = dependencyService.artifactsByClass(conf);
        var7_7 = $receiver$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        var9_9 = $receiver$iv$iv;
        var10_10 = var9_9.entrySet().iterator();
        while (var10_10.hasNext()) {
            block7: {
                it = element$iv$iv = var10_10.next();
                artifacts = (Collection)it.getValue();
                if (!dependencyClasses.contains(it.getKey())) ** GOTO lbl-1000
                $receiver$iv = artifacts;
                for (T element$iv : $receiver$iv) {
                    it = (ResolvedArtifact)element$iv;
                    if (!(ignoredDependencies.contains(it.getModuleVersion().getId()) == false && (Intrinsics.areEqual((Object)it.getModuleVersion().getId().getModule(), (Object)mvid.getModule()) ^ true) != false)) continue;
                    v1 = true;
                    break block7;
                }
                v1 = false;
            }
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        dupeDependencyClasses = destination$iv$iv;
        dupeClassesByDependency = new TreeMap<ModuleVersionIdentifier, V>(DependencyService.DEPENDENCY_COMPARATOR);
        dupeDependencyClasses.forEach((BiConsumer)new BiConsumer<String, Collection<ResolvedArtifact>>(dupeClassesByDependency){
            final /* synthetic */ TreeMap $dupeClassesByDependency;

            public final void accept(String className, Collection<ResolvedArtifact> resolvedArtifacts) {
                Iterable $receiver$iv = resolvedArtifacts;
                for (T element$iv : $receiver$iv) {
                    ResolvedArtifact artifact = (ResolvedArtifact)element$iv;
                    ModuleVersionIdentifier moduleId = artifact.getModuleVersion().getId();
                    if (!this.$dupeClassesByDependency.containsKey(moduleId)) {
                        ModuleVersionIdentifier moduleVersionIdentifier = moduleId;
                        TreeMap treeMap = this.$dupeClassesByDependency;
                        Set set = new LinkedHashSet<E>();
                        treeMap.put(moduleVersionIdentifier, set);
                    }
                    V v = this.$dupeClassesByDependency.get(artifact.getModuleVersion().getId());
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    Set set = (Set)v;
                    String string = className;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
                    set.add(string);
                }
            }
            {
                this.$dupeClassesByDependency = treeMap;
            }
        });
        violations = new ArrayList<E>();
        configuration = this.project.getConfigurations().getByName(conf);
        if (!dupeClassesByDependency.isEmpty() && Intrinsics.areEqual((Object)mvid, (Object)((ModuleVersionIdentifier)CollectionsKt.first((Iterable)dupeClassesByDependency.keySet())))) {
            dupeClassesByDependency.forEach((BiConsumer)new BiConsumer<ModuleVersionIdentifier, Set<String>>(this, mvid, configuration, violations){
                final /* synthetic */ DuplicateDependencyService this$0;
                final /* synthetic */ ModuleVersionIdentifier $mvid;
                final /* synthetic */ Configuration $configuration;
                final /* synthetic */ List $violations;

                public final void accept(@NotNull ModuleVersionIdentifier resolvedMvid, @NotNull Set<String> classes) {
                    Intrinsics.checkParameterIsNotNull((Object)resolvedMvid, (String)"resolvedMvid");
                    Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
                    if (Intrinsics.areEqual((Object)this.$mvid, (Object)resolvedMvid) ^ true) {
                        String message = this.$mvid + " in " + this.$configuration + " has " + classes.size() + " classes duplicated by " + resolvedMvid;
                        this.this$0.getLogger().debug(message + ". Duplicate classes:" + "\n" + classes);
                        this.$violations.add(message + " (use --debug for detailed class list)");
                    }
                }
                {
                    this.this$0 = duplicateDependencyService;
                    this.$mvid = moduleVersionIdentifier;
                    this.$configuration = configuration;
                    this.$violations = list;
                }
            });
        }
        return violations;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public DuplicateDependencyService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Logger logger = LoggerFactory.getLogger(DuplicateDependencyService.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026dencyService::class.java)");
        this.logger = logger;
    }
}

