package com.netflix.nebula.lint.rule.dependency

class JarContents {
    Set<String> entryNames

    /**
     * Fully qualified class names with '/' package separators
     */
    @Lazy Set<String> classes = entryNames
            // classes like org/hornetq/utils/HornetQUtilLogger_$logger are generated by references to interface fields, skip these
            .findAll { it.endsWith('.class') && !(it =~ /_\$\w+\.class$/)  }
            .collect { it.replaceAll(/\.class$/, '') }
            .toSet()

    @Lazy boolean isServiceProvider = entryNames.any { it == 'META-INF/services/' }
    @Lazy boolean nothingButMetaInf = !entryNames.any { !it.startsWith('META-INF') }
    @Lazy boolean isWebjar = entryNames.any { it == 'META-INF/resources/webjars/' }
}
