/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc.rule;

import com.netflix.nebula.lint.org.codenarc.analyzer.StringSourceAnalyzer;
import com.netflix.nebula.lint.org.codenarc.rule.AbstractAstVisitorRule;
import com.netflix.nebula.lint.org.codenarc.rule.AbstractRuleTestCase;
import com.netflix.nebula.lint.org.codenarc.rule.InlineViolationsParser;
import com.netflix.nebula.lint.org.codenarc.rule.Rule;
import com.netflix.nebula.lint.org.codenarc.rule.Violation;
import com.netflix.nebula.lint.org.codenarc.ruleset.ListRuleSet;
import com.netflix.nebula.lint.org.codenarc.source.CustomCompilerPhaseSourceDecorator;
import com.netflix.nebula.lint.org.codenarc.source.SourceCode;
import com.netflix.nebula.lint.org.codenarc.source.SourceString;
import com.netflix.nebula.lint.org.codenarc.test.AbstractTestCase;
import com.netflix.nebula.lint.org.codenarc.test.TestUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractRuleTestCase
extends AbstractTestCase
implements GroovyObject {
    protected static final Object CONSTRUCTOR_METHOD_NAME;
    protected static final Object DEFAULT_TEST_FILES;
    protected static final Object DEFAULT_TEST_CLASS_NAMES;
    protected Rule rule;
    protected String sourceCodeName;
    protected String sourceCodePath;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1459635399698;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AbstractRuleTestCase() {
        MetaClass metaClass;
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testThatUnrelatedCodeHasNoViolations() {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        String SOURCE = "class MyClass { }";
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].call(callSiteArray[2].callCurrent((GroovyObject)this)), (Object)"skipTestThatUnrelatedCodeHasNoViolations"))) {
            callSiteArray[3].callCurrent((GroovyObject)this, (Object)SOURCE);
        }
    }

    @Test
    public void testThatInvalidCodeHasNoViolations() {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        String SOURCE = "\n            @will not compile@ &^%$#\n        ";
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].callCurrent((GroovyObject)this)), (Object)"skipTestThatInvalidCodeHasNoViolations"))) {
            Object sourceCode = callSiteArray[7].callCurrent((GroovyObject)this, (Object)SOURCE);
            ValueRecorder valueRecorder = new ValueRecorder();
            try {
                CallSite callSite = callSiteArray[8];
                CallSite callSite2 = callSiteArray[9];
                Rule rule = this.rule;
                valueRecorder.record((Object)rule, -1);
                valueRecorder.record((Object)rule, 8);
                Object object = sourceCode;
                valueRecorder.record(object, 21);
                Object object2 = callSite2.call((Object)rule, object);
                valueRecorder.record(object2, 13);
                Object object3 = callSite.callGetProperty(object2);
                valueRecorder.record(object3, 33);
                if (DefaultTypeTransformation.booleanUnbox((Object)object3)) {
                    valueRecorder.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert rule.applyTo(sourceCode).empty", (ValueRecorder)valueRecorder), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder.clear();
                throw throwable;
            }
        }
    }

    @Test
    public void testThatApplyToFilesMatchingValuesAreValidRegex() {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        callSiteArray[10].callCurrent((GroovyObject)this, callSiteArray[11].callGetProperty((Object)this.rule), (Object)"applyToFilesMatching");
        callSiteArray[12].callCurrent((GroovyObject)this, callSiteArray[13].callGetProperty((Object)this.rule), (Object)"doNotApplyToFilesMatching");
    }

    private void assertValidRegex(String regex, String name) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)regex)) {
            try {
                callSiteArray[14].call(Pattern.class, (Object)regex);
            }
            catch (PatternSyntaxException e) {
                callSiteArray[15].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{name, regex, e}, new String[]{"The ", " value [", "] is not a valid regular expression: ", ""}));
            }
        }
    }

    protected abstract Rule createRule();

    protected void assertTwoViolations(String source, Integer lineNumber1, String sourceLineText1, Integer lineNumber2, String sourceLineText2) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object violations = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            violations = object = callSiteArray[16].callCurrent((GroovyObject)this, (Object)source);
        } else {
            List list = this.applyRuleTo(source);
            violations = list;
        }
        callSiteArray[17].call(violations, (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _assertTwoViolations_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _assertTwoViolations_closure1.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _assertTwoViolations_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _assertTwoViolations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _assertTwoViolations_closure1.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _assertTwoViolations_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "lineNumber";
                return new CallSiteArray(_assertTwoViolations_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _assertTwoViolations_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[18].call(violations), (Object)2)) {
            ScriptBytecodeAdapter.assertFailed((Object)"(violations.size() == 2)", (Object)new GStringImpl(new Object[]{callSiteArray[19].call(violations), callSiteArray[20].call(violations, (Object)"\n")}, new String[]{"Expected 2 violations\nFound ", ": \n", "\n"}));
        }
        callSiteArray[21].callCurrent((GroovyObject)this, callSiteArray[22].call(violations, (Object)0), (Object)lineNumber1, (Object)sourceLineText1);
        callSiteArray[23].callCurrent((GroovyObject)this, callSiteArray[24].call(violations, (Object)1), (Object)lineNumber2, (Object)sourceLineText2);
    }

    protected void assertInlineViolations(String annotatedSource) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object parseResult = callSiteArray[25].call(callSiteArray[26].callConstructor(InlineViolationsParser.class), (Object)annotatedSource);
        Map[] violationsMap = (Map[])ScriptBytecodeAdapter.asType((Object)callSiteArray[27].callGetProperty(parseResult), Map[].class);
        callSiteArray[28].callCurrent((GroovyObject)this, callSiteArray[29].callGetProperty(parseResult), (Object)violationsMap);
        if (!DefaultTypeTransformation.booleanUnbox((Object)violationsMap)) {
            StringBuffer stringBuffer = new StringBuffer("violationsMap. Values: ");
            stringBuffer.append((Object)"violationsMap = ");
            stringBuffer.append(InvokerHelper.toString((Object)violationsMap));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)"There must be at least one inline violation specified. If no violations are intended, then use assertNoViolations() instead");
        }
    }

    protected static String inlineViolation(String violationMessage) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[30].call(InlineViolationsParser.class, (Object)violationMessage), String.class);
    }

    protected static String removeInlineViolations(String annotatedSource) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        return (String)ScriptBytecodeAdapter.castToType((Object)callSiteArray[31].callGetProperty(callSiteArray[32].call(callSiteArray[33].callConstructor(InlineViolationsParser.class), (Object)annotatedSource)), String.class);
    }

    protected void assertViolations(String source, Map ... violationMaps) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Reference rawViolations = new Reference(null);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[34].callCurrent((GroovyObject)this, (Object)source);
            rawViolations.set(object);
        } else {
            List list = this.applyRuleTo(source);
            rawViolations.set((Object)list);
        }
        callSiteArray[35].call(rawViolations.get(), (Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _assertViolations_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object v) {
                CallSite[] callSiteArray = _assertViolations_closure2.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _assertViolations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _assertViolations_closure2.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _assertViolations_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "lineNumber";
                return new CallSiteArray(_assertViolations_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _assertViolations_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[36].call(rawViolations.get()), (Object)callSiteArray[37].call((Object)violationMaps))) {
            ScriptBytecodeAdapter.assertFailed((Object)"(rawViolations.size() == violationMaps.size())", (Object)new GStringImpl(new Object[]{callSiteArray[38].call((Object)violationMaps), callSiteArray[39].call(rawViolations.get()), callSiteArray[40].call(rawViolations.get(), (Object)"\n    ")}, new String[]{"Expected ", " violations\nFound ", ": \n    ", "\n"}));
        }
        callSiteArray[41].call((Object)violationMaps, (Object)new GeneratedClosure(this, this, rawViolations){
            private /* synthetic */ Reference rawViolations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _assertViolations_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.rawViolations = reference = rawViolations;
            }

            public Object doCall(Object violationMap, Object index) {
                CallSite[] callSiteArray = _assertViolations_closure3.$getCallSiteArray();
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[0].call(callSiteArray[1].call(violationMap), (Object)new GeneratedClosure((Object)this, this.getThisObject()){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        CallSite[] callSiteArray = _assertViolations_closure3_closure4.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object key) {
                        CallSite[] callSiteArray = _assertViolations_closure3_closure4.$getCallSiteArray();
                        return ScriptBytecodeAdapter.isCase((Object)key, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{"lineNumber", "sourceLineText", "messageText"}));
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _assertViolations_closure3_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                        CallSite[] callSiteArray = _assertViolations_closure3_closure4.$getCallSiteArray();
                        $callSiteArray = null;
                    }

                    static {
                        _assertViolations_closure3_closure4.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[]{};
                        return new CallSiteArray(_assertViolations_closure3_closure4.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _assertViolations_closure3_closure4.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                }))) {
                    ScriptBytecodeAdapter.assertFailed((Object)"violationMap.keySet().every({ java.lang.Object key -> ... })", (Object)"violationMap keys must be 'lineNumber', 'sourceLineText' and/or 'messageText'");
                }
                return callSiteArray[2].callCurrent((GroovyObject)this, callSiteArray[3].call(this.rawViolations.get(), index), callSiteArray[4].callGetProperty(violationMap), callSiteArray[5].callGetProperty(violationMap), callSiteArray[6].callGetProperty(violationMap));
            }

            public Object call(Object violationMap, Object index) {
                CallSite[] callSiteArray = _assertViolations_closure3.$getCallSiteArray();
                return callSiteArray[7].callCurrent((GroovyObject)this, violationMap, index);
            }

            public Object getRawViolations() {
                CallSite[] callSiteArray = _assertViolations_closure3.$getCallSiteArray();
                return this.rawViolations.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _assertViolations_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
                CallSite[] callSiteArray = _assertViolations_closure3.$getCallSiteArray();
                $callSiteArray = null;
            }

            static {
                _assertViolations_closure3.__$swapInit();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "every";
                stringArray[1] = "keySet";
                stringArray[2] = "assertViolation";
                stringArray[3] = "getAt";
                stringArray[4] = "lineNumber";
                stringArray[5] = "sourceLineText";
                stringArray[6] = "messageText";
                stringArray[7] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _assertViolations_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_assertViolations_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _assertViolations_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
    }

    protected void assertTwoViolations(String source, Integer lineNumber1, String sourceLineText1, Object msg1, Integer lineNumber2, String sourceLineText2, Object msg2) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object violations = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            violations = object = callSiteArray[42].callCurrent((GroovyObject)this, (Object)source);
        } else {
            List list = this.applyRuleTo(source);
            violations = list;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[43].call(violations), (Object)2)) {
            ScriptBytecodeAdapter.assertFailed((Object)"(violations.size() == 2)", (Object)new GStringImpl(new Object[]{callSiteArray[44].call(violations), callSiteArray[45].call(violations, (Object)"\n")}, new String[]{"Expected 2 violations\nFound ", ": \n", "\n"}));
        }
        callSiteArray[46].callCurrent((GroovyObject)this, callSiteArray[47].call(violations, (Object)0), (Object)lineNumber1, (Object)sourceLineText1, msg1);
        callSiteArray[48].callCurrent((GroovyObject)this, callSiteArray[49].call(violations, (Object)1), (Object)lineNumber2, (Object)sourceLineText2, msg2);
    }

    protected void assertSingleViolation(String source, Integer lineNumber, String sourceLineText, Object messageText) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object violations = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            violations = object = callSiteArray[50].callCurrent((GroovyObject)this, (Object)source);
        } else {
            List list = this.applyRuleTo(source);
            violations = list;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[51].call(violations), (Object)1)) {
            ScriptBytecodeAdapter.assertFailed((Object)"(violations.size() == 1)", (Object)new GStringImpl(new Object[]{callSiteArray[52].call(violations), callSiteArray[53].call(violations, (Object)"\n"), sourceLineText}, new String[]{"Expected 1 violation\nFound ", ": \n", "\n  for sourceLineText: [", "]"}));
        }
        callSiteArray[54].callCurrent((GroovyObject)this, callSiteArray[55].call(violations, (Object)0), (Object)lineNumber, (Object)sourceLineText, messageText);
    }

    protected void assertSingleViolation(String source, Closure closure) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object violations = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            violations = object = callSiteArray[56].callCurrent((GroovyObject)this, (Object)source);
        } else {
            List list = this.applyRuleTo(source);
            violations = list;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[57].call(violations), (Object)1)) {
            ScriptBytecodeAdapter.assertFailed((Object)"(violations.size() == 1)", (Object)new GStringImpl(new Object[]{callSiteArray[58].call(violations), callSiteArray[59].call(violations, (Object)"\n")}, new String[]{"Expected 1 violation\nFound ", ": \n", "\n"}));
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)closure, callSiteArray[61].call(violations, (Object)0)))) {
            ScriptBytecodeAdapter.assertFailed((Object)"closure.call(violations[0])", (Object)new GStringImpl(new Object[]{callSiteArray[62].call(violations, (Object)0)}, new String[]{"Closure failed for ", ""}));
        }
    }

    protected void assertNoViolations(String source) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object violations = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            violations = object = callSiteArray[63].callCurrent((GroovyObject)this, (Object)source);
        } else {
            List list = this.applyRuleTo(source);
            violations = list;
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[64].callGetProperty(violations))) {
            ScriptBytecodeAdapter.assertFailed((Object)"violations.empty", (Object)new GStringImpl(new Object[]{callSiteArray[65].call(violations), callSiteArray[66].call(violations, (Object)"\n")}, new String[]{"Expected no violations, but got ", ": \n", "\n"}));
        }
    }

    protected void assertViolation(Violation violation, Integer lineNumber, String sourceLineText, Object messageText) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[67];
            Violation violation2 = violation;
            valueRecorder.record((Object)violation2, 8);
            Object object = callSite.callGroovyObjectGetProperty((Object)violation2);
            valueRecorder.record(object, 18);
            Rule rule = this.rule;
            valueRecorder.record((Object)rule, -1);
            valueRecorder.record((Object)rule, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)rule);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert violation.rule == rule", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        if (!ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[68].callGroovyObjectGetProperty((Object)violation), (Object)lineNumber)) {
            StringBuffer stringBuffer = new StringBuffer("(violation.lineNumber == lineNumber). Values: ");
            stringBuffer.append((Object)"lineNumber = ");
            stringBuffer.append(InvokerHelper.toString((Object)lineNumber));
            ScriptBytecodeAdapter.assertFailed((Object)stringBuffer, (Object)new GStringImpl(new Object[]{violation, lineNumber, callSiteArray[69].callGroovyObjectGetProperty((Object)violation)}, new String[]{"Wrong line number for violation: \n", "\nExpected: ", "\nFound:    ", "\n"}));
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)sourceLineText)) {
            ValueRecorder valueRecorder2 = new ValueRecorder();
            try {
                CallSite callSite = callSiteArray[70];
                Violation violation3 = violation;
                valueRecorder2.record((Object)violation3, 8);
                Object object = callSite.callGroovyObjectGetProperty((Object)violation3);
                valueRecorder2.record(object, 18);
                if (DefaultTypeTransformation.booleanUnbox((Object)object)) {
                    valueRecorder2.clear();
                } else {
                    ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert violation.sourceLine", (ValueRecorder)valueRecorder2), null);
                }
            }
            catch (Throwable throwable) {
                valueRecorder2.clear();
                throw throwable;
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[71].call(callSiteArray[72].callGroovyObjectGetProperty((Object)violation), (Object)sourceLineText))) {
                ScriptBytecodeAdapter.assertFailed((Object)"violation.sourceLine.contains(sourceLineText)", (Object)new GStringImpl(new Object[]{sourceLineText, callSiteArray[73].callGroovyObjectGetProperty((Object)violation)}, new String[]{"Problem with source text:\nexpected to contain:  ", "\nactual:               ", "\n"}));
            }
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)messageText)) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[74].callGroovyObjectGetProperty((Object)violation))) {
                ScriptBytecodeAdapter.assertFailed((Object)"violation.message", (Object)"The violation message was null");
            }
            if (messageText instanceof Collection) {
                callSiteArray[75].callStatic(TestUtil.class, callSiteArray[76].callGroovyObjectGetProperty((Object)violation), messageText);
            } else if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].call(callSiteArray[78].callGroovyObjectGetProperty((Object)violation), messageText))) {
                ScriptBytecodeAdapter.assertFailed((Object)"violation.message.contains(messageText)", (Object)new GStringImpl(new Object[]{messageText, callSiteArray[79].callGroovyObjectGetProperty((Object)violation)}, new String[]{"\nExpected message text: [", "]\nFound message text:    [", "]\n"}));
            }
        }
    }

    protected List applyRuleTo(String source) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object sourceCode = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            sourceCode = object = callSiteArray[80].callCurrent((GroovyObject)this, (Object)source);
        } else {
            SourceCode sourceCode2 = this.prepareSourceCode(source);
            sourceCode = sourceCode2;
        }
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[81];
            Object object = sourceCode;
            valueRecorder.record(object, 8);
            Object object2 = callSite.callGetProperty(object);
            valueRecorder.record(object2, 19);
            if (DefaultTypeTransformation.booleanUnbox((Object)object2)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert sourceCode.valid", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Object violations = callSiteArray[82].call((Object)this.rule, sourceCode);
        callSiteArray[83].callCurrent((GroovyObject)this, (Object)new GStringImpl(new Object[]{violations}, new String[]{"violations=", ""}));
        return (List)ScriptBytecodeAdapter.castToType((Object)violations, List.class);
    }

    private SourceCode prepareSourceCode(String source) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object sourceCode = callSiteArray[84].callConstructor(SourceString.class, (Object)source, (Object)this.sourceCodePath, (Object)this.sourceCodeName);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[85].callGetProperty((Object)this.rule), (Object)callSiteArray[86].callGetProperty(SourceCode.class))) {
                Object object;
                sourceCode = object = callSiteArray[87].callConstructor(CustomCompilerPhaseSourceDecorator.class, sourceCode, callSiteArray[88].callGetProperty((Object)this.rule));
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[89].callGetProperty((Object)this.rule), (Object)callSiteArray[90].callGetProperty(SourceCode.class))) {
            Object object;
            sourceCode = object = callSiteArray[91].callConstructor(CustomCompilerPhaseSourceDecorator.class, sourceCode, callSiteArray[92].callGetProperty((Object)this.rule));
        }
        return (SourceCode)ScriptBytecodeAdapter.castToType((Object)sourceCode, SourceCode.class);
    }

    protected List manuallyApplyRule(String source) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object analyzer = callSiteArray[93].callConstructor(StringSourceAnalyzer.class, (Object)source);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[94];
            CallSite callSite2 = callSiteArray[95];
            Object object = analyzer;
            valueRecorder.record(object, 8);
            Object object2 = callSite2.callGetProperty(object);
            valueRecorder.record(object2, 17);
            Object object3 = callSite.callGetProperty(object2);
            valueRecorder.record(object3, 24);
            if (DefaultTypeTransformation.booleanUnbox((Object)object3)) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert analyzer.source.valid", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        Object results = callSiteArray[96].call(analyzer, callSiteArray[97].callConstructor(ListRuleSet.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{this.rule})));
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[98].callGetProperty(results), List.class);
    }

    @Before
    public void setUpAbstractRuleTestCase() {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[99].callCurrent((GroovyObject)this);
            this.rule = (Rule)ScriptBytecodeAdapter.castToType((Object)object, Rule.class);
        } else {
            Rule rule = this.createRule();
            this.rule = (Rule)ScriptBytecodeAdapter.castToType((Object)rule, Rule.class);
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractRuleTestCase.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractRuleTestCase.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, AbstractRuleTestCase.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField(AbstractRuleTestCase.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    protected void assertSingleViolation(String source, Integer lineNumber, String sourceLineText) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        this.assertSingleViolation(source, lineNumber, sourceLineText, null);
    }

    protected void assertSingleViolation(String source, Integer lineNumber) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        this.assertSingleViolation(source, lineNumber, null, null);
    }

    protected void assertSingleViolation(String source) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        this.assertSingleViolation(source, null, null, null);
    }

    protected void assertViolation(Violation violation, Integer lineNumber, String sourceLineText) {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        this.assertViolation(violation, lineNumber, sourceLineText, null);
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = AbstractRuleTestCase.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        Object object;
        Object object2;
        long l;
        long l2;
        AbstractRuleTestCase.__$swapInit();
        __timeStamp__239_neverHappen1459635399698 = l2 = 0L;
        __timeStamp = l = 1459635399698L;
        String string = "<init>";
        CONSTRUCTOR_METHOD_NAME = string;
        DEFAULT_TEST_FILES = object2 = AbstractRuleTestCase.$getCallSiteArray()[100].callGetProperty(AbstractAstVisitorRule.class);
        DEFAULT_TEST_CLASS_NAMES = object = AbstractRuleTestCase.$getCallSiteArray()[101].callGetProperty(AbstractAstVisitorRule.class);
    }

    public /* synthetic */ void this$3$assertValidRegex(String string, String string2) {
        this.assertValidRegex(string, string2);
    }

    public /* synthetic */ SourceCode this$3$prepareSourceCode(String string) {
        return this.prepareSourceCode(string);
    }

    public /* synthetic */ Object super$2$getProperty(String string) {
        return super.getProperty(string);
    }

    public /* synthetic */ String super$2$getName() {
        return super.getName();
    }

    @Override
    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$2$setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    @Override
    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    @Override
    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ void super$2$log(Object object) {
        super.log(object);
    }

    public /* synthetic */ Object super$2$this$dist$invoke$1(String string, Object object) {
        return super.this$dist$invoke$1(string, object);
    }

    public /* synthetic */ void super$2$setUpAbstractTestCase() {
        super.setUpAbstractTestCase();
    }

    @Override
    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ MetaClass super$2$getMetaClass() {
        return super.getMetaClass();
    }

    @Override
    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$2$setMetaClass(MetaClass metaClass) {
        super.setMetaClass(metaClass);
    }

    public /* synthetic */ Object super$2$this$dist$get$1(String string) {
        return super.this$dist$get$1(string);
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$2$this$dist$set$1(String string, Object object) {
        super.this$dist$set$1(string, object);
    }

    public /* synthetic */ Object super$2$invokeMethod(String string, Object object) {
        return super.invokeMethod(string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "contains";
        stringArray[1] = "keySet";
        stringArray[2] = "getProperties";
        stringArray[3] = "assertNoViolations";
        stringArray[4] = "contains";
        stringArray[5] = "keySet";
        stringArray[6] = "getProperties";
        stringArray[7] = "prepareSourceCode";
        stringArray[8] = "empty";
        stringArray[9] = "applyTo";
        stringArray[10] = "assertValidRegex";
        stringArray[11] = "applyToFilesMatching";
        stringArray[12] = "assertValidRegex";
        stringArray[13] = "doNotApplyToFilesMatching";
        stringArray[14] = "compile";
        stringArray[15] = "fail";
        stringArray[16] = "applyRuleTo";
        stringArray[17] = "sort";
        stringArray[18] = "size";
        stringArray[19] = "size";
        stringArray[20] = "join";
        stringArray[21] = "assertViolation";
        stringArray[22] = "getAt";
        stringArray[23] = "assertViolation";
        stringArray[24] = "getAt";
        stringArray[25] = "parse";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "violations";
        stringArray[28] = "assertViolations";
        stringArray[29] = "source";
        stringArray[30] = "inlineViolation";
        stringArray[31] = "source";
        stringArray[32] = "parse";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "applyRuleTo";
        stringArray[35] = "sort";
        stringArray[36] = "size";
        stringArray[37] = "size";
        stringArray[38] = "size";
        stringArray[39] = "size";
        stringArray[40] = "join";
        stringArray[41] = "eachWithIndex";
        stringArray[42] = "applyRuleTo";
        stringArray[43] = "size";
        stringArray[44] = "size";
        stringArray[45] = "join";
        stringArray[46] = "assertViolation";
        stringArray[47] = "getAt";
        stringArray[48] = "assertViolation";
        stringArray[49] = "getAt";
        stringArray[50] = "applyRuleTo";
        stringArray[51] = "size";
        stringArray[52] = "size";
        stringArray[53] = "join";
        stringArray[54] = "assertViolation";
        stringArray[55] = "getAt";
        stringArray[56] = "applyRuleTo";
        stringArray[57] = "size";
        stringArray[58] = "size";
        stringArray[59] = "join";
        stringArray[60] = "call";
        stringArray[61] = "getAt";
        stringArray[62] = "getAt";
        stringArray[63] = "applyRuleTo";
        stringArray[64] = "empty";
        stringArray[65] = "size";
        stringArray[66] = "join";
        stringArray[67] = "rule";
        stringArray[68] = "lineNumber";
        stringArray[69] = "lineNumber";
        stringArray[70] = "sourceLine";
        stringArray[71] = "contains";
        stringArray[72] = "sourceLine";
        stringArray[73] = "sourceLine";
        stringArray[74] = "message";
        stringArray[75] = "assertContainsAll";
        stringArray[76] = "message";
        stringArray[77] = "contains";
        stringArray[78] = "message";
        stringArray[79] = "message";
        stringArray[80] = "prepareSourceCode";
        stringArray[81] = "valid";
        stringArray[82] = "applyTo";
        stringArray[83] = "log";
        stringArray[84] = "<$constructor$>";
        stringArray[85] = "compilerPhase";
        stringArray[86] = "DEFAULT_COMPILER_PHASE";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "compilerPhase";
        stringArray[89] = "compilerPhase";
        stringArray[90] = "DEFAULT_COMPILER_PHASE";
        stringArray[91] = "<$constructor$>";
        stringArray[92] = "compilerPhase";
        stringArray[93] = "<$constructor$>";
        stringArray[94] = "valid";
        stringArray[95] = "source";
        stringArray[96] = "analyze";
        stringArray[97] = "<$constructor$>";
        stringArray[98] = "violations";
        stringArray[99] = "createRule";
        stringArray[100] = "DEFAULT_TEST_FILES";
        stringArray[101] = "DEFAULT_TEST_CLASS_NAMES";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[102];
        AbstractRuleTestCase.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AbstractRuleTestCase.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractRuleTestCase.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

