/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.diff;

import com.netflix.nebula.lint.jgit.diff.DiffAlgorithm;
import com.netflix.nebula.lint.jgit.diff.Edit;
import com.netflix.nebula.lint.jgit.diff.EditList;
import com.netflix.nebula.lint.jgit.diff.HashedSequence;
import com.netflix.nebula.lint.jgit.diff.HashedSequenceComparator;
import com.netflix.nebula.lint.jgit.diff.LowLevelDiffAlgorithm;
import com.netflix.nebula.lint.jgit.diff.MyersDiff;
import com.netflix.nebula.lint.jgit.diff.RawText;
import com.netflix.nebula.lint.jgit.diff.RawTextComparator;
import com.netflix.nebula.lint.jgit.diff.Sequence;
import com.netflix.nebula.lint.jgit.errors.DiffInterruptedException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.util.IntList;
import com.netflix.nebula.lint.jgit.util.LongList;
import java.io.File;
import java.text.MessageFormat;

public class MyersDiff<S extends Sequence> {
    public static final DiffAlgorithm INSTANCE = new LowLevelDiffAlgorithm(){

        @Override
        public <S extends Sequence> void diffNonCommon(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a, HashedSequence<S> b, Edit region) {
            new MyersDiff(edits, cmp, a, b, region);
        }
    };
    protected EditList edits;
    protected HashedSequenceComparator<S> cmp;
    protected HashedSequence<S> a;
    protected HashedSequence<S> b;
    MiddleEdit middle = new MiddleEdit();

    private MyersDiff(EditList edits, HashedSequenceComparator<S> cmp, HashedSequence<S> a, HashedSequence<S> b, Edit region) {
        this.edits = edits;
        this.cmp = cmp;
        this.a = a;
        this.b = b;
        this.calculateEdits(region);
    }

    private void calculateEdits(Edit r) {
        this.middle.initialize(r.beginA, r.endA, r.beginB, r.endB);
        if (this.middle.beginA >= this.middle.endA && this.middle.beginB >= this.middle.endB) {
            return;
        }
        this.calculateEdits(this.middle.beginA, this.middle.endA, this.middle.beginB, this.middle.endB);
    }

    protected void calculateEdits(int beginA, int endA, int beginB, int endB) {
        int x;
        int k;
        Edit edit = this.middle.calculate(beginA, endA, beginB, endB);
        if (beginA < edit.beginA || beginB < edit.beginB) {
            k = edit.beginB - edit.beginA;
            x = this.middle.backward.snake(k, edit.beginA);
            this.calculateEdits(beginA, x, beginB, k + x);
        }
        if (edit.getType() != Edit.Type.EMPTY) {
            this.edits.add(this.edits.size(), edit);
        }
        if (endA > edit.endA || endB > edit.endB) {
            k = edit.endB - edit.endA;
            x = this.middle.forward.snake(k, edit.endA);
            this.calculateEdits(x, endA, k + x, endB);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println(JGitText.get().need2Arguments);
            System.exit(1);
        }
        try {
            RawText a = new RawText(new File(args[0]));
            RawText b = new RawText(new File(args[1]));
            EditList r = INSTANCE.diff(RawTextComparator.DEFAULT, a, b);
            System.out.println(r.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MiddleEdit {
        com.netflix.nebula.lint.jgit.diff.MyersDiff$MiddleEdit.EditPaths forward = new ForwardEditPaths();
        com.netflix.nebula.lint.jgit.diff.MyersDiff$MiddleEdit.EditPaths backward = new BackwardEditPaths();
        protected int beginA;
        protected int endA;
        protected int beginB;
        protected int endB;
        protected Edit edit;

        MiddleEdit() {
        }

        void initialize(int beginA, int endA, int beginB, int endB) {
            this.beginA = beginA;
            this.endA = endA;
            this.beginB = beginB;
            this.endB = endB;
            int k = beginB - beginA;
            this.beginA = this.forward.snake(k, beginA);
            this.beginB = k + this.beginA;
            k = endB - endA;
            this.endA = this.backward.snake(k, endA);
            this.endB = k + this.endA;
        }

        Edit calculate(int beginA, int endA, int beginB, int endB) {
            if (beginA == endA || beginB == endB) {
                return new Edit(beginA, endA, beginB, endB);
            }
            this.beginA = beginA;
            this.endA = endA;
            this.beginB = beginB;
            this.endB = endB;
            int minK = beginB - endA;
            int maxK = endB - beginA;
            this.forward.initialize(beginB - beginA, beginA, minK, maxK);
            this.backward.initialize(endB - endA, endA, minK, maxK);
            int d = 1;
            while (!this.forward.calculate(d) && !this.backward.calculate(d)) {
                ++d;
            }
            return this.edit;
        }

        /*
         * Signature claims super is com.netflix.nebula.lint.jgit.diff.MyersDiff$MiddleEdit.EditPaths, not com.netflix.nebula.lint.jgit.diff.MyersDiff$MiddleEdit$EditPaths - discarding signature.
         */
        class BackwardEditPaths
        extends EditPaths {
            BackwardEditPaths() {
            }

            @Override
            final int snake(int k, int x) {
                while (x > MiddleEdit.this.beginA && k + x > MiddleEdit.this.beginB && MyersDiff.this.cmp.equals(MyersDiff.this.a, x - 1, MyersDiff.this.b, k + x - 1)) {
                    --x;
                }
                return x;
            }

            @Override
            final int getLeft(int x) {
                return x - 1;
            }

            @Override
            final int getRight(int x) {
                return x;
            }

            @Override
            final boolean isBetter(int left, int right) {
                return left < right;
            }

            @Override
            final void adjustMinMaxK(int k, int x) {
                if (x <= MiddleEdit.this.beginA || k + x <= MiddleEdit.this.beginB) {
                    if (k > MiddleEdit.this.forward.middleK) {
                        this.maxK = k;
                    } else {
                        this.minK = k;
                    }
                }
            }

            @Override
            final boolean meets(int d, int k, int x, long snake) {
                if (k < MiddleEdit.this.forward.beginK || k > MiddleEdit.this.forward.endK) {
                    return false;
                }
                if ((d + k - MiddleEdit.this.forward.middleK) % 2 != 0) {
                    return false;
                }
                if (x > MiddleEdit.this.forward.getX(d, k)) {
                    return false;
                }
                this.makeEdit(MiddleEdit.this.forward.getSnake(d, k), snake);
                return true;
            }
        }

        abstract class EditPaths {
            private IntList x = new IntList();
            private LongList snake = new LongList();
            int beginK;
            int endK;
            int middleK;
            int prevBeginK;
            int prevEndK;
            int minK;
            int maxK;

            EditPaths() {
            }

            final int getIndex(int d, int k) {
                if ((d + k - this.middleK) % 2 != 0) {
                    throw new RuntimeException(MessageFormat.format(JGitText.get().unexpectedOddResult, d, k, this.middleK));
                }
                return (d + k - this.middleK) / 2;
            }

            final int getX(int d, int k) {
                if (k < this.beginK || k > this.endK) {
                    throw new RuntimeException(MessageFormat.format(JGitText.get().kNotInRange, k, this.beginK, this.endK));
                }
                return this.x.get(this.getIndex(d, k));
            }

            final long getSnake(int d, int k) {
                if (k < this.beginK || k > this.endK) {
                    throw new RuntimeException(MessageFormat.format(JGitText.get().kNotInRange, k, this.beginK, this.endK));
                }
                return this.snake.get(this.getIndex(d, k));
            }

            private int forceKIntoRange(int k) {
                if (k < this.minK) {
                    return this.minK + ((k ^ this.minK) & 1);
                }
                if (k > this.maxK) {
                    return this.maxK - ((k ^ this.maxK) & 1);
                }
                return k;
            }

            void initialize(int k, int x, int minK, int maxK) {
                this.minK = minK;
                this.maxK = maxK;
                this.endK = this.middleK = k;
                this.beginK = this.middleK;
                this.x.clear();
                this.x.add(x);
                this.snake.clear();
                this.snake.add(this.newSnake(k, x));
            }

            abstract int snake(int var1, int var2);

            abstract int getLeft(int var1);

            abstract int getRight(int var1);

            abstract boolean isBetter(int var1, int var2);

            abstract void adjustMinMaxK(int var1, int var2);

            abstract boolean meets(int var1, int var2, int var3, long var4);

            final long newSnake(int k, int x) {
                long y = k + x;
                long ret = (long)x << 32;
                return ret | y;
            }

            final int snake2x(long snake) {
                return (int)(snake >>> 32);
            }

            final int snake2y(long snake) {
                return (int)snake;
            }

            final boolean makeEdit(long snake1, long snake2) {
                int x1 = this.snake2x(snake1);
                int x2 = this.snake2x(snake2);
                int y1 = this.snake2y(snake1);
                int y2 = this.snake2y(snake2);
                if (x1 > x2 || y1 > y2) {
                    x1 = x2;
                    y1 = y2;
                }
                MiddleEdit.this.edit = new Edit(x1, x2, y1, y2);
                return true;
            }

            boolean calculate(int d) {
                this.prevBeginK = this.beginK;
                this.prevEndK = this.endK;
                this.beginK = this.forceKIntoRange(this.middleK - d);
                for (int k = this.endK = this.forceKIntoRange(this.middleK + d); k >= this.beginK; k -= 2) {
                    long newSnake;
                    int newX;
                    int end;
                    int i;
                    if (Thread.interrupted()) {
                        throw new DiffInterruptedException();
                    }
                    int left = -1;
                    int right = -1;
                    long leftSnake = -1L;
                    long rightSnake = -1L;
                    if (k > this.prevBeginK) {
                        i = this.getIndex(d - 1, k - 1);
                        left = this.x.get(i);
                        long l = leftSnake = left != (end = this.snake(k - 1, left)) ? this.newSnake(k - 1, end) : this.snake.get(i);
                        if (this.meets(d, k - 1, end, leftSnake)) {
                            return true;
                        }
                        left = this.getLeft(end);
                    }
                    if (k < this.prevEndK) {
                        i = this.getIndex(d - 1, k + 1);
                        right = this.x.get(i);
                        long l = rightSnake = right != (end = this.snake(k + 1, right)) ? this.newSnake(k + 1, end) : this.snake.get(i);
                        if (this.meets(d, k + 1, end, rightSnake)) {
                            return true;
                        }
                        right = this.getRight(end);
                    }
                    if (k >= this.prevEndK || k > this.prevBeginK && this.isBetter(left, right)) {
                        newX = left;
                        newSnake = leftSnake;
                    } else {
                        newX = right;
                        newSnake = rightSnake;
                    }
                    if (this.meets(d, k, newX, newSnake)) {
                        return true;
                    }
                    this.adjustMinMaxK(k, newX);
                    int i2 = this.getIndex(d, k);
                    this.x.set(i2, newX);
                    this.snake.set(i2, newSnake);
                }
                return false;
            }
        }

        /*
         * Signature claims super is com.netflix.nebula.lint.jgit.diff.MyersDiff$MiddleEdit.EditPaths, not com.netflix.nebula.lint.jgit.diff.MyersDiff$MiddleEdit$EditPaths - discarding signature.
         */
        class ForwardEditPaths
        extends EditPaths {
            ForwardEditPaths() {
            }

            @Override
            final int snake(int k, int x) {
                while (x < MiddleEdit.this.endA && k + x < MiddleEdit.this.endB && MyersDiff.this.cmp.equals(MyersDiff.this.a, x, MyersDiff.this.b, k + x)) {
                    ++x;
                }
                return x;
            }

            @Override
            final int getLeft(int x) {
                return x;
            }

            @Override
            final int getRight(int x) {
                return x + 1;
            }

            @Override
            final boolean isBetter(int left, int right) {
                return left > right;
            }

            @Override
            final void adjustMinMaxK(int k, int x) {
                if (x >= MiddleEdit.this.endA || k + x >= MiddleEdit.this.endB) {
                    if (k > MiddleEdit.this.backward.middleK) {
                        this.maxK = k;
                    } else {
                        this.minK = k;
                    }
                }
            }

            @Override
            final boolean meets(int d, int k, int x, long snake) {
                if (k < MiddleEdit.this.backward.beginK || k > MiddleEdit.this.backward.endK) {
                    return false;
                }
                if ((d - 1 + k - MiddleEdit.this.backward.middleK) % 2 != 0) {
                    return false;
                }
                if (x < MiddleEdit.this.backward.getX(d - 1, k)) {
                    return false;
                }
                this.makeEdit(snake, MiddleEdit.this.backward.getSnake(d - 1, k));
                return true;
            }
        }
    }
}

