/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc.analyzer;

import com.netflix.nebula.lint.org.codenarc.rule.Rule;
import com.netflix.nebula.lint.org.codenarc.rule.Violation;
import com.netflix.nebula.lint.org.codenarc.source.SourceCode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;

public class SuppressionAnalyzer {
    private static final ClassNode SUPPRESS_WARNINGS = ClassHelper.make(SuppressWarnings.class);
    private final SourceCode source;
    private boolean initialized = false;
    private final Object initializationLock = new Object();
    private final Set<String> suppressedRuleNames = Collections.synchronizedSet(new HashSet());
    private final Map<String, BitSet> suppressionsByLineNumber = new ConcurrentHashMap<String, BitSet>();

    public SuppressionAnalyzer(SourceCode source) {
        this.source = source;
    }

    public boolean isRuleSuppressed(Rule rule) {
        this.init();
        return this.suppressedRuleNames.contains(rule.getName());
    }

    public List<Violation> filterSuppressedViolations(Iterable<Violation> violations) {
        ArrayList<Violation> result = new ArrayList<Violation>();
        if (violations == null) {
            return result;
        }
        for (Violation v : violations) {
            if (this.isViolationSuppressed(v)) continue;
            result.add(v);
        }
        return result;
    }

    public boolean isViolationSuppressed(Violation violation) {
        if (violation == null) {
            return false;
        }
        if (violation.getRule() == null) {
            return false;
        }
        if (violation.getRule().getName() == null) {
            return false;
        }
        if (violation.getLineNumber() == null) {
            return false;
        }
        if (violation.getLineNumber() < 0) {
            return false;
        }
        this.init();
        String ruleName = violation.getRule().getName();
        int lineNumber = violation.getLineNumber();
        BitSet lines = this.suppressionsByLineNumber.get(ruleName);
        if (lines != null) {
            return lines.get(lineNumber);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (!this.initialized) {
                ModuleNode ast = this.source.getAst();
                if (ast != null) {
                    this.suppressedRuleNames.addAll(SuppressionAnalyzer.getSuppressedRuleNames((AnnotatedNode)ast.getPackage()));
                    this.suppressedRuleNames.addAll(SuppressionAnalyzer.getSuppressedRuleNames(ast.getImports()));
                    this.suppressedRuleNames.addAll(SuppressionAnalyzer.getSuppressedRuleNames(ast.getStaticStarImports().values()));
                    this.suppressedRuleNames.addAll(SuppressionAnalyzer.getSuppressedRuleNames(ast.getStarImports()));
                    if (ast.getClasses() != null && ast.getClasses().size() == 1) {
                        this.suppressedRuleNames.addAll(SuppressionAnalyzer.getSuppressedRuleNames(ast.getClasses()));
                    }
                    this.suppressionsByLineNumber.putAll(this.getSuppressionsByLineNumber(ast));
                }
                this.initialized = true;
            }
        }
    }

    private Map<String, BitSet> getSuppressionsByLineNumber(ModuleNode ast) {
        HashMap<String, BitSet> result = new HashMap<String, BitSet>();
        int numLines = SuppressionAnalyzer.getLineCount(ast);
        for (ClassNode classNode : ast.getClasses()) {
            for (String ruleName : SuppressionAnalyzer.getSuppressedRuleNames((AnnotatedNode)classNode)) {
                SuppressionAnalyzer.populateLineNumbers((AnnotatedNode)classNode, result, numLines, ruleName);
            }
            for (AnnotatedNode fieldNode : SuppressionAnalyzer.from(classNode.getFields())) {
                for (String ruleName : SuppressionAnalyzer.getSuppressedRuleNames(fieldNode)) {
                    SuppressionAnalyzer.populateLineNumbers(fieldNode, result, numLines, ruleName);
                }
            }
            for (AnnotatedNode methodNode : SuppressionAnalyzer.from(classNode.getMethods())) {
                for (String ruleName : SuppressionAnalyzer.getSuppressedRuleNames(methodNode)) {
                    SuppressionAnalyzer.populateLineNumbers(methodNode, result, numLines, ruleName);
                }
            }
            for (AnnotatedNode methodNode : SuppressionAnalyzer.from(classNode.getDeclaredConstructors())) {
                for (String ruleName : SuppressionAnalyzer.getSuppressedRuleNames(methodNode)) {
                    SuppressionAnalyzer.populateLineNumbers(methodNode, result, numLines, ruleName);
                }
            }
        }
        return result;
    }

    private static <T extends Collection> T from(T from) {
        if (from != null) {
            return from;
        }
        return (T)Collections.emptyList();
    }

    private static void populateLineNumbers(AnnotatedNode node, Map<String, BitSet> result, int numLines, String ruleName) {
        BitSet bits = result.containsKey(ruleName) ? result.get(ruleName) : new BitSet(numLines);
        bits.set(node.getLineNumber(), node.getLastLineNumber() + 1);
        result.put(ruleName, bits);
    }

    private static int getLineCount(ModuleNode ast) {
        int highest = 0;
        for (AnnotatedNode classNode : ast.getClasses()) {
            if (classNode.getLastLineNumber() <= highest) continue;
            highest = classNode.getLastLineNumber();
        }
        return highest;
    }

    private static Collection<String> getSuppressedRuleNames(Collection<? extends AnnotatedNode> imports) {
        ArrayList<String> result = new ArrayList<String>();
        if (imports != null) {
            for (AnnotatedNode annotatedNode : imports) {
                result.addAll(SuppressionAnalyzer.getSuppressedRuleNames(annotatedNode));
            }
        }
        return result;
    }

    private static Collection<String> getSuppressedRuleNames(AnnotatedNode node) {
        ArrayList<String> result = new ArrayList<String>();
        if (node == null) {
            return result;
        }
        Set<AnnotationNode> annos = SuppressionAnalyzer.getSuppressWarningsAnnotations(node);
        for (AnnotationNode annotation : annos) {
            Collection values;
            Map members = annotation.getMembers();
            if (members == null || (values = members.values()) == null) continue;
            for (Expression exp : values) {
                List expressions;
                if (exp instanceof ConstantExpression && ((ConstantExpression)exp).getValue() instanceof String) {
                    result.add((String)((ConstantExpression)exp).getValue());
                    continue;
                }
                if (!(exp instanceof ListExpression) || (expressions = ((ListExpression)exp).getExpressions()) == null) continue;
                for (Expression entry : expressions) {
                    if (!(entry instanceof ConstantExpression) || !(((ConstantExpression)entry).getValue() instanceof String)) continue;
                    result.add((String)((ConstantExpression)entry).getValue());
                }
            }
        }
        return result;
    }

    private static Set<AnnotationNode> getSuppressWarningsAnnotations(AnnotatedNode node) {
        HashSet<AnnotationNode> result = new HashSet<AnnotationNode>();
        result.addAll(node.getAnnotations(SUPPRESS_WARNINGS));
        List annots = node.getAnnotations();
        if (annots != null) {
            for (AnnotationNode n : annots) {
                ClassNode classNode = n.getClassNode();
                if (classNode == null) continue;
                String name = classNode.getName();
                if ("SuppressWarnings".equals(name)) {
                    result.add(n);
                    continue;
                }
                if (!"java.lang.SuppressWarnings".equals(name)) continue;
                result.add(n);
            }
        }
        return result;
    }
}

