/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core.dom;

import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.IJavaProject;
import com.netflix.nebula.lint.jdt.core.IOpenable;
import com.netflix.nebula.lint.jdt.core.JavaCore;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.compiler.IProblem;
import com.netflix.nebula.lint.jdt.core.dom.AST;
import com.netflix.nebula.lint.jdt.core.dom.ASTConverter;
import com.netflix.nebula.lint.jdt.core.dom.ASTNode;
import com.netflix.nebula.lint.jdt.core.dom.ASTRequestor;
import com.netflix.nebula.lint.jdt.core.dom.ASTSyntaxErrorPropagator;
import com.netflix.nebula.lint.jdt.core.dom.BindingResolver;
import com.netflix.nebula.lint.jdt.core.dom.Block;
import com.netflix.nebula.lint.jdt.core.dom.CompilationUnit;
import com.netflix.nebula.lint.jdt.core.dom.CompilationUnitResolver;
import com.netflix.nebula.lint.jdt.core.dom.DefaultBindingResolver;
import com.netflix.nebula.lint.jdt.core.dom.Expression;
import com.netflix.nebula.lint.jdt.core.dom.ExpressionStatement;
import com.netflix.nebula.lint.jdt.core.dom.IBinding;
import com.netflix.nebula.lint.jdt.core.dom.Initializer;
import com.netflix.nebula.lint.jdt.core.dom.NodeSearcher;
import com.netflix.nebula.lint.jdt.core.dom.TypeDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ConstructorDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.LocalDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Statement;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryType;
import com.netflix.nebula.lint.jdt.internal.compiler.util.SuffixConstants;
import com.netflix.nebula.lint.jdt.internal.core.BasicCompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.BinaryType;
import com.netflix.nebula.lint.jdt.internal.core.DefaultWorkingCopyOwner;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.util.CodeSnippetParsingUtil;
import com.netflix.nebula.lint.jdt.internal.core.util.RecordedParsingInformation;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class ASTParser {
    public static final int K_EXPRESSION = 1;
    public static final int K_STATEMENTS = 2;
    public static final int K_CLASS_BODY_DECLARATIONS = 4;
    public static final int K_COMPILATION_UNIT = 8;
    private final int apiLevel;
    private int astKind;
    private Map compilerOptions;
    private boolean resolveBindings;
    private boolean partial = false;
    private int focalPointPosition;
    private char[] rawSource = null;
    private ICompilationUnit compilationUnitSource = null;
    private IClassFile classFileSource = null;
    private int sourceOffset = 0;
    private int sourceLength = -1;
    private WorkingCopyOwner workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
    private IJavaProject project = null;
    private String unitName = null;

    public static ASTParser newParser(int level) {
        return new ASTParser(level);
    }

    ASTParser(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException();
        }
        this.apiLevel = level;
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        this.astKind = 8;
        this.rawSource = null;
        this.classFileSource = null;
        this.compilationUnitSource = null;
        this.resolveBindings = false;
        this.sourceLength = -1;
        this.sourceOffset = 0;
        this.workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        this.unitName = null;
        this.project = null;
        this.partial = false;
        this.compilerOptions = JavaCore.getOptions();
    }

    public void setCompilerOptions(Map options) {
        if (options == null) {
            this.compilerOptions = JavaCore.getOptions();
        }
        this.compilerOptions = options;
    }

    public void setResolveBindings(boolean bindings) {
        this.resolveBindings = bindings;
    }

    public void setFocalPosition(int position) {
        this.partial = true;
        this.focalPointPosition = position;
    }

    public void setKind(int kind) {
        if (kind != 8 && kind != 4 && kind != 1 && kind != 2) {
            throw new IllegalArgumentException();
        }
        this.astKind = kind;
    }

    public void setSource(char[] source) {
        this.rawSource = source;
        this.compilationUnitSource = null;
        this.classFileSource = null;
    }

    public void setSource(ICompilationUnit source) {
        this.compilationUnitSource = source;
        this.rawSource = null;
        this.classFileSource = null;
        if (source != null) {
            this.project = source.getJavaProject();
            this.compilerOptions = this.project.getOptions(true);
        }
    }

    public void setSource(IClassFile source) {
        this.classFileSource = source;
        this.rawSource = null;
        this.compilationUnitSource = null;
        if (source != null) {
            this.project = source.getJavaProject();
            this.compilerOptions = this.project.getOptions(true);
        }
    }

    public void setSourceRange(int offset, int length) {
        if (offset < 0 || length < -1) {
            throw new IllegalArgumentException();
        }
        this.sourceOffset = offset;
        this.sourceLength = length;
    }

    public void setWorkingCopyOwner(WorkingCopyOwner owner) {
        this.workingCopyOwner = owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setProject(IJavaProject project) {
        this.project = project;
        if (project != null) {
            this.compilerOptions = project.getOptions(true);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASTNode createAST(IProgressMonitor monitor) {
        ASTNode result = null;
        try {
            if (this.rawSource == null && this.compilationUnitSource == null && this.classFileSource == null) {
                throw new IllegalStateException("source not specified");
            }
            result = this.internalCreateAST(monitor);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.initializeDefaults();
            throw throwable;
        }
        {
            Object var4_5 = null;
            this.initializeDefaults();
            return result;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createASTs(ICompilationUnit[] compilationUnits, String[] bindingKeys, ASTRequestor requestor, IProgressMonitor monitor) {
        try {
            if (this.resolveBindings) {
                if (this.project == null) {
                    throw new IllegalStateException("project not specified");
                }
                CompilationUnitResolver.resolve(compilationUnits, bindingKeys, requestor, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, monitor);
            } else {
                CompilationUnitResolver.parse(compilationUnits, requestor, this.apiLevel, this.compilerOptions, monitor);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.initializeDefaults();
            throw throwable;
        }
        {
            Object var6_7 = null;
            this.initializeDefaults();
            return;
        }
    }

    public IBinding[] createBindings(IJavaElement[] elements, IProgressMonitor monitor) {
        try {
            if (this.project == null) {
                throw new IllegalStateException("project not specified");
            }
            IBinding[] iBindingArray = CompilationUnitResolver.resolve(elements, this.apiLevel, this.compilerOptions, this.project, this.workingCopyOwner, monitor);
            Object var5_4 = null;
            this.initializeDefaults();
            return iBindingArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.initializeDefaults();
            throw throwable;
        }
    }

    private ASTNode internalCreateAST(IProgressMonitor monitor) {
        boolean needToResolveBindings = this.resolveBindings;
        switch (this.astKind) {
            case 1: 
            case 2: 
            case 4: {
                if (this.rawSource == null) break;
                if (this.sourceOffset + this.sourceLength > this.rawSource.length) {
                    throw new IllegalStateException();
                }
                return this.internalCreateASTForKind();
            }
            case 8: {
                CompilationUnitDeclaration compilationUnitDeclaration = null;
                try {
                    NodeSearcher searcher = null;
                    com.netflix.nebula.lint.jdt.internal.compiler.env.ICompilationUnit sourceUnit = null;
                    IOpenable element = null;
                    if (this.compilationUnitSource != null) {
                        sourceUnit = (com.netflix.nebula.lint.jdt.internal.compiler.env.ICompilationUnit)((Object)this.compilationUnitSource);
                        sourceUnit = new BasicCompilationUnit(sourceUnit.getContents(), sourceUnit.getPackageName(), new String(sourceUnit.getFileName()), this.project);
                        element = this.compilationUnitSource;
                    } else if (this.classFileSource != null) {
                        try {
                            String sourceString = this.classFileSource.getSource();
                            if (sourceString == null) {
                                throw new IllegalStateException();
                            }
                            PackageFragment packageFragment = (PackageFragment)this.classFileSource.getParent();
                            BinaryType type = (BinaryType)this.classFileSource.getType();
                            IBinaryType binaryType = (IBinaryType)type.getElementInfo();
                            char[] fileName = binaryType.getFileName();
                            int firstDollar = CharOperation.indexOf('$', fileName);
                            if (firstDollar != -1) {
                                char[] suffix = SuffixConstants.SUFFIX_class;
                                int suffixLength = suffix.length;
                                char[] newFileName = new char[firstDollar + suffixLength];
                                System.arraycopy(fileName, 0, newFileName, 0, firstDollar);
                                System.arraycopy(suffix, 0, newFileName, firstDollar, suffixLength);
                                fileName = newFileName;
                            }
                            sourceUnit = new BasicCompilationUnit(sourceString.toCharArray(), Util.toCharArrays(packageFragment.names), new String(fileName), this.project);
                            element = this.classFileSource;
                        }
                        catch (JavaModelException javaModelException) {
                            throw new IllegalStateException();
                        }
                    } else if (this.rawSource != null) {
                        needToResolveBindings = this.unitName != null && this.project != null && this.compilerOptions != null;
                        sourceUnit = new BasicCompilationUnit(this.rawSource, null, this.unitName == null ? "" : this.unitName, this.project);
                    } else {
                        throw new IllegalStateException();
                    }
                    if (this.partial) {
                        searcher = new NodeSearcher(this.focalPointPosition);
                    }
                    if (needToResolveBindings && this.project != null) {
                        try {
                            compilationUnitDeclaration = CompilationUnitResolver.resolve(sourceUnit, this.project, searcher, this.compilerOptions, this.workingCopyOwner, monitor);
                        }
                        catch (JavaModelException javaModelException) {
                            compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, searcher, this.compilerOptions);
                            needToResolveBindings = false;
                        }
                    } else {
                        compilationUnitDeclaration = CompilationUnitResolver.parse(sourceUnit, searcher, this.compilerOptions);
                        needToResolveBindings = false;
                    }
                    CompilationUnit result = CompilationUnitResolver.convert(compilationUnitDeclaration, sourceUnit.getContents(), this.apiLevel, this.compilerOptions, needToResolveBindings, this.compilationUnitSource == null ? this.workingCopyOwner : this.compilationUnitSource.getOwner(), needToResolveBindings ? new DefaultBindingResolver.BindingTables() : null, monitor);
                    result.setJavaElement((IJavaElement)((Object)element));
                    CompilationUnit compilationUnit = result;
                    Object var18_17 = null;
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                    }
                    return compilationUnit;
                }
                catch (Throwable throwable) {
                    Object var18_18 = null;
                    if (compilationUnitDeclaration != null && this.resolveBindings) {
                        compilationUnitDeclaration.cleanUp();
                    }
                    throw throwable;
                }
            }
        }
        throw new IllegalStateException();
    }

    private ASTNode internalCreateASTForKind() {
        ASTConverter converter = new ASTConverter(this.compilerOptions, false, null);
        converter.compilationUnitSource = this.rawSource;
        converter.compilationUnitSourceLength = this.rawSource.length;
        converter.scanner.setSource(this.rawSource);
        AST ast = AST.newAST(this.apiLevel);
        ast.setDefaultNodeFlag(2);
        ast.setBindingResolver(new BindingResolver());
        converter.setAST(ast);
        CodeSnippetParsingUtil codeSnippetParsingUtil = new CodeSnippetParsingUtil();
        CompilationUnit compilationUnit = ast.newCompilationUnit();
        if (this.sourceLength == -1) {
            this.sourceLength = this.rawSource.length;
        }
        switch (this.astKind) {
            case 2: {
                ConstructorDeclaration constructorDeclaration = codeSnippetParsingUtil.parseStatements(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (constructorDeclaration != null) {
                    Block block = ast.newBlock();
                    Statement[] statements = constructorDeclaration.statements;
                    if (statements != null) {
                        int statementsLength = statements.length;
                        int i = 0;
                        while (i < statementsLength) {
                            if (statements[i] instanceof LocalDeclaration) {
                                converter.checkAndAddMultipleLocalDeclaration(statements, i, block.statements());
                            } else {
                                block.statements().add(converter.convert(statements[i]));
                            }
                            ++i;
                        }
                    }
                    this.rootNodeToCompilationUnit(ast, compilationUnit, block, recordedParsingInformation);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return block;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
            case 1: {
                com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression expression = codeSnippetParsingUtil.parseExpression(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (expression != null) {
                    Expression expression2 = converter.convert(expression);
                    this.rootNodeToCompilationUnit(expression2.getAST(), compilationUnit, expression2, codeSnippetParsingUtil.recordedParsingInformation);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return expression2;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
            case 4: {
                com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode[] nodes = codeSnippetParsingUtil.parseClassBodyDeclarations(this.rawSource, this.sourceOffset, this.sourceLength, this.compilerOptions, true);
                RecordedParsingInformation recordedParsingInformation = codeSnippetParsingUtil.recordedParsingInformation;
                int[][] comments = recordedParsingInformation.commentPositions;
                if (comments != null) {
                    converter.buildCommentsTable(compilationUnit, comments);
                }
                compilationUnit.setLineEndTable(recordedParsingInformation.lineEnds);
                if (nodes != null) {
                    TypeDeclaration typeDeclaration = converter.convert(nodes);
                    this.rootNodeToCompilationUnit(typeDeclaration.getAST(), compilationUnit, typeDeclaration, codeSnippetParsingUtil.recordedParsingInformation);
                    ast.setDefaultNodeFlag(0);
                    ast.setOriginalModificationCount(ast.modificationCount());
                    return typeDeclaration;
                }
                IProblem[] problems = recordedParsingInformation.problems;
                if (problems != null) {
                    compilationUnit.setProblems(problems);
                }
                ast.setDefaultNodeFlag(0);
                ast.setOriginalModificationCount(ast.modificationCount());
                return compilationUnit;
            }
        }
        throw new IllegalStateException();
    }

    private void propagateErrors(ASTNode astNode, IProblem[] problems) {
        ASTSyntaxErrorPropagator syntaxErrorPropagator = new ASTSyntaxErrorPropagator(problems);
        astNode.accept(syntaxErrorPropagator);
    }

    private void rootNodeToCompilationUnit(AST ast, CompilationUnit compilationUnit, ASTNode node, RecordedParsingInformation recordedParsingInformation) {
        int problemsCount = recordedParsingInformation.problemsCount;
        switch (node.getNodeType()) {
            case 8: {
                Block block = (Block)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    int i = 0;
                    int max = block.statements().size();
                    while (i < max) {
                        this.propagateErrors((ASTNode)block.statements().get(i), problems);
                        ++i;
                    }
                    compilationUnit.setProblems(problems);
                }
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            case 55: {
                TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    int i = 0;
                    int max = typeDeclaration.bodyDeclarations().size();
                    while (i < max) {
                        this.propagateErrors((ASTNode)typeDeclaration.bodyDeclarations().get(i), problems);
                        ++i;
                    }
                    compilationUnit.setProblems(problems);
                }
                compilationUnit.types().add(typeDeclaration);
                break;
            }
            default: {
                if (!(node instanceof Expression)) break;
                Expression expression = (Expression)node;
                if (problemsCount != 0) {
                    IProblem[] problems = recordedParsingInformation.problems;
                    this.propagateErrors(expression, problems);
                    compilationUnit.setProblems(problems);
                }
                ExpressionStatement expressionStatement = ast.newExpressionStatement(expression);
                Block block = ast.newBlock();
                block.statements().add(expressionStatement);
                Initializer initializer = ast.newInitializer();
                initializer.setBody(block);
                TypeDeclaration typeDeclaration = ast.newTypeDeclaration();
                typeDeclaration.bodyDeclarations().add(initializer);
                compilationUnit.types().add(typeDeclaration);
            }
        }
    }
}

