/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IProblemRequestor;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.core.compiler.IProblem;
import com.netflix.nebula.lint.jdt.internal.compiler.CompilationResult;
import com.netflix.nebula.lint.jdt.internal.compiler.Compiler;
import com.netflix.nebula.lint.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import com.netflix.nebula.lint.jdt.internal.compiler.ICompilerRequestor;
import com.netflix.nebula.lint.jdt.internal.compiler.IErrorHandlingPolicy;
import com.netflix.nebula.lint.jdt.internal.compiler.IProblemFactory;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRestriction;
import com.netflix.nebula.lint.jdt.internal.compiler.env.INameEnvironment;
import com.netflix.nebula.lint.jdt.internal.compiler.env.ISourceType;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Parser;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.SourceTypeConverter;
import com.netflix.nebula.lint.jdt.internal.core.BasicCompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.CancelableNameEnvironment;
import com.netflix.nebula.lint.jdt.internal.core.CancelableProblemFactory;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.NameLookup;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.util.CommentRecorderParser;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(unit);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CompilationUnitDeclaration process(CompilationUnitDeclaration unit, ICompilationUnit unitElement, char[] contents, Parser parser, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, boolean resetEnvironment, IProgressMonitor monitor) throws JavaModelException {
        JavaProject project = (JavaProject)unitElement.getJavaProject();
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        CompilationUnitProblemFinder problemFinder = null;
        try {
            CompilationUnitDeclaration compilationUnitDeclaration;
            block13: {
                try {
                    environment = new CancelableNameEnvironment(project, workingCopyOwner, monitor);
                    problemFactory = new CancelableProblemFactory(monitor);
                    problemFinder = new CompilationUnitProblemFinder(environment, CompilationUnitProblemFinder.getHandlingPolicy(), project.getOptions(true), CompilationUnitProblemFinder.getRequestor(), problemFactory);
                    if (parser != null) {
                        problemFinder.parser = parser;
                    }
                    PackageFragment packageFragment = (PackageFragment)unitElement.getAncestor(4);
                    char[][] expectedPackageName = null;
                    if (packageFragment != null) {
                        expectedPackageName = Util.toCharArrays(packageFragment.names);
                    }
                    if (unit == null) {
                        unit = problemFinder.resolve(new BasicCompilationUnit(contents, expectedPackageName, unitElement.getPath().toString(), unitElement), true, true, true);
                    } else {
                        problemFinder.resolve(unit, null, true, true, true);
                    }
                    CompilationUnitProblemFinder.reportProblems(unit, problemRequestor, monitor);
                    if (NameLookup.VERBOSE) {
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
                        System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
                    }
                    compilationUnitDeclaration = unit;
                    Object var16_17 = null;
                    if (environment == null) break block13;
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Util.log(e, "Exception occurred during problem detection: ");
                    throw new JavaModelException(e, 1005);
                }
                environment.monitor = null;
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (problemFinder == null) return compilationUnitDeclaration;
            if (!resetEnvironment) return compilationUnitDeclaration;
            problemFinder.lookupEnvironment.reset();
            return compilationUnitDeclaration;
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (environment != null) {
                environment.monitor = null;
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (problemFinder == null) throw throwable;
            if (!resetEnvironment) throw throwable;
            problemFinder.lookupEnvironment.reset();
            throw throwable;
        }
    }

    public static CompilationUnitDeclaration process(ICompilationUnit unitElement, char[] contents, WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, boolean resetEnvironment, IProgressMonitor monitor) throws JavaModelException {
        return CompilationUnitProblemFinder.process(null, unitElement, contents, null, workingCopyOwner, problemRequestor, resetEnvironment, monitor);
    }

    private static void reportProblems(CompilationUnitDeclaration unit, IProblemRequestor problemRequestor, IProgressMonitor monitor) {
        CompilationResult unitResult = unit.compilationResult;
        IProblem[] problems = unitResult.getAllProblems();
        int i = 0;
        int problemLength = problems == null ? 0 : problems.length;
        while (i < problemLength) {
            if (JavaModelManager.VERBOSE) {
                System.out.println("PROBLEM FOUND while reconciling : " + problems[i].getMessage());
            }
            if (monitor != null && monitor.isCanceled()) break;
            problemRequestor.acceptProblem(problems[i]);
            ++i;
        }
    }

    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }
}

