/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.CherryPickResult;
import com.netflix.nebula.lint.jgit.api.Git;
import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.ConcurrentRefUpdateException;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.MultipleParentsNotAllowedException;
import com.netflix.nebula.lint.jgit.api.errors.NoHeadException;
import com.netflix.nebula.lint.jgit.api.errors.NoMessageException;
import com.netflix.nebula.lint.jgit.api.errors.UnmergedPathsException;
import com.netflix.nebula.lint.jgit.api.errors.WrongRepositoryStateException;
import com.netflix.nebula.lint.jgit.dircache.DirCacheCheckout;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectIdRef;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.merge.MergeMessageFormatter;
import com.netflix.nebula.lint.jgit.merge.MergeStrategy;
import com.netflix.nebula.lint.jgit.merge.ResolveMerger;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.treewalk.FileTreeIterator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CherryPickCommand
extends GitCommand<CherryPickResult> {
    private String reflogPrefix = "cherry-pick:";
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private Integer mainlineParentNumber;
    private boolean noCommit = false;

    protected CherryPickCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CherryPickResult call() throws GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        RevCommit newHead = null;
        LinkedList<Ref> cherryPickedRefs = new LinkedList<Ref>();
        this.checkCallable();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            Object dco;
            ResolveMerger merger;
            RevCommit srcCommit;
            block27: {
                Ref headRef = this.repo.exactRef("HEAD");
                if (headRef == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newHead = revWalk.parseCommit(headRef.getObjectId());
                Iterator<Ref> iterator = this.commits.iterator();
                while (iterator.hasNext()) {
                    Ref src = iterator.next();
                    ObjectId srcObjectId = src.getPeeledObjectId();
                    if (srcObjectId == null) {
                        srcObjectId = src.getObjectId();
                    }
                    srcCommit = revWalk.parseCommit(srcObjectId);
                    RevCommit srcParent = this.getParentCommit(srcCommit, revWalk);
                    String ourName = this.calculateOurName(headRef);
                    String cherryPickName = srcCommit.getId().abbreviate(7).name() + " " + srcCommit.getShortMessage();
                    merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                    merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                    merger.setBase(srcParent.getTree());
                    merger.setCommitNames(new String[]{"BASE", ourName, cherryPickName});
                    if (merger.merge(newHead, srcCommit)) {
                        if (AnyObjectId.equals(newHead.getTree().getId(), merger.getResultTreeId())) continue;
                        dco = new DirCacheCheckout(this.repo, newHead.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                        ((DirCacheCheckout)dco).setFailOnConflict(true);
                        ((DirCacheCheckout)dco).checkout();
                        if (!this.noCommit) {
                            newHead = new Git(this.getRepository()).commit().setMessage(srcCommit.getFullMessage()).setReflogComment(this.reflogPrefix + " " + srcCommit.getShortMessage()).setAuthor(srcCommit.getAuthorIdent()).setNoVerify(true).call();
                        }
                        cherryPickedRefs.add(src);
                        continue;
                    }
                    break block27;
                }
                return new CherryPickResult(newHead, cherryPickedRefs);
            }
            if (merger.failed()) {
                dco = new CherryPickResult(merger.getFailingPaths());
                return dco;
            }
            String message = new MergeMessageFormatter().formatWithConflicts(srcCommit.getFullMessage(), merger.getUnmergedPaths());
            if (!this.noCommit) {
                this.repo.writeCherryPickHead(srcCommit.getId());
            }
            this.repo.writeMergeCommitMsg(message);
            CherryPickResult cherryPickResult = CherryPickResult.CONFLICT;
            return cherryPickResult;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), e);
        }
    }

    private RevCommit getParentCommit(RevCommit srcCommit, RevWalk revWalk) throws MultipleParentsNotAllowedException, MissingObjectException, IOException {
        RevCommit srcParent;
        if (this.mainlineParentNumber == null) {
            if (srcCommit.getParentCount() != 1) {
                throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
            }
            srcParent = srcCommit.getParent(0);
        } else {
            if (this.mainlineParentNumber > srcCommit.getParentCount()) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().commitDoesNotHaveGivenParent, srcCommit, this.mainlineParentNumber));
            }
            srcParent = srcCommit.getParent(this.mainlineParentNumber - 1);
        }
        revWalk.parseHeaders(srcParent);
        return srcParent;
    }

    public CherryPickCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public CherryPickCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public CherryPickCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public CherryPickCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    public CherryPickCommand setReflogPrefix(String prefix) {
        this.reflogPrefix = prefix;
        return this;
    }

    public CherryPickCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public CherryPickCommand setMainlineParentNumber(int mainlineParentNumber) {
        this.mainlineParentNumber = mainlineParentNumber;
        return this;
    }

    public CherryPickCommand setNoCommit(boolean noCommit) {
        this.noCommit = noCommit;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }
}

