/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.CannotDeleteCurrentBranchException;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.NotMergedException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.lib.StoredConfig;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeleteBranchCommand
extends GitCommand<List<String>> {
    private final Set<String> branchNames = new HashSet<String>();
    private boolean force;

    protected DeleteBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<String> call() throws GitAPIException, NotMergedException, CannotDeleteCurrentBranchException {
        this.checkCallable();
        ArrayList<String> result = new ArrayList<String>();
        if (this.branchNames.isEmpty()) {
            return result;
        }
        try {
            String currentBranch = this.repo.getFullBranch();
            if (!this.force) {
                try (RevWalk walk = new RevWalk(this.repo);){
                    RevCommit tip = walk.parseCommit(this.repo.resolve("HEAD"));
                    for (String branchName : this.branchNames) {
                        RevCommit base;
                        Ref currentRef;
                        if (branchName == null || (currentRef = this.repo.findRef(branchName)) == null || walk.isMergedInto(base = walk.parseCommit(this.repo.resolve(branchName)), tip)) continue;
                        throw new NotMergedException();
                    }
                }
            }
            this.setCallable(false);
            for (String branchName : this.branchNames) {
                Ref currentRef;
                if (branchName == null || (currentRef = this.repo.findRef(branchName)) == null) continue;
                String fullName = currentRef.getName();
                if (fullName.equals(currentBranch)) {
                    throw new CannotDeleteCurrentBranchException(MessageFormat.format(JGitText.get().cannotDeleteCheckedOutBranch, branchName));
                }
                RefUpdate update = this.repo.updateRef(fullName);
                update.setRefLogMessage("branch deleted", false);
                update.setForceUpdate(true);
                RefUpdate.Result deleteResult = update.delete();
                boolean ok = true;
                switch (deleteResult) {
                    case IO_FAILURE: 
                    case LOCK_FAILURE: 
                    case REJECTED: {
                        ok = false;
                        break;
                    }
                }
                if (ok) {
                    result.add(fullName);
                    if (!fullName.startsWith("refs/heads/")) continue;
                    String shortenedName = fullName.substring("refs/heads/".length());
                    StoredConfig cfg = this.repo.getConfig();
                    cfg.unsetSection("branch", shortenedName);
                    cfg.save();
                    continue;
                }
                throw new JGitInternalException(MessageFormat.format(JGitText.get().deleteBranchUnexpectedResult, deleteResult.name()));
            }
            return result;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public DeleteBranchCommand setBranchNames(String ... branchnames) {
        this.checkCallable();
        this.branchNames.clear();
        for (String branch : branchnames) {
            this.branchNames.add(branch);
        }
        return this;
    }

    public DeleteBranchCommand setForce(boolean force) {
        this.checkCallable();
        this.force = force;
        return this;
    }
}

