/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.RefUpdate;
import com.netflix.nebula.lint.jgit.lib.Repository;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeleteTagCommand
extends GitCommand<List<String>> {
    private final Set<String> tags = new HashSet<String>();

    protected DeleteTagCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<String> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<String> result = new ArrayList<String>();
        if (this.tags.isEmpty()) {
            return result;
        }
        try {
            this.setCallable(false);
            for (String tagName : this.tags) {
                Ref currentRef;
                if (tagName == null || (currentRef = this.repo.findRef(tagName)) == null) continue;
                String fullName = currentRef.getName();
                RefUpdate update = this.repo.updateRef(fullName);
                update.setForceUpdate(true);
                RefUpdate.Result deleteResult = update.delete();
                boolean ok = true;
                switch (deleteResult) {
                    case IO_FAILURE: 
                    case LOCK_FAILURE: 
                    case REJECTED: {
                        ok = false;
                        break;
                    }
                }
                if (ok) {
                    result.add(fullName);
                    continue;
                }
                throw new JGitInternalException(MessageFormat.format(JGitText.get().deleteTagUnexpectedResult, deleteResult.name()));
            }
            return result;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public DeleteTagCommand setTags(String ... tags) {
        this.checkCallable();
        this.tags.clear();
        for (String tagName : tags) {
            this.tags.add(tagName);
        }
        return this;
    }
}

