/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.api;

import com.netflix.nebula.lint.jgit.api.GitCommand;
import com.netflix.nebula.lint.jgit.api.errors.GitAPIException;
import com.netflix.nebula.lint.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.lint.jgit.api.errors.NoHeadException;
import com.netflix.nebula.lint.jgit.errors.IncorrectObjectTypeException;
import com.netflix.nebula.lint.jgit.errors.MissingObjectException;
import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.lib.AnyObjectId;
import com.netflix.nebula.lint.jgit.lib.ObjectId;
import com.netflix.nebula.lint.jgit.lib.Ref;
import com.netflix.nebula.lint.jgit.lib.Repository;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.RevWalk;
import com.netflix.nebula.lint.jgit.revwalk.filter.AndRevFilter;
import com.netflix.nebula.lint.jgit.revwalk.filter.MaxCountRevFilter;
import com.netflix.nebula.lint.jgit.revwalk.filter.RevFilter;
import com.netflix.nebula.lint.jgit.revwalk.filter.SkipRevFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.AndTreeFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilter;
import com.netflix.nebula.lint.jgit.treewalk.filter.PathFilterGroup;
import com.netflix.nebula.lint.jgit.treewalk.filter.TreeFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LogCommand
extends GitCommand<Iterable<RevCommit>> {
    private RevWalk walk;
    private boolean startSpecified = false;
    private RevFilter revFilter;
    private final List<PathFilter> pathFilters = new ArrayList<PathFilter>();
    private int maxCount = -1;
    private int skip = -1;

    protected LogCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
    }

    @Override
    public Iterable<RevCommit> call() throws GitAPIException, NoHeadException {
        this.checkCallable();
        if (this.pathFilters.size() > 0) {
            this.walk.setTreeFilter(AndTreeFilter.create(PathFilterGroup.create(this.pathFilters), TreeFilter.ANY_DIFF));
        }
        if (this.skip > -1 && this.maxCount > -1) {
            this.walk.setRevFilter(AndRevFilter.create(SkipRevFilter.create(this.skip), MaxCountRevFilter.create(this.maxCount)));
        } else if (this.skip > -1) {
            this.walk.setRevFilter(SkipRevFilter.create(this.skip));
        } else if (this.maxCount > -1) {
            this.walk.setRevFilter(MaxCountRevFilter.create(this.maxCount));
        }
        if (!this.startSpecified) {
            try {
                ObjectId headId = this.repo.resolve("HEAD");
                if (headId == null) {
                    throw new NoHeadException(JGitText.get().noHEADExistsAndNoExplicitStartingRevisionWasSpecified);
                }
                this.add(headId);
            }
            catch (IOException e) {
                throw new JGitInternalException(JGitText.get().anExceptionOccurredWhileTryingToAddTheIdOfHEAD, e);
            }
        }
        if (this.revFilter != null) {
            this.walk.setRevFilter(this.revFilter);
        }
        this.setCallable(false);
        return this.walk;
    }

    public LogCommand add(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(true, start);
    }

    public LogCommand not(AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException {
        return this.add(false, start);
    }

    public LogCommand addRange(AnyObjectId since, AnyObjectId until) throws MissingObjectException, IncorrectObjectTypeException {
        return this.not(since).add(until);
    }

    public LogCommand all() throws IOException {
        Map<String, Ref> refs = this.getRepository().getRefDatabase().getRefs("");
        for (Ref ref : refs.values()) {
            ObjectId objectId;
            if (!ref.isPeeled()) {
                ref = this.getRepository().peel(ref);
            }
            if ((objectId = ref.getPeeledObjectId()) == null) {
                objectId = ref.getObjectId();
            }
            RevCommit commit = null;
            try {
                commit = this.walk.parseCommit(objectId);
            }
            catch (MissingObjectException missingObjectException) {
            }
            catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                // empty catch block
            }
            if (commit == null) continue;
            this.add(commit);
        }
        return this;
    }

    public LogCommand addPath(String path) {
        this.checkCallable();
        this.pathFilters.add(PathFilter.create(path));
        return this;
    }

    public LogCommand setSkip(int skip) {
        this.checkCallable();
        this.skip = skip;
        return this;
    }

    public LogCommand setMaxCount(int maxCount) {
        this.checkCallable();
        this.maxCount = maxCount;
        return this;
    }

    private LogCommand add(boolean include, AnyObjectId start) throws MissingObjectException, IncorrectObjectTypeException, JGitInternalException {
        this.checkCallable();
        try {
            if (include) {
                this.walk.markStart(this.walk.lookupCommit(start));
                this.startSpecified = true;
            } else {
                this.walk.markUninteresting(this.walk.lookupCommit(start));
            }
            return this;
        }
        catch (MissingObjectException e) {
            throw e;
        }
        catch (IncorrectObjectTypeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionOccurredDuringAddingOfOptionToALogCommand, start), e);
        }
    }

    public LogCommand setRevFilter(RevFilter aFilter) {
        this.checkCallable();
        this.revFilter = aFilter;
        return this;
    }
}

